#define WIN32_LEAN_AND_MEAN
#ifdef _MSC_VER
#pragma warning(disable : 4514)
#pragma warning(push,1)
#endif /* _MSC_VER */
#include <windows.h>
#include <malloc.h>
#include <stdlib.h>
#include "plugin.hpp"
#ifdef _MSC_VER
#pragma warning(pop)
#endif /* _MSC_VER */

static int                 ModuleNumber;
static FARAPIEDITORCONTROL EditorControl;
static FARAPICHARTABLE     CharTable;
static FARAPIDIALOG        Dialog;
static FARAPIGETMSG        GetMsg;
static FARAPIMENU          Menu;
static char                PluginRootKey[_MAX_PATH];

static struct EditorInfo ei;
static struct EditorSetPosition esp;
static struct EditorGetString egs;
static struct EditorSelect es;
static struct EditorSetString ess;
static struct CharTableSet CharSet;
static struct EditorConvertText ect;
static UINT CF_FARVB = 0;
static UINT CF_FARLOCALE = 0;
static UINT CF_FARBINARY = 0;
static const char szCrLf[] ="\r\n";
static const char szCr[]="\r";
static const char szFarVB[]="FAR_VerticalBlock";
static const char szFarLocale[]="FAR_Locale";
static const char szFarBinary[]="FAR_Binary";
static const char szEdCrutch[]="\\EditCrutch";
static const char szHlfConfig[]="Cfg";
static const char szOptions20[]="Options20";
static const char szOptAnsiTable[]="AnsiTable";
static int nlsSpace;

enum
{
  MEditCrutch,

  MOk,
  MCancel,

  MOptHrzScroll,
  MOptMoveLeftRight,
  MMoveUpDown,
  MClipAll,
  MClipAnsi,
  MPasteOver,
  MAnsiTable,
  MCharSet,
  MNoMoveUpDownSL,
  MLeftKeepLine,
  MPasteSetSel,

  MNone
};

typedef struct _DialogTemplateItem{
  unsigned char Type;
  signed   char X1;
  signed   char Y1;
  int           Selected;
  unsigned int  Flags;
  unsigned int  Data;  /* Message number or pointer to string */
}DialogTemplateItem;
#define DIFT_MSGNUM 0x80000000

/* #define InsertNewString() EditorControl(ECTL_INSERTSTRING,0) */
#define InsertNewString() EditorControl(ECTL_INSERTTEXT,(void*)szCr)
#define Msg(MsgId)        GetMsg(ModuleNumber,MsgId)


#define OPT20_HRZ_SCROLL        1
#define OPT20_MOVELEFTRIGHT     2
#define OPT20_MOVEUPDOWN        4
#define OPT20_CLIPANSI          8
#define OPT20_CLIPALL           16
#define OPT20_PASTEOVER         32
#define OPT20_VERTNOSINGLELINE  64
#define OPT20_LEFTKEEPLINE      128
#define OPT20_PASTESETSEL       256

static DWORD dwOptions20;
static char  szCfgAnsiTableName[sizeof(CharSet.TableName)];

void WINAPI SetStartupInfo(const struct PluginStartupInfo *Info)
{
    DWORD Type;
    DWORD DataSize;
    HKEY hKey;

    dwOptions20 = OPT20_HRZ_SCROLL | OPT20_MOVELEFTRIGHT | OPT20_MOVEUPDOWN | OPT20_CLIPANSI | OPT20_CLIPALL | OPT20_PASTEOVER | OPT20_VERTNOSINGLELINE | OPT20_LEFTKEEPLINE;

    ModuleNumber=Info->ModuleNumber;
    EditorControl=Info->EditorControl;
    CharTable=Info->CharTable;
    Dialog=Info->Dialog;
    GetMsg=Info->GetMsg;
    Menu=Info->Menu;
    strcpy(PluginRootKey,Info->RootKey);
    strcpy(PluginRootKey+strlen(PluginRootKey),szEdCrutch);

    szCfgAnsiTableName[0]='\0';
    if( RegOpenKeyEx(HKEY_CURRENT_USER,PluginRootKey,0,KEY_QUERY_VALUE,&hKey)==ERROR_SUCCESS ){
        DataSize=sizeof(DWORD);
        RegQueryValueEx(hKey,szOptions20,0,&Type,(LPBYTE)&dwOptions20,&DataSize);
        DataSize=sizeof(szCfgAnsiTableName);
        if( RegQueryValueEx(hKey,szOptAnsiTable,0,&Type,(LPBYTE)szCfgAnsiTableName,&DataSize)!=ERROR_SUCCESS )
            szCfgAnsiTableName[0]='\0';
        RegCloseKey(hKey);
    }
}

int WINAPI GetMinFarVersion(void)
{
    return MAKEFARVERSION(1,70,1282);
}

void WINAPI GetPluginInfo(struct PluginInfo *Info)
{
    static const char *sPtr;

    sPtr=Msg(MEditCrutch);
    Info->StructSize=sizeof(*Info);
    Info->Flags=PF_DISABLEPANELS | PF_EDITOR;
    Info->DiskMenuStringsNumber=0;
    Info->PluginConfigStrings=&sPtr;
    Info->PluginConfigStringsNumber=1;
}

static int DialogFromTemplate(const char* sTitle,const DialogTemplateItem* aTplItems,
    struct FarDialogItem* aDialogItems,int nItemsNumber,const char* sHelpTopic,
    int nFocus,int nDefaultButton)
{
    int i;
    int nDialogWidth=0;

    memset(aDialogItems,0,sizeof(struct FarDialogItem)*nItemsNumber);
    aDialogItems[0].Type=DI_DOUBLEBOX;
    for( i=1; i<nItemsNumber; i++ ){
        aDialogItems[i].Type=aTplItems[i-1].Type;
        aDialogItems[i].X1=aTplItems[i-1].X1;
        aDialogItems[i].Y1=aTplItems[i-1].Y1;
        aDialogItems[i].Selected=aTplItems[i-1].Selected;
        aDialogItems[i].Flags=aTplItems[i-1].Flags & ~DIFT_MSGNUM;
        if(aTplItems[i-1].Flags&DIFT_MSGNUM)strcpy(aDialogItems[i].Data,Msg(aTplItems[i-1].Data));
        else if(aTplItems[i-1].Data){
            if(aTplItems[i-1].Type==DI_COMBOBOX)
                aDialogItems[i].X2=aTplItems[i-1].X1+aTplItems[i-1].Data;
            else
                strcpy(aDialogItems[i].Data,(char*)(aTplItems[i-1].Data));
        }
    }
    aDialogItems[nFocus].Focus=TRUE;
    aDialogItems[nDefaultButton].DefaultButton=TRUE;

    if(sTitle)strcpy(aDialogItems[0].Data,sTitle);
    aDialogItems[0].X1=3;
    aDialogItems[0].Y1=1;
    aDialogItems[0].Y2=aDialogItems[nItemsNumber-1].Y1+1;

    for( i=1; i<nItemsNumber; i++ ){
        int w=strlen(aDialogItems[i].Data)+aDialogItems[i].X1-5;
        if( nDialogWidth<w )nDialogWidth=w;
    }

    nDialogWidth+=16;
    aDialogItems[0].X2=nDialogWidth-4;

    return Dialog(ModuleNumber,-1,-1,nDialogWidth,aDialogItems[0].Y2+2,sHelpTopic,aDialogItems,nItemsNumber);
}

static void CodeMenu(char* szAnsiTableName)
{
    struct FarMenuItem *CodeMenuItems;
    int i;

    for( i=0; CharTable(i,(char*)&CharSet,sizeof(CharSet))!=-1; i++ ) continue;
    i+=2;
    CodeMenuItems=(struct FarMenuItem*)alloca(sizeof(struct FarMenuItem)*i);
    if( CodeMenuItems ){
        memset(CodeMenuItems,0,sizeof(struct FarMenuItem)*i);
        strcpy(CodeMenuItems[0].Text,Msg(MNone));
        CodeMenuItems[0].Selected=TRUE;
        CodeMenuItems[1].Separator=TRUE;
        for( i=0; CharTable(i,(char*)&CharSet,sizeof(CharSet))!=-1; i++ ){
            strcpy(CodeMenuItems[i+2].Text,CharSet.TableName);
            if( strcmp(CharSet.TableName,szAnsiTableName)==0 ){
                CodeMenuItems[0].Selected=FALSE;
                CodeMenuItems[i+2].Selected=TRUE;
            }
        }
        i=Menu(ModuleNumber,-1,-1,0,FMENU_SHOWAMPERSAND|FMENU_AUTOHIGHLIGHT,Msg(MCharSet),NULL,szHlfConfig,NULL,NULL,CodeMenuItems,i+2);
        if( i>1 )strcpy(szAnsiTableName,CodeMenuItems[i].Text);
        else if( i==0 )szAnsiTableName[0]='\0';
    }
}

static int GetOpt(struct FarDialogItem const* DialogItems)
{
    DWORD dwOptTmp=0;
    if( DialogItems[1].Selected ) dwOptTmp|=OPT20_HRZ_SCROLL;
    if( DialogItems[2].Selected ) dwOptTmp|=OPT20_MOVELEFTRIGHT;
    if( DialogItems[3].Selected ) dwOptTmp|=OPT20_MOVEUPDOWN;
    if( DialogItems[4].Selected ) dwOptTmp|=OPT20_VERTNOSINGLELINE;
    if( DialogItems[5].Selected ) dwOptTmp|=OPT20_LEFTKEEPLINE;
    if( DialogItems[6].Selected ) dwOptTmp|=OPT20_CLIPALL;
    if( DialogItems[7].Selected ) dwOptTmp|=OPT20_CLIPANSI;
    if( DialogItems[10].Selected )dwOptTmp|=OPT20_PASTEOVER;
    if( DialogItems[11].Selected )dwOptTmp|=OPT20_PASTESETSEL;
    return dwOptTmp;
}

static const DialogTemplateItem DialogTemplateInit[14]={
    {DI_CHECKBOX,5 ,2 ,FALSE,DIFT_MSGNUM,                MOptHrzScroll     },
    {DI_CHECKBOX,5 ,3 ,FALSE,DIFT_MSGNUM,                MOptMoveLeftRight },
    {DI_CHECKBOX,5 ,4 ,FALSE,DIFT_MSGNUM,                MMoveUpDown       },
    {DI_CHECKBOX,5 ,5 ,FALSE,DIFT_MSGNUM,                MNoMoveUpDownSL   }, /* 2.4 */
    {DI_CHECKBOX,5 ,6 ,FALSE,DIFT_MSGNUM,                MLeftKeepLine     }, /* 2.4 */
    {DI_CHECKBOX,5 ,7 ,FALSE,DIFT_MSGNUM,                MClipAll          },
    {DI_CHECKBOX,5 ,8 ,FALSE,DIFT_MSGNUM,                MClipAnsi         },
    {DI_BUTTON  ,5 ,9 ,FALSE,DIFT_MSGNUM,                MAnsiTable        },
    {DI_TEXT,    31,9 ,FALSE,0,                          0                 },
    {DI_CHECKBOX,5 ,10,FALSE,DIFT_MSGNUM,                MPasteOver        },
    {DI_CHECKBOX,5 ,11,FALSE,DIFT_MSGNUM,                MPasteSetSel      }, /* 2.4 */
    {DI_TEXT,    5 ,12,FALSE,DIF_BOXCOLOR|DIF_SEPARATOR, 0                 },
    {DI_BUTTON,  5 ,13,FALSE,DIF_CENTERGROUP|DIFT_MSGNUM,MOk               },
    {DI_BUTTON,  5 ,13,FALSE,DIF_CENTERGROUP|DIFT_MSGNUM,MCancel           }
};

int WINAPI Configure(int ItemNumber)
{
    struct FarDialogItem DialogItems[15];
    DialogTemplateItem DialogTemplate[14];
    HKEY hKey;
    DWORD Disposition;
    DWORD dwOptTmp;
    int nFocus=1;
    char szAnsiTableName[sizeof(CharSet.TableName)];

    (void)ItemNumber;

    dwOptTmp=dwOptions20;
    strcpy(szAnsiTableName,szCfgAnsiTableName);
Dlg:
    memcpy(DialogTemplate,DialogTemplateInit,sizeof(DialogTemplateInit));
    DialogTemplate[8].Data=(unsigned int)(szAnsiTableName[0]?szAnsiTableName:Msg(MNone));

    DialogTemplate[0].Selected =(dwOptTmp&OPT20_HRZ_SCROLL)?1:0;
    DialogTemplate[1].Selected =(dwOptTmp&OPT20_MOVELEFTRIGHT)?1:0;
    DialogTemplate[2].Selected =(dwOptTmp&OPT20_MOVEUPDOWN)?1:0;
    DialogTemplate[3].Selected =(dwOptTmp&OPT20_VERTNOSINGLELINE)?1:0;
    DialogTemplate[4].Selected =(dwOptTmp&OPT20_LEFTKEEPLINE)?1:0;
    DialogTemplate[5].Selected =(dwOptTmp&OPT20_CLIPALL)?1:0;
    DialogTemplate[6].Selected =(dwOptTmp&OPT20_CLIPANSI)?1:0;
    DialogTemplate[9].Selected =(dwOptTmp&OPT20_PASTEOVER)?1:0;
    DialogTemplate[10].Selected=(dwOptTmp&OPT20_PASTESETSEL)?1:0;

    nFocus=DialogFromTemplate(Msg(MEditCrutch),DialogTemplate,DialogItems,
         sizeof(DialogItems)/sizeof(DialogItems[0]),szHlfConfig,nFocus,13);
    switch(nFocus){
    case 8:
        dwOptTmp=GetOpt(DialogItems);
        CodeMenu(szAnsiTableName);
        goto Dlg;
        break;
    case 13:
        dwOptions20=GetOpt(DialogItems);
        strcpy(szCfgAnsiTableName,szAnsiTableName);
        break;
    default:
        return FALSE;
    }

    if( RegCreateKeyEx(HKEY_CURRENT_USER,PluginRootKey,0,NULL,0,KEY_WRITE,NULL,
                 &hKey,&Disposition)==ERROR_SUCCESS ){
        RegSetValueEx(hKey,szOptions20,0,REG_DWORD,(CONST BYTE*)&dwOptions20,sizeof(dwOptions20));
        RegSetValueEx(hKey,szOptAnsiTable,0,REG_SZ,(CONST BYTE*)szCfgAnsiTableName,strlen(szCfgAnsiTableName));
        RegCloseKey(hKey);
    }

    return TRUE;
}

static BOOL EditMove(BOOL isLeft, BOOL isUpDown, BOOL isFixBlock)
{
    /* correct jump to end/begin of block */
    /* correct left key on the beggining of the line */
    int i=0;

    EditorControl(ECTL_GETINFO,&ei);
    if( ei.Options & EOPT_PERSISTENTBLOCKS ) isFixBlock=FALSE;
    if( (dwOptions20&OPT20_LEFTKEEPLINE) && isLeft && !isUpDown &&
        (
          ei.BlockType==BTYPE_NONE || !(dwOptions20&OPT20_MOVELEFTRIGHT) || !isFixBlock
        ) ){
        if( ei.CurPos!=0 )return FALSE;
        return TRUE;
    }
    if( ei.BlockType!=BTYPE_NONE && isFixBlock &&
        (isUpDown && (dwOptions20&OPT20_MOVEUPDOWN) ||
        !isUpDown && (dwOptions20&OPT20_MOVELEFTRIGHT))
        ){
        esp.CurTabPos=-1;
        esp.TopScreenLine=-1;
        esp.Overtype=-1;
        esp.LeftPos=-1;
        esp.CurPos=-1;
        esp.CurLine=ei.BlockStartLine;
        if( (dwOptions20&OPT20_VERTNOSINGLELINE) && isUpDown ){
            egs.StringNumber=ei.BlockStartLine+1;
            if( egs.StringNumber>=ei.TotalLines )return FALSE;
            EditorControl(ECTL_GETSTRING,&egs);
            if( egs.SelStart==-1 )return FALSE;
        }
        if( isLeft ){
            EditorControl(ECTL_SETPOSITION,&esp);
            egs.StringNumber=-1;
            EditorControl(ECTL_GETSTRING,&egs);
            esp.CurPos=egs.SelStart;
            esp.CurLine=-1;
        }else{ /* right/down */
            for( egs.StringNumber=ei.CurLine; EditorControl(ECTL_GETSTRING,&egs); egs.StringNumber++ ){
                if( egs.SelStart==-1 )break;
                else i=egs.SelEnd;
            }
            esp.CurLine=egs.StringNumber-1;
            esp.CurPos=i;
        }
        EditorControl(ECTL_SETPOSITION,&esp);
        es.BlockType=BTYPE_NONE;
        EditorControl(ECTL_SELECT,&es);
        return TRUE;
    }
    return FALSE;
}

static BOOL Scroll(BOOL isLeft)
{
    /* scroll viewpoint left/right */
    EditorControl(ECTL_GETINFO,&ei);
    esp.CurTabPos=-1;
    esp.TopScreenLine=-1;
    esp.Overtype=-1;
    esp.CurLine=-1;
    esp.CurPos=ei.CurPos;
    esp.LeftPos=ei.LeftPos;
    if( isLeft ){
        if( esp.LeftPos )esp.LeftPos--;
        if( esp.CurPos )esp.CurPos--;
    }else{ /* right */
        if( !(ei.Options & EOPT_CURSORBEYONDEOL) ){
            egs.StringNumber=-1;
            EditorControl(ECTL_GETSTRING,&egs);
            if( egs.StringLength > esp.CurPos )esp.CurPos++;
        }else esp.CurPos++;
        if( esp.CurPos < esp.LeftPos+ei.WindowSizeX ) esp.LeftPos++;
    }
    EditorControl(ECTL_SETPOSITION,&esp);
    if( !(ei.Options & EOPT_PERSISTENTBLOCKS) && ei.BlockType!=BTYPE_NONE ){
        es.BlockType=BTYPE_NONE;
        EditorControl(ECTL_SELECT,&es);
    }
    EditorControl(ECTL_REDRAW,NULL);
    return TRUE;
}

static void DelBlock()
{
    INPUT_RECORD rec;

    if( ei.CurState&ECSTATE_LOCKED )return;
    memset(&rec,0,sizeof(rec));
    rec.EventType=KEY_EVENT;
    rec.Event.KeyEvent.bKeyDown=TRUE;
    rec.Event.KeyEvent.wVirtualKeyCode='D';
    rec.Event.KeyEvent.uChar.AsciiChar='D';
    rec.Event.KeyEvent.dwControlKeyState=RIGHT_CTRL_PRESSED;
    EditorControl(ECTL_PROCESSINPUT,&rec);
    rec.Event.KeyEvent.bKeyDown=FALSE;
    EditorControl(ECTL_PROCESSINPUT,&rec);
}

static BOOL Copy(BOOL isDel)
{
    /* correct copy to clipboard in win-mode */
    int i,l,k,j,selstart=0;
    HGLOBAL hGlb, hGlbTmp, hGlbLoc, hGlbOem, hGlbFarLoc;
    char *p;
    char szEos[3];

    EditorControl(ECTL_GETINFO,&ei);

    if( ei.TableNum!=-1 ){
        CharTable(ei.TableNum,(char*)&CharSet,sizeof(CharSet));
        nlsSpace=CharSet.EncodeTable[' '];
        if( strcmp(CharSet.TableName,szCfgAnsiTableName)==0 )ei.AnsiMode=TRUE;
    }else nlsSpace=' ';

    if( !((dwOptions20 & OPT20_CLIPALL) ||
         (dwOptions20 & OPT20_CLIPANSI) && ei.AnsiMode ) )return FALSE;

    if( OpenClipboard(NULL) ){
        EmptyClipboard();
        CloseClipboard();
    }
    egs.StringNumber=(ei.BlockType==BTYPE_NONE)?-1:ei.BlockStartLine;
    k=l=0;
    hGlb=NULL;
    ess.StringText=NULL;
    ess.StringEOL=szEos;
    esp.CurPos=-1;
    esp.CurTabPos=-1;
    esp.TopScreenLine=-1;
    esp.LeftPos=-1;
    esp.Overtype=-1;
    while( EditorControl(ECTL_GETSTRING,&egs) ){
        if( ei.BlockType==BTYPE_NONE ){
            egs.SelStart=0;
            egs.SelEnd=-1;
        }
        if( !l )selstart=egs.SelStart;
        if( egs.SelStart==-1 ) break;
        j=0;
        if( egs.SelEnd==-1 ){
            i=egs.StringLength-egs.SelStart;
            k=2;
        }else{
            if( egs.SelEnd>egs.StringLength ){
                i=egs.StringLength-egs.SelStart;
                j=egs.SelEnd;
                if( i<0 ){
                    j-=egs.SelStart;
                    i=0;
                }else j-=egs.StringLength;
                k=2;
            }else{
                i=egs.SelEnd-egs.SelStart;
                k=(ei.BlockType==BTYPE_COLUMN)?2:0;
            }
        }
        if( l ){
            hGlbTmp=GlobalReAlloc(hGlb,l+i+k+j+1,GHND);
            if( !hGlbTmp ){
                GlobalFree(hGlb);
                return FALSE;
            }
            hGlb=hGlbTmp;
        }else{
            hGlb=GlobalAlloc(GHND,i+k+j+1);
            if( !hGlb ){
                return FALSE;
            }
        }
        p=(char*)GlobalLock(hGlb);
        memcpy(&p[l],&egs.StringText[egs.SelStart],i);
        l+=i;
        memset(&p[l],nlsSpace,j);
        l+=j;
        memcpy(&p[l],szCrLf,k);
        l+=k;
        p[l]='\0';
        GlobalUnlock(hGlb);

        if( ei.BlockType==BTYPE_NONE ) break;
        egs.StringNumber++;
    }
    if( k==2 && l>=k && ei.BlockType==BTYPE_COLUMN ){
        /* we have added crlf to the last column row... */
        l-=k;
        p=(char*)GlobalLock(hGlb);
        p[l]='\0';
        GlobalUnlock(hGlb);
    }

    if( isDel ) DelBlock();

    hGlbTmp=NULL;
    hGlbLoc=NULL;
    hGlbOem=NULL;
    hGlbFarLoc=NULL;
    if( OpenClipboard(NULL) ){
        if( EmptyClipboard() && l ){
            if( ei.BlockType==BTYPE_COLUMN ){
                if( CF_FARVB==0 )CF_FARVB = RegisterClipboardFormat(szFarVB);
                hGlbTmp=GlobalAlloc(GHND,l+1);
                if( hGlbTmp ){
                    ect.Text=GlobalLock(hGlbTmp);
                    ect.TextLength=l;
                    memcpy(ect.Text,GlobalLock(hGlb),l+1);
                    GlobalUnlock(hGlb);
                    EditorControl(ECTL_EDITORTOOEM,&ect);
                    GlobalUnlock(hGlbTmp);
                    SetClipboardData(CF_FARVB,hGlbTmp);
                }
            }

            hGlbLoc=GlobalAlloc(GHND,sizeof(LCID));
            if( hGlbLoc ){
                *(LCID*)GlobalLock(hGlbLoc)=GetThreadLocale();
                GlobalUnlock(hGlbLoc);
                SetClipboardData(CF_LOCALE,hGlbLoc);
            }

            if( ei.AnsiMode ){
                SetClipboardData(CF_TEXT,hGlb);
            }else if( ei.TableNum==-1){
                SetClipboardData(CF_OEMTEXT,hGlb);
            }else{
                hGlbOem=GlobalAlloc(GHND,l+1);
                if( hGlbOem ){
                    ect.Text=GlobalLock(hGlbOem);
                    ect.TextLength=l;
                    memcpy(ect.Text,GlobalLock(hGlb),l+1);
                    GlobalUnlock(hGlb);
                    EditorControl(ECTL_EDITORTOOEM,&ect);
                    GlobalUnlock(hGlbOem);
                    SetClipboardData(CF_OEMTEXT,hGlbOem);
                }
                if( CF_FARLOCALE==0 )CF_FARLOCALE = RegisterClipboardFormat(szFarLocale);
                hGlbFarLoc=GlobalAlloc(GHND,sizeof(int));
                if( hGlbFarLoc ){
                    *(int*)GlobalLock(hGlbFarLoc)=ei.TableNum;
                    GlobalUnlock(hGlbFarLoc);
                    SetClipboardData(CF_FARLOCALE,hGlbFarLoc);
                }
                if( CF_FARBINARY==0 )CF_FARBINARY = RegisterClipboardFormat(szFarBinary);
                SetClipboardData(CF_FARBINARY,hGlb);
            }
        }
        CloseClipboard();
    }
    if( l ){
        GlobalFree(hGlb);
        if( hGlbTmp ) GlobalFree(hGlbTmp);
        if( hGlbLoc ) GlobalFree(hGlbLoc);
        if( hGlbOem ) GlobalFree(hGlbOem);
        if( hGlbFarLoc ) GlobalFree(hGlbFarLoc);
    }
    return TRUE;
}

static BOOL InsertString(const char* str, int len, const char* StringText, int StringLength)
{
    /* needs ei.CurPos, egs and partially filles ess */
    int i;

    ess.StringLength=StringLength+len;

    if( ei.CurPos>StringLength ){
        ess.StringLength+=ei.CurPos-StringLength;
        i=StringLength;
    }else i=ei.CurPos;
    ess.StringText=(char*)alloca(ess.StringLength+1);
    if( !ess.StringText )return FALSE;
    memcpy(ess.StringText,StringText,i);
    if( ei.CurPos>StringLength ){
        memset(&ess.StringText[i],nlsSpace,ei.CurPos-StringLength);
        i+=ei.CurPos-StringLength;
    }
    memcpy(&ess.StringText[i],str,len);
    if( ei.CurPos<StringLength )
        memcpy(&ess.StringText[i+len],&StringText[i],StringLength-ei.CurPos);
    EditorControl(ECTL_SETSTRING,&ess);
    return TRUE;
}

static BOOL InsertStringOver(const char* str, int len, const char* StringText, int StringLength)
{
    /* needs ei.CurPos, egs and partially filles ess */
    int i;

    if( ei.CurPos>StringLength ){
        ess.StringLength=ei.CurPos;
        i=StringLength;
    }else{
        ess.StringLength=StringLength;
        i=ei.CurPos;
    }
    if( ei.CurPos+len > ess.StringLength ) ess.StringLength=ei.CurPos+len;
    ess.StringText=(char*)alloca(ess.StringLength+1);
    if( !ess.StringText )return FALSE;
    memcpy(ess.StringText,StringText,i);
    if( ei.CurPos>StringLength ){
        memset(&ess.StringText[i],nlsSpace,ei.CurPos-StringLength);
        i+=ei.CurPos-StringLength;
    }
    memcpy(&ess.StringText[i],str,len);
    i+=len;
    if( i < StringLength )
        memcpy(&ess.StringText[i],&StringText[i],StringLength-i);
    EditorControl(ECTL_SETSTRING,&ess);
    return TRUE;
}

static BOOL PasteString(const char* str, int len, int isdel)
{
    char* StringText;
    int StringLength;
    int SelEnd;

    if( isdel && egs.SelStart!=-1 && egs.SelStart!=egs.SelEnd && egs.SelStart<egs.StringLength ){
        SelEnd=egs.SelEnd;
        if( SelEnd>egs.StringLength )SelEnd=egs.StringLength;
        StringLength=(SelEnd==-1)?egs.SelStart:(egs.StringLength-(SelEnd-egs.SelStart));
        if( StringLength<=0 )StringLength=0;
        StringText=(char*)alloca(StringLength+1);
        if(!StringText)return FALSE;
        memcpy(StringText,egs.StringText,egs.SelStart);
        if( SelEnd!=-1 )
            memcpy(&StringText[egs.SelStart],&egs.StringText[SelEnd],egs.StringLength-SelEnd);
    }else{
        StringLength=egs.StringLength;
        StringText=(char*)egs.StringText;
    }
    if( ei.Overtype )return InsertStringOver(str,len,StringText,StringLength);
    return InsertString(str,len,StringText,StringLength);
}

static BOOL Paste()
{
    /* correct paste from clipboard in win-mode */
    BOOL res=FALSE;
    HGLOBAL hGlb;
    char *p;
    int i,form,j,inc;
    char szEos[3];
    BOOL isVb;
    BOOL isnext;
    BOOL isdel;
    BOOL isExpandTabs;
    struct EditorInfo eiorig;
    struct EditorSetParameter espar;

    EditorControl(ECTL_GETINFO,&ei);

    if( ei.CurState&ECSTATE_LOCKED )return FALSE;

    if( ei.TableNum!=-1 ){
        CharTable(ei.TableNum,(char*)&CharSet,sizeof(CharSet));
        nlsSpace=CharSet.EncodeTable[' '];
        if( strcmp(CharSet.TableName,szCfgAnsiTableName)==0 )ei.AnsiMode=TRUE;
    }else nlsSpace=' ';

    if( !(dwOptions20 & OPT20_PASTEOVER) )ei.Overtype=0;
    if( !((dwOptions20 & OPT20_CLIPALL) ||
        (dwOptions20 & OPT20_CLIPANSI) && ei.AnsiMode ||
        (dwOptions20 & OPT20_PASTEOVER) && ei.Overtype ||
        (dwOptions20 & OPT20_PASTESETSEL) && !(ei.Options&EOPT_PERSISTENTBLOCKS))
      ) return FALSE;

    if( CF_FARVB==0 )CF_FARVB = RegisterClipboardFormat(szFarVB);
    if( CF_FARLOCALE==0 )CF_FARLOCALE = RegisterClipboardFormat(szFarLocale);
    if( CF_FARBINARY==0 )CF_FARBINARY = RegisterClipboardFormat(szFarBinary);

    if( OpenClipboard(NULL) ){
        form=0;
        if( ei.AnsiMode ) form=CF_TEXT;
        else{
            hGlb=GetClipboardData(CF_FARLOCALE);
            if( hGlb ){
                if( *(int*)GlobalLock(hGlb)==ei.TableNum ) form=CF_FARBINARY;
                GlobalUnlock(hGlb);
            }
            if( form==0 ) form=CF_OEMTEXT;
        }

        j=0;
        if( form==CF_OEMTEXT || form==CF_TEXT ){
            for( i=0; (i=EnumClipboardFormats(i))!=0; ){
                if( i==form ){
                    j=0;
                    break;
                }
                if( i==CF_TEXT || i==CF_OEMTEXT || i==CF_UNICODETEXT ){
                    j=i;
                    break;
                }
            }
            if( i!=form ){ /* exact format not found */
                if( j==0 ){
                    CloseClipboard();
                    return TRUE; /* cannot paste */
                }
            }
        }

        hGlb=GetClipboardData(j?j:form);
        if( hGlb ){
            p=GlobalLock(hGlb);
            if( p ){
                ect.Text=NULL;
                if( j ){ /* we have not matching format to convert to OEM or ANSI */
                    ect.TextLength=GlobalSize(hGlb);
                    if( j==CF_UNICODETEXT ) ect.TextLength>>=1;
                    ect.Text=(char*)alloca(ect.TextLength);
                    if( ect.Text ){
                        switch( j ){
                        case CF_UNICODETEXT:
                            WideCharToMultiByte((form==CF_TEXT)?CP_ACP:CP_OEMCP,0,(LPCWSTR)p,-1,ect.Text,ect.TextLength,NULL,NULL);
                            break;
                        case CF_TEXT:
                            CharToOem(p,ect.Text);
                            break;
                        case CF_OEMTEXT:
                            OemToChar(p,ect.Text);
                            break;
                        }
                    }
                    p=ect.Text;
                }
                if( form==CF_OEMTEXT && ei.TableNum!=-1 && p ){
                    if( !ect.Text ){
                        ect.TextLength=GlobalSize(hGlb);
                        ect.Text=(char*)alloca(ect.TextLength);
                    }
                    if( ect.Text ){
                        memcpy(ect.Text,p,ect.TextLength);
                        EditorControl(ECTL_OEMTOEDITOR,&ect);
                    }
                    p=ect.Text;
                }
            }
            if( p ){
                isExpandTabs = (ei.Options&EOPT_EXPANDTABS);
                if( isExpandTabs ){
                    espar.Type=ESPT_EXPANDTABS;
                    espar.Param.iParam=FALSE;
                    EditorControl(ECTL_SETPARAM,&espar);
                }

                esp.CurLine=-1;
                esp.CurTabPos=-1;
                esp.TopScreenLine=-1;
                esp.LeftPos=-1;
                esp.Overtype=-1;
                isdel=(ei.BlockType!=BTYPE_NONE) && !(ei.Options&EOPT_PERSISTENTBLOCKS);
                isVb=IsClipboardFormatAvailable(CF_FARVB);
                if( isdel &&
                    (ei.BlockType==BTYPE_COLUMN && !isVb ) ||
                    (ei.BlockType==BTYPE_STREAM && isVb ) ){
                    DelBlock();
                    i=ei.Overtype;
                    j=ei.AnsiMode;
                    EditorControl(ECTL_GETINFO,&ei);
                    ei.Overtype=i;
                    ei.AnsiMode=j;
                    isdel=FALSE;
                }
                if( isdel ){
                    egs.StringNumber=ei.BlockStartLine;
                    EditorControl(ECTL_GETSTRING,&egs);
                    esp.CurLine=ei.CurLine=ei.BlockStartLine;
                    esp.CurPos=ei.CurPos=egs.SelStart;
                    EditorControl(ECTL_SETPOSITION,&esp);
                    esp.CurLine=-1;
                }else{
                    if( ei.BlockType!=BTYPE_NONE ){
                        es.BlockType=BTYPE_NONE;
                        EditorControl(ECTL_SELECT,&es);
                        ei.BlockType=BTYPE_NONE;
                        ei.BlockStartLine=-1;
                    }
                    egs.StringNumber=-1;
                    EditorControl(ECTL_GETSTRING,&egs);
                }
                es.BlockStartLine=ei.CurLine;
                es.BlockStartPos=ei.CurPos;
                ess.StringNumber=-1;
                ess.StringEOL=strcpy(szEos,egs.StringEOL);
                isnext=FALSE;
                inc=isVb?0:1;
                memcpy(&eiorig,&ei,sizeof(ei));
                for( es.BlockHeight=i=0; p[0]; es.BlockHeight++ ){
                    for( i=0; p[i] && *(short*)&p[i]!=*(short*)&szCrLf[0]; i++ ) continue;
                    if( isVb ){
                        if( isnext ){
                            ei.CurLine++;
                            if( ei.CurLine>=ei.TotalLines ){
                                isdel=FALSE;
                                esp.CurPos=ess.StringLength;
                                EditorControl(ECTL_SETPOSITION,&esp);
                                InsertNewString();
                                ei.TotalLines++;
                                egs.StringLength=0;
                            }else{
                                esp.CurLine=ei.CurLine;
                                EditorControl(ECTL_SETPOSITION,&esp);
                                esp.CurLine=-1;
                                egs.StringNumber=-1;
                                EditorControl(ECTL_GETSTRING,&egs);
                                strcpy(szEos,egs.StringEOL);
                            }
                        }else isnext=TRUE;
                        if( isdel && (egs.SelStart==-1 || egs.SelStart==egs.SelEnd) )isdel=FALSE;
                        PasteString(p,i,isdel);
                        p+=i;
                        if( p[0] ){
                            p+=2;
                        }else{
                            ei.CurPos=esp.CurPos=ei.CurPos+i;
                            EditorControl(ECTL_SETPOSITION,&esp);
                        }
                    }else{
                        PasteString(p,i,isdel);
                        p+=i;
                        if( egs.SelEnd==-1 )inc=0;
                        if( p[0] ){
                            inc=0;
                            p+=2;
                            ei.CurLine++;
                            if( ei.Overtype ){
                                if( ei.CurLine>=ei.TotalLines ){
                                    isdel=FALSE;
                                    esp.CurPos=ess.StringLength;
                                    EditorControl(ECTL_SETPOSITION,&esp);
                                    InsertNewString();
                                    ei.TotalLines++;
                                    egs.StringLength=0;
                                }else{
                                    esp.CurLine=ei.CurLine;
                                    esp.CurPos=0;
                                    EditorControl(ECTL_SETPOSITION,&esp);
                                    esp.CurLine=-1;
                                    egs.StringNumber=-1;
                                    EditorControl(ECTL_GETSTRING,&egs);
                                }
                            }else{
                                if( isdel && egs.SelStart!=-1 && egs.SelEnd==-1 && ei.CurLine<ei.TotalLines ){
                                    esp.CurPos=0;
                                    esp.CurLine=ei.CurLine;
                                    EditorControl(ECTL_SETPOSITION,&esp);
                                    esp.CurLine=-1;
                                }else{
                                    esp.CurPos=ei.CurPos+i;
                                    EditorControl(ECTL_SETPOSITION,&esp);
                                    InsertNewString();
                                    isdel=FALSE;
                                }
                                egs.StringNumber=-1;
                                EditorControl(ECTL_GETSTRING,&egs);
                            }
                            if( isdel && (egs.SelStart==-1 || egs.SelStart==egs.SelEnd) )isdel=FALSE;
                            ei.CurPos=0;
                        }else{
                            ei.CurPos=esp.CurPos=ei.CurPos+i;
                            EditorControl(ECTL_SETPOSITION,&esp);
                        }
                    }
                }
                if( isdel ){
                    struct EditorSelect es;
                    es.BlockType=ei.BlockType;
                    esp.CurLine=es.BlockStartLine=ei.CurLine;
                    if( ei.BlockType==BTYPE_COLUMN )es.BlockStartLine++;
                    es.BlockStartLine+=inc;
                    es.BlockHeight=0;
                    es.BlockWidth=0;
                    es.BlockStartPos=-1;
                    for( egs.StringNumber=es.BlockStartLine; egs.StringNumber<ei.TotalLines && EditorControl(ECTL_GETSTRING,&egs); egs.StringNumber++ ){
                        if( egs.SelStart==-1 ) break;
                        if( es.BlockStartPos==-1 ){
                            if( ei.CurLine==es.BlockStartLine && ei.CurPos>egs.SelStart )
                                es.BlockStartPos=ei.CurPos;
                            else
                                es.BlockStartPos=egs.SelStart;
                        }
                        es.BlockHeight++;
                        es.BlockWidth=((egs.SelEnd==-1)?egs.StringLength:egs.SelEnd)-es.BlockStartPos;
                    }
                    if( es.BlockHeight ){
                        EditorControl(ECTL_SELECT,&es);
                        DelBlock();
                        ei.BlockType=BTYPE_NONE;
                        EditorControl(ECTL_SETPOSITION,&esp);
                    }
                }
                if( (dwOptions20&OPT20_PASTESETSEL) || (ei.Options&EOPT_PERSISTENTBLOCKS) ){
                    es.BlockType=isVb?BTYPE_COLUMN:BTYPE_STREAM;
                    es.BlockWidth=i;
                    if( !isVb ){
                        EditorControl(ECTL_GETINFO,&ei);
                        es.BlockWidth=ei.CurPos-es.BlockStartPos;
                        es.BlockHeight=ei.CurLine-es.BlockStartLine+1;
                    }
                }else es.BlockType=BTYPE_NONE;
                if( isVb ){
                    esp.CurLine=eiorig.CurLine;
                    esp.CurPos=eiorig.CurPos;
                    EditorControl(ECTL_SETPOSITION,&esp);
                }
                EditorControl(ECTL_SELECT,&es);

                if( isExpandTabs ){
                    egs.StringNumber=-1;
                    EditorControl(ECTL_GETSTRING,&egs);
                    j=egs.StringLength;

                    espar.Type=ESPT_EXPANDTABS;
                    espar.Param.iParam=TRUE;
                    EditorControl(ECTL_SETPARAM,&espar);

                    /* expand spaces in inserted lines */
                    for( i=es.BlockStartLine; i<=ei.CurLine; i++ )
                        EditorControl(ECTL_EXPANDTABS,&i);

                    if( es.BlockType!=BTYPE_NONE ){
                        egs.StringNumber=-1;
                        EditorControl(ECTL_GETSTRING,&egs);
                        if( j!=egs.StringLength ){
                            es.BlockWidth+=(egs.StringLength-j);
                            EditorControl(ECTL_SELECT,&es);
                        }
                    }
                }

                res=TRUE;
            }
            GlobalUnlock(hGlb);
        }
        CloseClipboard();
    }
    EditorControl(ECTL_REDRAW,0);

    return res;
}

int WINAPI ProcessEditorInput(const INPUT_RECORD *Rec)
{
    static BOOL bReenter=FALSE;
    BOOL ret=FALSE;

    if( bReenter ) return FALSE;
    bReenter=TRUE;

    if( Rec->EventType==KEY_EVENT && Rec->Event.KeyEvent.bKeyDown ){
        if(
            ((dwOptions20 & OPT20_MOVELEFTRIGHT) &&
            ((Rec->Event.KeyEvent.wVirtualKeyCode==VK_LEFT || Rec->Event.KeyEvent.wVirtualKeyCode==VK_RIGHT) &&
            !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|LEFT_CTRL_PRESSED|RIGHT_ALT_PRESSED|RIGHT_CTRL_PRESSED|SHIFT_PRESSED)) ||
            (char)(Rec->Event.KeyEvent.wVirtualKeyCode&0xDF)=='S' && Rec->Event.KeyEvent.uChar.AsciiChar &&
            !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED|SHIFT_PRESSED)) &&
             (Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED)) ))
            ||
             (dwOptions20 & OPT20_MOVEUPDOWN)    && (Rec->Event.KeyEvent.wVirtualKeyCode==VK_UP || Rec->Event.KeyEvent.wVirtualKeyCode==VK_DOWN) &&
            !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|LEFT_CTRL_PRESSED|RIGHT_ALT_PRESSED|RIGHT_CTRL_PRESSED|SHIFT_PRESSED)) ){

            ret=EditMove(Rec->Event.KeyEvent.wVirtualKeyCode==VK_LEFT || Rec->Event.KeyEvent.wVirtualKeyCode==VK_UP || (char)(Rec->Event.KeyEvent.wVirtualKeyCode&0xDF)=='S',
                            Rec->Event.KeyEvent.wVirtualKeyCode==VK_UP || Rec->Event.KeyEvent.wVirtualKeyCode==VK_DOWN,
                            TRUE);

        }else if( (dwOptions20 & OPT20_HRZ_SCROLL) &&
                  (Rec->Event.KeyEvent.wVirtualKeyCode==VK_LEFT || Rec->Event.KeyEvent.wVirtualKeyCode==VK_RIGHT) &&
                  !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED)) &&
                   (Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED)) &&
                   (Rec->Event.KeyEvent.dwControlKeyState & SHIFT_PRESSED) ){

            ret=Scroll(Rec->Event.KeyEvent.wVirtualKeyCode==VK_LEFT);

        }else if(
            (dwOptions20 & OPT20_LEFTKEEPLINE) &&
            Rec->Event.KeyEvent.wVirtualKeyCode==VK_LEFT ) {

            ret=EditMove(TRUE,FALSE,FALSE);

        }else if( (dwOptions20 & (OPT20_CLIPALL|OPT20_CLIPANSI)) && (
                  (Rec->Event.KeyEvent.wVirtualKeyCode==VK_INSERT || ((char)(Rec->Event.KeyEvent.wVirtualKeyCode&0xDF)=='C' && Rec->Event.KeyEvent.uChar.AsciiChar)) &&
                  (Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED)) &&
                  !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED|SHIFT_PRESSED))) ){

            ret=Copy(FALSE);

        }else if( (dwOptions20 & (OPT20_CLIPALL|OPT20_CLIPANSI)) && (
                  (Rec->Event.KeyEvent.wVirtualKeyCode==VK_DELETE &&
                  !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED|LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED)) &&
                  (Rec->Event.KeyEvent.dwControlKeyState & SHIFT_PRESSED) ) ||
                  ((char)(Rec->Event.KeyEvent.wVirtualKeyCode&0xDF)=='X') && Rec->Event.KeyEvent.uChar.AsciiChar &&
                  (Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED)) &&
                  !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED|SHIFT_PRESSED)) ) ){

            ret=Copy(TRUE);

        }else if( (dwOptions20 & (OPT20_PASTEOVER|OPT20_CLIPALL|OPT20_CLIPANSI|OPT20_PASTESETSEL)) && (
                  (Rec->Event.KeyEvent.wVirtualKeyCode==VK_INSERT &&
                  !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED|LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED)) &&
                  (Rec->Event.KeyEvent.dwControlKeyState & SHIFT_PRESSED) ) ||
                  ((char)(Rec->Event.KeyEvent.wVirtualKeyCode&0xDF)=='V') && Rec->Event.KeyEvent.uChar.AsciiChar &&
                  (Rec->Event.KeyEvent.dwControlKeyState & (LEFT_CTRL_PRESSED|RIGHT_CTRL_PRESSED)) &&
                  !(Rec->Event.KeyEvent.dwControlKeyState & (LEFT_ALT_PRESSED|RIGHT_ALT_PRESSED|SHIFT_PRESSED)) ) ){

            ret=Paste();

        }
    }
    bReenter=FALSE;
    return ret;
}
