{ $Id: dir2html.pas,v 3.67 2019/03/28 21:06:44 ralph Exp $ }

Program Dir2HTML;        { 1.may.2000, RalphRoth@gmx.de }

{ ----------------- ToDo/Enhancements Requests --------------------- }
{
        Command line handling:
        - Filemask -> *.html
        - options  -> /s   -> subdirectories
        - Documentation
        - INI-File, done
        - Customizable [Header] and [Footer] section, done
        - Enhanced Descript.ION handling (Long File Names), done
}
{ ----------------- ToDo/Enhancements Requests --------------------- }

{ a 20 minute hack, so don't expect anything :))

  Long file names work now under Win NT 3/4, Win9x and Win2000!

According to TIDY HTML a header should look like this:

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
      <HTML>
        <HEAD>
          <TITLE>Title</TITLE>
        </HEAD>

        <BODY>
          <-- ... body of document ... -->
        </BODY>
      </HTML>

XHTML 1.0/Strict

<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
       "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Text</title>
<!-- gegebenenfalls andere Elemente im Kopfbereich -->
</head>
<body>
<h1>Text</h1>
</body>
</html>


------------------------------------------------------------------------
Idea:
FilesList: TStringList;
FilesList := TStringList.Create;
FilesList.Sorted := True;
FilesList.Add(S);

for I := 0 to FilesList.Count-1 do
          Strip(FilesList[I]);
finally
        FilesList.Free;
}

{$I comp.pas}
{$IFDEF FPC}
  {$ifdef WINDOWS}
    {$R \tp\icons\dir2html.res}
  {$endif}
{$ENDIF}

(*

(C)opyright (ALL RIGHTS RESERVED!)

            +-----------------------------------+
             ROSE SWE
             Dipl.-Ing. Ralph Roth

             Vollstaendige Adresse, inkl.
             Email, FAX, Telefon & PGP key
             siehe Datei:   ROSEBBS.TXT

                     RalphRoth@gmx.de
                 http://rose.rult.at/
            +-----------------------------------+


*)

uses crt, dos, rStrings, pd_ini, desc4dos, r_utils,  rc4key, kommando

(* {$ifdef LINUX}  {$define NOMD5}  {$endif} *)

{$IFDEF NOMD5}
{$ELSE}
        ,md5
{$ENDIF}
;

   Const
      CopyRight =
'Dir2HTML $Revision: 3.67 $ -+- (c) by ROSE SWE -+- http://rose.rult.at -+-';
      RCS_ID_DIR2HTML : String (* 130 *) =
'$Header: /home/cvs/src/prj/dir2html/dir2html.pas,v 3.67 2019/03/28 21:06:44 ralph Exp $';
      MaxExclude = 51; { 50 for user, 51 = ouput }
      MD5SUM     = 'md5sums.md5';

   Var  sr              : SearchRec;
        hOut, hMD5      : Text;
        lFiles, lUsed   : LongInt;        { total files and used }
        { DirColl : TSortedCollection;  }
        ini             : PConfigFile;
        szOutput, szTmp : String;
        szExclude       : Array[1..MaxExclude] of String;
        t               : Byte;
        nFiles2Find     : byte;
        aKey            : tRC4Key;
        dSize           : LongInt;
        nNewer          : Integer;  { days = new }
        oKZ             : PKommandoZeile;

{ ------------------------------------------------------------------- }

Procedure AddLine;

var szTmp           : String;
    lFDate,lNDate   : LongInt;
    aDT             : DateTime;
    lYear, lRest    : LongInt;
{$IFDEF NOMD5}
{$ELSE}
    sMD5            : TMD5Digest;
{$ENDIF}

Begin { AddLine }

  for t := 1 to MaxExclude do
  begin
          if szExclude[t] = upper(sr.name) then exit;
  end;

  clreol;
  if (sr.attr and directory) <> directory
  then
          dSize := dSize + sr.size;       { changed/added 12.06.2005 22:41 by Ralph Roth  }

  write('Adding: ',PathFit(sr.name, 58),'  ',format(sr.size),#13);

  write(hOut,'<br />');     { tidy: <p> }
  write(hOut, Wandle_Datum(sr.time));
  if (sr.size = 0) or (Upper(sr.name) = upper(MD5SUM)) then
          write(hOut, '<b>','n/a': 12, '</b>  ')
  else
          write(hOut, '<b>',format(sr.size): 12, '</b>  ');
  write(hOut, '<b><a href="'+sr.name+'">');
{$IFDEF NOMD5}
{$ELSE}

(*
Borg No. One:
                Um Quickinfo/Tooltips bei allen Browsern anzuzeigen, gibt es die
                Moeglichkeit, JavaScript zu verwenden (nicht so empfehlenswert, fuer die
                Personen, die kein Java(Script) moegen).
                Oder einfach als Atribut der jeweiligen Grafik folgendes hinzufuegen:
                alt="quickinfo/tooltip MD5SUM" title="quickinfo/tooltip MD5SUM"
*)
  if not oKZ^.IsOption('NoMD5') then
  begin
    if oKZ^.IsOption('MD5Sum') and (Upper(sr.name) <> upper(MD5SUM)) then
    begin
            sMD5 := MD5File(sr.name);       { md5 stuff}
            write(hOut, '<img src="file.gif" alt="quickinfo: MD5SUM=');
            write(hOut, MD5Print(sMD5)+'  click here to download!" title="quickinfo: MD5SUM='+MD5Print(sMD5));
            write(hOut, '  click here to download!" border=0>');
            writeln(hMD5,MD5Print(sMD5),' ',sr.name);
    end else
            write(hOut, '<img src="file.gif" alt="click to download" title="click to download" border=0>');
  end;
{$ENDIF}
        write(hOut, '</a>  <a href="' +sr.name+ '">' +sr.name+ '</a> </b>');

{ Is this file new (DOS/Windows)? Or newer than NEWER=XX? }
  { PackTime(aDT, sr.time);
  -- Procedure Long2DTime(d: LongInt; var res : DateTime);
  -- Function DTime2Long(d: DateTime) : LongInt;
  sr.time = LongInt
  }
  UnPackTime(sr.time, aDT);
  {Long2DTime(sr.time, aDT);}
  lFDate := DTime2Long(aDT);

  { THIS IS UGLY; AND I AM SURE THERE ARE ALREADY TIME FUNCTIONS AVAILABLE THAT DO THIS???? }
  lYear := Trunc((lFDate+nNewer) / 10000);
  lRest := (lFDate+nNewer) mod 10000;
  while lRest >1231
  do begin
    inc(lYear);
    lRest := lRest - 1200;
  end;
  lNDate := lYear*10000 + lRest;

{$ifdef DEBUG}
  writeln(sr.time,' Y=',aDt.year,' -- File=',lFDate,'+', nNewer,'=',lNDate,'  Now=',CurrentTime2Long(0),'   ',#9);
   { /* here is a bug: 1100051150 Y=2012 -- File=20121217+93=20121310  Now=20130108 */ }
{$endif}

  if ((sr.Attr and Archive) = Archive) or (lNDate > CurrentTime2Long(0))
  then
          write(hOut,'<img src="new.gif" alt="updated/refreshed file!" title="updated/refreshed file!"> ');  { </img> }

  szTmp := GetDescript(sr.name);
  if (szTmp = '') and (not oKZ^.IsOption('NoWarn')) then
  writeln('WARNING: File '+sr.name+' - NO descript.ion entry found!  ');  { 3.32 }
  { Ascii2OEM() }
        if length(szTmp)>0 then
                write(hOut, {'<small>'+}szTmp{+'</small>'} );
        writeln(hOut);
        inc(lUsed);

End; { AddLine }

{ ------------------------------------------------------------------- }

Procedure Abort(szWhy : String);

begin
  writeln;
  writeln(GuruHeadLine('Fatal error, program Dir2HTML aborted!'));
  writeln;
  writeln('Reason: ', szWhy, #7);
  halt(1);
end;

{ ------------------------------------------------------------------- }

Procedure FetchIniLine(szKey: String);
{ reads from INI file and expandes include statements, rar 26102002 }

var s, szLine   : String;
    t           : SizeInt;
    hIn         : Text;
    cChar       : Char;

begin
   s := TrimL(Ini^.GetItem(szKey));
   if (pos('INCLUDE=', Upper(s)) = 1) then
      begin
              t := Pos('=', s);
              szLine := copy(s, t+1, 255);            { fetch filename! }
              assign(hIn, szLine);
              if ioresult <> 0 then Abort('Include file '+szLine+' not found!');
              reset(hIn);
              if ioresult <> 0 then Abort('Can not open include file '+szLine);
              while not eof(hIn) do
              begin
              { /* limited to 255 chars per line */
                      readln(hIn, szLine);
                      if szLine <> '' then
                              writeln(hOut, '  ', szLine);
               }
                   read(hIn, cChar);
                   write(hOut, cChar);
              end;
              close(hIn);
      end
   else
   if (s <> '')
       then writeln(hOut, #9, s);

end;

{ ------------------------------------------------------------------- }

Begin { Dir2HTML }

  lFiles := 0;
  lUsed  := 0;
  dSize  := 0;
  FileMode := $80;
  writeln(CopyRight);
  writeln('dir2html -? for help about command line options');
  writeln(GuruHeadline('Settings'));

  If not existonpath('dir2html.key', szTmp) then
  begin
          abort(szTmp+': Keyfile not found, aborting!');
  end;

  writeln('Using keyfile: ', szTmp);
  aKey.szFile := szTmp;
  CheckRC4Key(aKey);

  If not existonpath('dir2html.ini', szTmp) then
  begin
          abort(szTmp+': INI file not found, aborting!');
  end;

  Writeln('Using config file: ', szTmp);
  Writeln('Registered to: ' + aKey.szUserName);

  new(oKZ, init);

  if oKZ^.IsOption('?') or oKZ^.IsOption('h') then
  begin
    writeln;
    writeln(GuruHeadLine('Options'));
    writeln;
    writeln('-?  -h             This help screen :)');
    writeln('-Dir               Add also sub-directories');
    writeln('-newer=XX          Flag files as new, if they are younger than XX days');
    writeln('-NoLastUpdate      Do NOT include "last updated" in output');
    writeln('-NoJava            Do NOT include JavaScript remark in output');
    writeln('-NoMD5             Do NOT calculate and add MD5 check-sums + icons');
    writeln('-NoTotal           Do NOT include total files and size count in output');
    writeln('-NoWarn            Do NOT warn if there is not descript.ion entry for a file');
    writeln('-md5sum            Create an additionally MD5 check-sum file ('+MD5SUM+')');
    halt(0);
  end;

  if oKZ^.IsOption('MD5Sum') then
  begin
    write(MD5SUM,': ');
    if exists(MD5SUM) then
    begin
            unlink(MD5SUM);
            write(' [old erased]');
    end;
    assign(hMD5, MD5SUM);
    if ioresult <> 0 then write(' [fopen error!]');
    rewrite(hMD5);
    if ioresult <> 0 then write(' [fwrite error!]');
    { writeln(hMD5); -- md5sum: WARNUNG: 1 Zeile ist nicht korrekt formatiert }
    close(hMD5);
    if ioresult <> 0 then write(' [fclose error!]');
    if setdescript(MD5SUM, 'MD5 checksums of this folder')
            then write(' [desc added]')
            else write(' [desc failed!]');
    append(hMD5);
    if ioresult <> 0 then write(' [append error!]');
    writeln(' [done]');
  end;
  Ini := New( PConfigFile, Init( szTmp, 'dir2html', 'dir2html' ));

  nNewer := Ini^.GetLong('Newer');
  if oKZ^.IsOption('newer') then
  nNewer := oKZ^.GetValue('newer');
  if (nNewer<1) then
  nNewer := 90;
  writeln('* New files are less than ', nNewer,' days old.');
  nNewer := (nNewer mod 30) + Trunc(nNewer / 30)*100;

  for t := 1 to MaxExclude-1 do
          szExclude[t] := TrimR(Upper(Ini^.GetItem('Exclude'+hex(t,2))));

  szOutput := TrimR(Ini^.GetItem('output'));
  szExclude[MaxExclude] := Upper(szOutPut);       { exclude -> index.html }

  assign(hOut, szOutput);
  rewrite(hOut);
  If ioresult <> 0 Then
  Begin
        writeln('ERROR: Can not create '+szOutput+', aborting!');
        close(hOut {OutPut} );
        halt(1);
  End;

{ <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
  writeln(hOut, '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">'#13#10);

}
  writeln(hOut, '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'#13#10);
  writeln(hOut, '<html><head>');
  writeln(hOut, #9' <html lang="en">');
  writeln(hOut, #9'<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">');
  writeln(hOut, #9'<meta name="generator" content="'+CopyRight+
                  #13#10'Registered to: ' + aKey.szUserName+'">');
  writeln(hOut, #9'<meta name="Author" content="'+RCS_ID_DIR2HTML+'">');
  for t := 0 to 15 do
  begin
          FetchIniLine('Header'+hex(t,1));
  end;
  writeln(hOut, #9'<title>',ini^.GetItem('Title'),'</title>');
  writeln(hOut, '</head>');
  writeln(hOut, '<body text="#F0F0F0" bgcolor="#000000" link="#FFFF00" '+
                'vlink="#C0C0C0" alink="#C0FFC0" background="background.gif">');

  if not oKZ^.IsOption('NoLastUpdate') then
  begin
    writeln(hOut, '<hr><center><font face="Arial, Helvetica, sans-serif">');
    writeln(hOut, '<h3>Last Updated: ' + Datum + ' '+GetEnv('TZ')+'  ('+time+')</h3>');
    writeln(hOut, '</font></center><hr>');
  end;

  for t := 0 to 15 do
      FetchIniLine('TextBefore'+hex(t,1));

  writeln(hOut, '<pre>');
  if oKZ^.IsOption('Dir') then
          nFiles2Find := anyfile-volumeid-hidden
  else
          nFiles2Find := anyfile-directory-volumeid-hidden;
  findfirst(FILEMASKALL, nFiles2Find, sr);
  while doserror = 0 Do
  Begin
         { index.html > lfn } { INDEX.HTM  > DOS 8.3 }
    if (sr.name <> '.') and (sr.name <> '..')
    then
    begin
         inc(lFiles);
         AddLine;
    end;
    findnext(sr)
  End; {endwhile}

  if not oKZ^.IsOption('NoTotal') then
      writeln(hOut,'<hr><br />Total: <b>' + padl(format(dSize), 15) + '</b>  '+format(lused)+' Files');

  writeln(hOut,'');
  writeln(hOut, '</pre><hr><font size="-1">');
  writeln(hOut, 'Web page created with <b> <a href="http://rose.rult.at/">'
                +CopyRight+ '</a></b>');

  if not oKZ^.IsOption('NoJava') then
  begin
      writeln(hOut, '<script language="JavaScript" type="text/javascript">'); { 1.33 }
      writeln(hOut, '<!--'); { 1.33 }
      writeln(hOut, '    document.write("<br><a href="+document.location+">This web page is located at " + document.location+"</a>");'); { 1.33 }
      writeln(hOut, '// -->'); { 1.33 }
      writeln(hOut, '</script>'); { 1.33 }
      writeln(hOut, ' - This site requires Java Script enabled! ');
  end;
  for t := 0 to 15 do
      FetchIniLine('TextAtEnd'+hex(t,1));

  writeln(hOut, '</font></body></html>');
  writeln(hOut);
  close(hOut);

  writeln(szOutput,': ',lused,' from ',lFiles,' files processed! ',format(dSize),' bytes. Good Bye!');

  { close(OutPut); }

  if oKZ^.IsOption('MD5Sum') then
  begin
          close(hMD5);
  end;
  ini^.SetItem('LastRun', datum);
  dispose(ini, done); { changed 20121228+29. Juli 2015 by Ralph Roth }
(*
RT 216 General Protection fault
 The application tried to access invalid memory space. This can be caused
 by several problems:
Deferencing a nil pointer
Trying to access memory which is out of bounds (for example, calling move
with an invalid length).
*)

  dispose(oKz, done);
  halt(0);

End. { Dir2HTML }

{

  1.00          01.May.2000, TP 6.0/7.0
  2.00          23.June.2002, first version with customizable INI file

Dir to HTML, Web tool by ROSE SWE
------------------------------------------------------------------------
$Log: dir2html.pas,v $
Revision 3.67  2019/03/28 21:06:44  ralph
upd: Windows: Forced commit by cvsall_win at 2019-03-28T22:06+01:00 on DESKTOP-874T76T !minor

Revision 3.65  2018/02/26 08:05:56  ralph
dir2html release 3.65

Revision 3.60  2015/07/29 10:12:14  ralph
fixes from FPC+pd_ini (destructor:FALSE)

Revision 3.58  2014/02/28 15:27:58  ralph
dir2html: added -newer option, fixed empty line in md5sums.
describe: can now handle terminals with more than 80 chars, e.g. Linux Konsole

Revision 3.56  2013-02-08 21:48:35  ralph
fixes for defect come.to redirector

Revision 3.55  2013-01-08 15:45:46  ralph
timebug_fixed

Revision 3.54  2012-12-28 19:00:34  ralph
added Linux filehandling (newer=xx days), similar to DOS Archive attribute

Revision 3.50  2011-01-17 21:25:55  Ralph
Small enhancements/re-formatting

Revision 3.48  2010/04/26 19:59:42  Ralph
Icon Resource added

Revision 3.44  2009/07/02 21:47:48  Ralph
typo fixes, version numbering

Revision 3.39  2006/09/08 15:11:53  Ralph
Added /NOWARN feature

Revision 3.37  2006/04/03 21:12:30  ralph
added hints and enhancements suggested by Borg No. One

Revision 3.35  2006/04/03 20:47:49  ralph
+ added quickinfo/tooltips suggestion made by Borg No. One
+ fixed bug with md5 check sum on md5sums.md5 - found by Chris

Revision 3.33  2006/02/06 13:05:24  ralproth
Bugfix for lines greater than 254 chars.

Revision 3.30  2005/11/14 21:42:53  ralproth
describe: get/set stuff, dir2html 3.13, small enhancements

Revision 3.29  2005/06/29 21:13:50  ralproth
dir2html 3.12//fixes for freepas 2.0.0

Revision 3.28  2005/06/13 16:42:29  ralproth
dir2html 3.11 with directory support

Revision 3.27  2005/04/07 17:40:26  ralproth
tstings/tsortedstrings added as comment

Revision 3.26  2005/02/10 21:45:44  ralproth
! replaced non-portable md5 windows unit with new fpc 1.9.6 unit

Revision 3.24  2004/07/23 08:49:44  ralproth
Dir2HTML: Added CommandLine support and md5sum.md5 support

Revision 3.19  2003/02/27 16:23:01  ralph roth
Added Timezone (TZ) handling

Revision 3.18  2003/01/12 20:20:51  ralph
dir2html 2.21 release

Revision 3.16  2002/10/27 18:55:47  ralph
+ option include= added
+ added keyword TextAtEnd

Revision 3.15  2002/09/04 20:42:35  ralph roth
2.10 release: Typo fixes

Revision 3.14  2002/09/03 19:26:48  ralph
+ Added CSS script support
- Arial Font definitions
+ Added TextBefore0x handling

Revision 3.13  2002/07/01 20:01:01  ralph
Dir2HTML 2.01 - small fixes for .INI file handling

Revision 3.12  2002/06/26 21:53:15  ralph
Fixed some memory heap leaks using fpc -gh -gl functions

Revision 3.11  2002/06/25 20:23:34  ralph
Dir2HTML 2.00 with INI file. First working version.

Revision 3.10  2002/06/23 19:22:21  ralph
Dir2HTML 2.00 - first working version with keyfile and ini file support

Revision 3.9  2002/05/26 18:55:54  ralph
Fixed Umlaute in DESCRIBE (ascii2oem)

Revision 3.8  2002/05/02 08:21:24  ralph
Dir2HTML 1.52 - fixed font

Revision 3.7  2002/03/27 22:32:56  ralph
dir2html 1.51 (fixed for dir2html.ico)

Revision 3.6  2002/03/06 17:33:22  ralph
LFN handling for descript.ion

Revision 3.5  2002/02/27 20:43:24  ralph
Added MD5 hashes to Dir2HTML, some small fixes

Revision 3.4  2001/12/20 10:32:43  ralph
Dir2HTML 1.40: Fixed all bugs Tidy claims about, W3C 3.2 complaint
Fixed new.gif

Describe 1.10 - Autohandling for FILE_ID.DIZ and CrCheck.txt added.
Supports now longer descriptions.

revision 1.1
date: 2000/12/23 20:13:35;  author: ralph_zimmern;  state: Exp;
Initial revision
=============================================================================

}
