Program Describe;        { 19.09.2001, rar }
{$i comp.pas}

{ * $Header: /home/cvs/src/prj/dir2html/describe.pas,v 3.31 2017/01/02 09:14:01 ralph Exp $
}
{ *
  * (C)opyright 1989-2017 by ROSE SWE, Dipl.Ing. Ralph Roth, ROSE_SWE@hotmail.com
  *                          http://rose.rult.at - ALL RIGHTS RESERVED!
  * Portable code, works on DOS16, DOS32, Windows and Linux
  *
}

{$IFDEF FPC}
{$ifdef windows}
{$R \tp\icons\dir2html.res}
{$endif}
{$ENDIF}

uses crt, dos, desc4dos, jwtool, rStrings, r_utils, kommando, md5;

Var sr          : Searchrec;
    szDesc      : String;
    lDone       : LongInt;
    oKZ         : PKommandoZeile;
    bMD5        : Boolean;
    szDir       : String;

Begin { Describe }

      {TestUnitKommando(false);}

      new(oKZ, init);
      bMD5 := okZ^.IsOption('md5');
      szDir := '';

      if oKZ^.IsOption('Get') then
      begin
                szDir := oKZ^.ParamString(1);
		writeln(GetDescript(szDir));
		halt(0);
      end;

      Writeln('Describe - Creates DESCRIPT.ION entries for files. (c) by ROSE SWE, Ralph Roth');
      Writeln('$Id: describe.pas,v 3.31 2017/01/02 09:14:01 ralph Exp $');

      If (ParamCount < 1) or (oKZ^.IsOption('?')) Then
         Begin
            writeln('usage:');
            writeln('   SET:    describe [-md5] [-batch] [-dir]    file|filemask');
            writeln('   GET:    describe -get file');
            halt(1);
         End;

      textattr := 7;
      lDone    := 0;

      findfirst(oKZ^.ParamString(1), AnyFile-VolumeID-Directory, sr);
      while DosError =  0 Do
      Begin

         if bMD5 then szDesc := MD5Print(MD5File(sr.name))+' '
                 else szDesc := '';
         if (length(sr.name)>22) then
          writeln(sr.name)
         else
          write(padr(sr.name,24),'  ');

        if oKZ^.IsOption('Dir') then
                begin
                        getdir(0, szDir);
                        szDesc := FileNameSplit(szDir);
                end
        else
                begin
                 if Upper(sr.name) = 'FILE_ID.DIZ' then
                    szDesc := 'Description of files/package inside an archive'
                 else
                  if Upper(sr.name) = 'CRCHECK.TXT' then
                    szDesc := 'Checksum file, run CrCheck to verify contents!'
                  else
                   if not oKZ^.IsOption('Batch') then
                    szDesc := Input_Text(szDesc+GetDescript(sr.name), WindMaxX-4-wherex, wherex, wherey);
                end;
         clreol;
         szDesc := ASCII2OEM(szDesc);
         If szDesc <> '' Then
            If SetDescript(sr.name, szDesc) Then write(szDesc,'-ok');
         writeln;
         inc(lDone);
         findnext(sr);
      End;

      if (lDone = 0) then
      begin
         writeln('No matching files found!');
         halt(1);
      end
       else
         halt(0);

End. { Describe }

{
 $Log: describe.pas,v $
 Revision 3.31  2017/01/02 09:14:01  ralph
 Changed the copyright year to 2017 (src)

 Revision 3.30  2015/12/27 12:36:41  ralph
 Yearly change of the copyright (y2k16)

 Revision 3.29  2014/12/21 14:03:00  ralph
 changed copyright y2k15 (src)

 Revision 3.28  2014/03/24 10:49:09  ralph
 fixes for Linux terminal bigger than 252 chars

 Revision 3.27  2014/02/28 15:27:58  ralph
 dir2html: added -newer option, fixed empty line in md5sums.
 describe: can now handle terminals with more than 80 chars, e.g. Linux Konsole

 Revision 3.25  2013-02-09 10:25:03  ralph
 replaced defect come.to redirector with rose.rult.at

 Revision 3.21  2010/06/14 19:39:09  Ralph
 Upstream nc6320, b5300

 Revision 3.20  2010/04/26 19:59:41  Ralph
 Icon Resource added

 Revision 3.14  2005/11/18 08:23:34  ralproth
 tried to fixed rte 216/fpc 2.0/win32 creates

 Revision 3.13  2005/11/14 21:42:53  ralproth
 describe: get/set stuff, dir2html 3.13, small enhancements

 Revision 3.11  2005/04/27 20:27:52  ralproth
 added -md5 -batch options

 Revision 3.10  2005/02/17 18:54:28  ralproth
 dir2html 3.10 web release

 Revision 3.6  2002/06/27 17:55:36  ralph
 Added check if zero files were processed.

 Revision 3.5  2002/05/26 18:55:54  ralph
 Fixed Umlaute in DESCRIBE (ascii2oem)

 Revision 3.4  2002/03/06 17:33:21  ralph
 LFN handling for descript.ion

 Revision 3.3  2001/11/26 20:14:34  Administrator
 Dir2HTML 1.31 - increased version number to indicate changes on Units
 and Describe

 Revision 1.1  2001/10/06 09:43:13  rar_ulm
 Initial revision

}
