;                                                                           ;
;                       DELTREE.S  v1.01  01-17-1999                        ;
;                       Copyright 1998, 1999  C. Dye                        ;
;                       email:  raster@highfiber.com                        ;
;                                                                           ;
;       This is source for Eric Isaacson's shareware assembler, A86.        ;
;       Re-assemble by typing A86 DELTREE.S.                                ;
;                                                                           ;
;       This program is copyrighted, but may be freely distributed          ;
;       under the terms of the Free Software Foundation's GNU general       ;
;       public license v2 (or later.)  See the file COPYING for the         ;
;       legalities.  If you did not receive a copy of COPYING, you          ;
;       may request one from the Free Software Foundation, Inc.,            ;
;       59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           ;
;       ABSOLUTELY NO WARRANTY -- use it at your own risk!                  ;
;                                                                           ;

radix 16                               ; gentlemen prefer hex

doscall macro                          ; call to dos int_21 with a
mov ah,#1                              ; one-byte function in ah
int 21
#em

doscall2 macro                         ; call to dos int_21 with a
mov ax,#1                              ; two-byte function in ax
int 21
#em

dosprint macro                         ; call to dos string-print function
mov dx,offset #1
mov ah,09
int 21
#em

zprint macro                           ; call to program's asciiz-print
mov di,offset #1                       ; subroutine
call zprint1
#em

zero macro                             ; set a register to zero
xor #1,#1
#em


maxlen   equ  0050                     ; maximum length of a filename


;  remove the following line to disable the root-directory safety check :

mungabunga  equ  1


; ------------------------------------ UNINITIALIZED VARIABLES IN PSP :

country  equ  005c                     ; put country data in the psp
country_thou equ country + 07          ; local thousands char (',' in usa)
country_deci equ country + 09          ; local decimal point  ('.' in usa)

tempvar  equ  0070                     ; variable used for sundry stuff


; -------------------------------------- START OF CODE :

begin:
cld
doscall2 3000                          ; check ms-dos version:
cmp al,02
ja dos_okay
dosprint msg_err_dos_bad               ; dos prior to version 3 :  complain!
doscall2 4c12                          ; and exit with errorlevel 18
int 20                                 ; (exit for dos 1.x)
dos_okay:
cmp bh,0fd                             ; running under freedos?
jne not_old_fd                         ; if not, never mind
jcxz fd_fix                            ; (i don't think this ever happens)
cmp cx,0ffff                           ; older beta release?
jne not_old_fd                         ; if not, never mind
fd_fix:
mov w [subdir_clear],0010              ; old freedos kernel, work around bug
not_old_fd:
mov ax,sp                              ; examine stack pointer:
cmp ax,stack_end                       ; plenty of room?
jae > l1
trs_80:                                ; not enough memory:
call error_out
dosprint msg_trs_80                    ; complain
doscall2 4c11                          ; and exit with errorlevel 17
l1:
mov sp,stack_end                       ; reduce stack size
zero ax                                ; push zero word onto stack
push ax                                ; for possible exit via ret
push cs
pop es                                 ; get program segment into .es
mov bx,(stack_end / 10) + 1
doscall 4a                             ; and shrink program's memory block
jc trs_80                              ; any error, assume not enough memory

call alloc_list_buffer                 ; allocate buffer for file list
call get_country_info                  ; get current country info
mov dx,offset dta
doscall 1a                             ; use primary disk transfer area
mov si,0080                            ; read from command line

parse_main:                            ; PRIMARY PARSER LOOP :
inc si
switch_done:
mov al,b [si]                          ; examine next character
call test_eol                          ; end of line?
je parse_done                          ; if so, terminate primary parser
call test_space                        ; is it a space?
je parse_main                          ; if so, ignore it
cmp w [parse_save],0000                ; have we found any filespecs yet?
jne > l1                               ; if so, don't check for switches
call test_switch                       ; is it a switch character?
je found_switch                        ; if so, interpret it
l1:                                    ; found the start of a filespec :
call parse_fn                          ; parse through the filespec
mov w [parse_save],si                  ; and save parse index
call handle_filespec                   ; delete item(s) as needed
mov si,w [parse_save]                  ; restore the parse index
mov al,b [si]
call test_eol                          ; found the end of the line yet?
je parse_done                          ; if so, terminate primary parser
jmp parse_main                         ; otherwise, keep on truckin'

found_switch:                          ; FOUND A SWITCH CHARACTER :
inc si
lodsb                                  ; examine next character
call force_lc                          ; in lowercase :
mov bx,0ffff                           ; start at beginning of switch table
l0:
inc bx
cmp b [switches+bx],00                 ; run out of legal switches to try?
je syntax                              ; if so, syntax error
cmp b [switches+bx],al                 ; found this letter in table?
jne l0                                 ; if not, keep looking
shl bx,01                              ; multiply .bx by two
mov ax,w [switch_routines+bx]          ; and get address of switch routine
jmp ax                                 ; to jump to

syntax:                                ; SYNTAX ERROR IN COMMAND LINE :
call error_out                         ; use stderr for output, fall through

switch_query:                          ; /? -- REQUEST SYNTAX DISPLAY :
dosprint msg_syntax                    ; print error message
doscall2 4c10                          ; and exit with errorlevel 16

parse_done:                            ; DONE PARSING COMMAND LINE :
cmp w [parse_save],0000                ; found any filespecs at all?
jne exit_program                       ; if not,
call error_out
dosprint msg_err_no_specs              ; display an error message
doscall2 4c10                          ; and exit with errorlevel 16
exit_program:                          ; if so,
call show_report                       ; display damage report if desired
mov al,b [return_code]                 ; return success or failure errorlevel
doscall 4c                             ; and exit to dos


handle_filespec:                       ; DELETE ITEM(S) AS NEEDED :
call prompt_fix                        ; force output to console for prompts
call clean_up_filespec                 ; canonicalize filespec
filespec_loop:
call get_fn_from_list                  ; read filespec from list, if needed
jc ret                                 ; if eof, exit
#if mungabunga
call root_safety                       ; check for extra-dangerous commands
jne safety_abort
#endif
subdir_loop:
call find_multiple_files               ; find files matching this filespec
jnc subdir_loop                        ; if so, alter any files in it
safety_abort:
test b [flags],04                      ; using a file list?
jne filespec_loop                      ; if so, get next filespec from it
ret                                    ; if not, exit

show_report:                           ; REPORT ON TOTAL DESTRUCTION :
test b [flags],40                      ; was /v specified on command line?
je ret                                 ; if not, just exit
dosprint msg_num_deleted               ; print 'files deleted' message
mov ax,w [deleted+0]                   ; get the number of files squiffed
mov dx,w [deleted+2]                   ; low word / high word
call dec_print_big                     ; and display it
call show_totals                       ; show total of file sizes, if needed
dosprint msg_num_removed               ; print 'subdirs removed' message
mov ax,w [removed+0]                   ; get number of directories removed
mov dx,w [removed+2]                   ; low word / high word
call dec_print_big                     ; and display it
call crlf                              ; finish off the line
ret                                    ; and exit

show_totals:                           ; DISPLAY TOTAL OF SIZES AS KB OR MB :
mov ax,w [deleted+0]
or  ax,w [deleted+2]                   ; were any files at all deleted?
or ax,ax                               ; if not,
je ret                                 ; exit without further comment
dosprint msg_total_sizes               ; print 'total of sizes' string
mov ax,w [total_sizes+0]               ; get total of file sizes
mov dx,w [total_sizes+2]               ; low word / high word
call dec_print_big                     ; and display it
dosprint msg_bytes                     ; 'bytes'
mov ax,w [total_sizes+0]               ; get total of file sizes
mov dx,w [total_sizes+2]               ; low word / high word
cmp dx,0010                            ; is the file 1 mb or larger?
jae show_size_mb                       ; if so, show file size in megs
show_size_kb:                          ; otherwise, report file size in kb :
mov cl,0a
shr ax,cl                              ; divide low word by 1024
mov cl,06
shl dx,cl                              ; get most significant bits
or ax,dx
call dec_print_small                   ; and display kb value
mov ax,w [total_sizes+0]               ; get fractional kb
shr ax,1
shr ax,1                               ; in al (0 to 255)
call show_fraction                     ; and display fractional kb
dosprint msg_kilobytes                 ; show 'kilobytes' message
ret
show_size_mb:                          ; report file size in mb :
mov ax,w [total_sizes+2]
mov cl,04
shr ax,cl                              ; file size in mb
call dec_print_small                   ; display mb value
mov ax,w [total_sizes+0]
mov dx,w [total_sizes+2]
mov cl,0c
shr ax,cl
mov cl,04
shl dx,cl
or ax,dx                               ; fractional mb value (0-255) in al
call show_fraction                     ; display fractional mb
dosprint msg_megabytes                 ; show 'megabytes' message
ret

show_fraction:                         ; al contains a value 0-255 :
push ax                                ; save it
mov dl,b [country_deci]
doscall 02                             ; display a decimal point
pop ax                                 ; al contains 0-255 :
mov ah,00                              ; convert to word length
mov bl,64
mul bl                                 ; multiply by 100
test al,80                             ; need to round up?
je show_frac_fix                       ; no, skip ahead
cmp ah,063                             ; would rounding up crack 100?
jae show_frac_fix                      ; if so, forget it (lazy bastard!)
inc ah                                 ; round fraction up
show_frac_fix:
mov al,ah
mov ah,00                              ; divide by 256
aam                                    ; convert to decimal digits
add ax,'0' by '0'                      ; and convert those to ascii
push ax                                ; save ones digit
mov dl,ah
doscall 02                             ; print tens digit
pop dx                                 ; retrieve ones digit
int 21                                 ; and print that
ret                                    ; exit

parse_fn:                              ; READ FILESPEC FROM COMMAND LINE :
and b [flags],0fa                      ; turn off quote-mode and at-mode
mov di,offset fnbuf                    ; point to filespec buffer
mov cl,00                              ; no characters yet
mov b [di],00                          ; empty the buffer

parse_fn_1:                            ; parse filename loop :
lodsb                                  ; get a character from command line
call force_lc                          ; and force it to lowercase
call test_eol                          ; end of line?
je parse_fn_eol                        ; if so, handle it
call test_space                        ; space or tab?
je parse_fn_space                      ; if so, handle it
cmp al,'"'                             ; quote mark?
je parse_fn_quote                      ; if so, handle it
cmp al,'/'                             ; forward slash?
jne > l2
mov al,'\'                             ; if so, convert to backslash
l2:
cmp al,'@'                             ; at sign?
jne parse_fn_char                      ; no, treat like a normal character
cmp cl,00                              ; yes:  got any characters yet?
jne parse_fn_char                      ; yes:  at sign is part of filename
test b [flags],05                      ; quote-mode or at-mode?  if either,
jne parse_fn_char                      ; at sign is part of filename
or b [flags],04                        ; note:  file list
jmp parse_fn_1                         ; continue parsing

parse_fn_char:                         ; NORMAL CHARACTER IN FILENAME :
mov b [di],al                          ; stash it
inc di
mov b [di],00                          ; null terminate the buffer
inc cl                                 ; increment count of characters
cmp cl,maxlen                          ; buffer overflow?
jb parse_fn_1                          ; if not, continue parsing
call error_out
dosprint msg_err_fn_ovf                ; if so, print error message
doscall2 4c10                          ; and exit with errorlevel 16

parse_fn_eol:                          ; FOUND THE END OF COMMAND LINE :
cmp cl,00                              ; found a filename yet?
jne > l0
call error_out
dosprint msg_err_in_filespec           ; if not, complain
doscall2 4c10                          ; and exit with errorlevel 16
l0:
dec si                                 ; let the primary parser see it
ret                                    ; and we're done parsing the filespec

parse_fn_space:                        ; FOUND A SPACE IN THE FILESPEC :
test b [flags],01                      ; parsing between quotes?
jne parse_fn_char                      ; if so, treat like any other char
cmp cl,00                              ; any characters in filespec yet?
jne > l1
call error_out
dosprint msg_err_in_filespec           ; if not, complain
doscall2 4c10                          ; and exit with errorlevel 16
l1:
dec si                                 ; if so, we're done parsing filespec
ret

parse_fn_quote:                        ; found a quote mark :
test b [flags],01                      ; has an opening quote been found?
jne parse_close_quote                  ; if so, this is a close quote
cmp cl,00                              ; is the filename empty?
jne parse_fn_char                      ; if not, quote is part of filename
or b [flags],01                        ; note that open quote was found
jmp parse_fn_1                         ; and continue parsing
parse_close_quote:
cmp cl,00                              ; empty filename?
jne > l2
call error_out
dosprint msg_err_in_filespec           ; if so, complain
doscall2 4c10                          ; and exit with errorlevel 16
l2:
ret                                    ; if not, done parsing filespec


find_multiple_files:                   ; FIND FILES MATCHING CURRENT SPEC :
mov dx,offset dta
doscall 1a                             ; use primary disk transfer area
mov dx,offset fnbuf                    ; point to working filespec
mov cx,0016                            ; include hidden and system files
doscall 4e                             ; find first matching file
find_multi_1:
jc find_multi_exit                     ; any error, exit loop
cmp b [dta_name],'.'                   ; stupid dos . or .. entry ?
je find_next_file                      ; if so, ignore it
test b [dta_attr],40                   ; name of a character device?
jne find_multi_err                     ; if so, exit
call nuke_item                         ; do it to it!
mov dx,offset dta
doscall 1a                             ; return to primary disk transfer area
find_next_file:
doscall 4f                             ; find next matching file
jmp find_multi_1                       ; till the cows come home
find_multi_err:
stc
find_multi_exit:
ret

nuke_item:                             ; DO WHATEVER TO THE FOUND FILE :
call crlf_maybe                        ; print a crlf if needed
call append_found_filespec             ; use the filename that was found
call prompt_user                       ; prompt user, if necessary
jne ret                                ; if user declined, exit now 
dosprint msg_deleting                  ; print 'deleting' message
call show_fnbuf                        ; and the current filespec
dosprint msg_ellipsis                  ; finish by displaying some dots
test b [flags],20                      ; was /x specified?
jne ret                                ; if so, exit without doing anything
mov dx,offset alt_dta
doscall 1a                             ; switch to alternate dta
call fix_last_bs
mov ax,w [last_bs]                     ; save value of last_bs so that we
mov w [topmost],ax                     ; don't exit the target directory !!!

nuke_loop:                             ; SHERMAN THROUGH GEORGIA :
mov dx,offset fnbuf
mov cx,0016
mov ah,4e                              ; find first matching entry
nuke_reloop:
int 21                                 ; look for item
if nc jmp nuke_something               ; found something?  if so, go kill it
mov di,w [last_bs]                     ; if not, target directory is empty
cmp di,w [topmost]                     ; in the topmost directory now?
jbe > l20                              ; yes, exit nuke_loop
mov b [di],00                          ; no, move up a level
test b [flags],08
je > l08
dosprint msg_debug_rmdir               ; print debug info, if desired
zprint fnbuf
l08:
mov dx,offset fnbuf                    ; point to name of target directory
mov cx,w [subdir_clear]                ; and clear all attributes
doscall2 4301                          ; (should not be necessary, but ....)
if c jmp err_rmdir
mov dx,offset fnbuf                    ; point to name of target directory
doscall 3a                             ; and rmdir it
if c jmp err_rmdir
add w [removed+0],0001
adc w [removed+2],0000                 ; add one to count of removed subdirs
mov di,w [last_bs]
l10:
dec di                                 ; hunt backwards through filespec
cmp b [di],'\'                         ; for previous backslash
jne l10
cmp di,w [topmost]                     ; have we backed up out of the target
jbe > l20                              ; area?  if so, time to quit!
mov w [last_bs],di                     ; otherwise save new value for last_bs
inc di
mov si,offset star_dot_star            ; and append a star-dot-star
call copy_string                       ; to exit to parent directory
test b [flags],08
je > l18
dosprint msg_debug_uplevel             ; print debug info, if desired
zprint fnbuf
l18:
jmp nuke_loop                          ; loop back for more destruction
l20:                                   ; time to quit finding things to kill:
mov di,w [topmost]                     ; restore correct value
mov w [last_bs],di                     ; to last_bs
mov w [di],00 by '\'                   ; add a backslash and a null
test b [flags],08
je > l28
dosprint msg_debug_quit                ; print debug info, if desired
l28:
ret                                    ; and exit
nuke_something:                        ; found something to destroy :
call append_found_alt                  ; append filename to fnbuf
cmp b [alt_name],'.'                   ; stupid dos . or .. entry?
jne nuke_realthing                     ; if so, just skip over it
test b [flags],08
je > l38
dosprint msg_debug_ignore              ; print debug info, if desired
zprint fnbuf
l38:
mov ah,4f                              ; dos find_next -- ignore . or ..
jmp nuke_reloop                        ; loop back for more
nuke_realthing:                        ; found a real file or subdirectory :
test b [alt_attr],10                   ; is this a subdirectory?
je nuke_file                           ; if not, it's a file -- red meat
test b [flags],08
je > l48
dosprint msg_debug_subdir              ; print debug info, if desired
zprint fnbuf
l48:
call find_null_fnbuf                   ; find the terminal null
mov w [last_bs],di                     ; update last_bs variable
mov si,offset bs_star_dot_star         ; and tack on a star-dot-star
call copy_string                       ; to enter the subdirectory
jmp nuke_loop                          ; loop back, keep hunting
nuke_file:                             ; found a file to kill :
test b [flags],08
je > l58
dosprint msg_debug_file                ; print debug info, if desired
zprint fnbuf
l58:
mov dx,offset fnbuf                    ; point to name of target directory
zero cx
doscall2 4301                          ; and clear all attributes
jc err_del
mov dx,offset fnbuf                    ; point to name of target file
doscall 41                             ; and delete it
jc err_del
add w [deleted+0],0001
adc w [deleted+2],0000                 ; add one to count of deleted files
mov ax,w [alt_size+0]
mov dx,w [alt_size+2]                  ; add file size, low-high
add w [total_sizes+0],ax               ; to total of deleted files' sizes
adc w [total_sizes+2],dx
mov ah,4f                              ; dos find-next function
jmp nuke_reloop                        ; loop back for more fun

err_del:                               ; can't delete target file :
mov dx,offset msg_err_del
jmp err_nuke
err_rmdir:                             ; can't remove target directory :
mov dx,offset msg_err_rmdir
err_nuke:                              ; can't remove target whatever :
push dx                                ; save offset of the error message
mov w [tempvar],ax                     ; save the error code
dosprint msg_err_dos                   ; print 'dos error' message
mov ax,w [tempvar]                     ; get the error code
call dec_print_small                   ; and print it as a decimal number
pop dx                                 ; get pointer to error type message
doscall 09                             ; and display that (to stdout)
call show_fnbuf                        ; display the current filespec
dosprint msg_err_finis                 ; and a close quote
mov ax,w [tempvar]                     ; get the error code again
call show_error_string                 ; display error string, if any
call crlf                              ; then terminate the print line
mov di,w [topmost]                     ; restore correct value
mov w [last_bs],di                     ; to last_bs
mov w [di],00 by '\'                   ; add a backslash and a null
mov b [return_code],01                 ; set failure flag
or b [flags],10                        ; note that a crlf is pending
ret                                    ; exit from nuke_loop

show_error_string:                     ; DISPLAY ERROR STRING, IF ANY :
cmp ah,00                              ; error number greather than 255?
jne ret                                ; if so, exit
cmp al,00                              ; error number exactly zero?
je ret                                 ; if so, exit
mov bx,0ffff
l1:
inc bx                                 ; examine next possible error code
mov ah,b [error_numbers+bx]
cmp ah,00                              ; hit the end of the list?
je ret                                 ; if so, exit with no string
cmp al,ah                              ; found the actual error number?
jne l1                                 ; if not, loop back for next
mov cx,bx                              ; move index into count register
mov bx,offset error_strings            ; and start at beginning of strings
l3:
jcxz > l5                              ; found the correct string yet?
l4:                                    ; if so, display it
inc bx                                 ; if not, scan forward through string
cmp b [bx],'$'                         ; looking for dollar sign
jne l4                                 ; found it?  no, keep looking
inc bx                                 ; yes, skip over dollar sign
loop l3                                ; and loop back
l5:                                    ; have pointer to correct string :
dosprint msg_open_pat                  ; display an open parenthesis
mov dx,bx
doscall 09                             ; display the error string
dosprint msg_close_pat                 ; and a close parenthesis
ret

switch_y:                              ; SWITCH /Y -- DO NOT PROMPT
or b [flags],80
jmp switch_done

switch_v:                              ; SWITCH /V -- VERBOSE
or b [flags],40
jmp switch_done

switch_d:                              ; SWITCH /D -- DISPLAY DEBUG INFO
or b [flags],08
jmp switch_done

switch_x:                              ; SWITCH /X -- DON'T REALLY DELETE
or b [flags],20
jmp switch_done


dec_print_small:                       ; DISPLAY WORD IN AX
zero dx                                ; zero dx and fall through to ....

dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov w [dp_t1],ax                       ; save the doubleword value
mov w [dp_t2],dx                       ; for later use
mov b [dp_t4],00
mov bx,000a                            ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00                              ; init digits-between-commas count
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,w [dp_t2]                       ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov w [dp_t2],ax                       ; save new high-order word
mov ax,w [dp_t1]                       ; get the old low word
div bx                                 ; and divide by ten
mov w [dp_t1],ax                       ; save new low word
add dx,0030                            ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc b [dp_t4]
or ax,ax                               ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp w [dp_t2],0000
je dec_print_15                        ; if not, print out digits
dec_print_12:
inc cl
cmp cl,03                              ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00                              ; yes, zero counter
mov dl,b [country_thou]
mov dh,dl                              ; and push a comma on the stack
push dx
inc b [dp_t4]
jmp dec_print_1                        ; and loop back for next digit
dec_print_15:                          ; done with divisions :
mov ah,02                              ; dos print-character function
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,000a                            ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
int 21                                 ; otherwise, print the digit
jmp dec_print_2                        ; and loop back for next digit
dec_print_3:
ret

dp_t1:                                 ; holds low-order word
dw 0000
dp_t2:                                 ; holds high-order word
dw 0000
dp_t4:                                 ; count of characters pushed on stack
db 00

force_lc:                              ; FORCE CHARACTER IN .AL TO LOWERCASE:
cmp al,'A'
jb ret
cmp al,'Z'
ja ret
or al,20
ret

test_switch:                           ; IS CHAR IN .AL A SWITCH CHARACTER?
cmp al,'/'                             ; exit with zero flag set if it is
je ret
cmp al,'-'
ret

test_space:                            ; IS CHARACTER IN .AL A SPACE OR TAB?
cmp al,20                              ; exit with zero flag set if it is
je ret
cmp al,09
ret

test_eol:                              ; IS CHARACTER IN .AL AN EOL OR NULL?
cmp al,0d                              ; exit with zero flag set if it is
je ret
cmp al,00
ret

clean_up_filespec:                     ; CANONICALIZE FILESPEC :
call fix_last_bs                       ; find final backslash
call must_have_drive                   ; supply drive letter if needed
call must_have_path                    ; supply pathname if needed
call never_ends_in_dots                ; watch out for . and .. specs
call never_ends_in_bs                  ; make sure filespec doesn't end in \
call dots_fix                          ; eliminate any . or .. entries
call no_double_bs                      ; remove any duplicated backslashes
ret

must_have_drive:                       ; MAKE SURE FILESPEC HAS A DRIVE :
cmp w [fnbuf],'\' by '\'               ; is this a unc filespec?
je ret                                 ; if so, don't muck about with it
mov ax,w [fnbuf]                       ; examine first two characters:
cmp ah,':'                             ; is the second a colon?
jne > l0                               ; if not, add drive letter
call force_lc
cmp al,'a'
jb > l0                                ; is the first a letter?
cmp al,'z'                             ; if not, add drive letter
ja > l0                                ; a drive letter was specified :
cmp b [fnbuf+2],00                     ; was there anything after it?
je > l5                                ; if not, add star-dot-star
ret                                    ; otherwise, exit with no change
l0:
call find_null_fnbuf                   ; find the end of the filespec
mov si,di                              ; source for copy
add di,0002                            ; and add 2 (destination)
cmp di,offset fnbuf + maxlen           ; will this overflow fnbuf?
jae > l7                               ; if so, problem
l1:
mov al,b [si]                          ; copy a byte from source
dec si
mov b [di],al                          ; to destination
dec di
cmp si,offset fnbuf                    ; done yet?
jae l1                                 ; no, continue
doscall 19                             ; get current drive number
add al,'a'                             ; and convert to a letter
mov ah,':'
mov w [fnbuf+0],ax                     ; stash it in the filename buffer
cmp w [last_bs],0000                   ; if a backslash was found,
je ret
add w [last_bs],0002                   ; add 2 to its location
ret                                    ; and we're done
l5:                                    ; only a drive letter found :
mov si,offset star_dot_star
mov di,offset fnbuf+2                  ; supply a star-dot-star
call copy_string
ret
l7:                                    ; adding drive would overflow fnbuf :
jmp error_fnbuf_over                   ; handle error

must_have_path:                        ; SUPPLY PATHNAME IF NEEDED :
cmp w [fnbuf],'\' by '\'               ; is this a unc filespec?
je ret                                 ; if so, don't muck about with it
cmp b [fnbuf+2],'\'                    ; did the user supply an abs. path?
je ret                                 ; if so, exit without further ado
mov si,offset fnbuf+2                  ; starting immediately after colon,
mov di,offset alt_dta                  ; copy everything to temp buffer
call copy_string
mov b [fnbuf+2],'\'                    ; poke in initial backslash
mov al,b [fnbuf]                       ; get drive letter
call force_lc                          ; as lowercase
mov dl,al
sub dl,60                              ; convert to a number
mov si,offset fnbuf + 3
doscall 47                             ; get current directory name
call find_null_fnbuf                   ; find the end of the pathname
dec di
cmp b [di],'\'                         ; does path already end in backslash?
je > l3
inc di
l3:
mov b [di],'\'                         ; terminate pathname
inc di
mov si,offset alt_dta
call copy_string                       ; and copy remainder of filespec back
call fix_last_bs                       ; repair last_bs variable
cmp w [last_bs],offset fnbuf + maxlen  ; check for possible buffer overflow
jb ret                                 ; if no problem, exit
jmp error_fnbuf_over                   ; if problem, go bomb out
ret

never_ends_in_dots:                    ; ELIMINATE . AND .. PROBLEMS :
call find_null_fnbuf                   ; find terminal null
dec di                                 ; examine the last character
cmp b [di],'.'                         ; is it a dot?
jne ret                                ; if not, exit
l1:
dec di                                 ; examine the last character
mov al,b [di]
cmp al,'.'                             ; another dot?
je l1                                  ; if so, ignore it, loop back for more
cmp al,'\'                             ; backslash?
je > l3                                ; if so, filespec needs attention
cmp al,':'                             ; colon?
jne ret                                ; if so, filespec needs attention
l3:                                    ; (anything else is okay)
call find_null_fnbuf                   ; filespec ends in dots, so
mov w [di],00 by '\'                   ; append a backslash
cmp di,offset fnbuf + maxlen - 1       ; spam the working buffer?
jb > l8
jmp error_fnbuf_over                   ; yes, go handle it
l8:
mov w [last_bs],di                     ; no, update last_bs variable
ret                                    ; and exit

never_ends_in_bs:                      ; FIX PATHNAMES ENDING IN BACKSLASH :
mov di,w [last_bs]                     ; get address of final backslash
inc di                                 ; and examine the following char.
cmp b [di],00                          ; is it a null?
jne ret                                ; if not, do nothing and exit
mov si,offset star_dot_star            ; if so, tack on a star-dot-star
call copy_string                       ; after the backslash
cmp di,offset fnbuf + maxlen           ; didn't overflow the buffer, did we?
ja > l2
ret
l2:
jmp error_fnbuf_over                   ; oops

dots_fix:                              ; LOOK FOR . OR .. ENTRIES :
mov si,offset fnbuf                    ; start at beginning of filespec
l0:
mov ax,w [si]                          ; look at two bytes at a time
inc si
cmp al,00                              ; found the end of the filespec yet?
jne > l1
l9:
call fix_last_bs
ret                                    ; if so, exit
l1:
cmp ax,'.' by '\'                      ; found a . entry?
jne l0                                 ; if not, keep looking
mov cx,0001                            ; one dot found so far
l2:
inc si                                 ; skip past that first dot
mov al,b [si]                          ; examine the next character
cmp al,00                              ; end of filespec?
je l9                                  ; if so, exit
cmp al,'.'                             ; another dot?
jne > l3
inc cx                                 ; if so, count it
jmp l2                                 ; and keep parsing
l3:
cmp al,'\'                             ; another backslash?
jne l0                                 ; if not, ignore this (weird) entry
mov di,si                              ; point .di to backslash after dots
l4:
dec di                                 ; and scan backwards through fnbuf
cmp di,offset fnbuf                    ; fell off the beginning of fnbuf?
jbe > l8                               ; if so error
cmp b [di],'\'                         ; found a backslash?
jne l4                                 ; if not, keep searching backwards
loop l4                                ; decrement dots count, continue
call copy_string                       ; copy string after dots down
jmp dots_fix                           ; and loop back for more .\ entries
l8:                                    ; too many dot entries:
call error_out
dosprint msg_err_dots_fix              ; complain about it
doscall2 4c15                          ; and exit with errorlevel 21

no_double_bs:                          ; remove any duplicated backslashes :
mov di,offset fnbuf                    ; start at beginning of filename
l10:
inc di
mov ax,w [di]                          ; examine two characters at a time
cmp al,00                              ; found the end of the filespec yet?
je > l30                               ; if so, exit
cmp ax,'\' by '\'                      ; duplicate backslashes?
jne l10                                ; if not, loop back, keep searching
l20:
mov si,di                              ; copy down
inc si                                 ; from the second backslash
call copy_string                       ; onto the first
dec w [last_bs]                        ; adjust last-backslash pointer
jmp no_double_bs                       ; and loop back for more abuse
l30:
ret


alloc_list_buffer:                     ; CREATE BUFFER FOR FILE LIST :
mov bx,0100                            ; allocate four kilobytes
doscall 48                             ; for list buffer
jnc > l0
jmp trs_80                             ; any problem, complain and abort
l0:
mov w [list_seg],ax                    ; no problem, remember segment
mov w [list_pnt],2000                  ; and note that the buffer is empty
ret

get_fn_from_list:                      ; READ FILESPEC FROM FILE LIST :
test b [flags],04                      ; are we using a file list?
jne > l1
clc
ret                                    ; if not, simply exit with carry clear
l1:
cmp w [auxhandle],0000                 ; is it open yet?
jne > l3                               ; if so, continue
mov dx,offset fnbuf
doscall2 3d20                          ; open file list file
jnc > l2
dosprint msg_err_listfile              ; problem; print error message
zprint fnbuf                           ; and filename
stc                                    ; and exit with carry
ret
l2:
mov w [auxhandle],ax                   ; save file handle
mov w [list_pnt],2000                  ; and note that the buffer is empty
l3:
mov di,offset fnbuf
mov b [di],00                          ; empty the filespec buffer
and b [flags],0fe                      ; not between quotes
read_fn_loop:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je read_fn_eof                         ; if so, deal with it
call test_space                        ; space?
je read_fn_sp                          ; if so, deal with it
cmp al,20                              ; end of line?
jb read_fn_eol                         ; if so, deal with it
cmp al,'"'                             ; quote mark?
je read_fn_qu                          ; if so, deal with it
cmp al,';'                             ; semicolon?
je read_fn_semi                        ; if so, deal with it
cmp al,':'                             ; colon?
je read_fn_semi                        ; if so, deal with it
call force_lc
cmp al,'/'                             ; slash?
jne read_fn_ch
mov al,'\'                             ; if so, convert to a backslash
read_fn_ch:                            ; got a legal character for filename :
mov b [di],al                          ; put it in the buffer
inc di
mov b [di],00                          ; and null-terminate it
cmp di,offset fnbuf + maxlen           ; blown past the end of the buffer?
jb read_fn_loop                        ; no, loop back for more
jmp read_fn_spam                       ; yes, deal with it
read_fn_eof:                           ; found end of list file :
mov bx,w [auxhandle]
doscall 3e                             ; close the list file
mov w [auxhandle],0000                 ; and mark it closed
and b [flags],0fb                      ; no more file list!
cmp b [fnbuf],00                       ; was a filename retrieved before eof?
je > l1
clc                                    ; yes, exit with carry clear
ret
l1:
stc                                    ; no, exit with carry set
ret
read_fn_sp:                            ; found a space :
test b [flags],01                      ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
read_fn_eol:                           ; found end of line:
cmp b [fnbuf],00                       ; anything in the buffer yet?
je read_fn_loop                        ; if not, keep looking
call clean_up_filespec                 ; clean it up
clc
ret                                    ; and exit
read_fn_qu:                            ; found a quote:
test b [flags],01                      ; was there an open quote?
jne read_fn_eol                        ; if so, it ends the filespec
cmp b [fnbuf],00                       ; anything in the buffer yet?
jne read_fn_ch                         ; if so, treat like any other char
or b [flags],01                        ; otherwise, this is an open quote
jmp read_fn_loop                       ; keep reading
read_fn_semi:                          ; found a semicolon :
test b [flags],01                      ; between quotes?
jne read_fn_ch                         ; if so, treat like any other char
cmp b [fnbuf],00                       ; anything in the buffer yet?
jne read_fn_ch                         ; if so treat like any other char
cmp al,':'                             ; was comment character a colon?
je read_fn_notice                      ; if so, this is a printable 'notice'
read_fn_remark:                        ; NONPRINTABLE COMMENT IN FILE LIST :
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je read_fn_eof                         ; if so, deal with it
cmp al,20                              ; found the end of the remark?
jae read_fn_remark                     ; if not, keep looking
jmp read_fn_loop                       ; otherwise, resume hunt for filespec
read_fn_notice:                        ; PRINTABLE NOTICE IN FILE LIST :
dosprint msg_notice                    ; introduce it
l0:
call read_from_list                    ; get a character from the file list
cmp al,1a                              ; end of file?
je > l2                                ; if so, deal with it
cmp al,20                              ; found the end of the notice?
jae > l1
call crlf                              ; if so, terminate the output line
jmp read_fn_loop                       ; and go back to the filespec search
l1:
mov dl,al                              ; otherwise, this is a printable char
doscall 02                             ; print it
jmp l0                                 ; and continue scanning through notice
l2:                                    ; end-of-file within notice:
call crlf                              ; terminate the output line
jmp read_fn_eof                        ; and the input file

read_fn_spam:                          ; overflowed the working buffer :
mov b [fnbuf],00                       ; empty the working buffer
dosprint msg_err_list_spam             ; print an error message
jmp read_fn_eof                        ; and kill the current file list

read_from_list:                        ; GET CHARACTER FROM FILE LIST FILE :
mov ax,w [list_pnt]
cmp ax,1000                            ; need to refill the buffer?
jb read_list                           ; nope, skip ahead
mov cx,1000                            ; read four kilobytes
mov bx,w [auxhandle]                   ; from the file list
zero dx                                ; to the start
mov ds,w [list_seg]                    ; of the list buffer
doscall 3f
push cs
pop ds                                 ; restore data segment
jnc > l3
call error_out
dosprint msg_err_read_list             ; problem!  print error message
doscall2 4c13                          ; and exit with errorlevel 19
l3:
mov w [list_pnt],0000                  ; move pointer back to start of buffer
cmp ax,1000                            ; got four kilobytes?
je read_list                           ; cool!
or ax,ax                               ; got anything at all?
jne > l4
mov al,1a                              ; if not, return end-of-file
ret
l4:
mov si,ax                              ; got less than four kilobytes :
mov es,w [list_seg]                    ; poke in an eof
mov b [es:si],1a                       ; just to be on the safe side
read_list:                             ; get buffered char from file list :
mov es,w [list_seg]                    ; segment of file list buffer
mov si,w [list_pnt]                    ; pointer into list buffer
mov al,b [es:si]                       ; get character from buffer
inc si
mov w [list_pnt],si                    ; and increment the pointer
push ds
pop es                                 ; fix data segment
ret                                    ; and exit

find_null_fnbuf:                       ; FIND END OF FILESPEC :
mov di,offset fnbuf                    ; fall through to:

find_null:                             ; FIND END OF ASCIIZ STRING :
cmp b [di],00                          ; found null yet?
jne >l0                                ; no, keep searching
ret                                    ; yes, exit
l0:
inc di
jmp find_null

fix_last_bs:                           ; REPAIR LAST_BS VARIABLE :
mov w [last_bs],0000                   ; note no backslashes found yet
mov si,offset fnbuf                    ; point to start of filespec buffer
l0:
mov al,b [si]                          ; look at character
cmp al,00                              ; terminal null?
je > l2                                ; if so, exit
cmp al,'\'                             ; backslash?
jne > l1
mov w [last_bs],si                     ; if so, save its address
l1:
inc si                                 ; and keep on going
jmp l0
l2:                                    ; found the terminal null
cmp si,offset fnbuf + maxlen           ; have we wandered off the edge?
jae > l4                               ; if so, problem
ret
l4:                                    ; spammed fnbuf :
jmp error_fnbuf_over                   ; abort

show_fnbuf:
mov ah,02
mov si,offset fnbuf
l10:
mov al,b [si]
lodsb
cmp al,00
je > l20
call force_lc
mov dl,al
int 21
jmp l10
l20:
ret

#if mungabunga

root_safety:                           ; CHECK FOR EXTRA-DANGEROUS COMMANDS :

;  If items in the root directory are to be deleted, and /Y is specified, the
;  user will be prompted anyhow.  This modification was inspired by a loser
;  calling himself "Munga Bunga" who writes batch files to erase peoples'
;  hard drives and posts them on the Internet.  This routine adds a new
;  incompatibility with Microsoft's DELTREE.EXE; I hope the additional safety
;  will outweigh any inconvenience.  Anyhow, the check should rarely bother
;  legitimate users.
;
;  To remove this safety check, comment out the line defining the variable
;  'mungabunga' near the top of the file, then re-assemble by typing
;  A86 DELTREE.S

test b [flags],80                      ; was /y specified?
je root_safety_okay                    ; if not, okay so exit
mov bx,offset fnbuf + 0002             ; normal position of root backslash
cmp w [fnbuf],'\' by '\'               ; is this a unc filespec?
jne > l20                              ; if not, proceed
mov cl,00                              ; found no more backslashes yet
l10:
mov al,b [bx]                          ; examine character :
cmp al,00                              ; hit the end of the filspec yet?
je root_danger                         ; if so, problem, so assume danger
cmp al,'\'
jne > l15
inc cl
cmp cl,02
jae > l20
l15:
inc bx
jmp l10
l20:                                   ; got offset of root backslash in .bx
cmp bx,w [last_bs]                     ; compare against last_bs variable
jb root_safety_okay                    ; if not in root, okay so exit
root_danger:                           ; dangerous command!
call prompt_fix_2                      ; force stdout to the console
dosprint msg_munga                     ; display a warning message
call show_fnbuf                        ; and the current filename
dosprint msg_bunga                     ; display a prompt message
jmp ask_yorn

root_safety_okay:
cmp al,al
ret

#endif

prompt_user:                           ; PROMPT USER, IF NEEDED :
test b [flags],80                      ; was /y specified?
je > l1                                ; if not, continue normally
cmp al,al                              ; if so, exit with .z set
ret
l1:                                    ; no /y, do prompt user :
test b [dta_attr],10                   ; found a file or a directory?
jne > l12                              ; if a file,
dosprint msg_prompt_file               ; display 'delete file' message
call show_fnbuf                        ; and the filename
mov dl,'"'
doscall 02                             ; close quote
jmp > l20                              ; and continue ....
l12:                                   ; if a directory,
dosprint msg_prompt_subdir             ; display 'delete directory ' message
call show_fnbuf                        ; and the filename
dosprint msg_prompt_contents           ; 'and all its subdirectories'
l20:                                   ; in either case,
dosprint msg_prompt_yorn               ; print y/n prompt

ask_yorn:                              ; get user's yes-or-no reply
mov cl,00                              ; no valid characters yet
l30:                                   ; wait loop :
doscall2 0c07                          ; flush key buffer, get character
call force_lc                          ; and force to lowercase
cmp al,0d                              ; enter?
je > l40                               ; maybe exit wait loop
cmp al,03                              ; control-c or control-break?
je > l45                               ; if so, abort immediately
cmp al,'q'                             ; 'q' for quit
je > l35                               ; is valid
cmp al,'n'                             ; 'n' for no
je > l35                               ; is valid
cmp al,'y'                             ; 'y' for yes
jne l30                                ; is valid; everything else is junk
l35:                                   ; got a valid response :
mov cl,al                              ; remember it
mov dl,al
doscall 02                             ; print it to the screen
mov dl,08                              ; with a backspace
int 21
jmp l30                                ; and return to the wait loop
l40:                                   ; user pressed enter :
cmp cl,00                              ; got a valid response yet?
je l30                                 ; if not, loop back, wait some more
call crlf                              ; if so, terminate output line
cmp cl,'q'                             ; alternate abort?
je > l50                               ; if so, go do it
cmp cl,'y'                             ; compare against 'yes' response
ret                                    ; and exit
l45:                                   ; control-c or control-break pressed :
dosprint msg_break                     ; print '^C' message
doscall2 4c03                          ; and bomb with errorlevel 3
l50:                                   ; q pressed -- alternate user abort :
mov b [return_code],03                 ; return an errorlevel of 3
jmp exit_program                       ; and exit from program


get_country_info:                      ; time and date formats, etcetera
mov dx,offset country
doscall2 3800                          ; get current country info
ret                                    ; and exit

append_found_filespec:                 ; ADD FOUND FILESPEC AFTER PATHNAME :
mov di,w [last_bs]                     ; destination is
inc di                                 ; character following final backslash
mov si,offset dta_name                 ; source is filename in dta
call copy_string                       ; copy found filename into fnbuf
cmp di,offset fnbuf + maxlen           ; fnbuf overflow?
ja error_fnbuf_over                    ; if so, handle it
ret                                    ; else exit

append_found_alt:
mov di,w [last_bs]
inc di
mov si,offset alt_name
call copy_string
cmp di,offset fnbuf + maxlen
ja error_fnbuf_over
ret

error_fnbuf_over:                      ; fnbuf has overflowed:
call error_out                         ; fix stdout to screen
dosprint msg_err_fnbuf_over            ; complain
doscall2 4c14                          ; and exit with errorlevel 20

copy_string:                           ; COPY ASCIIZ STRING [SI] TO [DI] :
push ds                                ; make .es equal to .ds
pop es
l0:
lodsb                                  ; get a character from [ds:si]
stosb                                  ; put it in [es:di]
cmp al,00                              ; until the final null is found
jne l0
ret                                    ; then quit

zprint1:                               ; PRINT ASCIIZ STRING VIA .DI :
mov ah,02                              ; dos print-a-character function
l0:
mov dl,b [di]                          ; get a byte from string
inc di
cmp dl,00                              ; found the final null?
je > l1                                ; if so, deal with it
int 21                                 ; otherwise, print the character
jmp l0                                 ; and loop back for more abuse
l1:                                    ; found the final null:

crlf:                                  ; END OF PRINT LINE :
dosprint msg_crlf                      ; print a carriage return, line feed
ret                                    ; otherwise, just exit

crlf_maybe:                            ; PRINT A CRLF IF ONE IS PENDING :
test b [flags],10                      ; do we need a crlf?
je ret                                 ; if not, just exit
and b [flags],0ef                      ; if so, clear flag and
jmp crlf                               ; go do it

prompt_fix:                            ; USE CONSOLE FOR PROMPTS :
test b [flags],80                      ; was /y specified?
jne ret                                ; if so, don't need to force console
prompt_fix_2:
test b [flags],02                      ; is prompt output already been fixed?
jne ret                                ; if so, don't do it again
mov dx,offset name_con                 ; open the console
doscall2 3d42                          ; for read and write, deny-none
push ax                                ; save the resulting handle
mov bx,ax
zero cx                                ; force standard input
doscall 46                             ; to the console
pop bx
push bx
mov cx,0001                            ; force standard output
doscall 46                             ; to the console
pop bx
doscall 3e                             ; close temporary console handle
or b [flags],02                        ; note that prompt output was fixed
ret                                    ; and exit

error_out:                             ; FORCE STDOUT TO STDERR :
mov cx,0001                            ; force stdout
mov bx,0002                            ; to stderr
doscall 46
ret


; -------------------------------------- STRINGS AND OTHER STATIC DATA :

msg_markver:                           ; info displayed by mark aitchison's
db 'VeRsIoN=1.01',00                   ; version.exe utility
db 'CoPyRiGhT=Copyright 1999, Charles Dye',00

msg_syntax:
db 0d,0a
db 'DELTREE.COM   v1.01   01-17-1999   C. Dye   raster@highfiber.com',0d,0a
db 'Freeware.  Copyright 1998, 1999 Charles Dye.  No warranty!',0d,0a
db 0a
db 'DELTREE [switches] filespec [filespec...]',0d,0a
db '  /Y    Delete specified items without prompting',0d,0a
db '  /V    Report counts and totals when finished',0d,0a
db '  /D    Display debug info',0d,0a
db 0a
db 'Filespecs may name files, subdirectories (all contents will be lost),',0d,0a
db 'or DR DOS-style file lists.  DELTREE is a dangerous command!  Use at',0d,0a
db 'your own risk.',0d,0a
db 0a
db 'This program may be freely distributed under the terms of the Free',0d,0a
db 'Software Foundation''s GNU General Public License, version 2; or, at',0d,0a
db 'your option, any later version of that License.  See the file COPYING',0d,0a
db 'for details.',0d,0a
db '$'

switches:
db 'yvdx?',00

switch_routines:
dw switch_y, switch_v, switch_d, switch_x, switch_query

error_numbers:
db 05,10,13,20,41,53,56,00

error_strings:
db 'access denied$current directory$write protect$sharing violation$'
db 'access denied$fail on INT 24$invalid password$'


msg_err_dos_bad:
db 0d,0a,'Error:  Requires DOS version 3 or better!',0d,0a,'$'

msg_trs_80:
db 0d,0a,'Error:  Not enough memory!',0d,0a,'$'

msg_err_fn_ovf:
db 0d,0a,'Error:  Filespec too long!',0d,0a,'$'

msg_err_in_filespec:
db 0d,0a,'Error in filespec!',0d,0a,'$'

msg_err_no_specs:
db 0d,0a,'Error:  No filespec specified!',0d,0a,'$'

msg_err_dots_fix:
db 0d,0a,'Error:  Resolving dots in directory name!',0d,0a,'$'

msg_err_listfile:
db 'Unable to open file list:  $'

msg_err_read_list:
db 0d,0a,'Error:  Problem reading from file list!$'

msg_err_fnbuf_over:
db 0d,0a,'Error:  Spammed working buffer!',0d,0a,'$'

msg_err_list_spam:
db 'Filespec too long in file list!  Closing file list.',0d,0a,'$'

msg_err_dos:
db '*  DOS error $'

msg_err_rmdir:
db ' removing "$'

msg_err_del:
db ' deleting "$'

msg_err_finis:
db '"$'

msg_open_pat:
db '  ($'

msg_close_pat:
db ')$'

msg_debug_rmdir:
db '- remove:  $'

msg_debug_uplevel:
db '- backup:  $'

msg_debug_quit:
db '-   quit:',0d,0a,'$'

msg_debug_ignore:
db '- ignore:  $'

msg_debug_subdir:
db '-  enter:  $'

msg_debug_file:
db '- delete:  $'

msg_notice:
db 'Notice:  $'

msg_prompt_file:
db 'Delete file "$'

msg_prompt_subdir:
db 'Delete directory "$'

msg_prompt_contents:
db '" and all its subdirectories$'

msg_prompt_yorn:
db '? [ynq] $'

msg_deleting:
db 'Deleting $'

msg_ellipsis:
db '...',0d,0a,'$'

msg_num_deleted:
db 0d,0a
db '*  Files deleted:  $'

msg_num_removed:
db 0d,0a
db '*  Subdirectories removed:  $'

msg_total_sizes:
db '    Total of sizes:  $'

msg_bytes:
db ' bytes ($'

msg_kilobytes:
db ' K)$'

msg_megabytes:
db ' M)$'

msg_crlf:
db 0d,0a,'$'

msg_break:
db '^C',0d,0a,'$'

#if mungabunga

msg_munga:
db 0d,0a
db 'Warning!  DELTREE called in root directory with /Y specified!',0d,0a
db 'Filespec to delete:  $'

msg_bunga:
db 0d,0a,0a
db 'Do you really want to do this?  Important system files may be',0d,0a
db 'destroyed!  $'

#endif

bs_star_dot_star:
db '\'

star_dot_star:
db '*.*',00

name_con:
db 'CON',00


even ; --------------------------------- WORD LENGTH VARIABLES :

auxhandle:                             ; handle for file list
dw 0000

last_bs:                               ; offset of final backslash in fnbuf
dw 0000

topmost:                               ; last_bs value saved by nuke_item
dw 0000

list_seg:                              ; segment of file list buffer
dw 0000

list_pnt:                              ; pointer into file list buffer
dw 0000

parse_save:                            ; value of .si saved by parse routine
dw 0000

subdir_clear:                          ; value to clear subdir attributes
dw 0000                                ; (workaround for freedos 4301 prob)

deleted:                               ; number of files deleted :
dw 0000,0000                           ; low word, high word

removed:                               ; number of subdirectories removed :
dw 0000,0000                           ; low word, high word

total_sizes:                           ; total of deleted files' sizes :
dw 0000,0000                           ; low word, high word


; -------------------------------------- BYTE LENGTH VARIABLES :

flags:                                 ; bit 7 = do not prompt user        /y
db 00                                  ; bit 6 = report when finished      /v
                                       ; bit 5 = don't delete anything     /x
                                       ; bit 4 = crlf pending
                                       ; bit 3 = show debug info           /d
                                       ; bit 2 = use file list      @filename
                                       ; bit 1 = prompt_fix done
                                       ; bit 0 = parsing between quotes

return_code:                           ; 00 :  everything is beautiful,
db 00                                  ; 01 :  something couldn't be deleted,
                                       ; 03 :  user abort (q or control-c)


dw 0ffff

; -------------------------------------- UNINITIALIZED DATA :


fnbuf:

dta       equ  fnbuf + 0050                      ; disk transfer area :
dta_attr  equ  dta   + 0015                      ; attribute of found file
dta_name  equ  dta   + 001e                      ; name of found file

alt_dta   equ  dta + 0030                        ; second disk transfer area:
alt_attr  equ  dta + 0045                        ; attribute of found file
alt_size  equ  dta + 004a                        ; size of found file
alt_name  equ  dta + 004e                        ; name of found file

stack_start  equ  (alt_dta + 3f) and 0fff0       ; stack starts on paragraph
stack_end    equ  stack_start + 07fe             ; stack is about 2k long

;
;   Errorlevels:
;   00   All's well
;   01   Something could not be deleted
;   03   User abort (control-C, control-break)
;   16   General syntax, buffer overflow
;   17   Not enough memory
;   18   Antique version of DOS
;   19   Problem with list file
;   20   Internal buffer overflow
;   21   Error resolving directory name (dots_fix)
;
;
;   VERSION LOG:
;
;   v0.90    03-13-1998    4086 bytes
;   Initial beta release.
;
;   v0.91    03-15-1998    3900 bytes
;   Changed two-pass parser to one-pass, removing 31-filespec limit.  Moved
;   fnbuf to uninitialized data area.
;
;   v0.92    03-26-1998    3968 bytes
;   Allow Q for 'quit' in addition to Y and N responses.  Q will abort with
;   errorlevel 3 like Control-C or Control-Break, but will print any /V
;   summary first.  Adds version and copyright strings for Mark Aitchison's
;   VERSION.EXE program.  Includes newer address for the Free Software
;   Foundation.
;
;   v0.93    03-30-1998    3970 bytes
;   Fixed sloppy calculations involving stack bottom and top addresses, and
;   program size.  Should not make a bit of difference in program operation.
;
;   v1.00    08-05-1998    4042 bytes
;   Workaround for a serious issue with earlier releases of the DOS-C kernel.
;   21/4301 could convert subdirectories into files....  The filespec cleanup
;   routine now removes any duplicated backslashes from the filespec.  Syntax
;   message now mentions /D (guess I won't delete the debug code after all.)
;
;   v1.00a   08-13-1998    4050 bytes
;   Fixes an incompatibility with 8086 and 8088 CPUs (logical shifts with
;   immediate count values.)
;
;   v1.01    01-17-1999    4318 bytes
;   Added a safety check:  If items in the root directory are to be deleted
;   and /Y is specified, the user will be prompted anyhow.  Also, new debug
;   switch /X prevents the program from actually deleting anything.
;
