/*****************************************************************************
*                                                                            *
* Copyright (c) 1996-2006 Funduc Software Inc.   All rights reserved.        *
*                                                                            *
* These programs are the sole property of Funduc Software Inc. and contain   *
* proprietary information.  These routines should not by used by anyone      *
* except Funduc Software Inc.'s customers in accoordance with terms of a     *
* license.  To get one, visit us at http://www.funduc.com                    *
* or E-MAIL: sales@funduc.com                                                *
*                                                                            *
*****************************************************************************/

#ifndef DECENC_H
#define DECENC_H

#ifdef __cplusplus
extern "C"
{
#endif
                       
/* Possible values for the nType parameter passed to EncodeFile() 
   and return code from DecodeFile */
#define NONE_TYPE        0
#define UUE_TYPE         1   /* UUENCODED file */
#define B64_TYPE         2   /* Base64 encoded (MIME) */
#define BINHEX_TYPE      3   /* BinHex (Macintosh) encoding */
#define XXE_TYPE         4   /* XXENCODED file */
#define TEXT_TYPE	     5   /* 7-bit or quoted-printable - encoding quoted-printable */

/* Possible values for the nPrompt parameter to Decode File() */
#define PROMPT_ALL       0   /* DLL prompts for everything */
#define PROMPT_NONE      1   /* No prompts, file names passed in are used */
#define PROMPT_OVERWRITE 2   /* DLL only prompts for overwrites */

/* Values for the GetMessageHeaderField() function */
#define DECENC_MSG_DATE_TIME_RECEIVED 0   /* To request the Date/Time received string */
#define DECENC_MSG_FROM               1   /* To request the From string */
#define DECENC_MSG_TO                 2   /* To request the To string */
#define DECENC_MSG_SUBJECT            3   /* To request the Subject */
#define DECENC_MSG_DATE_TIME_SENT     4   /* To request the Date/Time sent string */
#define DECENC_MSG_CC                 5   /* To request the CC string */
#define DECENC_MSG_REPLY_TO           6   /* To request the Reply To string */
#define DECENC_MSG_COMPANY            7   /* To request the Organization string */
#define DECENC_MSG_HEADER_INFO        8   /* To request the Header Info block */
                                          /* up to the first string from the list above */
                                          /* This could be spanning a few lines */

/* Structure containing the information returned by GetMessageInfo().  Note that
   FreeMessageInfo() must be called to free the memory when you no longer need it. */
typedef struct
{
   char *m_szDateTimeReceived;
   char *m_szFrom;
   char *m_szTo;
   char *m_szSubject;
   char *m_szDateTimeSent;
   char *m_szCC;
   char *m_szReplyTo;
   char *m_szCompany;
   char *m_szHeaderInfo;
} DECENC_MSG_INFO, * LPDECENC_MSG_INFO;


/* How many files are encoded */
int WINAPI GetNumFilesToDecode(LPCSTR szInFile);
/* 0 relative index into the array of names (see call above) */
int WINAPI GetEncodedFile(LPSTR szOutFile, int nIndex);
/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
   the strOutFile parameter.  That can be accomplished by calling GetNumFilesToDecode() 
   and GetEncodedFile in a loop to get the list of files first. The list of files passed
   (after modification if needed) must then be delimited by the ';' character */
/* Return code is one of the Encoding types above */
int WINAPI DecodeFile(LPCSTR strInFile, LPCSTR szOutFile, int nPrompts);
/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
   for example */
/* Boundary should be passed in.  It needs to be listed in the message header as:
    boundary="<your boundary>" */
int WINAPI EncodeFile(LPCSTR strFileIn, LPCSTR szFileOut, LPCTSTR szBoundary, int nType, BOOL bAppend); 

/* Call after all files are encoded to append the final boundary */
/* You can also append -- and 2 linefeeds to the end of the encoded file or */
/* send that out with your message */
void WINAPI FinishAttachments(LPCSTR strFileOut);

/* call with the name of registered application to write that to the encoded file */
void WINAPI SetEncodingApplication(LPCSTR szInFile);

/* Utility functions */
/* This function will return TRUE if the name of the file had to be changed to avoid an overwrite */
BOOL WINAPI GetUniqueFileName(LPSTR szFileName);
/* This function will concatenate related files into the first one.  All files must
   be found in the same directory.
   For example: file1.dat, file2.dat, file3.dat will be concatenated into file1.dat
   If bDeleteOthers is TRUE, file2.dat and file3.dat are deleted
   This function returns TRUE when successful, FALSE otherwise 
*/
BOOL WINAPI ConcatenateRelated(BOOL bDeleteOthers, LPSTR szFileName);

/* This function will split a file into as many smaller files as necessary
   For example: file.dat of size 100000 will be split into
   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
   if 35000 is used for the lFileSize parameter 
   This function returns TRUE when successful, FALSE otherwise
*/
BOOL WINAPI SplitFile(LPSTR szFileName, long lFileSize);

/* Use this function to encode a small buffer.  The Output Buffer needs to be
   different than the input buffer and needs to be roughly 1.5 times larger
   Only UUE_TYPE, B64_TYPE, XXE_TYPE and TEXT_TYPE (quoted-printable) types 
   are supported.
*/
int WINAPI EncodeBuffer(LPCSTR pBufferIn, LPSTR pBufferOut, int nInBufferSize, int nType);

/* Use this function to decode a small buffer.  The Output Buffer needs to be
   different than the input buffer and needs to be about the same size.
   Only UUE_TYPE, B64_TYPE, XXE_TYPE and TEXT_TYPE (quoted-printable) types 
   are supported.
*/
int WINAPI DecodeBuffer(LPCSTR pBufferIn, LPSTR pBufferOut, int nInBufferSize, int nType);

/* Use this function to retrieve the message information.  The information for
   the file specified by szFileName is returned in the szBuffer field.  nSize
   must be the allocated size of szBuffer (including room for the NULL byte)
   and nField must be one of the DECENC_MSG_ defines above 
*/
BOOL WINAPI GetMessageHeaderField(LPCTSTR szFileName, LPTSTR szBuffer, int nSize, int nField);

/* Use this function to retrieve the message information.  The information for
   the file specified by szFileName is returned in the pMsgInfo field.  You must
   call FreeMsgInfo() below to free the memory when you no longer need it.
*/
BOOL WINAPI GetMessageInfo(LPCTSTR szFileName, LPDECENC_MSG_INFO pMsgInfo);

/* Use this function to free the memory allocated by GetMessageInfo() above
*/
void WINAPI FreeMessageInfo(LPDECENC_MSG_INFO pMsgInfo);

/* Use this function to save just the text of a message to a file */
/* Return code is one of the Encoding types above if successful */
int  WINAPI GetMessageText(LPCTSTR szFileName, LPCTSTR szTargetFileName);

/* Use this function to parse a date/time string from a message header */
/* If parsing succeeded, the function returns a non-zero value */
/* If the bLocalTime flag is zero, a GMT date/time is returned */
BOOL WINAPI DecodeMimeTime(LPCTSTR szMimeDate, SYSTEMTIME *sysTime, BOOL bLocalTime);

#ifdef __cplusplus
}
#endif

#endif
