#include <windows.h>
#include "plugin.hpp"
#include "backrest.h"
#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"

char *OutTime(char *buf, InfoCopy *InfoFile)
{
  static char stbuf[10];
  char *p1,*p2,*p3;
  char buf1[10],buf2[10];
  unsigned long l,k,n,m;
  SYSTEMTIME t;
  double d;
  unsigned speed; 

  p1=GetMsg(M_T_TStart);
  p2=GetMsg(M_T_TReminder);
  l=GetLocalTimeToLong();
  l -= InfoFile->time_start;
  LongToTime(l, &t);
  GetTimeFormat(LOCALE_USER_DEFAULT,TIME_NOTIMEMARKER,&t,"HH\':\'mm\':\'ss",
                buf1,10);

  k=InfoFile->CountSize+InfoFile->start_pos+InfoFile->count_ver;//write;
  if(k==0)
  {
    l=0;
    speed=0;
    p3=GetMsg(M_T_bps);
  }
  else
  {
    l -= InfoFile->time_delta;
    m=l;
    d=(double)InfoFile->CommonSize/(double)k;
    n=(unsigned long)(l*d);
    if(n<l)
      l=0;
    else
      l=n-l;
    if(m==0 || (m/1000)==0)
      speed=0;
    else
    {
      speed=(unsigned)(k/(m/1000));
      if(speed>99999)
      {
        speed /= 1024;
        p3=GetMsg(M_T_kbps);
      }
      else
        p3=GetMsg(M_T_bps);
    }
  }

  LongToTime(l, &t);
  GetTimeFormat(LOCALE_USER_DEFAULT,TIME_NOTIMEMARKER,&t,"HH\':\'mm\':\'ss",
                buf2,10);
  lstrcpy(stbuf,buf2);
  wsprintf(buf,"%s %s  %s %s  %5u %s",p1,buf1,p2,buf2,speed,p3);
  return stbuf;
}


//-----------------------------------------
//   
char* GetDstPathFile(char *buf,InfoCopy *InfoFile)
{

  char tmp[11];
  GetPathFile(buf,InfoFile->DstDir,InfoFile->cFileName);
  if(InfoFile->NumberSection>0)
  {
    switch(InfoFile->AddNumberSection)
    {
      case 1: wsprintf(tmp,".%d",InfoFile->NumberSection);
              lstrcat(buf,tmp);
              break;
      case 2: wsprintf(tmp,".%u",InfoFile->start_pos);
              lstrcat(buf,tmp);
              break;
      case 3: wsprintf(tmp,".%.8X",InfoFile->start_pos);
              lstrcat(buf,tmp);
    }
  }
  return buf;
}

//-------------------------------------------
//  ,      
bool GetTimeDstFile(char *buf, char *path)
{
  WIN32_FIND_DATA Fdata;
  HANDLE h;
  SYSTEMTIME Stime;
  FILETIME ft;
  char *p,*s;
  bool ret=false;

  p=GetMsg(M_DstTime);
  if((h=FindFirstFile(path,&Fdata))!=INVALID_HANDLE_VALUE)
  {
    if(FileTimeToLocalFileTime(&Fdata.ftLastWriteTime,&ft) &&
       FileTimeToSystemTime(&ft,&Stime))
    {
      wsprintf(buf,"%s %10lu %2.2u.%2.2u.%2.2u %2.2u:%2.2u:%2.2u",
               p,
               Fdata.nFileSizeLow,
               Stime.wDay,Stime.wMonth,Stime.wYear%100,
               Stime.wHour,Stime.wMinute,Stime.wSecond);
      ret=true;
    }
    FindClose(h);
  }
  if(!ret)
  {
    s=GetMsg(M_ErrorTime);
    wsprintf(buf,"%s - %s",p,s);
  }
  return ret;
}

//-------------------------------------------
//  ,      
bool GetTimeSrcFile(char *buf, InfoCopy *InfoFile)
{
  SYSTEMTIME Stime;
  FILETIME ft;
  char *p,*s;
  bool ret=false;

  p=GetMsg(M_SrcTime);
  if(FileTimeToLocalFileTime(&InfoFile->ftLastWriteTime,&ft) &&
     FileTimeToSystemTime(&ft,&Stime))
  {
    wsprintf(buf,"%s %10lu %2.2u.%2.2u.%2.2u %2.2u:%2.2u:%2.2u",
             p,
             InfoFile->nFileSizeLow,
             Stime.wDay,Stime.wMonth,Stime.wYear%100,
             Stime.wHour,Stime.wMinute,Stime.wSecond);
    ret=true;
  }
  if(!ret)
  {
    s=GetMsg(M_ErrorTime);
    wsprintf(buf,"%s - %s",p,s);
  }
  return ret;
}


//========================================
//  
void GetAllRegKey(InfoCopy *InfoFile)
{
  //  
  InfoFile->sizebuf=GetRegKey(HKEY_CURRENT_USER,"","SizeBuf",64)*1024;
  //  
  InfoFile->Repeat=GetRegKey(HKEY_CURRENT_USER,"","Repeat",1);
  InfoFile->AddNumberSection=GetRegKey(HKEY_CURRENT_USER,"","Section",0);
  InfoFile->bBad=GetRegKey(HKEY_CURRENT_USER,"","Verify",0);

  InfoFile->CopyShowTotal=GetFarRegKey(HKEY_CURRENT_USER,"Interface","CopyShowTotal",0);
  InfoFile->CopyTimeRule=GetFarRegKey(HKEY_CURRENT_USER,"System","CopyTimeRule",0);
}
//-------------------------------------
//   
int CheckInt(struct FarDialogItem *Item, int par)
{ //par -  ,  -1 - 
  int sum=0;
  char buf[20];
  lstrcpyn(buf,Item->Data,par+1);
  lalltrim(buf);
  par=lstrlen(buf);
  if(par==0) return -1;
  for(int i=0; i<par; i++)
  {
    if(buf[i]>='0' && buf[i]<='9')
      sum=sum*10+(buf[i]-'0');
    else 
      return -1;
  }
  return sum;
}
//---------------   ------------------
BOOL Config(void)
{
  int maxsize=0;
  int s_buf,n_buf;
  int c_read,n_read;
  int ext;
  int ret;
  char buf[5];
  char *s[9];
  bool fl;
  int  bBad;

  s[0]=GetMsg(D_Zag);
  s[1]=GetMsg(D_Buf);
  s[2]=GetMsg(D_Read);
  s[3]=GetMsg(D_DevCommon);
  s[4]=GetMsg(D_Not);
  s[5]=GetMsg(D_Number);
  s[6]=GetMsg(D_Start);
  s[7]=GetMsg(D_StartH);
  s[8]=GetMsg(D_Bad);

  for(int i=0; i<8; i++)
    if(lstrlen(s[i])>maxsize)
      maxsize=lstrlen(s[i]);
  maxsize += 4;

  struct FarDialogItem DialogItems []={
    {DI_DOUBLEBOX,3,1,maxsize+5,13, 0,0,0,0,{0}},  //box = zag

    {DI_FIXEDIT,5,2,8,0,        0,0,0,0,{0}}, // 
    {DI_TEXT,10,2,0,0,          TRUE,0,0,0,{0}}, //

    {DI_FIXEDIT,8,3,8,0,        0,0,0,0,{0}}, // 
    {DI_TEXT,10,3,0,0,          0,0,0,0,{0}}, //

    {DI_CHECKBOX,6,4,0,0,    0,0,0,0,{0}}, //BAD

    {DI_TEXT,0,5,0,0,   0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,{0}}, 
    {DI_TEXT,0,6,0,0,   0,0,DIF_SETCOLOR|DIF_CENTERGROUP|0x7E,0,{0}}, // 
    {DI_RADIOBUTTON, 5,7,0,0,    0,0,0,0,{0}},    //
    {DI_RADIOBUTTON, 5,8,0,0,    0,0,0,0,{0}},    //
    {DI_RADIOBUTTON, 5,9,0,0,    0,0,0,0,{0}},    //-dec
    {DI_RADIOBUTTON, 5,10,0,0,    0,0,0,0,{0}},    //-hex

    {DI_TEXT,0,11,0,0,   0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0,{0}}, 

    {DI_BUTTON,0,12,0,0, 0,0,DIF_CENTERGROUP,1,{0}},
    {DI_BUTTON,0,12,0,0, 0,0,DIF_CENTERGROUP,0,{0}}
  };

  //  
  s_buf=GetRegKey(HKEY_CURRENT_USER,"","SizeBuf",64);
  //  
  c_read=GetRegKey(HKEY_CURRENT_USER,"","Repeat",1);
  ext=GetRegKey(HKEY_CURRENT_USER,"","Section",0);
  bBad=GetRegKey(HKEY_CURRENT_USER,"","Verify",0);

  lstrcpy(DialogItems[0].Data,s[0]);

  wsprintf(buf,"%d",s_buf);
  lstrcpy(DialogItems[1].Data,buf);
  lstrcpy(DialogItems[2].Data,s[1]);

  wsprintf(buf,"%d",c_read);
  lstrcpy(DialogItems[3].Data,buf);
  lstrcpy(DialogItems[4].Data,s[2]);
  lstrcpy(DialogItems[5].Data,s[8]);

  lstrcpy(DialogItems[7].Data,s[3]);

  lstrcpy(DialogItems[8].Data,s[4]);
  lstrcpy(DialogItems[9].Data,s[5]);
  lstrcpy(DialogItems[10].Data,s[6]);
  lstrcpy(DialogItems[11].Data,s[7]);

  if(bBad)
    DialogItems[5].Selected=1;

  DialogItems[ext+8].Selected=1;

  lstrcpy(DialogItems[13].Data,GetMsg(D_Save));
  lstrcpy(DialogItems[14].Data,GetMsg(M_B_Exit));

  fl=true;
  while(fl)
  {
    ret=Info.Dialog(Info.ModuleNumber,-1,-1,maxsize+9,15,"Setup",DialogItems,
        sizeof(DialogItems)/sizeof(DialogItems[0]));
    fl=false;
    if(ret!=13)
      return FALSE;
// 1  3
    if((n_buf=CheckInt(&DialogItems[1],4))<=0)
    {
      fl=true;
      wsprintf(buf,"%d",s_buf);
      lstrcpy(DialogItems[1].Data,buf);
    }
    if((n_read=CheckInt(&DialogItems[3],1))<0)
    {
      fl=true;
      wsprintf(buf,"%d",c_read);
      lstrcpy(DialogItems[3].Data,buf);
    }
  }

//        
  if(n_buf != s_buf)
    SetRegKey(HKEY_CURRENT_USER,"","SizeBuf",n_buf);
  if(n_read != c_read)
    SetRegKey(HKEY_CURRENT_USER,"","Repeat",n_read);
  for(ret=0; ret<4; ret++)
    if(DialogItems[ret+8].Selected!=0)
    {
      SetRegKey(HKEY_CURRENT_USER,"","Section",ret);
      break;
    }
  if(DialogItems[5].Selected!=bBad)
    SetRegKey(HKEY_CURRENT_USER,"","Verify",DialogItems[5].Selected);

  return TRUE;
}


//===========================
//   
void InitScr(InfoCopy *InfoFile)
{
  char buf[80];
  char buf1[61];
  char Dst[NM];
  char *p;
  p=GetMsg(O_Copy);
  lstrcpyn(InfoFile->Scr[0],p,61);

  p=GetMsg(M_Copy);
  lstrcpyn(InfoFile->Scr[1],p,61);

  MinimizeName(InfoFile->cFileName,buf,60);
  lstrcpyn(InfoFile->Scr[2],buf,61);

  p=GetMsg(O_In);
  lstrcpyn(InfoFile->Scr[3],p,61);

  MinimizeName(GetDstPathFile(Dst,InfoFile),buf,60);
  lstrcpyn(InfoFile->Scr[4],buf,61);
//
  if(InfoFile->CopyShowTotal)  // - 
  {
    p=GetMsg(M_All);
    Delimiter(buf1,InfoFile->CommonSize);
    wsprintf(buf,p,InfoFile->CountFiles,buf1);
    lstrcpyn(InfoFile->Scr[9],lpadc(Dst,buf,0xc4,60),61);
//
    if(InfoFile->CopyTimeRule)
    {
      lstrcpy(InfoFile->Scr[11],Line);
      OutTime(buf,InfoFile);
      lstrcpyn(InfoFile->Scr[12],buf,61);
    }
    else
    {
      p=GetMsg(O_ESC);
      lstrcpyn(InfoFile->Scr[11],lpadc(buf,p,' ',60),61);
    }
  }
  else
  {
    lstrcpy(InfoFile->Scr[9],Line);
//
    if(InfoFile->CopyTimeRule)
    {
      p=GetMsg(O_WorkFiles);
      lstrcpyn(InfoFile->Scr[10],p,61);
      lstrcpy(InfoFile->Scr[11],Line);
      OutTime(buf,InfoFile);
      lstrcpyn(InfoFile->Scr[12],buf,61);
    }
    else
    {
      p=GetMsg(O_ESC);
      lpadc(buf,p,' ',60);
      p=GetMsg(O_WorkFiles);
      wsprintf(buf1,p,0);
      linsstr(buf,buf1);
      lstrcpyn(InfoFile->Scr[10],buf,61);
    }
  }

  p=GetMsg(M_Single);                     //
  Delimiter(buf1,InfoFile->nFileSizeLow);
  wsprintf(buf,p,buf1);
  lstrcpyn(InfoFile->Scr[5],lpadc(Dst,buf,0xc4,60),61);

  p=GetMsg(O_Verify);
  lstrcpyn(InfoFile->Scr[7],lpadc(buf,p,0xc4,60),61);

  FillMemory(buf,60,0xb0);
  lstrcpyn(InfoFile->Scr[6],buf,61);
  lstrcpyn(InfoFile->Scr[8],buf,61);

}
//===================================
//  
void OutScr(InfoCopy *InfoFile, bool bwr)
{
  unsigned long n;
  char *Item[13];
  char buf[61];
  char buf1[61];
  char buf2[80];
  unsigned long q,k;
  char *p,*p1;
  double d;
  int len;

  k=InfoFile->CountSize+InfoFile->start_pos+InfoFile->count_write;
  if(InfoFile->CopyShowTotal)
  {
    p=GetMsg(M_All);
    Delimiter(buf1,InfoFile->CommonSize-k);
    wsprintf(buf,p,InfoFile->CountFiles,buf1);
    lstrcpyn(InfoFile->Scr[9],lpadc(buf2,buf,0xc4,60),61);
  }
  if(InfoFile->CopyTimeRule && bwr)
  {
    OutTime(buf,InfoFile);
    lstrcpyn(InfoFile->Scr[12],buf,61);
  }

  p=GetMsg(M_Single);                     //
  q=InfoFile->start_pos+InfoFile->count_write;
  n=(InfoFile->nFileSizeLow>=q)?InfoFile->nFileSizeLow-q:0;
  Delimiter(buf1,n);
  wsprintf(buf,p,buf1);
  lstrcpyn(InfoFile->Scr[5],lpadc(buf2,buf,0xc4,60),61);

  buf[60]='\0';

  if(InfoFile->CopyShowTotal)
  {
    //05.08.2002
    if(InfoFile->CommonSize > 0)
      d=(double)k*60/(double)InfoFile->CommonSize;
    else
      d=0;
    n=(int)d + (((d-(int)d)>=0.5)?1:0);
    if(n>60) n=60;

    FillMemory(buf,n,0xdb);
    FillMemory(&buf[n],60-n,0xb0);
    lstrcpyn(InfoFile->Scr[10],buf,61);
  }
  else
  {
    if(InfoFile->CopyTimeRule)
    {
      p=GetMsg(O_WorkFiles);
      wsprintf(buf1,p,InfoFile->WorkFiles);
      lstrcpyn(InfoFile->Scr[10],buf1,61);
    }
    else
    {
      p=GetMsg(O_ESC);
      lpadc(buf,p,' ',60);
      p=GetMsg(O_WorkFiles);
      wsprintf(buf1,p,InfoFile->WorkFiles);
      linsstr(buf,buf1);
      lstrcpyn(InfoFile->Scr[10],buf,61);
    }
  }

  //05.08.2002
  if(InfoFile->nFileSizeLow > 0)
    d=(double)q*60/(double)InfoFile->nFileSizeLow;
  else
    d=0;
  n=(int)d + (((d-(int)d)>=0.5)?1:0);
  if(n>60) n=60;

  FillMemory(buf,n,0xdb);
  FillMemory(&buf[n],60-n,0xb0);
  lstrcpyn(InfoFile->Scr[6],buf,61);

  //05.08.2002
  if(InfoFile->nFileSizeLow > 0)
    d=(double)(InfoFile->start_pos+InfoFile->count_ver)*60/(double)InfoFile->nFileSizeLow;
  else
    d=0;
  n=(int)d + (((d-(int)d)>=0.5)?1:0);
  if(n>60) n=60;

  FillMemory(buf,n,0xdb);
  FillMemory(&buf[n],60-n,0xb0);
  lstrcpyn(InfoFile->Scr[8],buf,61);

  for(n=0; n<13; n++)
    Item[n]=InfoFile->Scr[n];

//=====        %
  //05.08.2002
  if(InfoFile->CommonSize > 0)
    d=((double)k*100)/(double)InfoFile->CommonSize;
  else
    d=0;
  n=(int)d + (((d-(int)d)>=0.5)?1:0);
  p=GetMsg(M_Title);
  p1=OutTime(buf,InfoFile);
  wsprintf(buf,p,n,p1);
  SetConsoleTitle(buf);
//=======
  if(InfoFile->CopyShowTotal)
  {
    len=12;
  }
  else
    len=11;
  if(InfoFile->CopyTimeRule)
    len=13;

  Info.Message(Info.ModuleNumber,FMSG_LEFTALIGN,0,Item,len,0);
  Info.Text(0,0,0,NULL);
}
//=================================
bool CheckSpace(InfoCopy *InfoFile)
{
  int sizeclust;
  for(;;)
  {
    InfoFile->FreeSpace=DriveFreeSpace(InfoFile->DstDir, &sizeclust);
    if(InfoFile->FreeSpace<0)
    {
      if(Message("ebb",M_B_Continue,M_B_Exit)!=0)
        InfoFile->ret=WRT_ERROR;
      else
        InfoFile->ret=WRT_RETRY;
      return false;
    }
    InfoFile->ret=WRT_SUC;  //
    InfoFile->sizeclust=sizeclust;
    return true;
  }
}
//============================
bool CheckFileExist(InfoCopy *InfoFile)
{
  char buf[51];
  char Dst[NM];
  char SrcTxt[51];
  char DstTxt[51];
  int ret;
  InfoFile->ret=WRT_RETRY;
  if(!InfoFile->fl_devide &&
     FileExists(GetDstPathFile(Dst,InfoFile)))
  {
    if(InfoFile->SkipAll) //    
    {
      InfoFile->ret=WRT_SKIP;   
      return false;
    }
    if(!InfoFile->ReplaceAll) //   
    {
      MinimizeName(GetDstPathFile(Dst,InfoFile),
                   buf,50);
//13.05.2001
      GetTimeDstFile(DstTxt,GetDstPathFile(Dst,InfoFile));
      GetTimeSrcFile(SrcTxt,InfoFile);

      ret=Message("sssssbbbbb",M_FileExists,
                    buf,
                    Line,
                    SrcTxt,
                    DstTxt,
                    M_B_Replace,M_B_ReplaceAll,M_B_Skip,M_B_SkipAll,M_B_Exit);
      if(ret==2) {InfoFile->ret=WRT_SKIP; return false;}
      if(ret==3) {InfoFile->ret=WRT_SKIP; InfoFile->SkipAll=true; return false;}
      if(ret<0 || ret>3) {InfoFile->ret=WRT_ERROR; return false;}
      if(ret==1) InfoFile->ReplaceAll=true;
    }

    SetFileAttributes(GetDstPathFile(Dst,InfoFile),
                         FILE_ATTRIBUTE_NORMAL);
    if(!DeleteFile(GetDstPathFile(Dst,InfoFile)))
    {
      MinimizeName(GetDstPathFile(Dst,InfoFile),
                   buf,40);
      ret=Message("esbbb",buf,
                   M_B_Continue,M_B_Skip,M_B_Exit);
      if(ret==0) InfoFile->ret=WRT_RETRY; //
      else if(ret==1) InfoFile->ret=WRT_SKIP; //
      else InfoFile->ret=WRT_ERROR; //
    }
    return false;
  }

  if(InfoFile->FreeSpace<=0)
  {
    if((ret=Message("sbb",M_E_DiskFull,
                   M_B_Continue,M_B_Exit))!=0)
      InfoFile->ret=WRT_ERROR;     //
    else
      InfoFile->ret=WRT_RETRY;      //
    return false;
  }

  InfoFile->ret=WRT_SUC;
  return true;
}

//==================================
bool CheckForceDir(InfoCopy *InfoFile)
{
  int ret;
  if(!ForceDir(InfoFile))
  {
    if((ret=Message("esbbb",InfoFile->DstDir,M_B_Continue,M_B_Skip,M_B_Exit))!=0)
    {
      if(ret==1) InfoFile->ret=WRT_SKIP; //
      else InfoFile->ret=WRT_ERROR; //
    }
    else
      InfoFile->ret=WRT_RETRY;
    return false;
  }
  InfoFile->ret=1;
  return true;
}

//=========================
void DelBadFile(InfoCopy *InfoFile)
{
  char Dst[NM];
  if(InfoFile->h!=0)
    CloseHandle(InfoFile->h);
  SetFileAttributes(GetDstPathFile(Dst,InfoFile),
                         FILE_ATTRIBUTE_NORMAL);
  DeleteFile(GetDstPathFile(Dst,InfoFile));
}
//=========================
bool ResizeFileAndTime(InfoCopy *InfoFile)
{
  if(InfoFile->Resize)
  {
    if((SetFilePointer(InfoFile->h,InfoFile->count_write,0,FILE_BEGIN)==0xFFFFFFFF)||
       !SetEndOfFile(InfoFile->h))
      return false;
  }
  if(!SetFileTime(InfoFile->h,&InfoFile->ftCreationTime,
                 &InfoFile->ftLastAccessTime,
                 &InfoFile->ftLastWriteTime))
    return false;
  if(InfoFile->h!=0)
    CloseHandle(InfoFile->h);
  InfoFile->h=0;
  return true;
}
//========================
//   
bool CheckForDevide(InfoCopy *InfoFile)
{
  char buf[50];
  char Dst[NM];
  int ret;
  if(!InfoFile->Devide &&
     !InfoFile->fl_devide &&
     InfoFile->FreeSpace<InfoFile->nFileSizeLow)
  {
    MinimizeName(GetDstPathFile(Dst,InfoFile),
                   buf,40);
    ret=Message("ssbbbb",M_E_FreeSize,buf,M_B_Devide,M_B_DevideAll,
                 M_B_Skip,M_B_Exit);
    if(ret<0 || ret>2) {InfoFile->ret=WRT_ERROR; return false;}
    if(ret==2) {InfoFile->ret=WRT_SKIP; return false;}
    if(ret==1) InfoFile->Devide=true;
    InfoFile->fl_devide=true;
  }
  return true;
}
//========================
//    
bool CheckCreateDest(InfoCopy *InfoFile)
{
  char Dst[NM];
  int ret;
  char buf[50];

  InfoFile->h=CreateFile(GetDstPathFile(Dst,InfoFile),
                GENERIC_WRITE | GENERIC_READ,
                0,                      
                0,
                (InfoFile->bOpenExist)? OPEN_ALWAYS:CREATE_ALWAYS,
                FILE_FLAG_NO_BUFFERING,
                0);
  if(InfoFile->h==INVALID_HANDLE_VALUE)
  {
    MinimizeName(GetDstPathFile(Dst,InfoFile),
                   buf,40);
    ret=Message("esbbb",buf,M_B_Continue,M_B_Skip,M_B_Exit);
    if(ret==0) InfoFile->ret=WRT_RETRY;
    else if(ret==1) InfoFile->ret=WRT_SKIP;
    else InfoFile->ret=WRT_ERROR;
    return false;
  }
  return true;
}
//================================
//   
int CheckBreak(InfoCopy *InfoFile)
{
  int ret;
  if(CheckForEsc())
  {
    ret=Message("sbbb",M_E_Break,M_B_Continue,M_B_Retry_New,M_B_Exit);
    if(ret==1)
    {
      CloseHandle(InfoFile->h); InfoFile->h=0;
      DelBadFile(InfoFile);
      if(Message("sbb",M_E_DiskFull,M_B_Continue,M_B_Exit)!=0)
        InfoFile->ret=WRT_ERROR;
      else
        InfoFile->ret=WRT_RETRY;
      return 2;
    }
    else if(ret>1)
    {
      InfoFile->ret=WRT_ERROR;
      return 1;
    }
  }
  return 0;
}
//===============================================
//  
//===============================================
bool ReadSrc(InfoCopy *InfoFile)
{
  long count;
  char Dst[NM];
  char buf[100];
  int ret;

  InfoFile->SrcPosBefore=_llseek(InfoFile->hSrc,0,FILE_CURRENT);

  for(;;)
  {
    count=_lread(InfoFile->hSrc,InfoFile->buffer,InfoFile->sizebuf);
    if(count==HFILE_ERROR)
    {
      MinimizeName(GetPathFile(Dst,InfoFile->SrcDir,InfoFile->cFileName),
                   buf,40);
      ret=Message("esbbb",buf,M_B_Retry,M_B_Skip,M_B_Exit);
      if(ret==0) 
      {
        _llseek(InfoFile->hSrc,InfoFile->SrcPosBefore,FILE_BEGIN);
        continue;
      }
      if(ret==1) InfoFile->ret=WRT_SKIP;
      else InfoFile->ret=WRT_ERROR;
      return false;    //      
    }
    break;             
  }

  InfoFile->ret=WRT_SUC;

  if(InfoFile->len > count)
    InfoFile->len=count;
  if((InfoFile->len%InfoFile->sizeclust)!=0) //  
  {
    InfoFile->Resize=true;
    InfoFile->lenr=((InfoFile->len/InfoFile->sizeclust)+1)*InfoFile->sizeclust;
  }
  else
    InfoFile->lenr=InfoFile->len;
  return true;
}

//===============================================
// 
//===============================================
bool WriteDst(InfoCopy *InfoFile)
{
  bool er;
  unsigned long tec_w;
  char *Err;
  char Dst[NM];
  char buf[100];
  int ret;
  
  InfoFile->DstPosBefore=SetFilePointer(InfoFile->h,0,0,FILE_CURRENT);
//
  er=WriteFile(InfoFile->h,InfoFile->buffer,InfoFile->lenr,&tec_w,0);

  if(!er || InfoFile->lenr!=tec_w)
  {
    if(!InfoFile->bBad)     
    {
lw:   MinimizeName(GetDstPathFile(Dst,InfoFile),
                   buf,40);
      Err=SystemErrorMessage();
      DelBadFile(InfoFile);
      if(!er)
        ret=Message("ssbbbb",Err,buf,M_B_Retry,M_B_Retry_New,
                   M_B_Abort,M_B_Exit);
      else              
        ret=Message("ssbbbb",M_E_WriteFile,buf,M_B_Retry,M_B_Retry_New,
                   M_B_Abort,M_B_Exit);
      if(ret==0) InfoFile->ret=WRT_RETRY; //
      else if(ret==1) // 
      {
        if(Message("sbb",M_E_DiskFull,M_B_Continue,M_B_Exit)!=0)
          InfoFile->ret=WRT_ERROR;
        else
          InfoFile->ret=WRT_RETRY;
      }
      else if(ret==2) InfoFile->ret=WRT_SKIP;
      else InfoFile->ret=WRT_ERROR;
      return false;
    }
    else  //  BAD-
    {
      if(!CheckBadClaster(InfoFile))//,(DWORD)InfoFile->lenr,InfoFile->BadSize))
      {
        er=true;                 //****     
        goto lw;                 //  ,  
      }                          //len  lenr
      InfoFile->FreeSpace -= InfoFile->BadSize;
      if(InfoFile->count_write<=0 && InfoFile->len<=0) //   
        return false;
      if(!CheckForDevide(InfoFile))
        return false;
    }
  }
  InfoFile->count_write += InfoFile->len; //len ..  ()
  return true;
}

//============================================
// 
//============================================
bool ReadDst(InfoCopy *InfoFile)
{
  bool er;
  unsigned long tec_w;
  char *Err;
  char Dst[NM];
  char buf[100];
  int ret;

  for(;;)
  {
    if(SetFilePointer(InfoFile->h,InfoFile->DstPosBefore,
         0,FILE_BEGIN)==0xFFFFFFFF) // 
    {
      MinimizeName(GetDstPathFile(Dst,InfoFile),
                     buf,40);
      Err=SystemErrorMessage();
      DelBadFile(InfoFile);
      ret=Message("ssbbbb",Err,buf,M_B_Retry,M_B_Retry_New,
                 M_B_Abort,M_B_Exit);
      if(ret==0) InfoFile->ret=WRT_RETRY; //
      else if(ret==1) // 
      {
        if(Message("sbb",M_E_DiskFull,M_B_Continue,M_B_Exit)!=0)
          InfoFile->ret=WRT_ERROR;
        else
          InfoFile->ret=WRT_RETRY;
      }
      else if(ret==2) InfoFile->ret=WRT_SKIP;
      else InfoFile->ret=WRT_ERROR;
      return false;
    }

//
    er=ReadFile(InfoFile->h,InfoFile->rbuffer,InfoFile->lenr,&tec_w,0);
    if(!er || InfoFile->lenr!=tec_w)
    {
      if(!InfoFile->bBad)
      {
rd:     MinimizeName(GetDstPathFile(Dst,InfoFile),
                       buf,40);
        Err=SystemErrorMessage();
        DelBadFile(InfoFile);
        if(!er)
          ret=Message("ssbbbb",Err,buf,M_B_Retry,M_B_Retry_New,
                     M_B_Abort,M_B_Exit);
        else
          ret=Message("ssbbbb",M_E_VerFile,buf,M_B_Retry,M_B_Retry_New,
                       M_B_Abort,M_B_Exit);
        if(ret==0) InfoFile->ret=WRT_RETRY; //
        else if(ret==1) // 
        {
          if(Message("sbb",M_E_DiskFull,M_B_Continue,M_B_Exit)!=0)
            InfoFile->ret=WRT_ERROR;
          else
            InfoFile->ret=WRT_RETRY;
        }
        else if(ret==2) InfoFile->ret=WRT_SKIP;
        else InfoFile->ret=WRT_ERROR;
        return false;
      }
      else  //  BAD-
      {
        long t_len=InfoFile->len;

        if(!CheckBadClaster(InfoFile))
        {
          er=true;
          goto rd;
        }
        InfoFile->FreeSpace -= InfoFile->BadSize;
        t_len -= InfoFile->len;
        InfoFile->count_write -= t_len; //  
        if(InfoFile->count_write<=0 && InfoFile->len<=0) //   
          return false;
        if(!CheckForDevide(InfoFile))
          return false;
        continue;
      }
    }
    return true;
  }
}

//=========================
bool CheckReadWrite(InfoCopy *InfoFile)
{
  int ret;
  char buf[100];
  char *Err;
  char Dst[NM];
  bool ret_f;
  long l;
  bool end;

//     
  if(!CheckForDevide(InfoFile))
    return false;
//   
  if(!CheckCreateDest(InfoFile))
    return false;


  l=InfoFile->nFileSizeLow-InfoFile->start_pos;
  InfoFile->Resize=false;

  ret_f=true;
  for(;;)
  {
    end=(l<=InfoFile->FreeSpace)?true:false; //  
    if(!end)
      InfoFile->fl_devide=true;
    
    InfoFile->len=InfoFile->FreeSpace-InfoFile->count_write;
    if(InfoFile->len<=0)
      break; // 
    //**********20052001
//=========================  
    if(!(ret_f=ReadSrc(InfoFile)))  // 
      break;
    if(InfoFile->len==0)    //  
      break;
//----------------------------
//==============  
    if(!(ret_f=WriteDst(InfoFile)))
      break;

    OutScr(InfoFile,false);

    if((ret=CheckBreak(InfoFile))>0)
    {
      if(ret==2) return false;
      ret_f=false;
      break;
    }


    for(int i=0; i<InfoFile->Repeat; i++)
    {
//
      if(!(ret_f=ReadDst(InfoFile)))
        break;
      if((ret=CheckBreak(InfoFile))>0)
      {
        if(ret==2) return false;
        ret_f=false;
        break;
      }
    }
    if(ret_f) InfoFile->count_ver += InfoFile->len;

    OutScr(InfoFile,true);

    if(!ret_f) break;
  }

  if(ret_f) //  
  {
    CloseHandle(InfoFile->h); InfoFile->h=0;
    InfoFile->h=CreateFile(GetDstPathFile(Dst,InfoFile),
                GENERIC_READ|GENERIC_WRITE,
                0,
                0,
                OPEN_EXISTING,
                0,
                0);
    if((InfoFile->h==INVALID_HANDLE_VALUE) ||
       !ResizeFileAndTime(InfoFile) ||
       !SetFileAttributes(GetDstPathFile(Dst,InfoFile),
                          InfoFile->dwFileAttributes))
    {
      MinimizeName(GetDstPathFile(Dst,InfoFile),
                   buf,40);
      Err=SystemErrorMessage();
      DelBadFile(InfoFile);
      ret=Message("ssbbbb",Err,buf,M_B_Retry,M_B_Retry_New,
              M_B_Abort,M_B_Exit);
      if(ret==0) InfoFile->ret=WRT_RETRY; //
      else if(ret==1) // 
      {
        if(Message("sbb",M_E_DiskFull,M_B_Continue,M_B_Exit)!=0)
          InfoFile->ret=WRT_ERROR;
        else
          InfoFile->ret=WRT_RETRY;
      }
      else if(ret==2) InfoFile->ret=WRT_SKIP;
      else InfoFile->ret=WRT_ERROR;
      ret_f=false;
    }
  }

  if(InfoFile->h!=0)
  {
    CloseHandle(InfoFile->h);
    InfoFile->h=0;
  }
  if(!ret_f) //   ????????
    DelBadFile(InfoFile);
  else
  {
    InfoFile->ret=WRT_SUC;
    InfoFile->NumberSection++;
  }
  if(end)
    InfoFile->fl_devide=false;
  return ret_f;
}
//===================================
//  : 1-, 2-, 0-, -1-
bool CopyVF(InfoCopy *InfoFile)
{  
  if(!CheckSpace(InfoFile))
    return false;
  if(!CheckFileExist(InfoFile))
    return false;
//2-      
  if(!CheckForceDir(InfoFile))
    return false;
  if(!CheckSpace(InfoFile)) //, ..   
    return false;           //   
//3-----------
  InitScr(InfoFile);
  OutScr(InfoFile,false);
  InfoFile->bOpenExist=false; //   
  return CheckReadWrite(InfoFile);
}

//===============================================
//  
int CopyVerifyFile(InfoCopy *InfoFile)
{
  int ret;
  char buf[41];
  char Dst[NM];
//    -
  InfoFile->count_write=0;
  InfoFile->start_pos=0;
  InfoFile->count_ver=0;
  InfoFile->fl_devide=false;
  InfoFile->NumberSection=0;

//  
  for(;;)
  {
    if((InfoFile->hSrc=_lopen(GetPathFile(Dst,InfoFile->SrcDir,
                              InfoFile->cFileName),
                              OF_READ))==HFILE_ERROR)
    {
      MinimizeName(GetPathFile(Dst,InfoFile->SrcDir,
                   InfoFile->cFileName),buf,40);
      if((ret=Message("esbbb",buf,
                    M_B_Continue,M_B_Skip,M_B_Exit))!=0)
      {
        if(ret==1) return 0; ///
        return -1;           //
      }
      continue;
    }
    break;
  }

  for(;;)
  {
    CopyVF(InfoFile);
    ret=InfoFile->ret;
    if(InfoFile->ret<=0) //-1-exit, 0-skip
      break;
    if(InfoFile->ret==1)  //1-
      InfoFile->start_pos += InfoFile->count_write;
    else //2-
    {
      if(_llseek(InfoFile->hSrc,InfoFile->start_pos,FILE_BEGIN)==HFILE_ERROR)
      {
        if((ret=Message("esbb",buf,M_B_Abort,M_B_Exit))!=0)
          ret=-1;
        else
          ret=0;
        break;
      }
      InfoFile->count_write=0;
      InfoFile->count_ver=0;
    }
    //05.08.2002
    if(InfoFile->nFileSizeLow>0)
    {
      if(InfoFile->nFileSizeLow<=InfoFile->start_pos)
        break;
    }
    else if(InfoFile->ret < 2)
      break;
  }

  _lclose(InfoFile->hSrc);
  if(ret>=0)
  {
    InfoFile->CountFiles--;
    InfoFile->WorkFiles++;
    InfoFile->CountSize+=InfoFile->nFileSizeLow;
  }
//  InfoFile->NumberSection=0;
  return ret;
}
//==========  ===
void ClearSelected(InfoCopy *InfoFile)
{
  for(int i=0; i<InfoFile->ActP.ItemsNumber; i++)
    if(lstrcmp(InfoFile->ActP.PanelItems[i].FindData.cFileName,
               InfoFile->cFileName)==0)
    {
      InfoFile->ActP.PanelItems[i].Flags &=~PPIF_SELECTED;
      return;
    }
}

//=========  ==================
int CopyVerifyDir(InfoCopy *InfoFile)
{
  int nDst, nSrc;
  int ret,retf=1;
  HANDLE ff;
  WIN32_FIND_DATA Data;
  char buf1[NM];

  nDst=lstrlen(InfoFile->DstDir);
  nSrc=lstrlen(InfoFile->SrcDir);
//  11.05.2003 -  
  GetPathFile(buf1,InfoFile->DstDir,InfoFile->cFileName);
//----
  lstrcpy(InfoFile->DstDir,buf1);
  GetPathFile(buf1,InfoFile->SrcDir,InfoFile->cFileName);
  lstrcpy(InfoFile->SrcDir,buf1);

  lstrcat(buf1,"\\*.*");

  if((ff=FindFirstFile(buf1,&Data))!=INVALID_HANDLE_VALUE)
  { 
     do
     {
       if(Data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
       {
         if(lstrcmp(Data.cFileName,".")==0 ||
            lstrcmp(Data.cFileName,"..")==0)
            continue;
         lstrcpy(InfoFile->cFileName,Data.cFileName);
         InfoFile->AttribDir[InfoFile->CountDirAttr++]=Data.dwFileAttributes;
         ret=CopyVerifyDir(InfoFile);
         InfoFile->CountDirAttr--;
         if(ret<0)
         {
           retf=ret;
           break;
         }
         if(retf!=0 && ret==0)
           retf=0;  //       
       }
       else
       {
         InfoFile->dwFileAttributes=Data.dwFileAttributes;
         InfoFile->ftCreationTime=Data.ftCreationTime;
         InfoFile->ftLastAccessTime=Data.ftLastAccessTime;
         InfoFile->ftLastWriteTime=Data.ftLastWriteTime;
         InfoFile->nFileSizeLow=Data.nFileSizeLow;
         lstrcpy(InfoFile->cFileName,Data.cFileName);
         if((ret=CopyVerifyFile(InfoFile)) < 0)
         {
           retf=ret;
           break;
         }
         if(retf!=0 && ret==0)
           retf=0;  //       
       }
     } while(FindNextFile(ff,&Data));
     FindClose(ff);
  }

  InfoFile->DstDir[nDst]='\0';
  InfoFile->SrcDir[nSrc]='\0';
  return retf;
}

//=================  -  
void CopyAll(InfoCopy *InfoFile)
{
  struct PluginPanelItem *pl;
  int ret;
  if(InfoFile->ActP.ItemsNumber<=0 || InfoFile->ActP.SelectedItemsNumber<1)
    return;
//       
  for(;;)
  {
    if(!ForceDir(InfoFile))
    {
      ret=Message("esbb",InfoFile->DstDir,M_B_Retry,M_B_Exit);
      if(ret!=0)
        return;
    }
    break;
  }
  for(int i=0; i<InfoFile->ActP.SelectedItemsNumber; i++)
  {
    pl=&InfoFile->ActP.SelectedItems[i];
    if(!(pl->FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
    {
      InfoFile->dwFileAttributes=pl->FindData.dwFileAttributes; 
      InfoFile->ftCreationTime=pl->FindData.ftCreationTime; 
      InfoFile->ftLastAccessTime=pl->FindData.ftLastAccessTime; 
      InfoFile->ftLastWriteTime=pl->FindData.ftLastWriteTime; 
      InfoFile->nFileSizeLow=pl->FindData.nFileSizeLow; 
      lstrcpy(InfoFile->cFileName,pl->FindData.cFileName); 

      ret=CopyVerifyFile(InfoFile);
      if(ret<0)
        break;
      else if(ret==1)
        ClearSelected(InfoFile);
    }
    else
    {
      lstrcpy(InfoFile->cFileName,pl->FindData.cFileName); 
      InfoFile->AttribDir[InfoFile->CountDirAttr++]=pl->FindData.dwFileAttributes;
      ret=CopyVerifyDir(InfoFile);
      lstrcpy(InfoFile->cFileName,pl->FindData.cFileName); 
      if(ret<0)
        break;
      else if(ret==1)
        ClearSelected(InfoFile);
    }
  }

}


//----------------------------------------------------
void SRScreen(InfoCopy *InfoFile,bool Save)
{
  static HANDLE h;
  if(Save)
  {
    h=Info.SaveScreen(0,0,-1,-1);
    Info.RestoreScreen(InfoFile->hScreen);
    InfoFile->hScreen=Info.SaveScreen(0,0,-1,-1);
  }
  else
  {
    Info.RestoreScreen(h);
    h=0;
  }
}

//=============================
void UpdateFat(int s1, int s2, int n1, int n2)
{
  char str1[36],str2[36],str3[36];
  char *Item[5];
  Item[0]=GetMsg(F_Zag);
  Item[3]=Line;
  lpadc(str3,GetMsg(O_ESC),' ',35);
  Item[4]=str3;
  if(s1>=0)
    wsprintf(str1,GetMsg(s1),n1);
  else
    str1[0]='\0';
  Item[1]=str1;

  if(s2>=0)
    wsprintf(str2,GetMsg(s2),n2);
  else
    str2[0]='\0';
  Item[2]=str2;
  Info.Message(Info.ModuleNumber,FMSG_WARNING,0,Item,5,0);
  Info.Text(0,0,0,NULL);
}

