#ifndef _H_FatSrv
#define _H_FatSrv

//    N - NT(2000), W - WIN9X


#define FATEOF  0xffff
#define FATBAD  0xfff7

#define VWIN32_DIOC_DOS_DRIVEINFO   6 
#define VWIN32_DIOC_DOS_INT13       4
#define VWIN32_DIOC_DOS_INT25       2   
#define VWIN32_DIOC_DOS_INT26       3 
#define VWIN32_DIOC_DOS_IOCTL       1   

#pragma pack(push,1)

//     WIN95
typedef struct
{
  DWORD StartSec;
  WORD  CountSec;
  LPVOID Buffer;
} ABS_RW;


typedef struct _DIOC_REGISTERS {
    DWORD reg_EBX;
    DWORD reg_EDX;
    DWORD reg_ECX;
    DWORD reg_EAX;
    DWORD reg_EDI;
    DWORD reg_ESI;
    DWORD reg_Flags;
} DIOC_REGISTERS, *PDIOC_REGISTERS;

typedef struct
{
  BYTE  Jmp[3];
  BYTE  Oem[8];
  WORD  wSectSize;
  BYTE  bClustSects;
  WORD  wResSects;
  BYTE  bFatCnt;
  WORD  wRootEntries;
  WORD  wTotSects;

  BYTE  bMedia;
  WORD  wFatSects;
  WORD  wSectsPerTrack;
  WORD  wHeads;

} BOOT_SEC;

// 
typedef struct
{
  char  Name[8]; //  
  char  Ext[3];  //
  BYTE  Attr;
  BYTE  Dummy[10]; //
  WORD  rTime;
  WORD  rDate;
  WORD  StClast;
  DWORD Fsize; // !  
} DIR_ENTRY;


//    
typedef struct
{
  BOOT_SEC  Boot;
  BOOL      TypeFat; //TRUE-12, FALSE - 16
  DWORD     StartFatOff; //  
  DWORD     StartDirOff; //  ROOTDIR
  DWORD     StartDataOff;//  
  LPVOID    MemFat;      //     FAT
  LPVOID    MemFat2;     //     FAT ()
  LPVOID    MemRootDir;  //   root dir
  WORD      CountBad;    // bad
  DWORD     SizeFatAll;
  DWORD     SizeFat;
  DWORD     SizeRootDir;
  WORD      CountClast;  //   
//
  int       RetCode;     //  
//
  LPVOID    MemWrite;     //  InfoFile   
  LPVOID    MemRead;      //  InfoFile   
//
  DWORD     DirNum;       //     
  LPVOID    MemDir;       //     
  DWORD     NumDirCl;     //    
  BOOL      IsRoot;       // - TRUE -   , FALSE -  
} FAT;

#pragma pack(pop)

//  
BOOL LockVolume(HANDLE hDisk);
BOOL NLockVolume(HANDLE hDisk);
BOOL WLockVolume(HANDLE hDisk);
//--  
BOOL UnlockVolume(HANDLE hDisk);
BOOL NUnlockVolume(HANDLE hDisk);
BOOL WUnlockVolume(HANDLE hDisk);
//  
BOOL DismountVolume(HANDLE hDisk);
BOOL NDismountVolume(HANDLE hDisk);
BOOL WDismountVolume(HANDLE hDisk);
/*----------------------------------
//     
// ( )
-----------------------------------*/
HANDLE OpenVolume(int Disk); //  
HANDLE NOpenVolume(int Disk); //  
HANDLE WOpenVolume(int Disk); //  

/*----------------------------------
//  boot-
-----------------------------------*/
BOOL ReadBootSec(HANDLE hDrive, FAT *Sec);

/*----------------------------------
//    FAT
-----------------------------------*/
WORD GetFatElem(FAT *Fat, WORD Number);

/*----------------------------------
//   FAT
-----------------------------------*/
void SetFatElem(FAT *Fat, WORD Number, WORD Data);

/*----------------------------------
//  FAT  
-----------------------------------*/
BOOL WriteFat(HANDLE hDrive, FAT *Sec);

/*----------------------------------
//     /
//    ()
//  -   NClaster
-----------------------------------*/
BOOL _GetFirstNumberClaster(HANDLE hDrive, FAT *Fat, BOOL bRoot,
                            char *Name, WORD *NClaster);

/*----------------------------------
//     /
//    
//  -   NClaster
-----------------------------------*/
BOOL GetFirstNumberClaster(HANDLE hDrive, FAT *Fat, char *Name, WORD *NClaster);

/*----------------------------------
//  
-----------------------------------*/
void FreeMemFAT(FAT *Fat);

/*----------------------------------
//    
-----------------------------------*/
BOOL CheckEof(FAT *Fat, unsigned nCl);

/*----------------------------------
//    
-----------------------------------*/
WORD GetNumberClaster(FAT *Fat, WORD STCl, DWORD Offset);

/*----------------------------------
//    
-----------------------------------*/
WORD GetLastNumberClaster(FAT *Fat, WORD Claster);

/*----------------------------------
//     
-----------------------------------*/
BOOL VerifyBad(HANDLE hDrive, FAT *Fat, WORD StCl, InfoCopy *InfoFile);

/*----------------------------------
//      
//
-----------------------------------*/
int GetCharDrive(char *fname);

/*----------------------------------
//     
-----------------------------------*/
BOOL WriteBadFat(HANDLE hDrive, FAT *Fat);

/*----------------------------------
 FreeAll -     
-----------------------------------*/
BOOL FreeAll(HANDLE h, FAT *Fat);

/*----------------------------------
//    
// Size -    ,   
// CheckSize -   
// SubSize -   
// 
-----------------------------------*/
BOOL CheckBadClaster(InfoCopy *InfoFile);

//===============================
//   
BOOL CheckRestoreBreak(void);

// - 
BOOL AllReadFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat);
// - 
BOOL AllWriteFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat);

BOOL NReadFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat);
BOOL NWriteFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat);

BOOL WReadFile(HANDLE hDrive, DWORD Sec_Pos, WORD Sec_Count, LPVOID Buf);
BOOL WWriteFile(HANDLE hDrive, DWORD Sec_Pos, WORD Sec_Count, LPVOID Buf);
//BOOL WResetDrive(HANDLE hDrive);


#define CHK_SUC   0
#define CHK_WR    1
#define CHK_RD    2

#define CHK_ABT   3
#define CHK_ESC   4

#endif