
#include <windows.h>
#include "plugin.hpp"
#include "backrest.h"
#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"

static int Flop='A'; // 


//=============================
BOOL WReadFile(HANDLE hDrive, DWORD Sec_Pos, WORD Sec_Count, LPVOID Buf)
{
  DIOC_REGISTERS reg;
  BOOL bRet;
  DWORD cb;
  ABS_RW rw;

  rw.StartSec=Sec_Pos;
  rw.CountSec=Sec_Count;
  rw.Buffer=Buf;

  reg.reg_EAX=(Flop-'A'); 
  reg.reg_ECX=0xffff;
  reg.reg_EDX=100;
  reg.reg_EBX=(DWORD)&rw;
  reg.reg_Flags=0x0001;

  bRet = DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_INT25,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);
  if (!bRet || (reg.reg_Flags & 0x0001))
    return FALSE; // error if carry flag is set 
  return TRUE;
}

//====================================
//=============================
BOOL WWriteFile(HANDLE hDrive, DWORD Sec_Pos, WORD Sec_Count, LPVOID Buf)
{
  DIOC_REGISTERS reg;
  BOOL bRet;
  DWORD cb;
  ABS_RW rw;

  rw.StartSec=Sec_Pos;
  rw.CountSec=Sec_Count;
  rw.Buffer=Buf;

  reg.reg_EAX=(Flop-'A'); 
  reg.reg_ECX=0xffff;
  reg.reg_EDX=100;
  reg.reg_EBX=(DWORD)&rw;
  reg.reg_Flags=0x0001;

  bRet = DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_INT26,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);
  if (!bRet || (reg.reg_Flags & 0x0001))
    return FALSE; // error if carry flag is set 
  return TRUE;
}



BOOL LockVolume(HANDLE hDrive)
{
  if(System==PL_NT)
    return NLockVolume(hDrive);
  return WLockVolume(hDrive);
}
BOOL UnlockVolume(HANDLE hDrive)
{
  if(System==PL_NT)
    return NUnlockVolume(hDrive);
  return WUnlockVolume(hDrive);
}
BOOL DismountVolume(HANDLE hDrive)
{
  if(System==PL_NT)
    return NDismountVolume(hDrive);
  return WDismountVolume(hDrive);
}
HANDLE OpenVolume(int Disk)
{
  if(System==PL_NT)
    return NOpenVolume(Disk);
  return WOpenVolume(Disk);
}

//=======================
BOOL WLockVolume(HANDLE hDrive)
{
  DIOC_REGISTERS reg;
  BOOL bRet;
  DWORD cb;

  reg.reg_EAX=0x440D;
  reg.reg_ECX=0x84B;
  reg.reg_EBX=(Flop-'A') & 0x7f;
  reg.reg_EDX=0;
  reg.reg_Flags=0x0001;

  bRet = DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_IOCTL,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);

  if (!bRet || (reg.reg_Flags & 0x0001))
    return FALSE; // error if carry flag is set 
//   
  reg.reg_EAX=0x440D;
  reg.reg_ECX=0x84B;
  reg.reg_EBX=(Flop-'A') & 0x7f;
  reg.reg_EDX=4; //
  reg.reg_Flags=0x0001;

  bRet = DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_IOCTL,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);

  if (!bRet || (reg.reg_Flags & 0x0001))
  {
    //    1- 
    reg.reg_EAX=0x440D;
    reg.reg_ECX=0x86B;
    reg.reg_EBX=(Flop-'A') & 0x7f;
    reg.reg_Flags=0x0001;

    DeviceIoControl(hDrive, 
      VWIN32_DIOC_DOS_IOCTL,
      &reg, sizeof(reg), 
      &reg, sizeof(reg), 
      &cb, 0);

    return FALSE; // error if carry flag is set 
  }

  return TRUE;
}
//=============================
BOOL WDismountVolume(HANDLE hDrive)
{
  DIOC_REGISTERS reg;
  BOOL bRet;
  DWORD cb;

  reg.reg_EAX=0x710D; //reset drive
  reg.reg_ECX=0x0001;
  reg.reg_EDX=(Flop-'A')+1;
  reg.reg_Flags=0x0001;

  bRet = DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_IOCTL,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);
  if (!bRet)
    return FALSE;  
  return TRUE;
}
//===============================
BOOL WUnlockVolume(HANDLE hDrive)
{
  DIOC_REGISTERS reg;
  BOOL bRet;
  DWORD cb;

  reg.reg_EAX=0x440D;
  reg.reg_ECX=0x86B;
  reg.reg_EBX=(Flop-'A') & 0x7f;
  reg.reg_Flags=0x0001;

  DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_IOCTL,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);
// 
  reg.reg_EAX=0x440D;
  reg.reg_ECX=0x86B;
  reg.reg_EBX=(Flop-'A') & 0x7f;
  reg.reg_Flags=0x0001;

  bRet = DeviceIoControl(hDrive, 
    VWIN32_DIOC_DOS_IOCTL,
    &reg, sizeof(reg), 
    &reg, sizeof(reg), 
    &cb, 0);
  if (!bRet || (reg.reg_Flags & 0x0001))
    return FALSE;
  return TRUE;
}

//==========================
HANDLE WOpenVolume(int Disk) //  
{
  HANDLE hDrive;
  char *Drive="\\\\.\\VWIN32";
  BOOL bL=FALSE;

  Flop=(int)CharUpper((char*)Disk); // 

  for(;;)
  {
    hDrive = CreateFile(
               Drive,
               0,//GENERIC_READ | GENERIC_WRITE,
               0,//FILE_SHARE_READ|FILE_SHARE_WRITE,
               NULL,
               0,//OPEN_EXISTING,
               FILE_FLAG_DELETE_ON_CLOSE | FILE_FLAG_NO_BUFFERING,//0,
               NULL
               );
    if(hDrive == INVALID_HANDLE_VALUE)  //  
      return hDrive;

    if(WLockVolume(hDrive) == FALSE)
    {
      if(bL || (WDismountVolume(hDrive) == FALSE))
      {
        CloseHandle(hDrive);
        return INVALID_HANDLE_VALUE;
      }
      bL=TRUE;
      CloseHandle(hDrive);

    }
    else
      break;

  }
  return hDrive;
}

/*----------------------------------
//   NT
-----------------------------------*/
BOOL NLockVolume(HANDLE hDisk)
{
  DWORD ReturnedByteCount;

  return DeviceIoControl(
                hDisk,
                FSCTL_LOCK_VOLUME,
                NULL,
                0,
                NULL,
                0,
                &ReturnedByteCount,
                NULL
                );
}

/*----------------------------------
//--   NT
-----------------------------------*/
BOOL NUnlockVolume(HANDLE hDisk)
{
  DWORD ReturnedByteCount;

  return DeviceIoControl(
                hDisk,
                FSCTL_UNLOCK_VOLUME,
                NULL,
                0,
                NULL,
                0,
                &ReturnedByteCount,
                NULL
                );
}

/*----------------------------------
//   NT
-----------------------------------*/
BOOL NDismountVolume(HANDLE hDisk)
{
  DWORD ReturnedByteCount;

  return DeviceIoControl(
                hDisk,
                FSCTL_DISMOUNT_VOLUME,
                NULL,
                0,
                NULL,
                0,
                &ReturnedByteCount,
                NULL
                );
}


/*----------------------------------
//     
// ( ) NT
-----------------------------------*/
HANDLE NOpenVolume(int Disk) //  
{
  HANDLE hDrive;
  char Drive[8];
  BOOL bL=FALSE;

  wsprintf(Drive,"\\\\.\\%c:",(char)Disk);

  for(;;)
  {
    hDrive = CreateFile(
               Drive,
               GENERIC_READ | GENERIC_WRITE,
               FILE_SHARE_READ|FILE_SHARE_WRITE,
               NULL,
               OPEN_EXISTING,
               FILE_FLAG_NO_BUFFERING,//0,
               NULL
               );
    if(hDrive == INVALID_HANDLE_VALUE)  //  
      return hDrive;

    if(LockVolume(hDrive) == FALSE)
    {
      if(bL || (DismountVolume(hDrive) == FALSE))
      {
        CloseHandle(hDrive);
        return INVALID_HANDLE_VALUE;
      }
      bL=TRUE;
      CloseHandle(hDrive);

    }
    else
      break;

  }

  return hDrive;
}

/*----------------------------------
//  
-----------------------------------*/
void FreeMemFAT(FAT *Fat)
{
  if(Fat->MemFat)
  {
    VirtualFree(Fat->MemFat,0,MEM_RELEASE);
    Fat->MemFat=0;
  }
  if(Fat->MemDir)
  {
    VirtualFree(Fat->MemDir,0,MEM_RELEASE);
    Fat->MemFat=0;
  }
  if(Fat->MemRootDir)
  {
    VirtualFree(Fat->MemRootDir,0,MEM_RELEASE);
    Fat->MemRootDir=0;
  }
}

/*----------------------------------
//  boot-
-----------------------------------*/

BOOL ReadBootSec(HANDLE hDrive, FAT *Sec)
{
  LPVOID Mem;
  BOOL b;

  Sec->RetCode=CHK_RD;
  Mem=VirtualAlloc(NULL,Sec->Boot.wSectSize,MEM_COMMIT,PAGE_READWRITE);
  if(!Mem)
    return FALSE;
  b=AllReadFile(hDrive,0,1,Mem,Sec);
  if(!b)
  {
    VirtualFree(Mem,0,MEM_RELEASE);
    return FALSE;
  }

  CopyMemory(&Sec->Boot,Mem, sizeof (BOOT_SEC));
  VirtualFree(Mem,0,MEM_RELEASE);

  Sec->StartFatOff=Sec->Boot.wResSects;
  Sec->SizeFat=Sec->Boot.wFatSects;
  Sec->SizeFatAll=Sec->Boot.bFatCnt*Sec->SizeFat;
  Sec->StartDirOff=Sec->StartFatOff+Sec->SizeFatAll;
  Sec->SizeRootDir=Sec->Boot.wRootEntries*32;
  Sec->SizeRootDir=Sec->SizeRootDir/Sec->Boot.wSectSize+
         ((Sec->SizeRootDir%Sec->Boot.wSectSize)?1:0);
  Sec->StartDataOff=Sec->StartDirOff+Sec->SizeRootDir;

  Sec->CountClast=(Sec->Boot.wTotSects-Sec->StartDataOff)/Sec->Boot.bClustSects;
  Sec->TypeFat=(Sec->Boot.wTotSects<4086)? TRUE:FALSE;

  Sec->MemFat=VirtualAlloc(NULL,Sec->SizeFatAll * Sec->Boot.wSectSize,
                           MEM_COMMIT,PAGE_READWRITE);

  if(!Sec->MemFat)
    return FALSE;

  Sec->MemRootDir=VirtualAlloc(NULL,Sec->SizeRootDir * Sec->Boot.wSectSize,
                  MEM_COMMIT,PAGE_READWRITE);

  if(!Sec->MemRootDir)
    return FALSE;

  Sec->MemDir=VirtualAlloc(NULL,Sec->Boot.bClustSects * Sec->Boot.wSectSize,
                  MEM_COMMIT,PAGE_READWRITE);

  if(!Sec->MemDir)
    return FALSE;


  b=AllReadFile(hDrive,Sec->StartFatOff,Sec->SizeFatAll,
                Sec->MemFat,Sec);
  if(!b)
    return FALSE;

  b=AllReadFile(hDrive,Sec->StartDirOff,Sec->SizeRootDir,Sec->MemRootDir,Sec);
  if(!b)
    return FALSE;

  Sec->RetCode=CHK_SUC;
  return TRUE;
}

/*----------------------------------
//    FAT
-----------------------------------*/
WORD GetFatElem(FAT *Fat, WORD Number)
{
  WORD n;
  BYTE *l;
  if(Number==0)
    return Number;
  if(Fat->TypeFat) //12 bit
  {
    n=(((DWORD)Number)*3)/2;
    l=(BYTE*)((BYTE*)(Fat->MemFat)+n);
    n=*(WORD*)l;
    if(Number%2)
      n=(n>>4);
    else
      n=n & 0xfff;
  }
  else //16 
    n=*((WORD*)(Fat->MemFat)+Number);
  return n;
}

/*----------------------------------
//   FAT
-----------------------------------*/
void SetFatElem(FAT *Fat, WORD Number, WORD Data)
{
  WORD n,*m;
  BYTE *l;
  int i;
  if(Fat->TypeFat) //12 bit
  {
    n=(((DWORD)Number)*3)/2;
    for(i=0; i<Fat->Boot.bFatCnt; i++)
    {
      l=(BYTE*)(((BYTE*)Fat->MemFat)+(Fat->SizeFat*Fat->Boot.wSectSize*i));
      m=(WORD*)(l+n);
      if(Number%2)
        *m=(*m & 0xf) | ((Data <<4) & 0xfff0);
      else
        *m=(*m & 0xf000) | (Data & 0xfff);
    }
  }
  else //16 
  {
    for(i=0; i<Fat->Boot.bFatCnt; i++)
    {
      m=(WORD*)(((BYTE*)Fat->MemFat)+(Fat->SizeFat*Fat->Boot.wSectSize*i));
      m=m+Number;
      *m=Data;
    }
  }
}

/*----------------------------------
//  FAT  
-----------------------------------*/
BOOL WriteFat(HANDLE hDrive, FAT *Sec)
{
  BOOL b;

  Sec->RetCode=CHK_WR;
  b=AllWriteFile(hDrive,Sec->StartFatOff,Sec->SizeFatAll,Sec->MemFat,Sec);
  if(!b)
    return FALSE;
  Sec->RetCode=CHK_SUC;
  return TRUE;
}

/*----------------------------------
//     /
//  __    - ()
//  -   NClaster
-----------------------------------*/
BOOL _GetFirstNumberClaster(HANDLE hDrive, FAT *Fat, BOOL bRoot,
                            char *Name, WORD *NClaster)
{
  char *Slash, *Point=0;
  char N[8],E[3];
//  DIR_ENTRY *Dir;
  DWORD i;
  BOOL b=FALSE;
  WORD Ncl;
  DWORD n;
  DWORD Pos;
  DIR_ENTRY *Dir;

  WORD  NumberEntries;

  Slash=Name;

  Fat->RetCode=CHK_RD;
  while(*Slash!='\0')
  {
    if(*Slash=='\\')
    {
      *Slash='\0';
      Slash++;
      break;
    }
    if(*Slash=='.')
    {
      *Slash='\0';
      Point=Slash+1;
    }
    Slash++;
  }

  FillMemory(N,8,' ');
  FillMemory(E,3,' ');
  CopyMemory(N,Name,lstrlen(Name));
  if(Point)
    CopyMemory(E,Point,lstrlen(Point));


  if(bRoot) // 
  {
    NumberEntries=Fat->Boot.wRootEntries;
    Dir=(DIR_ENTRY*)Fat->MemRootDir;
  }
  else
  {
    NumberEntries=(Fat->Boot.bClustSects*Fat->Boot.wSectSize)/sizeof(DIR_ENTRY);
    Dir=(DIR_ENTRY*)Fat->MemDir;
  }

  Fat->IsRoot=bRoot;


  for(i=0; i<NumberEntries; i++)
  {
    if(CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
                   N,8,Dir[i].Name,8)!=2)
      continue;
    if(CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
                   E,3,Dir[i].Ext,3)!=2)
      continue;
    if(Dir[i].Attr & 0x8) //  
      continue;
    b=TRUE;
    Fat->DirNum=i;
    break;
  }
  if(!b)
    return FALSE;
  if(Dir[i].Attr & 0x10) //directory
  {
    if(*Slash=='\0') //    - 
    {
      *NClaster=Dir[i].StClast;
      Fat->RetCode=CHK_SUC;
      return TRUE;
    }
    //-------  
    Ncl=Dir[i].StClast;
    n=Fat->Boot.bClustSects;//Fat->Boot.wSectSize;
    do
    {
      Fat->NumDirCl=Ncl;
      Pos=Fat->StartDataOff+(Ncl-2)*n;
      b=AllReadFile(hDrive,Pos,n,Fat->MemDir,Fat);
      if(!b)
        return FALSE;
      if(_GetFirstNumberClaster(hDrive,Fat,FALSE,Slash,NClaster))
      {
        Fat->RetCode=CHK_SUC;
        return TRUE;
      }
    }
    while(!CheckEof(Fat,(Ncl=GetFatElem(Fat,Ncl))));
  }
  else //file
  {
    *NClaster=Dir[i].StClast;
    Fat->RetCode=CHK_SUC;
    return TRUE;
  }
  return FALSE;
}

/*----------------------------------
//     /
//  __    - ()
//  -   NClaster
-----------------------------------*/
BOOL GetFirstNumberClaster(HANDLE hDrive, FAT *Fat, char *Name, WORD *NClaster)
{
  Fat->RetCode=CHK_RD;

  while(*Name != '\0')
  {
    if(*Name=='\\')
      return _GetFirstNumberClaster(hDrive,Fat,true,++Name,NClaster);
    Name++;                                    //root
  }
  return FALSE;
}

/*----------------------------------
//    
-----------------------------------*/
BOOL CheckEof(FAT *Fat, unsigned nCl)
{
  BOOL ret=FALSE;
  if(Fat->TypeFat)
  {
    if(nCl>=0xff8 && nCl<=0xfff)
      ret=TRUE;
  }
  else
  {
    if(nCl>=0xfff8 && nCl<=0xffff)
      ret=TRUE;
  }
  return ret;
}

/*----------------------------------
//    
-----------------------------------*/
WORD GetNumberClaster(FAT *Fat, WORD StCl, DWORD Offset)
{
  int i;
  WORD Res;
  int ClastSize;
  if(StCl==0)
    return 0;
  ClastSize=Fat->Boot.wSectSize*Fat->Boot.bClustSects;
  Res=StCl;
  Offset=Offset/ClastSize + ((Offset%ClastSize)?1:0);
//=====
  for(i=0; i<Offset; i++)
  {
     Res=GetFatElem(Fat,Res);
     if(CheckEof(Fat, Res) || Res==0)
     {
       Res=FATEOF;
       break;
     }
  }
  return Res;
}


/*----------------------------------
//     
-----------------------------------*/
WORD GetLastNumberClaster(FAT *Fat, WORD Claster)
{
  WORD Res;
  if(Claster==0)
    return 0; // 
  Res=GetFatElem(Fat,Claster);
  if(CheckEof(Fat, Res) || Res==0)
    return Claster;
  for(;;)
  {
    Claster=Res;
    Res=GetFatElem(Fat,Claster);
    if(CheckEof(Fat, Res) || Res==0)
      break;
  }
  return Claster;
}

/*----------------------------------
//     
-----------------------------------*/
BOOL VerifyBad(HANDLE hDrive, FAT *Fat, WORD StCl, InfoCopy *InfoFile)
{
  unsigned All;
  unsigned cVerClast;
  unsigned ClastSize;
  unsigned j,k,l,n;
//  BOOL UpdFat=FALSE;
  DWORD Pos,s;//,Res;
  bool fl=false;
  BYTE *WrtBuf;
  DIR_ENTRY *Dir;


  ClastSize=Fat->Boot.wSectSize * Fat->Boot.bClustSects;
  All=Fat->CountClast;
  WrtBuf=(BYTE*)InfoFile->buffer;  // 

  cVerClast=InfoFile->lenr/ClastSize + ((InfoFile->lenr%ClastSize)?1:0);

  Fat->CountBad=0;

//==========
  j=0;
  if(StCl==0) //     DIR
  {
    StCl=2;
    fl=true;
  }

  n=StCl;

  Dir=(Fat->IsRoot) ? ((DIR_ENTRY*)Fat->MemRootDir) : ((DIR_ENTRY*)Fat->MemDir);
  Dir=&Dir[Fat->DirNum];

  for(l=0; l<All; l++)
  {
    if(CheckRestoreBreak())
      return FALSE;

    k=((unsigned)StCl-2+l)%All+2;

    if(GetFatElem(Fat,k)!=0)
        continue;

    Pos=Fat->StartDataOff+(k-2)*Fat->Boot.bClustSects;

    if(AllReadFile(hDrive,Pos,Fat->Boot.bClustSects,InfoFile->rbuffer,Fat) &&
       AllWriteFile(hDrive,Pos,Fat->Boot.bClustSects,WrtBuf,Fat))
    {
      if(fl) //    DIR
      {
        Dir->StClast=k;
        fl=false;  
      }
      else
      {
        SetFatElem(Fat,n,k);
      }
      WrtBuf += ClastSize;
      j++;
      n=k;
    }
    else
    {
      SetFatElem(Fat,k,FATBAD);
      Fat->CountBad++;
    }

    UpdateFat(F_VerClast,F_VerBad,j+Fat->CountBad,Fat->CountBad);
    if(j>=cVerClast)
      break;
  }

//   FAT  DIR
  UpdateFat(F_Wait,F_UpdateFat,0,0);
  if(j>0)  // DIR
  {
    SetFatElem(Fat,n,FATEOF);
    s=j*ClastSize;
    Dir->Fsize += s;
    if(s<InfoFile->lenr)
    {
      _llseek(InfoFile->hSrc,InfoFile->SrcPosBefore+s,FILE_BEGIN);
      InfoFile->lenr=s;
      InfoFile->len=s;
    }
    if(Fat->IsRoot) //
    {
      n=Fat->Boot.wSectSize / sizeof(DIR_ENTRY); //- DIR  
      l=Fat->DirNum/n;  //   root
      WrtBuf=(BYTE*)Fat->MemRootDir;
      WrtBuf += l*Fat->Boot.wSectSize;
      Pos=Fat->StartDirOff+l;
      if(!AllWriteFile(hDrive,Pos,1,WrtBuf,Fat))
        return FALSE;
    }
    else
    {
      Pos=Fat->StartDataOff+(Fat->NumDirCl-2)*Fat->Boot.bClustSects;
      if(!AllWriteFile(hDrive,Pos,Fat->Boot.bClustSects,Fat->MemDir,Fat))
        return FALSE;
    }
  }
// FAT
  if(j>0 || Fat->CountBad>0) //    
    if(!WriteFat(hDrive,Fat))
      return FALSE;

  InfoFile->BadSize=Fat->CountBad*ClastSize;

  Fat->RetCode=CHK_SUC;
  return TRUE; 
}

/*----------------------------------
//      
//  0   
-----------------------------------*/
int GetCharDrive(char *fname)
{
  while(*fname!='\0')
  {
    if(*fname==':')
      return (int)(*--fname);
    fname++;
  }
  return 0;
}

/*----------------------------------
 FreeAll -     
-----------------------------------*/
BOOL FreeAll(HANDLE h, FAT *Fat)
{
  BOOL a1,a2,a3;
  FreeMemFAT(Fat);
  a2=UnlockVolume(h);
  a1=DismountVolume(h);
  a3=CloseHandle(h);
  return (a1 && a2 && a3);
}


/*----------------------------------
//    
// Size -    ,   
// CheckSize -   
// SubSize -   
-----------------------------------*/
BOOL CheckBadClaster(InfoCopy *InfoFile)
{
  char buf[MAX_PATH];
  char Dst[MAX_PATH];
  WORD d;
  HANDLE h;
  FAT Fat;
  BOOL b=FALSE;
  int Drive; 
     
  ZeroMemory(&Fat,sizeof (FAT));
  Fat.Boot.wSectSize=InfoFile->sizeclust;  //   
  Fat.MemWrite=InfoFile->buffer;
  Fat.MemRead=InfoFile->rbuffer;

  GetShortPathName(GetDstPathFile(Dst,InfoFile),buf,MAX_PATH);
  InfoFile->BadSize=0;

  if((Drive=GetCharDrive(buf))==0)
    return FALSE;
  //   

  SRScreen(InfoFile,true);
  UpdateFat(F_Wait,F_CloseFile,0,0);
  if(SetFilePointer(InfoFile->h,InfoFile->DstPosBefore,0,FILE_BEGIN)==0xFFFFFFFF)
    goto end;
  if(!SetEndOfFile(InfoFile->h))
    goto end;
  if(!CloseHandle(InfoFile->h))
    goto end;
  InfoFile->h=0;
  if(CheckRestoreBreak())
    goto end;

//1---------
  UpdateFat(F_Wait,F_MountDrive,0,0);
  for(;;)
  {
    h=OpenVolume(Drive);
    if(h==INVALID_HANDLE_VALUE)
    {
      if(Message("ebb",M_B_Continue,M_B_Exit)==1)
        goto end;
    }
    else
      break;
  }
  if(ReadBootSec(h,&Fat) &&
     GetFirstNumberClaster(h,&Fat,buf,&d))
  {
    if(CheckRestoreBreak()) //  ESC 
    {
      FreeAll(h,&Fat);
      goto end;
    }
    
    d=GetLastNumberClaster(&Fat,d); //     0

    if(!VerifyBad(h,&Fat,d,InfoFile))
    {
      FreeAll(h,&Fat);
      goto end;
    }
  }
  if(!FreeAll(h,&Fat))
    goto end;

  InfoFile->bOpenExist=true;
  if(!CheckCreateDest(InfoFile))
  {
    InfoFile->bOpenExist=false;
    goto end;
  }
  InfoFile->bOpenExist=false;
  if(SetFilePointer(InfoFile->h,0,0,FILE_END)==0xFFFFFFFF) // 
    goto end;

  b=TRUE;

end:  
  SRScreen(InfoFile,false);
  return b;
}

//===============================
//   
BOOL CheckRestoreBreak(void)
{
  int ret;
  if(CheckForEsc())
  {
    ret=Message("sbb",F_Break,F_No,F_Yes);
    if(ret==1)
      return TRUE;
  }
  return FALSE;
}

//=================================
BOOL NReadFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat)
{
  DWORD Res;
  DWORD Size;

  Size=Fat->Boot.wSectSize * CntSec;
  if(SetFilePointer(hDrive,StSec * Fat->Boot.wSectSize,0,FILE_BEGIN)!=0xFFFFFFFF)
    if(ReadFile(hDrive,Buf,Size,&Res,0))
      if(Res==Size)
        return TRUE;
  return FALSE;
}
// - 
BOOL NWriteFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat)
{
  DWORD Res;
  DWORD Size;

  Size=Fat->Boot.wSectSize * CntSec;
  if(SetFilePointer(hDrive,StSec * Fat->Boot.wSectSize,0,FILE_BEGIN)!=0xFFFFFFFF)
    if(WriteFile(hDrive,Buf,Size,&Res,0))
      if(Res==Size)
        return TRUE;
  return FALSE;
}


//================================
// - 
BOOL AllReadFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat)
{
  if(System==PL_NT)
    return NReadFile(hDrive,StSec,CntSec,Buf,Fat);
  return WReadFile(hDrive, StSec,CntSec,Buf);
}
// - 
BOOL AllWriteFile(HANDLE hDrive, DWORD StSec, WORD CntSec, LPVOID Buf, FAT *Fat)
{
  if(System==PL_NT)
    return NWriteFile(hDrive,StSec,CntSec,Buf,Fat);
  return WWriteFile(hDrive,StSec,CntSec,Buf);
}



