#include <windows.h>
#include "plugin.hpp"
#include "backrest.h"
#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"
//======================
//  
bool GetRootDir(char *Dst, char *Src)
{
  char *p;
  int n;
  if((p=lstrrchr(Src,':'))==NULL)
     return false;
  n=p-Src+2;
  lstrcpyn(Dst,Src,n);
  lstrcat(Dst,"\\");
  return true;
}
//-------------
//,   - 
bool CheckRemovableDrive(char *dir)
{
  char root[NM];
  if(!GetRootDir(root,dir) ||
     GetDriveType(root)!=DRIVE_REMOVABLE)
     return false;
   return true;
}
//----------------
//   
bool CheckDrive(char *dir)
{
  char root[NM];
  if(GetRootDir(root,dir))
  {
    switch(GetDriveType(root))
    {
      case DRIVE_REMOVABLE:
      case DRIVE_FIXED:
      case DRIVE_REMOTE:
      case DRIVE_CDROM:
      case DRIVE_RAMDISK: return true;
    }
  }
  return false;
}
//----------------
//    
//sizeclust -    
long DriveFreeSpace(char *dir, int *sizeclust)
{
   unsigned long sec_clas, byte_sec, free_clas, all_clas;
   char root[NM];
   if(!GetRootDir(root,dir) ||
      !GetDiskFreeSpace(root, &sec_clas, &byte_sec, &free_clas, &all_clas))
     return -1;
   *sizeclust=(int)(byte_sec*sec_clas);
   return (byte_sec*sec_clas*free_clas);
}


