#include <windows.h>
#include "plugin.hpp"
#include "backrest.h"
#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"

//===============================
//     
void SizeDir(InfoCopy *InfoFile,char *SrcDir,char *Name)
{
  char buf[NM];
  char buf1[NM];
  HANDLE ff;
  WIN32_FIND_DATA Data;
  GetPathFile(buf,SrcDir,Name);

  lstrcpy(buf1,buf);
  lstrcat(buf1,"\\*.*");
  if((ff=FindFirstFile(buf1,&Data))!=INVALID_HANDLE_VALUE)
  {
     do
     {
       if(Data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
       {
         if(lstrcmp(Data.cFileName,".")==0 ||
            lstrcmp(Data.cFileName,"..")==0)
            continue;
         SizeDir(InfoFile,buf,Data.cFileName);
       }
       else
       {
         InfoFile->CountFiles++;
         InfoFile->CommonSize += Data.nFileSizeLow;
       }
     } while(FindNextFile(ff,&Data));
     FindClose(ff);
  }
}

//===============================
//      
bool GetNumberFiles(InfoCopy *InfoFile)
{
  PluginPanelItem *pl;

  InfoFile->CountFiles=0;
  InfoFile->CommonSize=0;

  if(InfoFile->ActP.ItemsNumber<=0 || InfoFile->ActP.SelectedItemsNumber<1)
    return false;

  for(int i=0; i<InfoFile->ActP.SelectedItemsNumber; i++)
  {
    pl=&InfoFile->ActP.SelectedItems[i];
    if(!(pl->FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
    {
      InfoFile->CommonSize+=pl->FindData.nFileSizeLow; 
      InfoFile->CountFiles++;
    }
    else
      SizeDir(InfoFile,InfoFile->SrcDir,pl->FindData.cFileName);
  }
  return true;
}

//=========================
//   
int ChoiceDlg(InfoCopy *InfoFile)
{
  int ret;
  int size;
  char buf[80];
  char buf1[20];

  wsprintf(buf,GetMsg(O_Dlg),InfoFile->CountFiles,Delimiter(buf1,InfoFile->CommonSize));
  size=lstrlen(buf);
  if(size<60) size=60;
  size += 4;
  struct FarDialogItem DialogItems []={
    {DI_DOUBLEBOX,3,1,size+5,6, 0,0,0,0},
    {DI_TEXT,5,2,0,0,           0,0,DIF_BOXCOLOR,0},
    {DI_EDIT,5,3,size+3,0,   TRUE,0,0,0},  
    {DI_TEXT,0,4,0,0,   0,0,DIF_BOXCOLOR|DIF_SEPARATOR,0},
    {DI_BUTTON,0,5,0,0, 0,0,DIF_CENTERGROUP,1},
    {DI_BUTTON,0,5,0,0, 0,0,DIF_CENTERGROUP,0}
  };

  lstrcpy(DialogItems[0].Data,GetMsg(M_BackRest));
  lstrcpy(DialogItems[1].Data,buf);
  lstrcpy(DialogItems[2].Data,InfoFile->DstDir);
  lstrcpy(DialogItems[4].Data,GetMsg(M_B_Continue));
  lstrcpy(DialogItems[5].Data,GetMsg(M_B_Exit));

  ret=Info.Dialog(Info.ModuleNumber,-1,-1,size+9,8,NULL,DialogItems,
      sizeof(DialogItems)/sizeof(DialogItems[0]));
  if(ret==4)
  {
    lstrcpy(InfoFile->DstDir,DialogItems[2].Data);
    return 1;
  }
  else
    return 0;
}

//============      FD
bool CheckFirstRemovableDrive(char *Drv)
{
  for(char i='A'; i<='Z'; i++)
  {
    Drv[0]=i;
    if(GetDriveType(Drv)==DRIVE_REMOVABLE)
      return true;
  }
  return false;
}

//=========================
int ChoiceCopy(InfoCopy *InfoFile)
{
  int ret;
  PanelInfo PasP;
  char Drv[4]="A:\\";
  if(!CheckFirstRemovableDrive(Drv))
  {
    Message("sb",M_NotDrive,M_B_Exit);
    return 0;
  }
  ret=GetPanelInfo(true,&InfoFile->ActP);
  if(!ret ||
      InfoFile->ActP.PanelType!=PTYPE_FILEPANEL ||
      InfoFile->ActP.Plugin)
    return -1; //
  lstrcpy(InfoFile->SrcDir,InfoFile->ActP.CurDir);
  if(!GetNumberFiles(InfoFile))
    return 0; // 
  ret=GetPanelInfo(false,&PasP);
  if(!ret || PasP.PanelType!=PTYPE_FILEPANEL || PasP.Plugin ||
     !CheckRemovableDrive(PasP.CurDir))
    lstrcpy(InfoFile->DstDir,Drv);
  else
    lstrcpy(InfoFile->DstDir,PasP.CurDir);

// 
  if((ret=ChoiceDlg(InfoFile))>0)
  {
    int n;
    lalltrim(InfoFile->DstDir);
    n=lstrlen(InfoFile->DstDir);
    if(n<=0)
    {
      Message("sb",M_NotPath,M_B_Exit);
      return 0;
    }
    if(!CheckRemovableDrive(InfoFile->DstDir))
      ret=-1;
    else
    {
      n--;
      if(InfoFile->DstDir[n]=='\\' && InfoFile->DstDir[n-1]!=':')
        InfoFile->DstDir[n]='\0';
    }
  }
  return ret;
}
