#include <windows.h>

#include "plugin.hpp"
#include "backrest.h"
#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"


//HKEY CreateRegKey(HKEY hRoot,char *Key);
//HKEY OpenRegKey(HKEY hRoot,char *Key);
//HKEY OpenFarRegKey(HKEY hRoot,char *Key);

void SetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_DWORD,(BYTE *)&ValueData,sizeof(ValueData));
  RegCloseKey(hKey);
}


int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type,Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    ValueData=Default;
    return(FALSE);
  }
  return(TRUE);
}


int GetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default)
{
  int ValueData;
  GetRegKey(hRoot,Key,ValueName,ValueData,Default);
  return(ValueData);
}


HKEY CreateRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  DWORD Disposition;
  char FullKeyName[512];
  lstrcpy(FullKeyName,PluginRootKey);
  if (*Key)
  {
    lstrcat(FullKeyName,"\\");
    lstrcat(FullKeyName,Key);
  }
  RegCreateKeyEx(hRoot,FullKeyName,0,NULL,0,KEY_WRITE,NULL,
                 &hKey,&Disposition);
  return(hKey);
}


HKEY OpenRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  char FullKeyName[512];
  lstrcpy(FullKeyName,PluginRootKey);
  if (*Key)
  {
    lstrcat(FullKeyName,"\\");
    lstrcat(FullKeyName,Key);
  }
  if (RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey)!=ERROR_SUCCESS)
    return(NULL);
  return(hKey);
}



//==============   㯠  ६ 

HKEY OpenFarRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  char FullKeyName[512];
  lstrcpy(FullKeyName,"Software\\Far");
  if (*Key)
  {
    lstrcat(FullKeyName,"\\");
    lstrcat(FullKeyName,Key);
  }
  if (RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey)!=ERROR_SUCCESS)
    return(NULL);
  return(hKey);
}

int GetFarRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default)
{
  HKEY hKey=OpenFarRegKey(hRoot,Key);
  DWORD Type,Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    ValueData=Default;
    return(FALSE);
  }
  return(TRUE);
}


int GetFarRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default)
{
  int ValueData;
  GetFarRegKey(hRoot,Key,ValueName,ValueData,Default);
  return(ValueData);
}
