#include <windows.h>

#include "plugin.hpp"
#include "backrest.h"
#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"

/*----------------------------------
// SYSTEMTIME  long
-----------------------------------*/
unsigned long TimeToLong(SYSTEMTIME *t)
{
  unsigned long ret;
  ret=(((((long)t->wHour)*60+t->wMinute)*60+t->wSecond)*1000+
       t->wMilliseconds);
  return ret;
}

/*----------------------------------
// long  SYSTEMTIME 
-----------------------------------*/
void LongToTime(unsigned long l, SYSTEMTIME *t)
{
  t->wMilliseconds=l%1000;
  l /= 1000;
  t->wSecond=l%60;
  l /= 60;
  t->wMinute=l%60;
  t->wHour=l/60;
}

/*----------------------------------
//    long 
-----------------------------------*/
unsigned long GetLocalTimeToLong(void)
{
  SYSTEMTIME t;
  GetLocalTime(&t);
  return TimeToLong(&t);
}

/*----------------------------------
//  - 
-----------------------------------*/
int GetNTorWin(void)
{
  OSVERSIONINFO Osv;
  Osv.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
  if(GetVersionEx(&Osv))
  {
    if(Osv.dwPlatformId==VER_PLATFORM_WIN32_NT)
      return PL_NT;
    if(Osv.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)
      return PL_WIN;
  }
  return 0;
}


//===========   
//      
char *linsstr(char *dst, char *src)
{
  char *p=dst;
  while(*src!='\0')
    *dst++=*src++;
  return p;
}

//===    
char *lstrrchr(char *str, char chr)
{
  char *p=str+lstrlen(str);
  while((--p)!=str)
    if(*p==chr)
      return p;
  if(*p==chr)
    return str;
  return NULL;
}
//===    
char *lstrchr(char *str, char chr)
{
  while(*str!='\0')
    if(*str==chr)
      return str;
    else
      str++;
  return NULL;
}
//===   
char *lrtrim(char *str)
{
  int n,i;
  n=lstrlen(str)-1;
  for(i=n; i>=0; i--)
    if(str[i]==' ')
      str[i]='\0';
    else
      break;
  return str;  
}

//===   
char *lltrim(char *str)
{
  int n,i;
  i=n=0;
  while(str[i]!='\0' && str[i]==' ')
    i++;
  while(str[i]!='\0')
    str[n++]=str[i++];
  str[n]='\0';
  return str;  
}

//====     
char *lalltrim(char *str)
{
  return lltrim(lrtrim(str));
}

//====      
char *lpadc(char *buf,char *src, char sym, int size)
{
  int n;
  int k;
  lstrcpy(buf,src);
  n=lstrlen(buf);
  if(n<size)
  {
    k=(size-n)/2;
    MoveMemory(buf+k,buf,n);
    FillMemory(buf,k,sym);
    FillMemory(buf+k+n,size-k-n,sym);
    buf[size]='\0';
  }
  return buf;
}

//=========     ( )======
char *Delimiter(char *buf, unsigned long number)
{
  unsigned long n,s;
  n=number/1000000;
  s=number%1000000;
  if(n>0)
  {
    wsprintf(buf,"%lu,%03.3lu,%03.3lu",n,s/1000,s%1000);
  }
  else
  {
    n=number/1000;
    if(n>0)
      wsprintf(buf,"%lu,%03.3lu",n,number%1000);
    else
      wsprintf(buf,"%lu",number);
  }
  return buf;
}

//===============================================================
//----------------
char* GetPathFile(char *buf,char *SrcDir,char *name)
{
  lstrcpy(buf,SrcDir);
  if(buf[lstrlen(SrcDir)-1]!='\\')
    lstrcat(buf,"\\");
  lstrcat(buf,name);
  return buf;
}

//=======================
BOOL CheckForKey(WORD vKey)
{
  INPUT_RECORD *InputRec;
  DWORD NumberOfEvents;
  DWORD ReadCnt,i;
  BOOL result = FALSE;
  HANDLE Console = GetStdHandle(STD_INPUT_HANDLE);

  if(GetNumberOfConsoleInputEvents(Console,&NumberOfEvents))
  {
    if((InputRec=(INPUT_RECORD *)GlobalAlloc(GPTR,
                             NumberOfEvents*sizeof(INPUT_RECORD))) != NULL)
    {
      if(PeekConsoleInput(Console,InputRec,NumberOfEvents,&ReadCnt))
        if(ReadCnt <= NumberOfEvents)
          for(i=0; i < NumberOfEvents; ++i)
          {
            if (InputRec[i].EventType == KEY_EVENT &&
                InputRec[i].Event.KeyEvent.bKeyDown &&
                InputRec[i].Event.KeyEvent.wVirtualKeyCode == vKey)
            {
              result=TRUE;
              if(i > 0)
                ReadConsoleInput(Console,InputRec,i,&ReadCnt);
              break;
            }
          }
      GlobalFree((HGLOBAL)InputRec);
    }
  }
  return result;
}

//=========================================
bool CheckForEsc(void)
{
  return CheckForKey(VK_ESCAPE);
}

//----------------------
//    "ssebbbb"    
// :
//s - char* or uint - 
//e -   -    
//b - char* or uint - 
int Message(char *format,...)
{
  va_list ap;
  unsigned int arg;
  char *Item[13];
  char *buf;
  int ret;
  char *p;
  int count;
  int c_b=0;
  bool flerr=false;
  int pos;
  bool beg_but=false;
  unsigned long l1,l2;

  Item[0]=GetMsg(M_E_Error);
  count=1;

  va_start(ap, format);

  while((arg = va_arg(ap,unsigned int)) != 0)
  {
    if(*format == 'e')
    {
      pos=count++; flerr=true; format++;
    }
    switch(*format)
    {
      case 's': if(arg>200) Item[count++]=(char *)arg;
                else Item[count++]=GetMsg(arg);
                break;
      case 'b': if(!beg_but) {beg_but=true; Item[count++]=Line;}
                if(arg>200) Item[count++]=(char *)arg;
                else Item[count++]=GetMsg(arg);
                c_b++;
                break;
      case '\0':format--;           
    }
    format++;
  }
  va_end(ap);

  if(flerr)
  {
    FormatMessage(
      FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
      NULL,
      GetLastError(),
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
      (LPTSTR)&buf,
      0,
      NULL);
    CharToOem(buf,buf);
    if((p=lstrrchr(buf,'\r'))!=0)
      *p='\0';
    Item[pos]=buf;
  }

  l1=GetLocalTimeToLong();

  ret=Info.Message(Info.ModuleNumber,
      FMSG_WARNING,
      0,
      Item,
      count,
      c_b);
  l2=GetLocalTimeToLong();
  pInfoFile->time_delta += l2-l1;

  if(flerr)
    LocalFree(buf);
  return ret;
}

//====================  
bool DirectoryExists(char *name)
{
  unsigned long ret;
  ret=GetFileAttributes(name);
  if(ret==0xFFFFFFFF || !(ret & FILE_ATTRIBUTE_DIRECTORY))
    return false;
  return true;
}
//=================== 
bool FileExists(char *name)
{
  unsigned long ret;
  ret=GetFileAttributes(name);
  if(ret!=0xFFFFFFFF && !(ret & FILE_ATTRIBUTE_DIRECTORY))
    return true;
  return false;
}
//==================     
bool ForceDir(InfoCopy *InfoFile)/*char *name)*/
{
  int i;
  char *p,*p1;
  unsigned long AttrDir;
  char TmpDir[NM];

  lstrcpy(TmpDir,InfoFile->DstDir);
  i=lstrlen(TmpDir);
  if(TmpDir[i-1]!='\\')
    lstrcat(TmpDir,"\\");

  if((p=lstrchr(TmpDir,':'))==NULL || *++p!='\\')
    return false;
  p++;
  i=0;
  while((p1=lstrchr(p,'\\'))!=NULL)
  {
    *p1='\0';
    AttrDir=GetFileAttributes(TmpDir);
    if(AttrDir==0xFFFFFFFF) // 
    {
      if(!CreateDirectory(TmpDir,NULL))
        return false;
      if(i<InfoFile->CountDirAttr) //  
      {
        if(!SetFileAttributes(TmpDir,InfoFile->AttribDir[i]))
          return false;
      }
      else
      {
        if((AttrDir=GetFileAttributes(TmpDir))==0xFFFFFFFF)
          return false;
        InfoFile->AttribDir[i]=AttrDir;
        InfoFile->CountDirAttr++;
      }
    }
    else
    {
       if(AttrDir & FILE_ATTRIBUTE_DIRECTORY) // 
       {
         if(i==InfoFile->CountDirAttr)
         {
           InfoFile->AttribDir[i]=AttrDir;
           InfoFile->CountDirAttr++;
         }
       }
       else
         return false; //  
    }
    i++;
    *p1='\\';
    p=p1+1;
  }
  return true;
}
//==================================
// 
char *MinimizeName(char *FileName, char *OutName, int MaxLen)
{
  char *p;
  int l=lstrlen(FileName);
  if(l<=MaxLen)
     lstrcpy(OutName,FileName);
  else
  {
     p=OutName;
    *p++=FileName[0];
    *p++=FileName[1];
    *p++=FileName[2];
    *p++='.';
    *p++='.';
    l=l-(MaxLen-5);
    lstrcpy(p,&FileName[l]);
  }
  return OutName;
}


//====================
char *GetMsg(int MsgId)
{
  return(Info.GetMsg(Info.ModuleNumber,MsgId));
}

//===============================
bool GetPanelInfo(bool Active, struct PanelInfo *Param)
{
  return (Info.Control(INVALID_HANDLE_VALUE,
          (Active)? FCTL_GETPANELINFO : FCTL_GETANOTHERPANELINFO,
          Param));
}

//===============================
bool RedrawPanels(InfoCopy *InfoFile)
{
  return (Info.Control(INVALID_HANDLE_VALUE,FCTL_SETSELECTION,&InfoFile->ActP) &&
          Info.Control(INVALID_HANDLE_VALUE,FCTL_REDRAWPANEL,NULL) &&
          Info.Control(INVALID_HANDLE_VALUE,FCTL_REDRAWANOTHERPANEL,NULL));
}


//====================================
char* SystemErrorMessage(void)
{
  static char buf[100];
  char *p;
  FormatMessage(
  FORMAT_MESSAGE_FROM_SYSTEM,
  NULL,
  GetLastError(),
  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
  (LPTSTR)buf,
  100,
  NULL);
  CharToOem(buf,buf);
  if((p=lstrrchr(buf,'\r'))!=0)
    *p='\0';
  return buf;
}
