#include <windows.h>
#include "plugin.hpp"
#include "backrest.h"

#include "common.h"
#include "cvfdreg.h"
#include "drive.h"
#include "disk.h"
#include "oper.h"
#include "FatSrv.h"
#include "brlang.cpp"


struct PluginStartupInfo Info;
char PluginRootKey[80];
char Line[]={'\1','\0'};
int System;
InfoCopy *pInfoFile;

//--------------
void WINAPI _export SetStartupInfo(struct PluginStartupInfo *SInfo)
{
  Info=*SInfo;
  lstrcpy(PluginRootKey,SInfo->RootKey);
  lstrcat(PluginRootKey,"\\TDN\\CopyVFD");
}
//-----------
void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  Info->StructSize=sizeof(struct PluginInfo);
  static char *PluginMenuStrings[1];
  PluginMenuStrings[0]=GetMsg(M_BackRest);
  Info->PluginMenuStrings=PluginMenuStrings;
  Info->PluginConfigStrings=PluginMenuStrings;
  Info->PluginMenuStringsNumber=1;
  Info->PluginConfigStringsNumber=1;
  Info->PluginMenuStringsNumber=sizeof(PluginMenuStrings)/sizeof(PluginMenuStrings[0]);
}

//-----------------------------
HANDLE WINAPI _export OpenPlugin(int OpenFrom,int Item)
{
  InfoCopy InfoFile;
  char Title[MAX_PATH];
  int ret;
  if(OpenFrom!=OPEN_PLUGINSMENU) return INVALID_HANDLE_VALUE;
  ZeroMemory(&InfoFile, sizeof(InfoCopy));
  pInfoFile=&InfoFile;

//Check type of disks in panels
  if((ret=ChoiceCopy(&InfoFile))<=0)
  {
    if(ret<0)
      Message("sb",M_Not,M_B_Exit);
    return INVALID_HANDLE_VALUE;
  }
  if(lstrcmpi(InfoFile.DstDir,InfoFile.SrcDir)==0)
    Message("sb",M_IdentDir,M_B_Exit);
  else
  {
    GetAllRegKey(&InfoFile); //    
    if((InfoFile.buffer=VirtualAlloc(0,InfoFile.sizebuf,MEM_COMMIT,PAGE_READWRITE))==0 ||
       (InfoFile.rbuffer=VirtualAlloc(0,InfoFile.sizebuf,MEM_COMMIT,PAGE_READWRITE))==0)
    {
      Message("eb",M_B_Exit);
      if(InfoFile.buffer!=0)
        VirtualFree(InfoFile.buffer,0,MEM_RELEASE);
      if(InfoFile.rbuffer!=0)
        VirtualFree(InfoFile.rbuffer,0,MEM_RELEASE);
    }
    else
    {
      System=GetNTorWin();
      GetConsoleTitle(Title,MAX_PATH);
      InfoFile.CountSize=0;
      InfoFile.hScreen=Info.SaveScreen(0,0,-1,-1);

      InfoFile.time_start=GetLocalTimeToLong(); // 

      CopyAll(&InfoFile);

      Info.RestoreScreen(InfoFile.hScreen);
      VirtualFree(InfoFile.buffer,0,MEM_RELEASE);
      VirtualFree(InfoFile.rbuffer,0,MEM_RELEASE);
      SetConsoleTitle(Title);
    }
    RedrawPanels(&InfoFile);
  }
  return INVALID_HANDLE_VALUE;
}


//----------------------------
int WINAPI _export Configure(int ItemNumber)
{
  return Config();
}
