{$I-}
{$V-}
{$M 4096,65534,65534}

program copygrp;

uses dos, strings;

const
  bufferlength      = 65534; {this is the largest possible}
  headerlength      = 22;

label nextitem;

type
  TBuffer = array[0..bufferlength] of byte;
  TTag = record
    ID   : Word;
    item : Word;
    size : Word;
    path : array[0..255] of char;
  end;

const
  PathID = $8101;

var
  thisparam                                     : string;
  dir                                           : dirstr;
  name                                          : namestr;
  extn                                          : extstr;
  i, itemnum, filelength, cbgroup, attrib       : word;
  param, numitems, tagsectionoffset, tagoffset  : word;
  checksum                                      : longint;
  srcfile,dstfile,prgfile                       : file;
  srcfilename,dstfilename,prgfilename           : pathstr;
  dstexists, nocheck, verbose                   : boolean;
  buffer                                        : ^TBuffer;
  wordptr, itemoffsetptr                        : ^word;
  tagptr                                        : ^TTag;

procedure exit_with_message(code:word; message:string);
begin
  writeln(message);
  halt(code);
end;

procedure syntaxerror;
begin
  writeln('COPYGRP: Copies information between group files - v2.2, 21 January 1997.');
  writeln('  (C) Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
  writeln;
  exit_with_message(255,
    'SYNTAX: COPYGRP <source file> <destination file/directory> [/VRB] [/NCHK]');
end;

begin
  new(buffer);
  if buffer=nil then exit_with_message(10,'Not enough memory for buffer.');

  if (paramcount < 2) then syntaxerror;

  srcfilename := paramstr(1);
  dstfilename := paramstr(2);
  for param := 3 to paramcount do begin
    thisparam := paramstr(param);
    for i := 1 to length(thisparam) do thisparam[i] := upcase(thisparam[i]);
    if thisparam = '/VRB' then
      verbose := true
    else if thisparam = '/NCHK' then
      nocheck := true
    else syntaxerror;
  end;

  assign(dstfile, dstfilename);
  getfattr(dstfile, attrib);
  if (attrib and Directory) <> 0 then {destination is directory, so} begin
    fsplit(srcfilename, dir, name, extn);
    dstfilename := dstfilename + '\' + name + extn;
    assign(dstfile, dstfilename);
  end;

  filemode := 0;
  reset(dstfile, 1);
  dstexists := (IOResult=0);

  assign(srcfile, srcfilename);
  reset(srcfile, 1);
  if IOresult <> 0 then
    exit_with_message(9, 'Can''t open file '+srcfilename+'.');

  blockread(srcfile, buffer^, bufferlength, filelength);
  if filelength < headerlength then
    exit_with_message(8, 'Can''t read header from file '+srcfilename+'.');

  if (buffer^[0]<>80)or(buffer^[1]<>77)or(buffer^[2]<>67)or(buffer^[3]<>67) then
    exit_with_message(7, srcfilename+' is not a group file.');
  if not eof(srcfile) then
    exit_with_message(6, 'Can''t process file '+srcfilename+' (too long).');

  if dstexists then begin
    { Copy its header over the source file header. }
    wordptr := @buffer^[6];
    cbgroup := wordptr^;
    blockread(dstfile, buffer^, headerlength);
    if (IOResult=0) and (buffer^[0]=80) and (buffer^[1]=77)
      and (buffer^[2]=67) and (buffer^[3]=67) then
        wordptr^ := cbgroup
    else begin
      writeln(dstfilename+' was not a valid group file.');
      { Reread the source file's header. }
      seek(srcfile,0);
      blockread(srcfile, buffer^, headerlength);
      if IOResult<>0 then exit_with_message(5,'Can''t reread '+srcfilename);
    end;
  end;

  if not nocheck then begin

    tagsectionoffset := cbgroup + 10;

    if (tagsectionoffset < filelength-6)
    and (buffer^[tagsectionoffset-5] = 0)
    and (buffer^[tagsectionoffset-4] = 80)
    and (buffer^[tagsectionoffset-3] = 77)
    and (buffer^[tagsectionoffset-2] = 67)
    and (buffer^[tagsectionoffset-1] = 67) then begin
      wordptr := @buffer^[32];
      numitems := wordptr^;
      for itemnum := 0 to numitems-1 {ie. for each item} do begin
        itemoffsetptr := @buffer^[34+2*itemnum];
        if itemoffsetptr^ > 0 {ie. if item is not nil} then begin
          wordptr := @buffer^[itemoffsetptr^+20];
          prgfilename := strpas(@buffer^[wordptr^]);
          delete(prgfilename,pos(' ',prgfilename),255) {remove after space};
          fsplit(prgfilename,dir,name,extn) {extract path components};
          if verbose then write(name+extn);
          if extn<>'' then begin
            tagoffset := tagsectionoffset;
            while tagoffset < filelength do begin
              tagptr := @buffer^[tagoffset];
              if tagptr^.size = 0 then goto nextitem;
              if (tagptr^.ID <> PathID) or (tagptr^.item <> itemnum) then
                tagoffset := tagoffset + tagptr^.size
              else begin
                prgfilename := strpas(tagptr^.path) + name + extn;
                assign(prgfile,prgfilename);
                getfattr(prgfile,attrib);
                if DosError<>0 then begin
                  itemoffsetptr^ := 0;
                  tagptr^.item := $FFFF;
                  if verbose then write(' not');
                end;
                if verbose then write(' found in '+strpas(tagptr^.path));
                goto nextitem;
              end;
            end;
          end;
        nextitem:
          if verbose then writeln;
        end;
      end;
    end;
  end;

  { Set the checksum. }
  buffer^[4] := 0;
  buffer^[5] := 0;
  checksum := 0;
  buffer^[filelength] := 0;
  for i := 0 to (filelength-1) div 2 do begin
    wordptr := @buffer^[2*i];
    checksum := checksum - wordptr^;
  end;
  wordptr := @buffer^[4];
  wordptr^ := checksum;

  { Write the output file.}
  rewrite(dstfile,1);
  blockwrite(dstfile, buffer^, filelength);
  if IOResult <> 0 then
    exit_with_message(3, 'Can''t write to file '+dstfilename+'.');

  close(srcfile);
  if IOResult<>0 then
    exit_with_message(2, 'Can''t close file '+srcfilename+'.');

  close(dstfile);
  if IOResult<>0 then
    exit_with_message(1, 'Can''t close file '+dstfilename+'.');

  exit_with_message(0, srcfilename+' copied to '+dstfilename+'.');

end.

