#include "stdafx.h"
#include "common.hpp"
#include "lng.hpp"

extern HANDLE hHeap;
extern struct PluginStartupInfo Info;

#ifdef FROM_CMD
void * __cdecl realloc(void *block, size_t size)
{
  if (block)
    return HeapReAlloc(hHeap,HEAP_ZERO_MEMORY,block,size);
  else
    return HeapAlloc(hHeap,HEAP_ZERO_MEMORY, size);
}

void __cdecl free(void *block)
{
  HeapFree(hHeap, 0, block);
}

void _pure_error_ () {};
#endif

const char *GetMsg(int MsgId)
{
  return (Info.GetMsg(Info.ModuleNumber, MsgId));
}

void InitDialogItems(const struct InitDialogItem *Init, struct FarDialogItem *Item, int ItemsNumber)
{
  const struct InitDialogItem *PInit = Init;
  struct FarDialogItem *PItem = Item;
  for (int i = 0; i < ItemsNumber; i++, PItem++, PInit++) {
    PItem->Type = PInit->Type;
    PItem->X1 = PInit->X1;
    PItem->Y1 = PInit->Y1;
    PItem->X2 = PInit->X2;
    PItem->Y2 = PInit->Y2;
    PItem->Focus = 0;
    PItem->Selected = 0;
    PItem->Flags = PInit->Flags;
    PItem->DefaultButton = 0;
    lstrcpy(PItem->Data,PInit->Data != -1 ? GetMsg(PInit->Data) : "");
  }
}
