#include "stdafx.h"

#include "lng.hpp"
#include "common.hpp"

char iniFileName[MAX_PATH];

HANDLE hHeap;
BYTE AllAttr[256], AllColors[256], PrevAllColors[256], CurrAllColors[256];
int AllColorsCount, LBoxColorsPos;
WORD SavedColors[1];
struct PluginStartupInfo Info;
struct ColorGroupItem ColorsGroups[GrpCnt];
static struct FarDialogItem DialogItems[ILast];
ColorGroupItem *CurrentColorGroup;

void DefineMyColors(void);
static int ShowMessage(unsigned int Flags, const char *HelpTopic, int MsgID);
static void SetCaption(HANDLE hDlg, char *ThemeName);
static void ListBoxPosUpdate(HANDLE hDlg, int Method);
static BOOL ProcessControlKey(COORD *coord, long Key, int MaxX, int MaxY);

void DefineMyColors(void)
{
  AllColors[AllColorsCount + 0] = AllColors[COL_PANELTEXT] | 0x0f;
  AllColors[AllColorsCount + 1] = AllColors[COL_PANELTEXT];
  AllColors[AllColorsCount + 2] = AllColors[COL_DIALOGBOX] >> 4;
  AllColors[AllColorsCount + 10] = 0x0f;
  SavedColors[0] = AllColors[COL_DIALOGTEXT];
}

static int ShowMessage(unsigned int Flags, const char *HelpTopic, int MsgID)
{
  const char *MsgItems[] = {GetMsg(MTitle), GetMsg(MsgID)};
  return Info.Message(Info.ModuleNumber, Flags, HelpTopic,
    MsgItems, sizeof(MsgItems) / sizeof(MsgItems[0]), 1);
}

static void SetCaption(HANDLE hDlg, char *ThemeName)
{
  BOOL bCurrModified = FALSE, bPrevModified = FALSE, bFARModified = FALSE;
  BYTE FARAllColors[256];
  Info.AdvControl(Info.ModuleNumber, ACTL_GETARRAYCOLOR, FARAllColors);
  for (int i = 0; i < AllColorsCount; i++) {
    bPrevModified |= (PrevAllColors[i] != AllColors[i]);
    bCurrModified |= (CurrAllColors[i] != AllColors[i]);
    bFARModified |= (FARAllColors[i] != AllColors[i]);
  }

  char Buffer[1024];
  lstrcpy(Buffer, GetMsg(MColors));
  lstrcat(Buffer, ": ");
  lstrcat(Buffer, ThemeName);

  if (bCurrModified) lstrcat(Buffer, " (*)");

  if (bFARModified) DialogItems[IApply].Flags &= ~DIF_DISABLE;
  else DialogItems[IApply].Flags |= DIF_DISABLE;

  if (bPrevModified) DialogItems[IRestore].Flags &= ~DIF_DISABLE;
  else DialogItems[IRestore].Flags |= DIF_DISABLE;

  Info.SendDlgMessage(hDlg, DM_SETDLGITEM, IApply, (long)&DialogItems[IApply]);
  Info.SendDlgMessage(hDlg, DM_SETDLGITEM, IRestore, (long)&DialogItems[IRestore]);

  struct FarDialogItemData Item;
  Item.PtrLength = lstrlen(Buffer);
  Item.PtrData = Buffer;
  Info.SendDlgMessage(hDlg, DM_SETTEXT, IExampleBox, (long)&Item);
}

static void ListBoxPosUpdate(HANDLE hDlg, int Method)
{
  int Pos = Info.SendDlgMessage(hDlg, DM_LISTGETCURPOS, IGroupsList, NULL);
  if (Method == 1 || Pos >= 0 && Pos != LBoxColorsPos) {
    LBoxColorsPos = Pos;
    CurrentColorGroup = &ColorsGroups[Pos];
    Info.SendDlgMessage(hDlg, DN_DRAWDLGITEM, IExampleCtl, 0);

    MOUSE_EVENT_RECORD m_record;
    m_record.dwMousePosition.X = 0;
    m_record.dwMousePosition.Y = 0;
    Info.SendDlgMessage(hDlg, DN_MOUSECLICK, IExampleCtl, (long)&m_record);
    Info.SendDlgMessage(hDlg, DM_REDRAW, 0, 0);
  }
}

static BOOL ProcessControlKey(COORD *coord, long Key, int MaxX, int MaxY)
{
  static const signed char dx[8] = {0, 0, 1, -1, -127, 127, 0, 0};
  static const signed char dy[8] = {1, -1, 0, 0, 0, 0, -127, 127};
  static const WORD ExampleKeys[8] = {
    KEY_DOWN, KEY_UP, KEY_RIGHT, KEY_LEFT,
    KEY_HOME, KEY_END, KEY_PGUP, KEY_PGDN,
  };

  for (int i = 0; i < 8; i++) {
    if (Key == ExampleKeys[i]) {
      coord->X += dx[i];
      if (coord->X < 0) coord->X = 0;
      if (coord->X > MaxX - 1) coord->X = MaxX - 1;

      coord->Y += dy[i];
      if (coord->Y < 0) coord->Y = 0;
      if (coord->Y > MaxY - 1) coord->Y = MaxY - 1;
      return TRUE;
    }
  }
  return FALSE;
}

long WINAPI DlgProc(HANDLE hDlg, int Msg,int Param1,long Param2)
{
  static COORD ExampleCoord;
  static BYTE ExampleAttr;
  static char szThemeName[32];

  static int LastSelectedTheme = 0;
  static int PrevFocused;
  static int bLBoxPosChanged;
  static int clForeground, clBackground;

  MOUSE_EVENT_RECORD m_record;
  long FocusedControl;
  int i, j, k;
  COORD coord;
  WORD Attr;

  //    
  FocusedControl = Info.SendDlgMessage(hDlg, DM_GETFOCUS, 0, 0);

  //      ,      
  ListBoxPosUpdate(hDlg, 0);

  switch (Msg) {
    case DN_CTLCOLORDLGITEM:
      if (Param1 == IBlackBox)
        return 0;
      break;

    case DN_INITDIALOG:
      //    
      Info.SendDlgMessage(hDlg, DM_SETCURSORSIZE, IExampleCtl, MAKELONG(1, 99));
      Info.SendDlgMessage(hDlg, DM_SETCURSORSIZE, IFColorCtl, MAKELONG(1, 8));
      Info.SendDlgMessage(hDlg, DM_SETCURSORSIZE, IBColorCtl, MAKELONG(1, 8));
      //     .lng
      for (i = 0; i < GrpCnt; i++)
        Info.SendDlgMessage(hDlg, DM_LISTADDSTR, IGroupsList, (long)GetMsg(MGroupColors00 + i));
      //   " "   
      lstrcpy(szThemeName, GetMsg(MMyFavoriteScheme));
      SetCaption(hDlg, szThemeName);
      ListBoxPosUpdate(hDlg, 1);
      return FALSE;

    case DN_KILLFOCUS:
      if (FocusedControl == IGroupsList || FocusedControl == IFColorCtl || FocusedControl == IBColorCtl)
        PrevFocused = Param1;
      break;

    case DN_KEY:
      if (Param2 == KEY_ENTER) {
        int ToControl = -1;
        if (FocusedControl == IExampleCtl) ToControl = PrevFocused;
        if (FocusedControl == IGroupsList || FocusedControl == IFColorCtl || FocusedControl == IBColorCtl)
          ToControl = IExampleCtl;
        if (ToControl != -1) Info.SendDlgMessage(hDlg, DM_SETFOCUS, ToControl, 0);
      }
      switch (Param1) {
        case IGroupsList:
          bLBoxPosChanged = 1;
          Info.SendDlgMessage(hDlg, DN_LISTCHANGE, IGroupsList, 0);
          break;
        case IFColorCtl:
        case IBColorCtl:
          if (Param1 == IFColorCtl) k = clForeground; else k = clBackground;
          m_record.dwMousePosition.X = k % 4;
          m_record.dwMousePosition.Y = k / 4;
          if (ProcessControlKey(&m_record.dwMousePosition, Param2, 4, 4)) {
            m_record.dwMousePosition.X *= 3;
            Info.SendDlgMessage(hDlg, DN_MOUSECLICK, Param1, (long)&m_record);
            Info.SendDlgMessage(hDlg, DM_REDRAW, 0, 0);
          }
          break;
        case IExampleCtl:
          //      
          m_record.dwMousePosition = ExampleCoord;
          if (ProcessControlKey(&m_record.dwMousePosition, Param2, ExampleW, ExampleH)) {
            Info.SendDlgMessage(hDlg, DN_MOUSECLICK, Param1, (long)&m_record);
            Info.SendDlgMessage(hDlg, DM_REDRAW, 0, 0);
          }
          break;
      }
      break;

    case DN_LISTCHANGE:
      if (bLBoxPosChanged > 0) {
        //      
        //         
        bLBoxPosChanged = 0;
        break;
      }
      return FALSE;

    case DN_MOUSECLICK:
      switch (Param1) {
        case IExampleCtl:
          //   
          ExampleCoord = ((MOUSE_EVENT_RECORD*)Param2)->dwMousePosition;
          ExampleAttr = AllAttr[CurrentColorGroup->Mask[ExampleCoord.Y][ExampleCoord.X]];

          clForeground = AllColors[ExampleAttr] & 0x0f;
          clBackground = AllColors[ExampleAttr] >> 4;
          break;

        case IFColorCtl:
        case IBColorCtl:
          coord = ((MOUSE_EVENT_RECORD*)Param2)->dwMousePosition;
          k = coord.Y * 4 + coord.X / 3;
          if (Param1 == IFColorCtl) clForeground = k; else clBackground = k;
          //      
          AllColors[ExampleAttr] = (clBackground << 4) + clForeground;
          SetCaption(hDlg, szThemeName);
          Info.SendDlgMessage(hDlg, DN_DRAWDLGITEM, Param1, 0);
          return FALSE;

        case IGroupsList:
          bLBoxPosChanged = 1;
          return TRUE;
      }
      break;

    case DN_BTNCLICK:
      switch (Param1) {
        case ISaveCurrent:
          //     
          if (Info.InputBox(GetMsg(MTitle), GetMsg(MSaveSchemeAs), NULL, szThemeName,
            szThemeName, sizeof(szThemeName), NULL,
            FIB_EXPANDENV | FIB_BUTTONS | FIB_NOAMPERSAND)) {
            //   ini 
            if (WritePrivateProfileStruct(PHRASE_THEMES, szThemeName, AllColors, AllColorsCount, iniFileName) == 0)
              //       
              ShowMessage(FMSG_ERRORTYPE | FMSG_WARNING | FMSG_MB_OK, NULL, MCantSaveScheme);
          }
          break;

        case ILoadPreset: {
          //     
          struct FarMenuItem *MenuItems = NULL;
          char Buffer[1024];
          char *p = Buffer;
          i = 0;  //  
          //     colors.ini
          if (GetPrivateProfileString(PHRASE_THEMES, NULL, NULL, Buffer, sizeof(Buffer), iniFileName)) {
            while (*p) {
              MenuItems = (FarMenuItem*)realloc(MenuItems, sizeof(FarMenuItem) * (i + 1));
              lstrcpy(MenuItems[i].Text, p);
              if (i==LastSelectedTheme) MenuItems[i].Selected = TRUE;
              p += lstrlen(MenuItems[i++].Text) + 1;
            }
          }
          //     
          LastSelectedTheme = Info.Menu(Info.ModuleNumber, -1, -1, 0,
            FMENU_WRAPMODE | FMENU_SHOWAMPERSAND,
            GetMsg(MPresets), NULL, PHRASE_THEMES, NULL, NULL, MenuItems, i);
          if (LastSelectedTheme != -1) {
            //   colors.ini       
            GetPrivateProfileStruct(PHRASE_THEMES, MenuItems[LastSelectedTheme].Text,
              AllColors, AllColorsCount, iniFileName);
            //  AllColors    
            DefineMyColors();
            CopyMemory(CurrAllColors, AllColors, sizeof(AllColors));
            //  " "      
            lstrcpy(szThemeName, MenuItems[LastSelectedTheme].Text);
            SetCaption(hDlg, szThemeName);
            ListBoxPosUpdate(hDlg, 1);
          }
          free(MenuItems);
        }
        break;

        case IRestore:
        case IApply:
          int iMsg;
          if (Param1 == IRestore) iMsg = MReallyDoRestore; else iMsg = MReallyDoApplay;
          if (ShowMessage(FMSG_MB_YESNO, NULL, iMsg) == 0) {
            if (Param1 == IRestore) {
              CopyMemory(AllColors, PrevAllColors, sizeof(AllColors));
              lstrcpy(szThemeName, GetMsg(MMyFavoriteScheme));
            } else {
              //   
              struct FarListColors farcolor = {FCLR_REDRAW, 0, AllColorsCount, (LPBYTE)&AllColors};
              Info.AdvControl(Info.ModuleNumber, ACTL_SETARRAYCOLOR, &farcolor);
            }
            DefineMyColors();
            CopyMemory(CurrAllColors, AllColors, sizeof(AllColors));
            SetCaption(hDlg, szThemeName);
            ListBoxPosUpdate(hDlg, 1);
          }
          break;
      }
      break;
    // end of case DN_BTNCLICK:
    case DN_DRAWDLGITEM: {
      static struct FarDialogItem DialogItem;
      // DialogItem <-       DN_DRAWDLGITEM
      Info.SendDlgMessage(hDlg, DM_GETDLGITEM, Param1, (long)&DialogItem);
      // VBuf <-     DialogItem
      CHAR_INFO *VBuf = &DialogItem.VBuf[0];

      switch (Param1) {
        case IFColorCtl:
        case IBColorCtl:
          //     
          int color;
          if (Param1 == IFColorCtl) color = clForeground; else color = clBackground;
          coord.X = color % 4 * 3 + 1;
          coord.Y = color / 4;
          Info.SendDlgMessage(hDlg, DM_SETCURSORPOS, Param1, (long)&coord);

          //    
          Attr = 0;
          for(i = 0; i < 4; i++) {
            for(j = 0; j < 4; j++, Attr++) {
              for(k = 0; k < 3; k++, VBuf++) {
                VBuf->Char.AsciiChar = (k == 1 && Attr == color) ? 7 : ' ';
                VBuf->Attributes = Attr << 4;
                if (Attr < 2 || Attr == 8) VBuf->Attributes |= 0x07;
              }
            }
          }
          break;
        case IExampleCtl:
          Info.SendDlgMessage(hDlg, DM_SETCURSORPOS, IExampleCtl, (long)&ExampleCoord);
          //   
          for(i = 0; i < ExampleH; i++)
            for(j = 0; j < ExampleW; j++, VBuf++) {
              VBuf->Char.AsciiChar = CurrentColorGroup->Data[i][j];
              VBuf->Attributes = AllColors[AllAttr[CurrentColorGroup->Mask[i][j]]];
              if (i == ExampleCoord.Y && j == ExampleCoord.X)
                VBuf->Attributes = ~VBuf->Attributes;
            }
          break;
        case IInfoCtl:
          //      
          const char *PaletteColors = GetMsg(MPaletteColors00 + ExampleAttr);
          for(i = 0; i < ExampleW; i++, VBuf++) {
            VBuf->Char.AsciiChar = (i < lstrlen(PaletteColors)) ? PaletteColors[i]: ' ';
            VBuf->Attributes = SavedColors[0];
          }
          break;
      }
    }
    break;
    // End of case DN_DRAWDLGITEM:

    case DN_CLOSE:
      //    Cancel  ESC
      return(Param1 < 0 || Param1 == ICancel);
  }

  //    
  return Info.DefDlgProc(hDlg, Msg, Param1, Param2);
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item)
{
  static const struct InitDialogItem InitItems [] = {
    DI_SINGLEBOX,   0,       0,        UCtlL-2, DlgH-1,   0, MGroups,
    DI_LISTBOX,     1,       1,        UCtlL-3, GrpCnt,   DIF_LISTNOAMPERSAND | DIF_LISTNOBOX, -1,
    DI_SINGLEBOX,   1,       GrpCnt+1, UCtlL-3, GrpCnt+1, 0, -1,

    DI_TEXT,        3,       GrpCnt+2, 0,       0,        0, MForeground,
    DI_USERCONTROL, 3,       GrpCnt+3, 3+11,    GrpCnt+6, 0, -1,
    DI_TEXT,        3,       GrpCnt+7, 0,       0,        0, MBackground,
    DI_USERCONTROL, 3,       GrpCnt+8, 3+11,    GrpCnt+11,0, -1,

    DI_SINGLEBOX,   UCtlL-2, 0,        DlgW-1,  DlgH-1,   0, MColors,
    DI_USERCONTROL, UCtlL,   UCtlT,    UCtlR,   UCtlB-3,  0, -1,
    DI_USERCONTROL, UCtlL,   DlgH-2,   UCtlR,   DlgH-2,   DIF_NOFOCUS, -1,

    DI_SINGLEBOX,   1,       DlgH-6,   UCtlL-3, DlgH-6,   0, -1,
    DI_BUTTON,      1,       DlgH-5,   0,       0,        DIF_NOBRACKETS, MRestore,
    DI_BUTTON,      1,       DlgH-4,   0,       0,        DIF_NOBRACKETS, MLoadScheme,
    DI_BUTTON,      8,       DlgH-4,   0,       0,        DIF_NOBRACKETS, MSaveScheme,
    DI_SINGLEBOX,   1,       DlgH-3,   UCtlL-3, DlgH-3,   0, -1,
    DI_BUTTON,      1,       DlgH-2,   0,       0,        DIF_NOBRACKETS, MApply,
    DI_BUTTON,      11,      DlgH-2,   0,       0,        DIF_NOBRACKETS, MCancel,

    DI_SINGLEBOX,   UCtlL-1, 1,        DlgW-2,  DlgH-3,   0, -1,
  };
  InitDialogItems(InitItems, DialogItems, sizeof(InitItems) / sizeof(InitItems[0]));
  DialogItems[ISaveCurrent].X1 = UCtlL - 1 - lstrlen(GetMsg(MSaveScheme));

  // ColorsGroups[][] <-  ""   
  int k = MPanelData00;
  for(int i = 0; i < GrpCnt; i++, k += 2 * ExampleH)
    for(int j = 0; j < ExampleH; j++) {
      lstrcpy((char*)ColorsGroups[i].Data[j], GetMsg(k + j));
      lstrcpy((char*)ColorsGroups[i].Mask[j], GetMsg(k + j + 20));
    }

  //   DI_USERCONTROL'     
  struct FarDialogItem *PItem = &DialogItems[0];
  for (i = 0; i < sizeof(InitItems) / sizeof(InitItems[0]); i++, PItem++)
    if (PItem->Type == DI_USERCONTROL)
      PItem->VBuf = (CHAR_INFO*)realloc(NULL, sizeof(CHAR_INFO) * DIM(*PItem));;

  // AllColorsCount <-     FAR
  AllColorsCount = Info.AdvControl(Info.ModuleNumber, ACTL_GETARRAYCOLOR, NULL);
  // AllColors[] <-   FAR'
  Info.AdvControl(Info.ModuleNumber, ACTL_GETARRAYCOLOR, AllColors);
  //  AllColors    
  DefineMyColors();

  CopyMemory(PrevAllColors, AllColors, sizeof(AllColors));
  CopyMemory(CurrAllColors, AllColors, sizeof(AllColors));

  ZeroMemory(AllAttr, sizeof(AllAttr));
  for(i = 0; i < 32; i++) {
    if (i < 10)
      AllAttr[i + '0'] = AllColorsCount + i;
    if (i < 26) {
      AllAttr[i + 'A'] = i;
      AllAttr[i + 'a'] = i + 26;
    }
    AllAttr[i + 128] = i + 26 + 26;
    AllAttr[i + (i < 16 ? 160 : 224 - 16)] = i + 26 + 26 + 32;
  }
  AllAttr[' '] = AllColorsCount + 10;

  Info.DialogEx(Info.ModuleNumber, -1, -1, DlgW, DlgH,
    PHRASE_COLORS, DialogItems,
    sizeof(DialogItems) / sizeof(DialogItems[0]),
    0, FDLG_NODRAWSHADOW, DlgProc,0);

  //   DI_USERCONTROL'      
  PItem = &DialogItems[0];
  for (i = 0; i < sizeof(InitItems)/sizeof(InitItems[0]); i++, PItem++)
    if (PItem->Type == DI_USERCONTROL) free(PItem->VBuf);

  return INVALID_HANDLE_VALUE;
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info)
{
  static char *PluginMenuStrings[1];
  PluginMenuStrings[0] = (char*)GetMsg(MPluginMenuStrings);
  Info->PluginMenuStrings = PluginMenuStrings;
  Info->StructSize = sizeof(struct PluginInfo);
  Info->PluginMenuStringsNumber = sizeof(PluginMenuStrings) / sizeof(PluginMenuStrings[0]);
}

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *pInfo)
{
  Info = *pInfo;
  hHeap = GetProcessHeap();
}

int WINAPI _export GetMinFarVersion(void)
{
  return(MAKEFARVERSION(1,70,1634));
}

extern "C" int WINAPI _DllMainCRTStartup(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
  if (DLL_PROCESS_ATTACH == fdwReason && hinstDLL) {
    GetModuleFileName(hinstDLL, iniFileName, MAX_PATH);
    for (int i = lstrlen(iniFileName) - 1; i >= 0 && iniFileName[i] != '.'; i--);
    if (i < 0) i = lstrlen(iniFileName);
    lstrcpy(&iniFileName[i], PHRASE_INI);
  }
  return TRUE;
}
