
/* CdIt v1.50 by Mikael Klasson aka Fluff
   Hope you like it!					  */

#include <stdio.h>
#include <direct.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>

#define MAX_DIRS	200

char	checkdrive( char );
int 	getdirs( char *, int );
short	cursoff( void );
void	curson( short );
void	colorputs( char * );
void	colorputc( char, char );
char	readattrib( void );
char	getch( void );

FILE	*cfg;
char	dnum;
char	origattrib;
char	buf[256];

void main( int argc, char **argv )
{
	unsigned	crap;
	char		lop, lop2;
	char		path[3];
	char		result;
	char		c, c2;
	char		backspace = 1;
	char		driveletter;
	char		fullpath[MAX_DIRS][256];
	char		finalpath[256];
	char		dirinfo[MAX_DIRS];
	char		leastsofar;
	int 		equaldirs;
	int 		founddirs = 0;
	int 		sublevel;
	char		subdir[256][15];
	int 		chkeof;
	char		*initmsg = "^05\nCdIt v^021.50^05 (C) ^03Mikael Klasson^05 aka ^03Fluff\n\n";
	char		origpath[256];
	short		cursstate;
	char		*cfgname = "CDIT.CFG";
	char		cfgpath[256];
	char		forcecdrom = 0; 	/* 1 == always yes, 2 == always no */
	char		forcenetwork = 0;	/* 1 == always yes, 2 == always no */
	int 		helpmsg = 0;		/* 1 == show helpmsg, 0 == don't */
	int 		builddb = 0;		/* 1 == build database, 0 == don't */
	int 		i;

	origattrib = readattrib();

	strcpy( cfgpath, argv[0] );
	strcpy( strrchr( cfgpath, '\\' ) + 1, cfgname );


/* Check to see what arguments were given */

	for( i = 1; i < argc; i++ ) {

		argv[i] = strupr( argv[i] );

		if( argv[i][0] == '/' ) {
			argv[i][0] = '-';
		}

		if( !strcmp( argv[i], "-HELP" )
		 || !strcmp( argv[i], "-H" )
		 || !strcmp( argv[i], "-?" ) ) {

			helpmsg = 1;

		} else if( !strcmp( argv[i], "-YESCD" )
				|| !strcmp( argv[i], "-YC" ) ) {

			forcecdrom = 1;

		} else if( !strcmp( argv[i], "-NOCD" )
				|| !strcmp( argv[i], "-NC" ) ) {

			forcecdrom = 2;

		} else if( !strcmp( argv[i], "-YESND" )
				|| !strcmp( argv[i], "-YN" ) ) {

			forcenetwork = 1;

		} else if( !strcmp( argv[i], "-NOND" )
				|| !strcmp( argv[i], "-NN" ) ) {

			forcenetwork = 2;

		} else if( !strcmp( argv[i], "-BUILD" )
				|| !strcmp( argv[i], "-B" ) ) {

			builddb = 1;
		}

	}

/* Show helpmsg */

	if( ( argc == 1 ) || ( helpmsg == 1 ) ) {
		colorputs( initmsg );
		colorputs( "^03Usage:     ^03CdIt^08 [<^03OPTIONS^08> | <^03DIRECTORY^08>]\n" );
		colorputs( "^03             -H^08 or^03 -Help^08 to get this helpscreen.\n" );
		colorputs( "^03             -B^08 or^03 -Build^08 to build database.\n" );
		colorputs( "^03             -NC^08 or^03 -NoCD^08 in conjunction with^03 -B^08 to ignore CD-ROMs.\n" );
		colorputs( "^03             -YC^08 or^03 -YesCD^08 in conjunction with^03 -B^08 to search CD-ROMs.\n" );
		colorputs( "^03             -NN^08 or^03 -NoND^08 in conjunction with^03 -B^08 to ignore network drives.\n" );
		colorputs( "^03             -YN^08 or^03 -YesND^08 in conjunction with^03 -B^08 to search network drives.\n" );
		colorputs( "^03Examples:  ^03CdIt -b -nc -nn^08 ;^03 CdIt mydir\n" );

		return;
	}


/* Build database */

	if( builddb ) {

		colorputs( initmsg );
		cursstate = cursoff();

		if( !( cfg = fopen( cfgpath, "wb" ) ) ) {
			colorputs( "^04\nCouldn't open cfg-file for writing!\n" );
			return;
		}

		colorputs( "^03Building database" );

		switch( forcecdrom ) {
		case 1:
			colorputs( "^03, searching CD-ROMs" );
			break;
		case 2:
			colorputs( "^03, ignoring CD-ROMs" );
			break;
		default:
			break;
		}

		switch( forcenetwork ) {
		case 1:
			colorputs( "^03, searching network drives" );
			break;
		case 2:
			colorputs( "^03, ignoring network drives" );
			break;
		default:
			break;
		}

		colorputs( "^03...\n\n" );

		getcwd( origpath, 256 );

		for( lop = 1 ; lop < 30 ; lop++ ) {
			if( result = checkdrive( lop ) ) {
				if( result == 2 ) {

					sprintf( buf, "^03Drive ^06%c^03 appears to be a CD-ROM, scan anyway? (Y/N) ", lop+'@' );
					colorputs( buf );
					fflush( stdout );

					if( !forcecdrom ) {
						sprintf( buf, "^03%c\r", toupper( c = getch() ) );
					} else {
						sprintf( buf, "^03%c\r", c = ( forcecdrom == 1 ) ? 'Y' : 'N' );
					}

					colorputs( buf );

					if( toupper( c ) == 'Y' ) {
						result = 1;
					} else {
						printf( "\n\n" );
					}

				} else if( result == 3 ) {

					sprintf( buf, "^03Drive ^06%c^03 appears to be a network drive, scan anyway? (Y/N) ", lop+'@' );
					colorputs( buf );
					fflush( stdout );

					if( !forcenetwork ) {
						sprintf( buf, "^03%c\r", toupper( c = getch() ) );
					} else {
						sprintf( buf, "^03%c\r", c = ( forcenetwork == 1 ) ? 'Y' : 'N' );
					}

					colorputs( buf );

					if( toupper( c ) == 'Y' ) {
						result = 1;
					} else {
						printf( "\n\n" );
					}

				}

				if( result == 1 ) {
					_dos_setdrive( lop, &crap );
					fprintf( cfg, ":%c\n", lop+'@' );
					sprintf( path, "%c:\\", lop+'@' );
					sprintf( buf, "^03Scanning Drive ^06%c                                           \n", lop+'@' );
					colorputs( buf );
					sprintf( buf, "^02%d ^08directories on drive ^06%c\n\n", getdirs( path, 0 ), lop + '@' );
					colorputs( buf );
				}
			}
		}

		fclose( cfg );
		_dos_setdrive( origpath[0]-'@', &crap );

		if( origpath[strlen( origpath ) - 1] == '\\' ) {
			origpath[strlen( origpath ) - 1] = 0;
		}

		chdir( origpath );
		colorputs( "^03CdIt will now work perfectly!\n" );
		curson( cursstate );

		return;
	}


/* Change Directory */

	if( !( cfg = fopen( cfgpath, "rb" ) ) ) {
		colorputs( "^04\nCouldn't open cfg-file! Please run \"CdIt -b\" to build one.\n" );
		return;
	}

	while( 1 ) {
		if( ( c = fgetc( cfg ) ) == ':' ) {
			driveletter = fgetc( cfg );
			fgetc( cfg );					  /* Read LineFeed */
		} else {
			if( ( chkeof = fgetc( cfg ) ) == EOF ) {
				if( founddirs ) {
					break;
				}

				sprintf( buf, "^03\nNo Directory Found Matching \"%s*\"\n", argv[1] );
				colorputs( buf );

				fclose( cfg );
				return;
			}

			ungetc( chkeof, cfg );
			sublevel = 0;

			while( c == '+' ) {
				sublevel++;
				c = fgetc( cfg );
			}

			ungetc( c, cfg );

			if( !strncmp( argv[1], fgets( subdir[sublevel], 15, cfg ), strlen( argv[1] ) ) ) {
				fullpath[founddirs][0] = driveletter;
				fullpath[founddirs][1] = ':';
				fullpath[founddirs][2] = 0;

				for( lop = 0 ; lop <= sublevel ; lop++ ) {
					strcat( fullpath[founddirs], "\\" );
					strcat( fullpath[founddirs], subdir[lop] );
					fullpath[founddirs][strlen( fullpath[founddirs] ) - 1] = 0;
				}

				dirinfo[founddirs] = strlen( subdir[sublevel] ) - strlen( argv[1] );
				founddirs++;
				if( founddirs >= MAX_DIRS ) {
					break;
				}
			}
		}
	}

	leastsofar = 127;
	equaldirs = 0;

	for( lop = 0; lop < founddirs; lop++ ) {
		if( dirinfo[lop] <= 1 ) {
			equaldirs++;
			strcpy( finalpath, fullpath[lop] );
		}
	}

	if( equaldirs != 1 && founddirs != 1 ) {
		colorputs( initmsg );

		if( equaldirs > 1 ) {
			for( lop = 0, lop2 = 0; lop < founddirs; lop++ ) {
				if( dirinfo[lop] <= 1 ) {
					if( lop != lop2 ) {
						strcpy( fullpath[lop2], fullpath[lop] );
					}
					lop2++;
				}
			}
			founddirs = lop2;
		}

		for( lop = 0; lop < founddirs; lop++ ) {
			sprintf( buf, "^02  %d. ^08%s\n", lop + 1, fullpath[lop] );
			colorputs( buf );
		}

		colorputs( "^03\nDirectory? " );
		fflush( stdout );

		while( founddirs > 9 && backspace ) {
			backspace = 0;
			c2 = 20;
			colorputc( ' ', 0x03 );
			colorputc( '\b', 0x03 );

			while( ( ( c = getch() - '1' ) > 8 ) && c != 234 ) {
				;
			}

			if( c == 234 ) {
				colorputs( "\n" );
				return;
			}

			colorputc( c + '1', 0x03 );

			if( c < ( founddirs / 10 ) ) {
				colorputc( ' ', 0x03 );
				putchar( '\b' );
				fflush( stdout );

				if( c + 1 < founddirs / 10 ) {
					while( c2 != 234 && c2 != 220 && c2 != 215 && ( c2 > 8 && c2 < 255 ) ) {
						c2 = getch() - '1';
					}
				} else {
					while( c2 != 234 && c2 != 220 && c2 != 215 && ( c2 >= ( founddirs % 10 ) && c2 < 255 ) ) {
						c2 = getch() - '1';
					}
				}

				if( c2 == 234 ) {
					colorputs( "\n" );
					return;
				} else if( c2 == 215 ) {
					putchar( '\b' );
					fflush( stdout );
					backspace = 1;
				} else if( c2 != 220 ) {		/* Enter ( ASCII 13 - '1' ) */
					colorputc( c2 + '1', 0x03 );
					c = ( c + 1 ) * 10 + c2;
				}
			}
		}

		if( founddirs <= 9 ) {
			while( ( ( c = getch() - '1' ) >= founddirs ) && c != 234 ) {
				;
			}
			if( c == 234 ) {					/* Escape ( ASCII 27 - '1' ) */
				colorputs( "\n" );
				return;
			}
			colorputc( c + '1', 0x03 );
		}

		strcpy( finalpath, fullpath[c] );
		colorputs( "\n" );

	} else if( equaldirs == 0 ) {
		strcpy( finalpath, fullpath[0] );
	}

	if( chdir( finalpath ) ) {
		sprintf( buf, "^04\nUnable to change dir to \"%s\"!\nPlease build a new database to update this list.\n", finalpath );
		colorputs( buf );
	} else {
		_dos_setdrive( finalpath[0] - '@', &crap );
	}

	fclose( cfg );
}


void colorputs( char *s )
{
	char c, color = origattrib;

	while( c = *s++ ) {
		if( c == '\n' ) {
			colorputc( 10, origattrib );
			colorputc( 13, origattrib );
		} else if( c == '^' ) {
			if( *s == '^' ) {
				s++;
				colorputc( c, color );
				continue;
			}
			color = ( ( *s++ - '0' ) << 4 ) + ( *s++ - '0' );
		} else {
			colorputc( c, color );
		}
	}
}


#pragma aux getch = \
" xor   ax,ax   "\
" int   16h     "\
value [al] modify [ax];


#pragma aux readattrib = \
" mov   ah,08h  "\
" xor   bh,bh   "\
" int   10h     "\
value [ah] modify [ax bx];


#pragma aux colorputc = \
" mov   ax,0900h"\
" xor   bh,bh   "\
" mov   cx,1    "\
" int   10h     "\
" mov   ah,0eh  "\
" mov   al,dl   "\
" int   10h     "\
parm [dl] [bl] modify [ax bx cx];


#pragma aux cursoff = \
" mov   ah,03h      "\
" xor   bh,bh       "\
" int   10h         "\
" mov   dx,cx       "\
" mov   ah,01h      "\
" mov   cx,2000h    "\
" int   10h         "\
value [dx] modify [ax bx cx dx];


#pragma aux curson = \
" mov   ah,01h  "\
" int   10h     "\
parm [cx] modify [ax cx];


#pragma aux checkdrive = \
" mov   dnum,bl     " \
" mov   ax,4408h    "\
" int   21h         "\
" mov   dx,ax       "\
" cmp   ax,1        "\
" je    _fixed      "\
" xor   dx,dx       "\
" jmp   _ret        "\
"_fixed:            "\
\
" mov   ax,1500h    "\
" xor   bx,bx       "\
" int   2fh         "\
" or    bx,bx       "\
" jz    _notcd      "\
" mov   ax,150bh    "\
" mov   cl,dnum     "\
" dec   cl          "\
" int   2fh         "\
" or    ax,ax       "\
" jz    _notcd      "\
" mov   dx,2        "\
" jmp   _ret        "\
"_notcd:            "\
\
" mov   cx,dx       "\
" mov   ax,4409h    "\
" mov   bl,dnum     "\
" int   21h         "\
" test  dx,1000h    "\
" mov   dx,cx       "\
" jz    _ret        "\
" mov   dx,3        "\
" jmp   _ret        "\
\
"_ret:              "\
value [dl] modify [eax ebx ecx edx] parm [bl];


int getdirs( char *dir, int sublevel )
{
	DIR 			*dirp;
	struct dirent	*direntp;
	int 			lop;
	int 			directories = 0;

	if( !( dirp = opendir( dir ) ) ) {
		return 0;
	}

	chdir( dir );

	for( ; ; ) {
		direntp = readdir( dirp );

		if( !direntp ) {
			break;
		}

		if( direntp->d_attr & 0x10
		  && strcmp( direntp->d_name, "." )
		  && strcmp( direntp->d_name, ".." ) ) {

			directories++;

			for( lop = 0 ; lop < sublevel ; lop++ ) {
				fprintf( cfg, "+" );
			}

			fprintf( cfg, "%s\n", direntp->d_name );
			sprintf( buf, "^03Scanning Dir:              \rScanning Dir: ^08%s\r", direntp->d_name );
			colorputs( buf );
			fflush( stdout );

			directories += getdirs( direntp->d_name, sublevel + 1 );
			chdir( ".." );
		}
	}

	closedir( dirp );

	return directories;
}

