char PluginRootKey[80];

#define HKCU HKEY_CURRENT_USER
#define HKCR HKEY_CLASSES_ROOT
#define HKCC HKEY_CURRENT_CONFIG
#define HKLM HKEY_LOCAL_MACHINE
#define HKU  HKEY_USERS

/*
  㭪樨 ࠡ  ॥஬
  ॡ  ६ PluginRootKey
*/

#ifdef __cplusplus

HKEY CreateRegKey(HKEY hRoot,char *Key);
HKEY OpenRegKey(HKEY hRoot,char *Key);

//  祭   ValueName ⠭ 祭 ⨯ char*
void SetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_SZ,ValueData,lstrlen(ValueData)+1);
  RegCloseKey(hKey);
}


// ⠭ 祭 ⨯ DWORD
void SetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD ValueData)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_DWORD,(BYTE *)&ValueData,sizeof(ValueData));
  RegCloseKey(hKey);
}


// ⠭ 祭 ⨯ Binary
void SetRegKey(HKEY hRoot,char *Key,char *ValueName,BYTE *ValueData,DWORD ValueSize)
{
  HKEY hKey=CreateRegKey(hRoot,Key);
  RegSetValueEx(hKey,ValueName,0,REG_BINARY,ValueData,ValueSize);
  RegCloseKey(hKey);
}


//   ⨯ char*
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,char *ValueData,char *Default,DWORD DataSize)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type;
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,ValueData,&DataSize);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    lstrcpy(ValueData,Default);
    return(FALSE);
  }
  return(TRUE);
}


//   ⨯ DWORD
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,int &ValueData,DWORD Default)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type,Size=sizeof(ValueData);
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,(BYTE *)&ValueData,&Size);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    ValueData=Default;
    return(FALSE);
  }
  return(TRUE);
}


//   ⨯ DWORD
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,DWORD Default)
{
  int ValueData;
  GetRegKey(hRoot,Key,ValueName,ValueData,Default);
  return(ValueData);
}


//   ⨯ Binary
int GetRegKey(HKEY hRoot,char *Key,char *ValueName,BYTE *ValueData,BYTE *Default,DWORD DataSize)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  DWORD Type;
  int ExitCode=RegQueryValueEx(hKey,ValueName,0,&Type,ValueData,&DataSize);
  RegCloseKey(hKey);
  if (hKey==NULL || ExitCode!=ERROR_SUCCESS)
  {
    if (Default!=NULL)
      memcpy(ValueData,Default,DataSize);
    else
      memset(ValueData,0,DataSize);
    return(FALSE);
  }
  return(TRUE);
}


// 㤠 
void DeleteRegKey(HKEY hRoot,char *Key)
{
  char FullKeyName[512];
  lstrcpy(FullKeyName,PluginRootKey);
  lstrcat(FullKeyName,(Key && *Key ? "\\":""));
  lstrcat(FullKeyName,Key);
  RegDeleteKey(hRoot,FullKeyName);
}


// ᮧ 
HKEY CreateRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  DWORD Disposition;
  char FullKeyName[512];
  lstrcpy(FullKeyName,PluginRootKey);
  lstrcat(FullKeyName,(Key && *Key ? "\\":""));
  lstrcat(FullKeyName,Key);
  if(RegCreateKeyEx(hRoot,FullKeyName,0,NULL,0,KEY_WRITE,NULL,
                 &hKey,&Disposition) != ERROR_SUCCESS)
    hKey=NULL;
  return(hKey);
}


//    ॥
HKEY OpenRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey;
  char FullKeyName[512];
  lstrcpy(FullKeyName,PluginRootKey);
  lstrcat(FullKeyName,(Key && *Key ? "\\":""));
  lstrcat(FullKeyName,Key);
  if (RegOpenKeyEx(hRoot,FullKeyName,0,KEY_QUERY_VALUE,&hKey)!=ERROR_SUCCESS)
    return(NULL);
  return(hKey);
}

// ஢ ⢮ 
BOOL CheckRegKey(HKEY hRoot,char *Key)
{
  HKEY hKey=OpenRegKey(hRoot,Key);
  if (hKey!=NULL)
    RegCloseKey(hKey);
  return(hKey!=NULL);
}

#endif
