static struct PluginStartupInfo Info;
static struct FarStandardFunctions FSF;

struct InitDialogItem {
  int Type;
  int X1, Y1, X2, Y2;
  int Focus;
  int Selected;
  unsigned int Flags;
  int DefaultButton;
  char *Data;
};

int EMessage(const char * const * s,int type, int n) {
  return Info.Message(Info.ModuleNumber, FMSG_ALLINONE|type, NULL, s,
               0, // ࠬ  FMSG_ALLINONE 
               n); //⢮ 
}

const char* GetMsg(int MsgId) {
  return (Info.GetMsg(Info.ModuleNumber,MsgId));
}

int Debug(char *fmt, ...) {
  FILE *f = fopen("C:\\Log.txt","at" );
  va_list argptr;
  int cnt;

  va_start(argptr, fmt);
  cnt = vfprintf(f, fmt, argptr);
  va_end(argptr);

  fclose(f);
  return(cnt);
}

static void InitDialogItems( InitDialogItem* InitItems, FarDialogItem* DialogItems, int Count ) {
  for ( int i = 0; i < Count; i++ ) {
    DialogItems[i].Type = InitItems[i].Type;
    DialogItems[i].X1 = InitItems[i].X1;
    DialogItems[i].Y1 = InitItems[i].Y1;
    DialogItems[i].X2 = InitItems[i].X2;
    DialogItems[i].Y2 = InitItems[i].Y2;
    DialogItems[i].Focus = InitItems[i].Focus;
    DialogItems[i].Selected = InitItems[i].Selected;
    DialogItems[i].Flags = InitItems[i].Flags;
    DialogItems[i].DefaultButton = InitItems[i].DefaultButton;

    if ( (unsigned int) InitItems[i].Data < 2000 )
      lstrcpy( DialogItems[i].Data, GetMsg( (unsigned int)InitItems[i].Data ) );
    else
      lstrcpy( DialogItems[i].Data, InitItems[i].Data );
  }
}

void ShowHelp(const char * HelpTopic) {
  Info.ShowHelp(Info.ModuleName,HelpTopic,0);
}
