#include <windows.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#define _FAR_USE_FARFINDDATA
#include "plugin.hpp"
#include "farkeys.hpp"

#define MAXLENGTH 50
#define MAXSTRINGLENGTH 150
#define DIALOGWIDTH 20
#define DATESIZE 15
#define SETCOLORFLAG 0x78|DIF_SETCOLOR

#include "eplugin.cpp"
#include "farlang.h"
// , ,    -     
int GY;
int GM;
int GD;
int GMode;

struct Options {
  int ShowOnlyCurMonthDays;
  int SelectSaSuWithAnotherColor;
  int SaSuColor;
  int CurDayColor;
  int DaysOfOtherMonthsColor;
} Opt;

#include "addon.cpp"
#include "registry.cpp"

long KeyScan(HANDLE hDlg, long Key) {
  int Y = GY;
  int M = GM;
  int D = GD;
  int Param = 0;
  int ECode;
  char StrDate[DATESIZE];
  char string[MAXSTRINGLENGTH];

  switch (Key) {
    case KEY_F4:
      FSF.sprintf(string,"%02d.%02d.%04d",D,M,Y);
      if (!Info.InputBox(GetMsg(DateEntering), GetMsg(DateFormat), "Calendar", (const char*) string, StrDate, sizeof(StrDate), NULL, FIB_NOUSELASTHISTORY)) {
        Param |= 4;
        return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);
      }

      FSF.Trim(StrDate);
      ECode = StrScan(StrDate);

      if (!ECode)
        ECode = -1;  // 

      if (ECode!=-1) {
        if (Count(GY,GM)<GD && Count(GY,GM)>0)
          ECode = -5;  //      

        if (Count(GY,GM)<0)
          ECode = Count(GY,GM); // -2 ( ),  -3 ( )

        if (GD>31 || GD<1)
          ECode = -4;  //   
      }
      if (ECode < 0) {
        ECode = -ECode;  //     .lng
        string[0] =  '\0';
        FSF.sprintf(string,GetMsg(InputBoxError),GetMsg(InvalidFormat + ECode - 1));
        GD = D;
        GY = Y;
        GM = M;
        Param |= 4;
        EMessage((const char * const *) string, 0, 1); //  
      }
      else
        if (GY != Y || GM != M) {
          Param |=2;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_CTRLHOME:
      if (GY != YMin || GM != MMin) {
        Param |= 2;
        GY = YMin;
        GM = MMin;
        GD = 1;
      }
      else
        if (GD == 1)
          Param |= 4;
        else
          GD = 1;
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_CTRLEND:
      if (GY != YMax || GM != MMax) {
        Param |= 2;
        GY = YMax;
        GM = MMax;
        GD = 31;
      }
      else
        if (GD == 31)
          Param |= 4;
        else
          GD = 31;
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_MULTIPLY:
    case '*':
      Param |= 1;
      SYSTEMTIME Time;
      GetLocalTime(&Time);
      if (Time.wYear != Y || Time.wMonth != M) {
        Param |= 2;
        GY = Time.wYear;
        GM = Time.wMonth;
        GD = Time.wDay;
      }
      else
        GD = Time.wDay;
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    case KEY_END:
      if (D == Count(Y,M))
        Param |= 4;
      if ((Param & 4) == 0)
        GD = Count(Y,M);
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_HOME:
      if (D == 1)
        Param |= 4;
      if ((Param & 4) == 0)
        GD = 1;
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_PGUP:
      if (M == 1)
        Param |= 4;
      if ((Param & 4) == 0)
        GM = 1;
      Param |= 2;
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_PGDN:
      if (M == 12)
        Param |= 4;
      if ((Param & 4) == 0)
        GM = 12;
      Param |= 2;
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_LEFT:
      if ((Y==YMin) && (M==1) && (D<8))
        Param |= 4;  // ,  
      if ((D-7)<1) {
        if (M == 1) {
          M = MMax;
          Y--;
        }
        else
          M--;
        D = D + Count(Y,M) - 7;
        Param |= 2;
      }
      else
        D -= 7;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_RIGHT:
      if ((Y==YMax) && (M==MMax) && (D>24))
        Param |= 4;  // ,  
      if ((D+7)>Count(Y,M)) {
        int OldCount = Count(Y,M);
        if (M == MMax) {
          M = 1;
          Y++;
        }
        else
          M++;
        D = D - OldCount + 7;
        Param |= 2;
      }
      else
        D += 7;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0);

    case KEY_UP:
      if ((Y==YMin) && (M==MMin) && (D==1))
        Param |= 4;  // ,  
      if ((D-1)<1) {
        if (M == 1) {
          M = MMax;
          Y--;
        }
        else
          M--;
        D = Count(Y,M);
        Param |= 2;
      }
      else
        D--;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    case KEY_DOWN:
      if ((Y==YMax) && (M==MMax) && (D==31))
        Param |= 4;  // ,  
      if ((D+1)>Count(Y,M)) {
        if (M == MMax) {
          M = 1;
          Y++;
        }
        else
          M++;
        D = 1;
        Param |= 2;
      }
      else
        D++;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    case KEY_ALTLEFT:
      Param |= 2;  //
      if ((Y==YMin) && (M==1))
        Param |= 4;  // ,  
      if (M == 1) {
        Y--;
        M = 12;
      }
      else
        M--;
      if ((Param & 4) == 0)  {
        GY = Y;
        GM = M;
        if (Count(Y,M)<D)
          GD = Count(Y,M);
        else
          GD = D;

      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    case KEY_ALTRIGHT:
      Param |= 2;  //
      if ((Y==YMax) && (M==MMax))
        Param |= 4;  // ,  
      if (M == 12) {
        M = 1;
        Y++;
      }
      else
        M++;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        if (Count(Y,M)<D)
          GD = Count(Y,M);
        else
          GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    case KEY_CTRLLEFT:
      Param |= 2;  //
      if (Y==YMin)
        Param |= 4;  // ,  
      else
        Y--;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        if (Count(Y,M)<D)
          GD = Count(Y,M);
        else
          GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    case KEY_CTRLRIGHT:
      Param |= 2;  //
      if (Y==YMax)
        Param |= 4;  // ,  
      else
        Y++;
      if ((Param & 4) == 0) {
        GY = Y;
        GM = M;
        if (Count(Y,M)<D)
          GD = Count(Y,M);
        else
          GD = D;
      }
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  

    default:
      Param |= 8;  //   
      return Info.SendDlgMessage(hDlg,DM_USER, Param, 0); //  
  }
}

void AbledElements(HANDLE hDlg) {
  if (GY==YMin)
    Disabled(hDlg,CTRLLEFT);
  else
    Enabled(hDlg,CTRLLEFT);
  if (GY==YMax)
    Disabled(hDlg,CTRLRIGHT);
  else
    Enabled(hDlg,CTRLRIGHT);

  if (GY==YMin && GM==MMin)
    Disabled(hDlg,ALTLEFT);
  else
    Enabled(hDlg,ALTLEFT);
  if (GY==YMax && GM==MMax)
    Disabled(hDlg,ALTRIGHT);
  else
    Enabled(hDlg,ALTRIGHT);
}

long WINAPI DlgProc(HANDLE hDlg, int Msg, int Param1, long Param2) {
  int KN;

  switch(Msg) {
    case DN_KEY:
      switch (Param2) {
        case KEY_TAB:
        case KEY_SHIFTTAB:
          return TRUE;
        case KEY_SHIFTF1:
          ShowHelp("Zodiac");
          return TRUE;
        case KEY_MULTIPLY:
        case '*':
        case KEY_PGUP:
        case KEY_PGDN:
        case KEY_HOME:
        case KEY_END:
        case KEY_CTRLHOME:
        case KEY_CTRLEND:
        case KEY_CTRLLEFT:
        case KEY_CTRLRIGHT:
        case KEY_ALTLEFT:
        case KEY_ALTRIGHT:
        case KEY_UP:
        case KEY_DOWN:
        case KEY_LEFT:
        case KEY_RIGHT:
        case KEY_F4:
          return KeyScan(hDlg,Param2);
        default:
          return FALSE;
      }

    case DN_MOUSECLICK:
      //.     
      if ((((MOUSE_EVENT_RECORD *) Param2) -> dwButtonState & 1) == 0)
        return FALSE;

      switch (Param1) {
        case CTRLLEFT:
          KN = KEY_CTRLLEFT;
          break;
        case CTRLRIGHT:
          KN = KEY_CTRLRIGHT;
          break;
        case ALTLEFT:
          KN = KEY_ALTLEFT;
          break;
        case ALTRIGHT:
          KN = KEY_ALTRIGHT;
          break;
        default:
          return FALSE;
      }
      return KeyScan(hDlg,KN);

    case DM_USER:
      if ((Param1 & 4)!=0)
        return TRUE;
      if ((Param1 & 8)!=0)
        return FALSE;

      if ((Param1 & 1)!=0)
        GMode = TRUE;
      else
        GMode = FALSE;

      if ((Param1 & 2)!=0) {
        Fill(hDlg);
        AbledElements(hDlg);
      }
      else
        UpDate(hDlg);
      return TRUE;

    case DN_INITDIALOG:
      Fill(hDlg);
      AbledElements(hDlg);
      Info.SendDlgMessage(hDlg,DM_SETFOCUS,BUTTON_OK,0); // OK   
      return TRUE;

    default:
      return Info.DefDlgProc(hDlg,Msg,Param1,Param2);
  }
}

void WINAPI _export SetStartupInfo(const struct PluginStartupInfo *psInfo) {
  Info = *psInfo;
  FSF = *psInfo-> FSF;
  Info.FSF = &FSF;
}

void WINAPI _export GetPluginInfo(struct PluginInfo *Info) {
  static char * PluginMenuStrings[1];
  PluginMenuStrings[0] = (char*)GetMsg(Calendar);
  Info -> PluginMenuStrings = PluginMenuStrings;
  Info -> PluginMenuStringsNumber = sizeof(PluginMenuStrings) / sizeof(PluginMenuStrings[0]);

  static char * ConfigMenuStrings[1];
  ConfigMenuStrings[0] = (char*)GetMsg(Calendar);
  Info -> PluginConfigStrings = ConfigMenuStrings;
  Info -> PluginConfigStringsNumber = sizeof(ConfigMenuStrings) / sizeof(ConfigMenuStrings[0]);

  Info -> StructSize = sizeof(*Info);
  Info -> Flags = PF_VIEWER|PF_EDITOR;

  Info -> CommandPrefix=GetMsg(Prefix);
}

void ReadRegistry(void) {
  if (GetRegKey(HKCU,"","ShowOnlyCurMonthDays",Opt.ShowOnlyCurMonthDays,0))
    if ((Opt.ShowOnlyCurMonthDays<0) || (Opt.ShowOnlyCurMonthDays>1))
      Opt.ShowOnlyCurMonthDays = 0;
  SetRegKey(HKCU,"", "ShowOnlyCurMonthDays",(DWORD) Opt.ShowOnlyCurMonthDays);

  if (GetRegKey(HKCU,"","SelectSaSuWithAnotherColor",Opt.SelectSaSuWithAnotherColor,1))
    if ((Opt.SelectSaSuWithAnotherColor<0) || (Opt.SelectSaSuWithAnotherColor>1))
      Opt.SelectSaSuWithAnotherColor = 1;
  SetRegKey(HKCU,"", "SelectSaSuWithAnotherColor",(DWORD) Opt.SelectSaSuWithAnotherColor);

  if (GetRegKey(HKCU,"","SaSuColor",Opt.SaSuColor,0x7F))
    if ((Opt.SaSuColor<0) || (Opt.SaSuColor>255))
      Opt.SaSuColor = 0x7F;
  SetRegKey(HKCU,"", "SaSuColor",(DWORD) Opt.SaSuColor);

  if (GetRegKey(HKCU,"","CurDayColor",Opt.CurDayColor,0x4F))
    if ((Opt.CurDayColor<0) || (Opt.CurDayColor>255))
      Opt.CurDayColor = 0x4F;
  SetRegKey(HKCU,"", "CurDayColor",(DWORD) Opt.CurDayColor);

  if (GetRegKey(HKCU,"","DaysOfOtherMonthsColor",Opt.DaysOfOtherMonthsColor,0x78))
    if ((Opt.DaysOfOtherMonthsColor<0) || (Opt.DaysOfOtherMonthsColor>255))
      Opt.DaysOfOtherMonthsColor = 0x78;
  SetRegKey(HKCU,"", "DaysOfOtherMonthsColor",(DWORD) Opt.DaysOfOtherMonthsColor);
}

void WriteRegistry() {
  SetRegKey(HKCU,"", "ShowOnlyCurMonthDays",(DWORD) Opt.ShowOnlyCurMonthDays);
  SetRegKey(HKCU,"", "SelectSaSuWithAnotherColor",(DWORD) Opt.SelectSaSuWithAnotherColor);
  SetRegKey(HKCU,"", "SaSuColor",(DWORD) Opt.SaSuColor);
  SetRegKey(HKCU,"", "CurDayColor",(DWORD) Opt.CurDayColor);
  SetRegKey(HKCU,"", "DaysOfOtherMonthsColor",(DWORD) Opt.DaysOfOtherMonthsColor);
}

const char * xxMask =  "99";
int WINAPI _export Configure(int /*ItemNumber*/) {
  lstrcpy(PluginRootKey,Info.RootKey);
  lstrcat(PluginRootKey,"\\Calendar");
  ReadRegistry();

  struct InitDialogItem InitItems[] = {
/*00*/DI_DOUBLEBOX,3, 1,45,9,0,0,0,              0, (char*)Calendar,
/*01*/DI_CHECKBOX, 4, 2, 0,0,0,0,0,              0, (char*)ShowOnlyCurrentMonthDays,
/*02*/DI_CHECKBOX, 4, 3, 0,0,0,0,0,              0, (char*)DoSelectSaSuWithAnotherColor,
/*03*/DI_FIXEDIT,  4, 4, 5,0,0,0,DIF_MASKEDIT,   0, "",
/*04*/DI_FIXEDIT,  7, 4, 8,0,0,0,DIF_MASKEDIT,   0, "",
/*05*/DI_TEXT,    10, 4, 0,0,0,0,0,              0, (char*)ColorOfSaSu,
/*06*/DI_FIXEDIT,  4, 5, 5,0,0,0,DIF_MASKEDIT,   0, "",
/*07*/DI_FIXEDIT,  7, 5, 8,0,0,0,DIF_MASKEDIT,   0, "",
/*08*/DI_TEXT,    10, 5, 0,0,0,0,0,              0, (char*)ColorOfDaysOfNotCurrentMonth,
/*09*/DI_FIXEDIT,  4, 6, 5,0,0,0,DIF_MASKEDIT,   0, "",
/*10*/DI_FIXEDIT,  7, 6, 8,0,0,0,DIF_MASKEDIT,   0, "",
/*11*/DI_TEXT,    10, 6, 0,0,0,0,0,              0, (char*)ColorOfCurrentDay,
/*12*/DI_TEXT,     0, 7, 0,0,0,0,DIF_SEPARATOR,  0, "",
/*13*/DI_BUTTON,   0, 8, 0,0,0,0,DIF_CENTERGROUP,1, (char*)MOK,
/*14*/DI_BUTTON,   0, 8, 0,0,0,0,DIF_CENTERGROUP,0, (char*)MCancel
  };

  const int n = sizeof(InitItems) / sizeof(InitItems[0]);
  FarDialogItem DialogItems[n];
  InitDialogItems(InitItems, DialogItems, n);

  DialogItems[1].Selected = Opt.ShowOnlyCurMonthDays;
  DialogItems[2].Selected = Opt.SelectSaSuWithAnotherColor;

  DialogItems[3].Mask = xxMask;
  DialogItems[4].Mask = xxMask;
  DialogItems[6].Mask = xxMask;
  DialogItems[7].Mask = xxMask;
  DialogItems[9].Mask = xxMask;
  DialogItems[10].Mask = xxMask;

  itoa(Opt.SaSuColor & 15,DialogItems[3].Data,10);
  itoa(Opt.SaSuColor >> 4 & 15,DialogItems[4].Data,10);
  itoa(Opt.DaysOfOtherMonthsColor & 15,DialogItems[6].Data,10);
  itoa(Opt.DaysOfOtherMonthsColor >> 4 & 15,DialogItems[7].Data,10);
  itoa(Opt.CurDayColor & 15,DialogItems[9].Data,10);
  itoa(Opt.CurDayColor >> 4 & 15,DialogItems[10].Data,10);

  int ExitCode = Info.Dialog(Info.ModuleNumber, -1, -1, 49, 11, "AboutPlugin", DialogItems, n);

  if (ExitCode!=13)
    return FALSE;

  Opt.ShowOnlyCurMonthDays = DialogItems[1].Selected;
  Opt.SelectSaSuWithAnotherColor = DialogItems[2].Selected;
  char * ErrStr = NULL;
  int Number1, Number2;

  Number1 = strtol(DialogItems[3].Data, &ErrStr, 10) ;
  Number2 = strtol(DialogItems[4].Data, &ErrStr, 10);
  if (Number1<16 && Number2<16)
    Opt.SaSuColor = Number1 + (Number2 << 4);

  Number1 = strtol(DialogItems[6].Data, &ErrStr, 10) ;
  Number2 = strtol(DialogItems[7].Data, &ErrStr, 10);
  if (Number1<16 && Number2<16)
    Opt.DaysOfOtherMonthsColor = Number1 + (Number2 << 4);

  Number1 = strtol(DialogItems[9].Data, &ErrStr, 10) ;
  Number2 = strtol(DialogItems[10].Data, &ErrStr, 10);
  if (Number1<16 && Number2<16)
    Opt.CurDayColor = Number1 + (Number2 << 4);

  WriteRegistry();
  return FALSE;
}

int WINAPI _export GetMinFarVersion(void) {
  return MAKEFARVERSION(1,70,1282);
}

HANDLE WINAPI _export OpenPlugin(int OpenFrom, int Item) {
  lstrcpy(PluginRootKey,Info.RootKey);
  lstrcat(PluginRootKey,"\\Calendar");
  ReadRegistry();

  if (OpenFrom == OPEN_COMMANDLINE) {
    char StrItem[MAXLENGTH];
    lstrcpy(StrItem, (const char *) Item);
    FSF.Trim(StrItem);
    if (lstrcmp(StrItem,"") == 0)
      GMode = TRUE;  //..   
    else
      GMode = FALSE;
    if (!GMode) {
      int ECode = StrScan(StrItem);
      //ECode:
      //-1 - bad format of data
      //-2 - bad year
      //-3 - bad month
      //-4 - bad day
      //-5 - curday > monthdays

      if (!ECode)
        ECode = -1;  // 

      if (ECode!=-1) {
        if (Count(GY,GM)<GD && Count(GY,GM)>0)
          ECode = -5;  //      

        if (Count(GY,GM)<0)
          ECode = Count(GY,GM); // -2 ( ),  -3 ( )

        if (GD>31 || GD<1)
          ECode = -4;  //   
      }
      if (ECode < 0) {
        char string[MAXSTRINGLENGTH];
        ECode = -ECode;  //     .lng
        string[0] = '\0';
        FSF.sprintf(string,GetMsg(Error),GetMsg(InvalidFormat + ECode - 1));
        EMessage((const char * const *) string, 0, 1); //  
        return INVALID_HANDLE_VALUE;
      }
    }
  }

  if ((GMode) || (OpenFrom != OPEN_COMMANDLINE)) {
    SYSTEMTIME Time;
    GetLocalTime(&Time);
    GD = Time.wDay;
    GM = Time.wMonth;
    GY = Time.wYear;
    GMode = TRUE;  //..   
  }

  const int n = sizeof(InitItems) / sizeof(InitItems[0]);
  FarDialogItem DialogItems[n];
  InitDialogItems(InitItems, DialogItems, n);

  Info.DialogEx(Info.ModuleNumber, -1, -1, 28, 16, "AboutPlugin", DialogItems, n, 0, 0, DlgProc,0);

  return INVALID_HANDLE_VALUE;
}
