/*

wcx.h

This should be part of official Total Commander SDK.

*/

#ifndef WCX_H
#define WCX_H

/*
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
*/

#include "wcxhead.h"

/*
*/

#define WCXEXPORT //__declspec(dllexport)
#define WCXAPI __stdcall

/*

Mandatory API

*/

WCXEXPORT HANDLE WCXAPI OpenArchive (tOpenArchiveData *ArchiveData);
WCXEXPORT int WCXAPI ReadHeader (HANDLE hArcData, tHeaderData *HeaderData);
WCXEXPORT int WCXAPI ProcessFile (HANDLE hArcData, int Operation, char *DestPath, char *DestName);
WCXEXPORT int WCXAPI CloseArchive (HANDLE hArcData);
WCXEXPORT void WCXAPI SetChangeVolProc (HANDLE hArcData, tChangeVolProc pChangeVolProc1);
WCXEXPORT void WCXAPI SetProcessDataProc (HANDLE hArcData, tProcessDataProc pProcessDataProc);

/*

Optional API

*/

WCXEXPORT int WCXAPI PackFiles (char *PackedFile, char *SubPath, char *SrcPath, char *AddList, int Flags);
WCXEXPORT int WCXAPI DeleteFiles (char *PackedFile, char *DeleteList);
WCXEXPORT int WCXAPI GetPackerCaps();
WCXEXPORT void WCXAPI ConfigurePacker (HWND Parent, HINSTANCE DllInstance);
WCXEXPORT int WCXAPI StartMemPack (int Options, char *FileName);
WCXEXPORT int WCXAPI PackToMem (int hMemPack,char* BufIn,int InLen,int* Taken,char* BufOut, int OutLen,int* Written,int SeekBy);
WCXEXPORT int WCXAPI DoneMemPack (int hMemPack);
WCXEXPORT BOOL WCXAPI CanYouHandleThisFile (char *FileName);
WCXEXPORT void WCXAPI PackSetDefaultParams (PackDefaultParamStruct* dps);

/*
*/

#ifdef __cplusplus
}
#endif

/*
*/

#endif WCX_H
