/*

CabFile.cpp

*/

#include <windows.h>
#include "CabFile.h"

#include <fcntl.h>

/*
*/

extern "C"
{

extern FILEHANDLE hCabHdr;
extern CABHEADER CabHdr;
extern LPCABDESC pCabDesc;
extern SETUPTYPETABLE SetupTypes;
extern DWORD cSetupTypes;
//extern COMPONENTDESC* Components[CSCP_MAX];
extern DWORD cComponents;
//extern FILEGROUPDESC* FileGroups[CSFG_MAX];
extern DWORD cFileGroups;
extern LPSTR pCabPattern;
extern DIRARRAY* Dirs;
extern FILEDESC* Files;

extern ISVersion ver;
extern LPSTR exename;
extern void* pZBuf;
extern LPCABFILELIST pFileList;
extern LPDISKFILELIST pDiskList;
extern DWORD FileCount;

void InitZData(void* pHnds, ZDProcess proc);
void CreateDir(LPSTR dirname);
FILEHANDLE OpenForRead(LPSTR filename);
FILEHANDLE OpenForWrite(LPSTR filename, int Flags);
FILEHANDLE OpenForAccess(LPSTR filename, int Access);
FILEHANDLE OpenCabForAccess(int VolN, LPSTR ext, int Access);
BOOL TranslatePathToGroup(LPSTR* ppPath, LPSTR* ppFGName);
void CabBasedFileList(LPSTR CabParam, LPSTR DiskParam);
void DiskBasedFileList(LPSTR CabParam, LPSTR DiskParam);
BOOL WildMatch(LPSTR str, LPSTR wildcard);
long strtolong(char* str);
long atolong(char* str);
BOOL IsMask(LPSTR str);
LPFILEGROUPDESC GetGroupByFile(DWORD index);
LPSTR GetGroupNameByFile(DWORD Index);
DWORD GetGroupIndexByName(LPSTR GroupName);
void TranslateFileGroup();
BOOL DirExists(LPSTR DirName);
void RecurseBuildDiskList(LPSTR BegDP, LPSTR CurDP, LPSTR Mask, LPSTR CabPath);
void Free(void* ptr);
void* Alloc(DWORD NewSize);
void* ReAlloc(void* Ptr, DWORD NewSize);
LPDIRARRAY DirsArrayBuild(DFTABLE DFT);
void DirsArrayDestruct(LPDIRARRAY pDA);
long DirsArrayFind(LPDIRARRAY pDA, LPSTR DirName);
long DirsArrayAddDir(LPDIRARRAY* ppDA, LPSTR DirName);
DFTABLE RebuildDFT();
void RemoveFileBody(DWORD Index);
void AddFileBody(DWORD Index, char* FileName, RWHANDLES* pHnd);
DWORD GetLastRefVolume();
int CompareLongs(long Val1, long Val2, WORD Relation);
void ReNumberVolumes(DWORD FromVol, DWORD Index, WORD IndexRelation, long IndexDelta);
DWORD GetNewFileInGroup(DWORD iFileGroup);

// IShield functions
void ConvertToSingle();
void ExtractFiles();
void ReplaceFiles();
//void DeleteFiles();
void ZeroSizeFiles();
void AddFiles();
void ListFiles();
void ListSetupTypes();
void ListComponents();
void ListFileGroups();
void ReadCabHeader(FILEHANDLE hCab, LPCABHEADER pHdr);
void InitCabFile(LPSTR cabfile, int Access);
void SaveCabHeaders(int bCloseHandle);
void SaveCabHeader(FILEHANDLE hCabFile, CABHEADER* pHdr);
FILEHANDLE OpenCabReadHeader(int VolN, LPSTR ext, int Access, LPCABHEADER pHdr);

} // extern "C"

/*
*/

int CabFile::Load (const char* name)
{
	strcpy (FileName, name);

	InitCabFile (FileName, O_RDONLY);
	TranslateFileGroup();
	CabBasedFileList (0, 0);

	pCurrent = pFileList;

	return 0;
}

int CabFile::ReadHeader (tHeaderData *HeaderData)
{
	if (!pCurrent)
		return E_END_ARCHIVE;

	strcpy (HeaderData->ArcName, FileName);

	LPFILEDESC pFile = Files + pCurrent->CabIndex;

	strcpy (HeaderData->FileName, GetGroupNameByFile (pCurrent->CabIndex));
	strcat (HeaderData->FileName, TEXT("\\"));

	LPSTR pDir = Dirs->Dirs[pFile->DirIndex];

	if (*pDir != 0)
	{
		strcat (HeaderData->FileName, pDir);
		strcat (HeaderData->FileName, TEXT("\\"));
	}

	strcat (HeaderData->FileName, pFile->lpName);

	HeaderData->UnpSize = pFile->cbExpanded;
	HeaderData->PackSize = pFile->cbCompressed;
	HeaderData->FileTime = pFile->FatDate << 16 | pFile->FatTime;
	HeaderData->FileAttr = pFile->Attrs;

	pCurrent = pCurrent->pNext;

	return 0;
}

int CabFile::ProcessFile (int Operation, char *DestPath, char *DestName)
{
	return 0;
}
