/*
 * Copyright (c) Ondrej Brablc, 2001 <far@brablc.com>
 * You can use, modify, distribute this source code  or
 * any other parts of BlockPro plugin only according to
 * BlockPro  License  (see  \Doc\License.txt  for  more
 * information).
 */

/******************************************************************************
 *** M A I N   S W I T C H ****************************************************
 ******************************************************************************/

var objShell = WScript.CreateObject("WScript.Shell");
var objArg   = WScript.Arguments;
var objFso   = new ActiveXObject("Scripting.FileSystemObject");

var ForReading   = 1;
var ForWriting   = 2;
var ForAppending = 8;

if (objArg.length==0)
{
    WScript.Echo("Command missing!");
    WScript.Quit(1);
}

var STDIN      = WScript.StdIn;
var STDOUT     = WScript.StdOut;

switch (objArg(0))
{
    case "EXPAND":  ExpandEnvironment();
                    break;

    case "FC":      FileCompare();
                    break;

    case "URL":     if (objArg(1) == "EDIT")
                       OpenURL("", objArg(2), objArg(3));
                    else
                       OpenURL(objArg(2));
                    break;

    case "BLOCK":   BlockOperations();
                    break;

    case "CASE":    ToggleCase();
                    break;

    case "HTMLTBL": CreateHtmlTable();
                    break;

    case "HTMLHRF": AddLinkToText();
                    break;

    default:        STDOUT.WriteLine("Unknown command [" + objArg(0) + "]!");
                    WScript.Quit(1);
                    break;
}

STDOUT.Close();
STDIN.Close();

/******************************************************************************
 *** C O M M A N D S **********************************************************
 ******************************************************************************/

function ExpandEnvironment()
{
    while (!STDIN.AtEndOfStream)
    {
        STDOUT.WriteLine(objShell.ExpandEnvironmentStrings(STDIN.ReadLine()));
    }
}

function OpenURL( psUrl, piStart, piWidth)
{
    var url;

    if (psUrl.length == 0)
    {
        url = STDIN.ReadLine();

        if (piWidth>0)
        {
            url = url.substr(piStart,piWidth);
        }
        else
        {
            var o = piStart;
            while (o>0 && url.substr(o,1).search(/[\s'"]/) == -1) o--;
            if (o>0) o++;
            url   = url.substr(o);

            if (url.length == 0)
            {
                STDOUT.WriteLine("No URL found under the cursor!");
                WScript.Quit(1);
            }

            try
            {
                if      (url.search(/(\w+:\S*?)[\s'"]/)>-1)
                {
                    url = RegExp.$1;
                }
                else if (url.search(/(\w+:\S*?)$/)>-1)
                {
                    url = RegExp.$1;
                }
                else
                {
                    STDOUT.WriteLine("Cannot recognize URL!");
                    STDOUT.WriteLine("Please select it to block.");
                    WScript.Quit(1);
                }
            }
            catch(e)
            {
                STDOUT.WriteLine("Use WSH 5.6 and higher! [" + e.description + "]");
                WScript.Quit(1);
            }
        }
    }
    else
    {
        url = psUrl;
    }

    if (url.search(/^(\w+):/)==0)
    {
        var cmd = "";

        try
        {
            cmd = objShell.RegRead("HKCR\\" + RegExp.$1 + "\\shell\\open\\command\\");
        }
        catch(e)
        {
            STDOUT.WriteLine("Unknown protokol [" + RegExp.$1 + "]!");
            WScript.Quit(1);
        }

        var reg = new RegExp(/%1/);

        if (cmd.search(reg) != -1)
        {
            cmd = cmd.replace(reg,url);
        }
        else
        {
            cmd += " " + url;
        }

        // WScript.Echo(cmd);
        objShell.Run(cmd,1,false);
    }
    else
    {
        STDOUT.WriteLine("Unrecognized URL [" + url + "]!");
        WScript.Quit(1);
    }
}

function BlockOperations()
{
    switch ( objArg(1))
    {
        case "READ":
            ReadFile(objArg(2),objArg(3));
            break;

        case "SAVE":
            SaveFile(objArg(2),objArg(3),objArg(4));
            break;

        case "DELETE":
            DeleteFile(objArg(2));
            break;

        default:
            STDOUT.WriteLine("Unsupported block operation [" + objArg(1) + "]!");
            WScript.Quit(1);
    }
}

function SaveFile( filename, append, input)
{
    try
    {
        if (append == 0 || !objFso.FileExists(filename))
        {
            objFso.CopyFile(input, filename);
        }
        else
        {
            var SRC  = objFso.OpenTextFile( input,    ForReading);
            var DEST = objFso.OpenTextFile( filename, ForAppending, true);

            while (!SRC.AtEndOfStream)
            {
                DEST.WriteLine(SRC.ReadLine());
            }

            SRC.Close();
            DEST.Close();
        }
    }
    catch(e)
    {
        STDOUT.WriteLine("Cannot save the file " + filename);
        STDOUT.WriteLine("Error: " + e.description);
        WScript.Quit(1);
    }
}

function ReadFile( filename, output)
{
    try
    {
        objFso.CopyFile(filename, output);
    }
    catch(e)
    {
        STDOUT.WriteLine("Cannot read the file " + filename);
        STDOUT.WriteLine("Error: " + e.description);
        WScript.Quit(1);
    }
}

function DeleteFile( filename)
{
    try
    {
        objFso.DeleteFile(filename);
    }
    catch(e)
    {
        STDOUT.WriteLine("Cannot delete the file " + filename);
        STDOUT.WriteLine("Error: " + e.description);
        WScript.Quit(1);
    }
}

function CreateHtmlTable()
{
    var table_param = "";
    var columns     = 1;
    var rows        = 1;
    var re          = /^-([a-z]+)(\d+)$/;

    for (var a=1; a<objArg.length; a++)
    {
        if (re.exec(objArg(a)))
        {
            switch ( RegExp.$1)
            {
                case "c":  columns = parseInt( RegExp.$2, 10);
                           break;
                case "r":  rows    = parseInt( RegExp.$2, 10);
                           break;
                case "b":  table_param += " border=\"" + parseInt( RegExp.$2, 10) + "\"";
                           break;
                case "cp": table_param += " cellpadding=\"" + parseInt( RegExp.$2, 10) + "\"";
                           break;
                case "cs": table_param += " cellspacing=\"" + parseInt( RegExp.$2, 10) + "\"";
                           break;
            }
        }
    }

    STDOUT.WriteLine("<table" + table_param + ">");
    for (var i=0; i<rows; i++)
    {
        STDOUT.WriteLine("\t<tr>");
        for (var j=0; j<columns; j++)
        {
            STDOUT.WriteLine("\t\t<td></td>");
        }
        STDOUT.WriteLine("\t</tr>");
    }
    STDOUT.WriteLine("</table>");
}

function AddLinkToText()
{
    var url  = objArg(1);
    STDOUT.WriteLine("<a href=\"" + url + "\">" + STDIN.ReadLine() + "</a>");
}

function FatalError( psFile, psError)
{
    var STDOUT = objFso.OpenTextFile( psFile, ForWriting, true);
    STDOUT.WriteLine(psError);
    STDOUT.Close();
    WScript.Quit(1);
}

function FileCompare()
{
    var result = objArg(1);

    var file1  = STDIN.ReadLine();

    if (STDIN.AtEndOfStream)
    {
        FatalError(result, "Two files must be selected!");
    }

    var file2  = STDIN.ReadLine();

    if (!STDIN.AtEndOfStream)
    {
        FatalError(result, "FC can compare only two files!");
    }

    var params = "";

    for (var i = 2; i < objArg.length; i++)
    {
        params += " " + objArg(i);
    }

    var cmd    = "%COMSPEC% /c FC " + params + " \"" + file1 + "\" \"" + file2 + "\">\"" + result + "\"";

    objShell.Run(objShell.ExpandEnvironmentStrings(cmd),0,true);
}

function ToggleCase() // Implemented in Perl too
{
    var file  = new Array();
    var count = 0;
    var lo = 0;
    var hi = 0;

    var relo = /[a-z]/;
    var rehi = /[A-Z]/;
    var retg = /\b(\w)(\w+)\b/g;

    while (!STDIN.AtEndOfStream)
    {
        var line      = STDIN.ReadLine();
        file[count++] = line;

        if (line.search(relo)>-1) lo++;
        if (line.search(rehi)>-1) hi++;
    }

    for (var i=0; i<count; i++)
    {
        var line = file[i];

        if   (hi == 0) // Toggle case
        {
            var out = line.replace( retg, function($0,$1,$2)
                                          {
                                              var r = $1.toUpperCase() +
                                                      $2.toLowerCase();
                                              return r;
                                          });

            STDOUT.WriteLine(out);
        }
        else if (lo>0 && hi>0)
        {
            STDOUT.WriteLine(line.toUpperCase());
        }
        else if (lo == 0)
        {
            STDOUT.WriteLine(line.toLowerCase());
        }
        else
        {
            STDOUT.WriteLine(line);
        }
    }
}
