/*
 * Copyright (c) Ondrej Brablc, 2002 <brablc@yahoo.com>
 * You can use, modify, distribute this source code  or
 * any other parts of BlockPro plugin only according to
 * BlockPro  License  (see  \Doc\License.txt  for  more
 * information).
 */

#include <scanfile.h>
#include <farintf.h>
#include <winmem.h>
#include <filebuf.hpp>

int MenuFromFile(char * fileName, FarMenuItem **menu, int* n, int lastLine)
{
    struct TMenuArray
    {
        FarMenuItem *Items;
        size_t Count, Size, Delta;
    } a = { NULL, 0, 0, 10 };

    FarMenuItem *newItems;
    ReadFileBuf lo( fileName);
    int cont = 1;
    while (lo.ReadLine())
    {
        if ( a.Count == a.Size )
        {
            newItems = winNew(FarMenuItem, a.Size+a.Delta);
            if ( a.Count != 0 )
            {
                memcpy(newItems, a.Items, a.Count*sizeof(FarMenuItem));
                winDel(a.Items);
            }
            a.Items = newItems;
            a.Size += a.Delta;
        }

        a.Items[a.Count].Selected = a.Items[a.Count].Checked = a.Items[a.Count].Separator = false;
        strncpy(a.Items[a.Count].Text,lo.LastLine(),sizeof(a.Items[a.Count].Text));
        a.Items[a.Count].Text[sizeof(a.Items[a.Count].Text)-1] = 0;
        if (a.Count == (unsigned)lastLine)
        {
            a.Items[a.Count].Selected = true;
        }
        a.Count++; // Increase counter
    }

    *menu = a.Items;
    return a.Count;
}
