/*
 * Copyright (c) Ondrej Brablc, 2002 <brablc@yahoo.com>
 * You can use, modify, distribute this source code  or
 * any other parts of BlockPro plugin only according to
 * BlockPro  License  (see  \Doc\License.txt  for  more
 * information).
 */

#include "farintf.h"
#include "rtparams.hpp"
#include "BlockProLng.h"
#include "winmem.h"

#define MAX_ITEMS 10
#define MAX_ARRAY (MAX_ITEMS*2 + 4)

/* Defined by mother appplication */
extern void InfoMsg(BOOL pbWait, char *fmt,...);
extern void ErrorMsg(char *fmt,...);
extern void WinError(char *fmt,...);

/******************************************************************************/

RunTimeParameters::RunTimeParameters()
{
    ClearCache();
}

RunTimeParameters::~RunTimeParameters()
{
}

bool RunTimeParameters::Translate(char * pCaption, char * pCommand, int pSize)
{
    caption = pCaption;
    strcpy( help, "Command: ");
    strcat( help, caption);

    if (strcmp(pCommand,inCommand)!=0 || !cached)
    {
        strcpy(inCommand,pCommand);

        if (!Execute())
        {
            return FALSE;
        }
    }

    cached  = TRUE;
    strncpy(pCommand,outCommand,pSize);
    pCommand[pSize-1] = 0;
    return TRUE;
}

void RunTimeParameters::AddItem(struct InitDialogItem & item,
                                unsigned char pType,
                                unsigned int  pX1,
                                unsigned int  pY1,
                                unsigned int  pX2,
                                unsigned int  pY2,
                                unsigned int  pSelected,
                                unsigned int  pFlags,
                                char * pData)
{
    item.Type     = pType;
    item.X1       = pX1;
    item.Y1       = pY1;
    item.X2       = pX2;
    item.Y2       = pY2;
    item.Selected = pSelected;
    item.Flags    = pFlags;

    if ( (pType == DI_EDIT || pType == DI_FIXEDIT) && prevLabel != NULL)
    {
        char history[128];
        FSF.sprintf( history, "RunTimeParam\\%s", prevLabel);
        char * ptr=strchr( history, '&');
        if (ptr) strcpy( ptr, ptr+1);

        char * newStr = winNew(char,strlen(history)+1);
        strcpy(newStr, history);

        item.Flags    |= DIF_HISTORY | DIF_USELASTHISTORY;
        item.Selected |= (DWORD)newStr;
    }

    item.Data     = pData;
    prevLabel     = pData;
}

bool RunTimeParameters::Execute()
{
    char *ptrCmd, *ptrStart, *ptrInit, *ptrEnd;
    char label[80];
    char init[1024];
    int  len,oldLen;

    struct InitDialogItem InitItems[MAX_ARRAY];
    int    items = 0, row = 1, found = 0;

    AddItem(InitItems[items++],DI_DOUBLEBOX,3,row,48,7,-1,0, caption);

    ptrCmd = inCommand;

    // Enumerate questions
    while (found < MAX_ITEMS)
    {
        if (!(ptrStart = strstr( ptrCmd,     "!?"))) break;
        if (!(ptrInit  = strstr( ptrStart+2, "?" ))) break;
        if (!(ptrEnd   = strstr( ptrInit +1, "!" ))) break;

        found ++;

        len = ptrInit - (ptrStart + 2);
        strncpy(label,ptrStart+2, len);
        label[len] = 0;

        len = ptrEnd - (ptrInit + 1);
        strncpy(init, ptrInit+1 , len);
        init[len]  = 0;

        char * newStr = winNew(char, strlen(label)+1);
        strcpy(newStr, label);

        if (init[0]=='?' && (init[1]=='+' || init[1]=='-')) //Checkbox
        {
            row++;
            AddItem(InitItems[items++],DI_CHECKBOX, 5,row, 0,  0,(init[1]=='+'?1:0),0, newStr);
        }
        else // Edit text
        {
            row++;
            AddItem(InitItems[items++],DI_TEXT, 5,row,25,0,0,0, newStr );

            int lType = DI_EDIT;
            int lX2   = 46;

            newStr = winNew(char, 128);
            strcpy(newStr, init);

            if (init[0] == '?' && init[1] == '#')
            {
                strcpy(newStr, newStr+2);
                lType = DI_FIXEDIT;
                lX2   = 26 + strlen(newStr) - 1;
                FSF.RTrim(newStr);
            }

            AddItem(InitItems[items++],lType,26,row,lX2,0,0,0, newStr );
        }

        ptrCmd = ptrEnd + 1;
    }

    if (!found)
    {
        strcat( outCommand, inCommand);
        return TRUE;
    }

    row++;
    AddItem(InitItems[items++],DI_TEXT,5,row,0,255,0,0,NULL);
    row++;
    AddItem(InitItems[items++],DI_BUTTON,0,row,0,0,0,DIF_CENTERGROUP,(char *)MOK);
    AddItem(InitItems[items++],DI_BUTTON,0,row,0,0,0,DIF_CENTERGROUP,(char *)MCancel);

    InitItems[0].Y2 = (++row);

    int dOK       = items -2;
    int dExitCode = ExecDialog(InitItems,items,1,dOK, help);

    ptrCmd      = inCommand;
    *outCommand = 0;
    items       = 1;
    found       = 0;

    // Replace with answers
    while (found < MAX_ITEMS)
    {
        if (!(ptrStart = strstr( ptrCmd,     "!?"))) break;
        if (!(ptrInit  = strstr( ptrStart+2, "?" ))) break;
        if (!(ptrEnd   = strstr( ptrInit +1, "!" ))) break;

        found++;

        len = ptrEnd - (ptrInit + 1);
        strncpy(init, ptrInit+1 , len);
        init[len]  = 0;

        len = ptrStart - ptrCmd;
        oldLen = strlen(outCommand);
        strncat( outCommand, ptrCmd, len);
        outCommand[oldLen + len] = 0;

        if (init[0]=='?' && (init[1]=='+' || init[1]=='-')) //Checkbox
        {
            winDel(InitItems[items].Data);
            char * ptr = strchr(init,':');

            if (!ptr)
            {
                strcat(outCommand,InitItems[items].Selected?"1":"0");
            }
            else // "yes:no"
            {
                if (InitItems[items].Selected)
                {
                    ptr[0]=0;
                }
                else
                {
                    strcpy(init+2,ptr+1);
                }
                strcat(outCommand,init+2);
            }
            items++;
        }
        else // Edit text
        {
            winDel(InitItems[items++].Data);

            char * ptr, * start = InitItems[items].Data;
            while ((ptr = strchr(start,'"')))
            {
                *ptr  = 0;
                strcat( outCommand, start);
                strcat( outCommand, "\\\"");
                start = ptr+1;
            }
            strcat( outCommand, start);
            winDel(InitItems[items].Data);
            winDel((char*)InitItems[items].Selected);
            items++;
        }

        ptrCmd = ptrEnd + 1;
    }

    strcat( outCommand, ptrCmd);

    if (dExitCode!=dOK)
    {
        return FALSE;
    }

    return TRUE;
}

void RunTimeParameters::ClearCache()
{
    prevLabel   = NULL;
    cached      = FALSE;
    *inCommand  = 0;
    *outCommand = 0;
}
