#include <renreg.hpp>
#include <plugin.hpp>
#include <winmem.h>

bool CopyRegistryKey( HKEY hFrom, HKEY hTo )
{
   long lStatus;
   int iKey;
   DWORD dwValueSize, dwBufferSize, dwType;
   char *pszValueName;
   BYTE *pbBuffer;
   HKEY hNewTo, hNewFrom;


   pszValueName = winNew(char,8192);      //  Need some buffer space
   if( ! pszValueName )
      return( FALSE );

   pbBuffer = (BYTE *)pszValueName + 512;

   iKey = 0;                                            //  Start with value #0
   do
   {
      dwValueSize = 512;                //  Tell system how much buffer we have
      dwBufferSize = 8192 - 512;
                                   //  and enumerate data values at current key
      lStatus = RegEnumValue( hFrom, iKey, pszValueName, &dwValueSize,
                              NULL, &dwType, pbBuffer, &dwBufferSize );

      if( lStatus == ERROR_SUCCESS )           //  Move each value to new place
      {
         lStatus = RegSetValueEx( hTo, pszValueName, 0, dwType, pbBuffer,
                                  dwBufferSize );
         RegDeleteValue( hFrom, pszValueName );            //  Delete old value
      }
   }
   while( lStatus == ERROR_SUCCESS );           //  Loop until all values found

   iKey = 0;             //  Start over, looking for keys now instead of values
   do
   {
      dwValueSize = 512;                  //  Tell system about the buffer size
      dwBufferSize = 8192 - 512;
                                                             //  Get "next" key
      lStatus = RegEnumKeyEx( hFrom, iKey, pszValueName, &dwValueSize,
                              NULL, pbBuffer, &dwBufferSize, NULL );
      if( lStatus == ERROR_SUCCESS )                 //  Was a valid key found?
      {                                               //  Open the key if found
         lStatus = RegCreateKey( hTo, pszValueName, &hNewTo );
         if( lStatus == ERROR_SUCCESS )                //  If the key opened...
         {                                       //  Create new key of old name
            lStatus = RegCreateKey( hFrom, pszValueName, &hNewFrom );
            if( lStatus == ERROR_SUCCESS )
            {                             //  If that worked, recurse back here
               CopyRegistryKey( hNewFrom, hNewTo );      //  to "walk the tree"
               RegCloseKey( hNewFrom );                  //  Close each new key
               RegDeleteKey( hFrom, pszValueName );          //  Delete old key
            }
            RegCloseKey( hNewTo );                       //  Close each old key
         }
      }
   }
   while( lStatus == ERROR_SUCCESS );             //  Loop until key enum fails

   winDel( pszValueName );                      //  Free buffer and exit
   return( TRUE );
}

// ============================================================================

bool RenameRegistryItem( char *pszFrom, char *pszTo )
{
   HKEY hKey, hFromKey, hToKey;
   bool bStatus;
   long lStatus;


   hKey = HKEY_CURRENT_USER;                 //  This assumes HKEY_CURRENT_USER
                                               //  so nothing *drastic* happens
   lStatus = RegOpenKey( hKey, pszFrom, &hFromKey );        //  Open "from" key
   if( lStatus != ERROR_SUCCESS )
      return( FALSE );                      //  Fail if "from" key doesn't open

   lStatus = RegCreateKey( hKey, pszTo, &hToKey );          //  Create "to" key
   if( lStatus != ERROR_SUCCESS )             //  Fail if "to" key doesn't open
   {
      RegCloseKey( hFromKey );              //  Close "from" key before leaving
      return( FALSE );
   }

   bStatus = CopyRegistryKey( hFromKey, hToKey );         //  Copy "from"->"to"

   RegCloseKey( hToKey );                          //  Close both keys and exit
   RegCloseKey( hFromKey );

   RegDeleteKey( hKey, pszFrom );                 //  Delete last top-level key

   return( TRUE );
}                                               //  End of RenameRegistryItem()
