/*
 * Copyright (c) Ondrej Brablc, 2002 <brablc@yahoo.com>
 * You can use, modify, distribute this source code  or
 * any other parts of BlockPro plugin only according to
 * BlockPro  License  (see  \Doc\License.txt  for  more
 * information).
 */

#include <winmem.h>
#include <farintf.h>
#include <oemcoder.hpp>

void OEMCoder::init(const char * s, int length)
{
    len = length;

    if (len <0) len = strlen(s);

    input  = winNew( char, len + 1);
    output = winNew( char, len + 1);

    memcpy( input, s, len );
    input[len] = 0;
}

OEMCoder::~OEMCoder()
{
    winDel( input);
    winDel( output);
}

char * OEMCoder::ToOEM()
{
    memcpy( output, input, len + 1);
    convertToOEM( output, len);
    return output;
}

char * OEMCoder::FromOEM()
{
    memcpy( output, input, len + 1);
    convertFromOEM( output, len);
    return output;
}

void OEMCoder::convertToOEM(char * s, int length)
{
    if (length <0) length = strlen(s);

    struct EditorConvertText   ect;
    ect.Text       = s;
    ect.TextLength = length;
    Info.EditorControl(ECTL_EDITORTOOEM, &ect);
}

void OEMCoder::convertFromOEM(char * s, int length)
{
    if (length <0) length = strlen(s);

    struct EditorConvertText   ect;
    ect.Text       = s;
    ect.TextLength = length;
    Info.EditorControl(ECTL_OEMTOEDITOR, &ect);
}
