/*
 * Copyright (c) Ondrej Brablc, 2002 <far@brablc.com>
 * You can use, modify, distribute this source code  or
 * any other parts of BlockPro plugin only according to
 * BlockPro  License  (see  \Doc\License.txt  for  more
 * information).
 */

#ifndef __OEMCODER_H
#define __OEMCODER_H

#include <plugin.hpp>

class OEMCoder
{
    public:

        OEMCoder(const char * s, int length = -1)
        {
            init( s, length);
        }

        OEMCoder(struct EditorGetString & egs)
        {
            init( egs.StringText, egs.StringLength);
        }

        ~OEMCoder();

        char * ToOEM();
        char * FromOEM();

        static void convertToOEM(char * s, int length = -1);
        static void convertFromOEM(char * s, int length = -1);

    private:

        void init( const char * s, int length);
        int len;
        char * input;
        char * output;
};

#endif // __OEMCODER_H
