/*
 * Copyright (c) Ondrej Brablc, 2001 <far@brablc.com>
 * You can use, modify, distribute this source code  or
 * any other parts of BlockPro plugin only according to
 * BlockPro  License  (see  \Doc\License.txt  for  more
 * information).
 */

#ifndef __READFILEBUF_H
#define __READFILEBUF_H

#define READ_BUFFER_LEN 4096

class FileNameConvertor
{
    public:
        FileNameConvertor(const char * pFullLongPath);
        ~FileNameConvertor();

        char * get(char * fmt, char * pBuffer);
        char * getShort(char * pBuffer);

    private:
        char * longPath;
        char * shortPath;
};

class FileBuf
{
    public:
        FileBuf();
        ~FileBuf();

        bool Error();
        void Close();

    protected:
        HANDLE file;
};

class ReadFileBuf: public FileBuf
{
    public:
        ReadFileBuf(const char * fileName, DWORD mode = FILE_FLAG_SEQUENTIAL_SCAN);

        ~ReadFileBuf();

        bool ReadLine();
        long Size();
        bool Seek(long pos);
        long Tell();
        void Flush();

        DWORD Length();
        char * LastLine();

    private:

        char * sLine;
        char * sBuffer;

        DWORD lLine;
        DWORD lBuffer;
};

class WriteFileBuf: public FileBuf
{
    public:
        WriteFileBuf(const char * fileName);
        ~WriteFileBuf();

        bool Write(const char * string);
        bool WriteLine(const char * string);
};

#endif // __READFILEBUF_H
