#include <plugin.hpp>

// EXARR: pass an existing array where an open array is expected
#define EXARR(a) (a), ((sizeof(a)/sizeof(a[0])))

extern struct PluginStartupInfo Info;
extern struct FarStandardFunctions FSF;
extern char PluginRootKey[80];

struct InitDialogItem
{
  unsigned char Type;
  unsigned char X1,Y1,X2,Y2;
  unsigned int Selected;
  unsigned int Flags;
  char *Data;
};

inline const char *GetMsg(int MsgId)
{
  return Info.GetMsg(Info.ModuleNumber, MsgId);
}

extern void InitDialogItems(struct InitDialogItem*, struct FarDialogItem*, int);
extern void SaveDialogItems(struct FarDialogItem *Item, struct InitDialogItem *Init, int ItemsNumber);
extern int ExecDialog(struct InitDialogItem*, unsigned int, int, int, char*);
extern HKEY CreateRegKey(HKEY, char*);
extern HKEY OpenRegKey(HKEY, char*);
extern int GetRegKey(HKEY, char*, char*, int&, DWORD);
extern int GetRegKey(HKEY, char*, char*, DWORD Default);
extern int GetRegKey(HKEY, char*, char*, char*, char*, DWORD);
extern void SetRegKey(HKEY, char*, char*, DWORD);
extern void SetRegKey(HKEY, char*, char*, char*);
extern void DeleteRegKey(HKEY, char*);
extern bool InfoMsg(bool pbWait, const char * caption, const char * ok, const char *fmt,...);
