;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                     BFC.ASM                     
;                                                 
;               Binary File Compare               
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

BufferSize	equ	64512
ProgramSize	equ	4096

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@15
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@15:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	bl, -1
		xor	di, di
		call	ParamStr
		cmp	bh, 2
		jae	@01
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		xor	al, al
		jmp	@02
@01:		mov	bl, 3
		mov	di, Offset Parameter
		mov	cx, 2
		call	ParamStr
		mov	si, Offset Parameter
		lodsb
		cmp	al, '-'
		je	@11
		cmp	al, '/'
		jne	@12
@11:		lodsb
		call	UpCase
		cmp	al, 'Q'
		jne	@12
		mov	Quiet, 1
@12:		mov	bl, 2
		mov	di, Offset Parameter
		mov	cx, 79
		call	ParamStr
		mov	si, Offset Parameter
		mov	di, Offset Dir2
		mov	bx, Offset Name2
		mov	bp, Offset Ext2
		call	SplitName
		mov	bl, 1
		mov	di, Offset Parameter
		mov	cx, 79
		call	ParamStr
		mov	si, Offset Parameter
		mov	di, Offset Dir1
		mov	bx, Offset Name1
		mov	bp, Offset Ext1
		call	SplitName
		mov	dx, Offset Parameter
		mov	cx, 27h
		mov	ah, 4Eh
		int	21h
		jnc	@04
		mov	bx, Offset Parameter
		mov	dx, Offset FName1
		mov	cx, 69
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@03
@04:		mov	si, 009Eh
		xor	di, di
		mov	bx, Offset Name1
		mov	bp, Offset Ext1
		call	FSplit
		mov	di, Offset FName1
		mov	cx, 79
		mov	si, Offset Dir1
		clc
		call	StrCopy
		mov	si, Offset Name1
		clc
		call	StrCopy
		mov	si, Offset Ext1
		stc
		call	StrCopy
		mov	di, Offset FName2
		mov	cx, 79
		mov	si, Offset Dir2
		clc
		call	StrCopy
		mov	si, Offset Name2
		mov	bx, Offset Name1
		clc
		call	CloneName
		mov	si, Offset Ext2
		mov	bx, Offset Ext1
		stc
		call	CloneName
		mov	dx, Offset Comparing
		mov	ah, 9
		int	21h
		mov	bx, Offset FName1
		mov	dx, Offset Parameter
		mov	cx, 32
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Conjunctive
		mov	ah, 9
		int	21h
		mov	bx, Offset FName2
		mov	dx, Offset Parameter
		mov	cx, 32
		call	MakeName
		stc
		call	PrintStr
		mov	dx, Offset FName1
		mov	ax, 3D00h
		int	21h
		jnc	@05
		jmp	@06
@05:		mov	si, ax
		mov	dx, Offset FName2
		mov	ax, 3D00h
		int	21h
		jnc	@08
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		mov	bx, Offset FName2
		mov	dx, Offset Parameter
		mov	cx, 67
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		mov	ah, 9
		int	21h
		jmp	@07
@08:		mov	di, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jc	@13
		mov	Buffer1, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@14
@13:		mov	dx, Offset NoMemory
		jmp	@03
@14:		mov	Buffer2, ax
		mov	bx, si
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	word ptr Length1[0], ax
		mov	word ptr Length1[2], dx
		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	bx, di
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	word ptr Length2[0], ax
		mov	word ptr Length2[2], dx
		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	ax, word ptr Length1[0]
		mov	dx, word ptr Length1[2]
		mov	bx, word ptr Length2[0]
		mov	cx, word ptr Length2[2]
		cmp	dx, cx
		ja	@10
		jne	@09
		cmp	ax, bx
		jbe	@09
@10:		mov	ax, bx
		mov	dx, cx
@09:		mov	word ptr ReadLen[0], ax
		mov	word ptr ReadLen[2], dx
		xor	ax, ax
		mov	word ptr Diff[0], ax
		mov	word ptr Diff[2], ax
		mov	word ptr Pos[0], ax
		mov	word ptr Pos[2], ax
		call	Percent
		call	Escape
@23:		cmp	EscHit, 0
		je	@27
		jmp	@17
@27:		mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		mov	bx, word ptr Pos[0]
		mov	cx, word ptr Pos[2]
		sub	ax, bx
		sbb	dx, cx
		jnc	@24
		jmp	@17
@24:		or	dx, dx
		jne	@18
		or	ax, ax
		jne	@25
		jmp	@17
@25:		cmp	ax, BufferSize
		jbe	@19
@18:		mov	ax, BufferSize
@19:		mov	cx, ax
		mov	bx, si
		mov	ax, Buffer1
		call	BlockRead
		mov	bx, di
		mov	ax, Buffer2
		call	BlockRead
		call	Escape
		cmp	EscHit, 0
		je	@32
		jmp	@17
@32:		xor	bx, bx
@22:		push	ds
		mov	ds, cs:Buffer1
		mov	al, [bx]
		mov	ds, cs:Buffer2
		mov	ah, [bx]
		pop	ds
		cmp	al, ah
		je	@20
		push	cx
		push	bx
		cmp	Quiet, 0
		jne	@28
		push	ax
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		mov	ax, word ptr Pos[0]
		mov	dx, word ptr Pos[2]
		mov	cx, 0830h
		call	HexStr
		clc
		call	PrintStr
		mov	dx, Offset Colon
		mov	ah, 9
		int	21h
		pop	ax
		push	ax
		xor	ah, ah
		xor	dx, dx
		mov	cx, 0230h
		call	HexStr
		clc
		call	PrintStr
		mov	dl, ' '
		mov	ah, 2
		int	21h
		pop	ax
		mov	al, ah
		xor	ah, ah
		xor	dx, dx
		mov	cx, 0230h
		call	HexStr
		stc
		call	PrintStr
@28:		inc	word ptr Diff[0]
		jne	@26
		inc	word ptr Diff[2]
		call	Escape
@26:		pop	bx
		pop	cx
@20:		inc	bx
		inc	word ptr Pos[0]
		jne	@21
		inc	word ptr Pos[2]
@21:		dec	cx
		je	@33
		jmp	@22
@33:		call	Percent
		jmp	@23
@17:		push	es
		mov	es, Buffer1
		mov	ah, 49h
		int	21h
		mov	es, Buffer2
		mov	ah, 49h
		int	21h
		pop	es
		xor	al, al
		cmp	EscHit, 0
		je	@38
		jmp	@02
@38:		mov	ax, word ptr Diff[0]
		mov	dx, word ptr Diff[2]
		or	ax, dx
		je	@29
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		mov	bx, Offset FName1
		mov	dx, Offset Parameter
		mov	cx, 23
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Conjunctive
		mov	ah, 9
		int	21h
		mov	bx, Offset FName2
		mov	dx, Offset Parameter
		mov	cx, 23
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Differ
		mov	ah, 9
		int	21h
		mov	ax, word ptr Diff[0]
		mov	dx, word ptr Diff[2]
		call	DecStr
		clc
		call	PrintStr
		mov	dx, Offset Bytes
		mov	ah, 9
		int	21h
		mov	ax, word ptr Diff[0]
		mov	dx, word ptr Diff[2]
		or	dx, dx
		jne	@30
		cmp	ax, 1
		je	@31
@30:		mov	dl, 's'
		mov	ah, 2
		int	21h
@31:		mov	dx, Offset LineFeed
		mov	ah, 9
		int	21h
@29:		mov	bx, Offset FName1
		mov	cx, Offset FName2
		mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		cmp	dx, word ptr Length1[2]
		ja	@35
		jne	@36
		cmp	ax, word ptr Length1[0]
		jae	@35
@36:		call	PrintLonger
		jmp	@37
@35:		cmp	dx, word ptr Length2[2]
		ja	@37
		jne	@34
		cmp	ax, word ptr Length2[0]
		jae	@37
@34:		xchg	bx, cx
		call	PrintLonger
@37:		mov	bx, di
		mov	ah, 3Eh
		int	21h
@07:		mov	bx, si
		mov	ah, 3Eh
		int	21h
@06:		xor	al, al
		cmp	EscHit, 0
		jne	@02
		mov	ah, 4Fh
		int	21h
		jc	@02
		jmp	@04
@03:		mov	ah, 9
		int	21h
		mov	al, 1
		jmp	@39
@02:		xor	al, al
@39:		push	ax
		call	ClrLine
		pop	ax
		mov	ah, 4Ch
		int	21h

PrintLonger:	push	cx
		push	bx
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		pop	bx
		mov	dx, Offset Parameter
		mov	cx, 30
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Longer
		mov	ah, 9
		int	21h
		pop	bx
		mov	dx, Offset Parameter
		mov	cx, 30
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset LineFeed
		mov	ah, 9
		int	21h
		retn

BlockRead:	push	ds
		push	dx
		mov	ds, ax
		xor	dx, dx
		mov	ah, 3Fh
		int	21h
		pop	dx
		pop	ds
		retn

Escape:		mov	ah, 1
		int	16h
		je	@01_Escape
		xor	ah, ah
		int	16h
		cmp	ax, 011Bh
		jne	@01_Escape
		mov	EscHit, 1
@01_Escape:	retn

ClrLine:	mov	dl, 13
		mov	ah, 2
		int	21h
		mov	cx, 79
		mov	dl, ' '
@01_ClrLine:	int	21h
		loop	@01_ClrLine
		mov	dl, 13
		mov	ah, 2
		int	21h
		retn

Percent:	mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		mov	cx, 100
		xor	bx, bx
		call	LongDiv
		jc	@01_Percent
		or	ax, ax
		jne	@02_Percent
		or	dx, dx
		je	@03_Percent
@02_Percent:	mov	cx, ax
		mov	bx, dx
		mov	ax, word ptr Pos[0]
		mov	dx, word ptr Pos[2]
		call	LongDiv
		cmp	al, 100
		jbe	@04_Percent
@03_Percent:	mov	al, 100
@04_Percent:	push	ax
		mov	dl, ' '
		mov	ah, 2
		int	21h
		pop	ax
		xor	dx, dx
		mov	bx, 10
		mov	cx, 0320h
		call	NumStr
		call	PrintStr
		cmp	al, 100
		mov	dx, Offset Complete
		mov	ah, 9
		int	21h
@01_Percent:	retn

HexStr:		mov	bx, 10h
		jmp	NumStr
DecStr:		mov	bx, 10
		xor	cx, cx
NumStr:		push	si
		push	di
		push	cx
		mov	si, bx
		mov	di, Offset NumStrBuffer[10]
		mov	byte ptr [di], 0
		mov	cx, di
		mov	bx, dx
@01_NumStr:	xor	dx, dx
		xchg	bx, ax
		div	si
		xchg	bx, ax
		div	si
		add	dl, '0'
		cmp	dl, '9'
		jbe	@02_NumStr
		add	dl, 'A' - '0' - 10
@02_NumStr:	dec	di
		mov	[di], dl
		mov	dx, ax
		or	dx, bx
		jne	@01_NumStr
		sub	cx, di
		pop	bx
		or	bh, bh
		je	@03_NumStr
		sub	bh, cl
		jbe	@03_NumStr
@04_NumStr:	dec	di
		mov	byte ptr [di], bl
		inc	cx
		dec	bh
		jne	@04_NumStr
@03_NumStr:	mov	dx, di
		pop	di
		pop	si
		retn

FSplit:		mov	dx, si
		call	StrLen
		add	si, ax
		dec	si
		xor	cx, cx
		std
@04_FSplit:	cmp	si, dx
		jb	@01_FSplit
		lodsb
		cmp	al, '.'
		jne	@02_FSplit
		or	cx, cx
		jne	@02_FSplit
		mov	cx, si
		inc	cx
@02_FSplit:	cmp	al, '\'
		je	@03_FSplit
		cmp	al, ':'
		jne	@04_FSplit
@03_FSplit:	inc	si
@01_FSplit:	inc	si
		or	cx, cx
		jne	@05_FSplit
		mov	cx, dx
		xchg	si, dx
		call	StrLen
		xchg	si, dx
		add	cx, ax
@05_FSplit:	xchg	si, dx
		sub	cx, dx
		sub	dx, si
		push	cx
		mov	cx, 67
		stc
		call	StrPartCopy
		mov	di, bx
		pop	dx
		mov	cx, 8
		stc
		call	StrPartCopy
		mov	di, bp
		mov	cx, 4
		stc
		call	StrCopy
		retn

SplitName:	push	si
		push	di
		push	bx
		push	bp
		call	FSplit
		pop	bp
		pop	bx
		pop	si
		pop	di
		mov	ax, ds:[bp]
		or	al, al
		jne	@02_SplitName
		mov	al, [bx]
		or	al, al
		jne	@01_SplitName
		mov	ax, '*'
		mov	[bx], ax
		mov	ds:[bp][1], ax
		mov	al, '.'
		mov	ds:[bp], al
		jmp	@01_SplitName
@02_SplitName:	cmp	ax, '.'
		jne	@01_SplitName
		mov	ds:[bp], ah
@01_SplitName:	mov	cx, 79
		clc
		call	StrCopy
		mov	si, bx
		clc
		call	StrCopy
		mov	si, bp
		stc
		call	StrCopy
		retn

CloneName:	cld
		pushf
@04_CloneName:	mov	ah, [si]
		or	ah, ah
		je	@01_CloneName
		mov	al, [bx]
		cmp	ah, '?'
		je	@02_CloneName
		cmp	ah, '*'
		je	@03_CloneName
		mov	al, ah
@02_CloneName:	inc	si
@03_CloneName:	cmp	byte ptr [bx], 0
		je	@06_CloneName
		inc	bx
@06_CloneName:	or	al, al
		je	@01_CloneName
		stosb
		loop	@04_CloneName
@01_CloneName:	cmp	byte ptr [di][-1], 2Eh
		jne	@07_CloneName
		dec	di
@07_CloneName:	popf
		jnc	@05_CloneName
		xor	al, al
		stosb
@05_CloneName:	retn

MakeName:	push	si
		push	di
		mov	si, bx
		mov	di, dx
		call	StrLen
		cmp	al, cl
		jbe	@02_MakeName
		add	si, ax
		sub	si, cx
		add	si, 6
		add	di, 3
		mov	ax, 2E2Eh
		stosw
		stosb
@02_MakeName:	lodsb
		stosb
		or	al, al
		jne	@02_MakeName
@01_MakeName:	pop	di
		pop	si
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
		call	UpCase
		stosb
		lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

LongDiv:	push	si
		push	di
		xor	dx, bx
		pushf
		xor	dx, bx
		pushf
		jns	@01_LongDiv
		not	dx
		neg	ax
		sbb	dx, -1
@01_LongDiv:	or	bx, bx
		jns	@02_LongDiv
		not	bx
		neg	cx
		sbb	bx, -1
@02_LongDiv:	jne	@03_LongDiv
		cmp	dx, cx
		jb	@04_LongDiv
		jcxz	@10_LongDiv
		xchg	ax, bx
		xchg	ax, dx
		div	cx
		xchg	ax, bx
@04_LongDiv:	div	cx
		mov	cx, dx
		mov	dx, bx
		xor	bx, bx
		jmp	@05_LongDiv
@03_LongDiv:	push	dx
		push	ax
		mov	si, cx
		mov	di, bx
		or	bh, bh
		je	@06_LongDiv
		mov	cl, ch
		mov	ch, bl
		mov	bl, bh
		xor	bh, bh
		mov	al, ah
		mov	ah, dl
		mov	dl, dh
		mov	dh, bh
@06_LongDiv:	shr	dx, 1
		rcr	ax, 1
		shr	bx, 1
		rcr	cx, 1
		jne	@06_LongDiv
		div	cx
		mov	cx, ax
		mov	bx, ax
		mul	di
		xchg	ax, cx
		mul	si
		add	dx, cx
		pop	cx
		sub	cx, ax
		mov	ax, bx
		pop	bx
		sbb	bx, dx
		jnb	@07_LongDiv
		add	cx, si
		adc	bx, di
		dec	ax
@07_LongDiv:	xor	dx, dx
@05_LongDiv:	popf
		jns	@08_LongDiv
		not	bx
		neg	cx
		sbb	bx, -1
@08_LongDiv:	popf
		jns	@09_LongDiv
		not	dx
		neg	ax
		sbb	dx, -1
@09_LongDiv:	clc
		jmp	@11_LongDiv
@10_LongDiv:	stc
@11_LongDiv:	pop	di
		pop	si
		retn

Hello		db	'Binary File Compare by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program compares two binary files similarly to DOS''s  FC /B  command.  You', 13, 10
		db	'can also use wildcards in both filenames. Use the  /Q  option  for  quiet  mode', 13, 10
		db	'(only the number of differences will be displayed).', 13, 10, 13, 10
		db	'Usage: BFC <filename1> <filename2> [/Q]', 13, 10, '$'
NotFound	db	' not found', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
Comparing	db	'Comparing $'
Conjunctive	db	' and $'
Complete	db	'% complete', 13, '$'
Differ		db	' differ in $'
Bytes		db	' byte$'
Longer		db	' is longer than $'
Indent		db	'  $'
Colon		db	': $'
LineFeed	db	13, 10, '$'

DataStart:

Quiet		db	?
EscHit		db	?
Pos		dd	?
Diff		dd	?
ReadLen		dd	?
Length1		dd	?
Length2		dd	?
Buffer1		dw	?
Buffer2		dw	?
NumStrBuffer	db	10 + 1 dup (?)
Parameter	db	79 + 1 dup (?)
FName1		db	79 + 1 dup (?)
FName2		db	79 + 1 dup (?)
Dir1		db	79 + 1 dup (?)
Dir2		db	79 + 1 dup (?)
Name1		db	8 + 1 dup (?)
Name2		db	8 + 1 dup (?)
Ext1		db	4 + 1 dup (?)
Ext2		db	4 + 1 dup (?)

DataEnd:

CSeg		ends

		end	Main
