#include "Headers.h"
#include "Macros.h"
#include "AnotherPlugin.h"
#include "Globals.h"

unsigned long GetFileSize(char *Path)
{
	HANDLE hF = CreateFile(Path, GENERIC_READ, 0, 0, OPEN_EXISTING, 0, 0);
    if (hF == INVALID_HANDLE_VALUE)
    	return 0;
	ULONG size = GetFileSize(hF, 0);
	if (size == (ULONG)-1)
		size = 0;
	CloseHandle(hF);
	return size;
}

char *LoadFileToMem(char *Path, char **peob)
{
	*peob = 0;
	ULONG size = GetFileSize(Path);
	FILE *F = fopen(Path, "rb");
	if (!size || !F)
		return 0;
	char *buf = new char [size];
	if (fread(buf, size, 1, F) == 1)
	{
		*peob = buf + size - 1;
    }
	else
	{
		delete [] buf;
		buf = 0;
	};
	fclose(F);
	return buf;
}

inline bool IsEOL(char c)
{
	return c == '\n' || c == '\r';
}

char *FindStrEnd(char *s, char *last)
{
	if (!s)
		return 0;
	while (!IsEOL(*s) && s != last)
		s++;
	if (s != last)
		--s;
	return s;
}

char *FindNextStr(char *s, char *last)
{
	if (!s)
		return 0;
	if (s != last)
		s++;
	while (IsEOL(*s) && s != last)
		s++;
	return s;
}

bool FindQuotedSubstr(char *b, char *e, char **pqb, char **pqe)
{
	char *qb = 0, *qe = 0, *p;
	for (p = b; p < e; p++)
		if (*p == '\"')
		{
			qb = p;
			break;
		};
	for (p = e; p > b; p--)
		if (*p == '\"')
		{
			qe = p;
			break;
		};
	if (!qb || !qe || qb == qe)			
		return false;
	*pqb = qb + 1;
	*pqe = qe - 1;
	return true;
}

int ScanMsgsBuf(char *buf, char *eob, char **pMsgs = 0)
{
	char *b = buf, *e;
	char *qb, *qe;
	int c = 0;
	while (b != eob)
	{
		e = FindStrEnd(b, eob);
		if (FindQuotedSubstr(b, e, &qb, &qe))
		{
			if (pMsgs)
			{
				int len = qe - qb + 1;
				char *pnew = new char [len + 1];
				strncpy(pnew, qb, len);
				pnew[len] = 0;
                pMsgs[c] = pnew;
            };
            c++;
		};
		b = FindNextStr(e, eob);		
    };
    return c;
}

char **LoadMsgsFromFile(char *Path, int *pSize)
{
	char *eob;
	char *buf = LoadFileToMem(Path, &eob);
	if (!buf)
		return NULL;
	int Size = ScanMsgsBuf(buf, eob);
	char **Msgs = new char* [Size];
	ScanMsgsBuf(buf, eob, Msgs);
	delete [] buf;
	*pSize = Size; // ᭮,  ⮬ ਣ
	return Msgs;
}

