#include "Headers.h"
#include "Macros.h"
#include "AnotherPlugin.h"
#include "Utility.h"
#include "Globals.h"

CAnotherPlugin *pAnotherPlugin = NULL;
static HANDLE hServerThr = NULL;

extern "C"
int UnloadPlugin()
{
	if (pAnotherPlugin)
	{
		delete pAnotherPlugin;
		pAnotherPlugin = 0;
	}
	return TRUE;
}

extern "C"
int LoadPlugin(char *Path)
{
	if (pAnotherPlugin)
		UnloadPlugin();
	pAnotherPlugin = CAnotherPlugin::CreateInstance(Path);
	if (pAnotherPlugin)
		pAnotherPlugin->SetStartupInfo(&InfoStub);
	return pAnotherPlugin? TRUE: FALSE;
}

char* WINAPI GetMsgStub(int PluginNumber, int MsgId)
{
	(PluginNumber);
	return pAnotherPlugin->GetMsgStub(MsgId);
}

HANDLE WINAPI OpenPlugin(int OpenFrom, int Item)
{
	if (pAnotherPlugin)
		return pAnotherPlugin->OpenPlugin(OpenFrom, Item);
    return INVALID_HANDLE_VALUE;
};

void WINAPI GetPluginInfo(struct PluginInfo *Info)
{
	Info->StructSize = sizeof(*Info);
	if (pAnotherPlugin)
		pAnotherPlugin->GetPluginInfo(Info);
	Info->Flags |= PF_PRELOAD;
};

DWORD WINAPI ServerThread(LPVOID)
{
	char szMailslot[32]; 
	wsprintf(szMailslot, "\\\\.\\mailslot\\%0x", GetCurrentThreadId());
	hMailslot = CreateMailslot(szMailslot, 0, MAILSLOT_WAIT_FOREVER, NULL);
    SetEnvironmentVariable("betatest", szMailslot);	
	char buf[_MAX_PATH]; DWORD bytes;
	while (ReadFile(hMailslot, buf, sizeof(buf), &bytes, NULL))
	{
		buf[bytes] = 0;
		if (buf[0]=='~' && buf[1]==0)
			UnloadPlugin();
		else if (buf[0]=='@' && buf[1]==0)
			break; // exit
		else
			LoadPlugin(buf);
	}
	CloseHandle(hMailslot);
	return 0;
}

void WINAPI SetStartupInfo(struct PluginStartupInfo *Info1)
{
	// StartupInfo
	memcpy(&Info, Info1, Info1->StructSize);
	if (Info1->StructSize == sizeof(Info))
		FSF = *Info1->FSF;
    Info.FSF = &FSF;
	InfoStub = Info;
	InfoStub.GetMsg = GetMsgStub;
	InfoStub.FSF = &FSF;

	// Server thread setup
	DWORD ThrId;
	hServerThr = CreateThread(NULL, 0, ServerThread, NULL, 0, &ThrId);
};

void WINAPI ExitFAR()
{
	if (pAnotherPlugin)
		pAnotherPlugin->ExitFAR();
	char value[100];
	GetEnvironmentVariable("betatest", value, sizeof(value));
	HANDLE h = CreateFile(value, GENERIC_WRITE, FILE_SHARE_READ, NULL, 
    	OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,NULL); 
	DWORD bytes;
    WriteFile(h, "@", 2, &bytes, NULL); // shutdown server thread
    CloseHandle(h);
    WaitForSingleObject(hServerThr, INFINITE);
};

#include "Stubs.inc"
