#ifndef MACROS_H
#define MACROS_H

#define PROC(P) P##Proc proc = (P##Proc)ExportAddress[Export_##P]
#define CONTROL(CMD,PARAM) Info.Control(INVALID_HANDLE_VALUE, CMD, (void *)PARAM)

// EXPORT_NAME
// EXPORT_PARAMS_DESC
// EXPORT_PARAMS
// EXPORT_RETVAL_TYPE
// EXPORT_RETVAL_DEFAULT
#define EXPORT_STUB_IMPL_(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS, EXPORT_RETVAL_TYPE, EXPORT_RETVAL_DEFAULT) \
extern "C" \
EXPORT_RETVAL_TYPE WINAPI _export EXPORT_NAME EXPORT_PARAMS_DESC   \
{                                                                  \
	if (pAnotherPlugin)                                            \
		return pAnotherPlugin-> EXPORT_NAME EXPORT_PARAMS;     	   \
	return EXPORT_RETVAL_DEFAULT;                                  \
}

// EXPORT_NAME
// EXPORT_PARAMS_DESC
// EXPORT_PARAMS
#define EXPORT_STUB_IMPL(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS) \
extern "C" \
void WINAPI _export EXPORT_NAME EXPORT_PARAMS_DESC   \
{                                                                 \
	if (pAnotherPlugin)                                           \
		pAnotherPlugin-> EXPORT_NAME EXPORT_PARAMS;               \
	return;                                                       \
}

#define CLASSIMPL(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS) \
void CAnotherPlugin::EXPORT_NAME EXPORT_PARAMS_DESC               \
{                                                                 \
	PROC(EXPORT_NAME);                                            \
	if (proc)                                                     \
	{                                                             \
		proc EXPORT_PARAMS;                                       \
	}                                                             \
}

#define CLASSIMPL_(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS, EXPORT_RETVAL_TYPE, EXPORT_RETVAL_DEFAULT) \
EXPORT_RETVAL_TYPE CAnotherPlugin::EXPORT_NAME EXPORT_PARAMS_DESC \
{                                                                 \
	PROC(EXPORT_NAME);                                            \
	if (proc)                                                     \
	{                                                             \
		EXPORT_RETVAL_TYPE Ret = proc EXPORT_PARAMS;              \
		return Ret;                                               \
	}                                                             \
	return EXPORT_RETVAL_DEFAULT;                                 \
}

#define TYPEDEF_(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS, EXPORT_RETVAL_TYPE, EXPORT_RETVAL_DEFAULT) \
	typedef EXPORT_RETVAL_TYPE (WINAPI *EXPORT_NAME##Proc) EXPORT_PARAMS_DESC

#define TYPEDEF(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS) \
	TYPEDEF_(EXPORT_NAME, EXPORT_PARAMS_DESC, EXPORT_PARAMS, void, NULL)

#endif // MACROS_H
