#include "Headers.h"
#include "Macros.h"
#include "AnotherPlugin.h"
#include "Globals.h"
#include "Utility.h"

#include "ExportNames.inc"

CAnotherPlugin *CAnotherPlugin::CreateInstance(char *Path)
{
    CAnotherPlugin *pAnotherPlugin = new CAnotherPlugin(Path);
    if (!pAnotherPlugin->hDll)
    {
    	delete pAnotherPlugin;
    	return NULL;
    };

    //  ⮩  ४ਨ 쬥 .lng 䠩, ਣ
    // todo - প  .lng 䠩
	WIN32_FIND_DATA fd;

    char P[_MAX_DIR], SearchMask[_MAX_PATH], BasePath[_MAX_PATH];
	_splitpath(Path, BasePath, P, 0, 0);
	strcat(BasePath, P);
	strcpy(SearchMask, BasePath);
	strcat(SearchMask, "*.lng");
    HANDLE hff = FindFirstFile(SearchMask, &fd);
    if (hff != INVALID_HANDLE_VALUE)
    {
    	char LngFile[_MAX_PATH];
    	strcpy(LngFile, BasePath);
    	strcat(LngFile, fd.cFileName);
    	pAnotherPlugin->LoadLangFromFile(LngFile);
    	FindClose(hff);
    };
    strcpy(InfoStub.ModuleName, Path);

    return pAnotherPlugin;
};

CAnotherPlugin::CAnotherPlugin(char *Path)
{
	hDll = LoadLibrary(Path);
	if (!hDll)
		return;
	for (int i = 0; i < Export_Count; i++)
	{
		void *proc = GetProcAddress(hDll, ExportName[i]);
		ExportAddress[i] = proc;
    };		
    Msgs = NULL;
    MsgsNumber = 0;
};

CAnotherPlugin::~CAnotherPlugin()
{
	UnloadLang();
	FreeLibrary(hDll);
};

HANDLE CAnotherPlugin::OpenPlugin(int OpenFrom, int Item)
{
	HANDLE ret = INVALID_HANDLE_VALUE;
	OpenPluginProc proc = (OpenPluginProc)ExportAddress[Export_OpenPlugin];
	if (proc)
	{
		ret = proc(OpenFrom, Item);
	}
	return(ret);
};

void CAnotherPlugin::GetPluginInfo(struct PluginInfo *Info)
{
	PROC(GetPluginInfo);
	if (proc)
	{
		proc(Info);
	}
	// xxx else warn
};

void CAnotherPlugin::SetStartupInfo(struct PluginStartupInfo *Info)
{
	PROC(SetStartupInfo);
	if (proc)
	{
		proc(Info);
	}
};

void CAnotherPlugin::LoadLangFromFile(char *Path)
{
	Msgs = LoadMsgsFromFile(Path, &MsgsNumber);
};

void CAnotherPlugin::UnloadLang()
{
	if (MsgsNumber)
	{
		for (int i = 0; i < MsgsNumber; i++)
			delete [] Msgs[i];
		delete [] Msgs;
		Msgs = NULL;
		MsgsNumber = 0;
	};						
}

char *CAnotherPlugin::GetMsgStub(int MsgId)
{
	static char *sEmpty = "";
	if (!Msgs || MsgId >= MsgsNumber)
		return sEmpty;
	return Msgs[MsgId];	
}

#include "ClassImpl.inc"
