;PROC.INC (procedures for binary file compare utility)
;(version 1.01 (offset bug fix))
;----------------------------------------------------------------------------
; IN:   si=pointer to source value in ds
;       di=pointer to location for result in es
;       cx=number of bytes to do
;----------------------------------------------------------------------------
PROC    bin2hex         NEAR            
        dec     cx
        add     di,cx
        add     di,cx
        inc     cx
b2ha1:  cld
        push    cx                      ;AL = first nibble of binary
        lodsb                           ;BL = second nibble of binary
        xor     bl,bl                   ;
        mov     cx,4                    ;
b2ha2:  shr     al,1                    ;
        rcr     bl,1                    ;
        loop    b2ha2                   ;
        mov     cl,4                    ;
        shr     bl,cl                   ;
        pop     cx                      ;
       
b2ha3:  add     al,030h                 ;AL = first byte of ascii
        cmp     al,039h                 ;
        jbe     b2ha4                   ;
        add     al,7                    ;
b2ha4:  add     bl,030h                 ;BL = second byte of ascii
        cmp     bl,039h                 ;
        jbe     b2ha5                   ;
        add     bl,7                    ;

b2ha5:  mov     ah,bl                   ;
        std     
        stosw
        loop    b2ha1                   ;Do it again if neciciary
        
        cld        
        ret        
ENDP    bin2hex     
;----------------------------------------------------------------------------
; IN:   si=pointer to last digit of source value in ds
;          (value must have a 'x' or a '=' at the start)
;       di=pointer to location for result in es (32bit)
;----------------------------------------------------------------------------
PROC    hex2bin         NEAR
        push    di
        std                             ;Kill that 'h' at the end
        lodsb                           ;
        cmp     al,"H"                  ;
        je      h2b0                    ;
        cmp     al,"h"                  ;
        je      h2b0                    ;
        inc     si                      ;
        
h2b0:   dec     si                      ;Get to start of last word in ascii
        mov     cx,4                    ;

h2br:   std
        lodsw                           ;Load two bytes ascii (1 binary)
        cmp     ah,"x"                  ;Is it the start of the thingo
        je      h2be                    ;
        cmp     ah,"="                  ;
        je      h2be                    ;

        cmp     al,060h                 ;Make lowercase into uppercase
        jbe     h2b01                   ;
        sub     al,020h                 ;
h2b01:  cmp     ah,060h                 ;
        jbe     h2b02                   ;
        sub     ah,020h                 ;

h2b02:  cmp     ah,039h                 ;AH=Low nibble of byte
        jbe     h2b1                    ;
        sub     ah,7                    ;
h2b1:   sub     ah,030h                 ;

        cmp     al,"x"                  ;Is it the start of the thingo
        je      h2b11                   ;
        cmp     al,"="                  ;
        jne     h2b2                    ;

h2b11:  mov     cx,1                    ;If its the start fix it
        mov     al,030h                 ;

h2b2:   cmp     al,039h                 ;AL=High nibble of byte
        jbe     h2b3                    ;
        sub     al,7                    ;
h2b3:   sub     al,030h                 ;

        push    cx                      ;Get resulting byte
        mov     cl,4                    ;
        shl     al,cl                   ;
        add     al,ah                   ;
        pop     cx                      ;
        
        cld                             ;
        stosb                           ;Store it!

        loop    h2br                    ;Do it again!

h2be:   cld                             ;Get number of bytes left in the 
        pop     cx                      ;double
        add     cx,4                    ;
        sub     cx,di                   ;
        
h2be1:  jcxz    h2be2                   ;zero them out
        xor     al,al                   ;
        stosb                           ;
        dec     cx                      ;
        jmp     h2be1                   ;

h2be2:  ret        
ENDP    hex2bin     
;----------------------------------------------------------------------------
PROC    writeclear      NEAR
        mov     ah,040h                 ;Write line
        mov     bx,1                    ;
        mov     cx,81                   ;
        mov     dx,offset cline         ;  
        int     21h                     ;
        jnc     wl1                     ;
        mov     dx,offset stdouterror   ;
        jmp     error                   ;

wl1:    mov     cx,16                   ;Clear file1 area
        mov     di,F1Hstart             ;
        mov     ax,02020h               ;
        rep     stosw                   ;
        
        mov     cx,16                   ;Clear file2 area
        mov     di,F2Hstart             ;
        rep     stosw                   ;
        
        ret
ENDP    writeclear
;----------------------------------------------------------------------------
PROC    asciify         NEAR    
        cmp     [BYTE BX],00h          ;Is it a non-visable character ?
        je      @ok1                   ;
        cmp     [BYTE BX],01h          ;
        je      @ok1                   ;
        cmp     [BYTE BX],07h          ;
        je      @ok1                   ;
        cmp     [BYTE BX],08h          ;
        je      @ok1                   ;
        cmp     [BYTE BX],09h          ;
        je      @ok1                   ;
        cmp     [BYTE BX],0Ah          ;
        je      @ok1                   ;
        cmp     [BYTE BX],0Dh          ;
        je      @ok1                   ;
        cmp     [BYTE BX],01Ah         ;
        je      @ok1                   ;
        cmp     [BYTE BX],0FFh         ;
        je      @ok1                   ;
        jmp     @ok0                   ;
@ok1:   mov     [BYTE BX],0F9h         ;If so make it a small dot thingo
@ok0:   ret                            ;(could be 0FAh for smaller dot)
ENDP    asciify
;----------------------------------------------------------------------------
