;============================================================================
; Compares two files and finds the differences (version 1.01 (offset bug fix))
;============================================================================

    .MODEL TINY
    .CODE
    ORG 100h
    Ideal

START:
;==[ Main Code ]=============================================================
        
        
        mov     ah,04Ah                 ;Resize memory
        mov     bx,129                  ;(com size + 100h + 30 byte stack)/16
        int     21h                     ;

        mov     sp,2062                 ;New place for the stack
                   
        xor     cx,cx                   ;Put number of bytes on command line
        mov     cl,[080h]               ;into CX
        
        mov     si,081h                 ;Get source index ready
        xor     dx,dx                   ;Counter for paramaters
        xor     bx,bx                   ;Reg for start pointer

        cmp     cx,0                    ;If no param's disp message
        jne     cl0                     ;
        jmp     msg                     ;
        
cl0:    inc     cx                      ;Add 1 to cx so it works with stuff

cl1:    dec     cx                      ;Get start of a paramater
        jcxz    ascan                   ;
        lodsb                           ;
        cmp     al,020h                 ;
        je      cl1                     ;
        
        mov     bx,si                   ;Put the starting pointer in BX
        dec     bx                      ;

cl2:    dec     cx                      ;Get end if a paramater
        jcxz    cl3                     ;
        lodsb                           ;
        cmp     al,020h                 ;
        jne     cl2                     ;
                                        
cl3:    mov     ax,si                   ;Put ending pointer in AX
        jcxz    cl35                    ;
        dec     ax                      ;
cl35:   dec     ax                      ;
        
        push    ax                      ;Ending pointer on stack
        push    bx                      ;Starting pointer on top of stack
        
        inc     dx                      ;Inc paramater counter
        cmp     dx,7                    ;Check that there are not too
        jne     tok1                    ;many paramaters
        mov     dx,offset paramerror    ;
        jmp     ERROR                   ;
tok1:                                   ;

        cmp     cx,0                    ;If more paramaters go get 'em
        jne     cl1                     ;

        ;DX = number of paramaters found
        ;Stack = Param1start, Param1end, Param2start, Param2end, Param3start,

ascan:  cmp     dx,0                    ;If there are no paramaters,
        je      msg                     ;display syntax message

        mov     cx,dx                   ;Put number of params into CX
        
para:   pop     si                      ;Get first byte of paramater
        lodsb                           ;
        cmp     al,"/"                  ;
        je      switch                  ;
        
        dec     si                      ;SI = start of paramater

        pop     ax                      ;Pointer to last byte in AX
        push    ax                      ;
        
        sub     ax,si                   ;AX = number of byte in paramater
        inc     ax                      ;

        mov     di,si                   ;Place to move to
        dec     di                      ;
        push    di                      ;Stack = newstart,newend
        push    cx                      ;CX = number of bytes to move back
        mov     cx,ax                   ;

cl4:    lodsb                           ;Move filename back one byte
        stosb                           ;
        loop    cl4                     ;
        
        pop     cx                      ;Restore CX
        
        cmp     [F2Handle],0            ;Put a pointer to the start
        jne     cf2                     ;of the ASCIIZ filename in
        pop     [F2Handle]              ;the files handle variable
        jmp     cc1                     ;
cf2:    pop     [F1Handle]              ;

cc1:    pop     di                      ;Make it ASCIIZ
        xor     ax,ax                   ;
        stosb                           ;

        loop    para                    ;Go get next paramater
        jmp     aall                    ;Else go to after all

switch: lodsb                           ;Get next byte and find out
        pop     si                      ;Get ready for hex2bin
        cmp     al,"1"                  ;which switch it is
        je      s1                      ;
        cmp     al,"2"                  ;
        je      s2                      ;
        cmp     al,"n"                  ;
        je      sn                      ;
        cmp     al,"N"                  ;
        je      sn                      ;
        
        mov     dx,offset paramerror    ;If none of those do an error
        jmp     ERROR                   ;
        
S1:     mov     di,offset F1Start       ;Get the value from the param
        jmp     SA                      ;
S2:     mov     di,offset F2Start       ;
        jmp     SA                      ;
SN:     mov     di,offset Nbytes        ;
SA:     push    cx                      ;
        call    hex2bin                 ;
        pop     cx                      ;

        loop    para                    ;Go get the next paramater
        jmp     aall                    ;Else go to after all
        
msg:    mov     ah,9                    ;Write message then end
        mov     dx,offset msg1          ;
        int     21h                     ;
        mov     dx,offset msg2          ;
        int     21h                     ;
        mov     dx,offset msg3          ;
        int     21h                     ;
        mov     dx,offset msg4          ;
        int     21h                     ;
        mov     dx,offset msg5          ;
        int     21h                     ;
        jmp     EOC                     ;

aall:   cmp     [F1Handle],0            ;If not enough file names disp msg
        je      msg                     ;

        mov     si,[F1Handle]           ;Writes the names of the files in 
        mov     di,F1nlabel             ;the top lines (Tlines)
        mov     cx,23                   ;
l1:     lodsb                           ;
        cmp     al,0                    ;
        je      cont1                   ;
        stosb                           ;
        loop    l1                      ;
cont1:  mov     si,[F2Handle]           ;
        mov     di,F2nlabel             ;
        mov     cx,23                   ;
l2:     lodsb                           ;
        cmp     al,0                    ;
        je      cont2                   ;
        stosb                           ;
        loop    l2                      ;
cont2:                                  ;
                      
        mov     ax,03D00h               ;Open file 1
        mov     dx,[F1Handle]           ;
        int     21h                     ;
        jc      nok1                    ;
        mov     [f1handle],ax           ;
        
        mov     ax,03D00h               ;Open file 2
        mov     dx,[F2Handle]           ;
        int     21h                     ;
        jnc     ok1                     ;
nok1:   mov     dx,offset openerror     ;
        jmp     ERROR                   ;
ok1:    mov     [f2handle],ax           ;

        mov     ax,04200h               ;Set files to correct offset according
        mov     bx,[F1Handle]           ;to F?Start values
        mov     cx,[WORD HIGH F1Start]  ;
        mov     dx,[WORD LOW F1Start]   ;
        int     21h                     ;
        jc      nok2                    ;
        mov     ax,04200h               ;
        mov     bx,[F2Handle]           ;
        mov     cx,[WORD HIGH F2Start]  ;
        mov     dx,[WORD LOW F2Start]   ;
        int     21h                     ;
        jnc     yok1                    ;
nok2:   mov     dx,offset moveerror     ;
        jmp     ERROR                   ;
        yok1:                           ;

        cmp     [WORD LOW Nbytes],0     ;Give error if asked to compare 0 bytes
        jne     ok2                     ;
        cmp     [WORD HIGH Nbytes],0    ;
        jne     ok2                     ;
        mov     dx,offset nbyteserror   ;
        jmp     ERROR                   ;
        ok2:                            ;

        mov     si,offset F1Start       ;Set labels in tlines to show were
        mov     di,F1slabel             ;each file starts
        mov     cx,4                    ;
        call    bin2hex                 ;
        mov     si,offset F2Start       ;
        mov     di,F2slabel             ;
        mov     cx,4                    ;
        call    bin2hex                 ;
        
        mov     ah,040h                 ;Writes the top lines to the output
        mov     bx,1                    ;
        mov     cx,243                  ;
        mov     dx,offset Tlines        ;
        int     21h                     ;

READ:   mov     [eofstate],0            ;

        mov     ah,03Fh                 ;Read files
        mov     bx,[F1handle]           ;
        mov     cx,1                    ;
        mov     dx,offset F1B           ;
        int     21h                     ;
        jc      rerr                    ;
        cmp     ax,0                    ;
        jne     ok3                     ;
        mov     [eofstate],1            ;
ok3:    mov     ah,03Fh                 ;
        mov     bx,[F2handle]           ;
        mov     dx,offset F2B           ;
        int     21h                     ;
        jnc     ok4                     ;
rerr:   mov     dx,offset readerror     ;
        jmp     ERROR                   ;
ok4:    cmp     ax,0                    ;if [eofstate] = 1 then file 1 eof
        jne     ok5                     ;if [eofstate] = 2 then file 2 eof
        add     [eofstate],2            ;if [eofstate] = 3 then both eof
ok5:                                    ;

        cmp     [eofstate],3            ;Jump out if both files are at EOF
        jne     ok6                     ;
        jmp     OUT1                    ;
ok6:                                    ;

        cmp     [eofstate],0            ;If one file is eof then it must be
        jne     DIFF                    ;different to the other

        mov     al,[F1B]                ;Compare
        cmp     [F2B],al                ;
        jne     DIFF                    ;

        inc     [WORD LOW cbyte]        ;Increment current byte value
        cmp     [WORD LOW cbyte],0      ;
        jne     i321                    ;
        inc     [WORD HIGH cbyte]       ;
        i321:                           ;

        jmp     ad1                     ;If same do this.. else...

DIFF:   cmp     [asciioffset],0         ;If asciioffset = 0 do address thing
        jne     cont3                   ;
        mov     si,offset cbyte         ;
        mov     di,addrlabel            ;
        mov     cx,4                    ;
        call    bin2hex                 ;
        
cont3:  cmp     [eofstate],1            ;Check if file one is still with us
        je      cont4                   ;
        mov     si,offset F1B           ;Write hex value for file one
        mov     di,F1Hstart             ;
        mov     al,[asciioffset]        ;
        mov     ah,3                    ;
        mul     ah                      ;
        add     di,ax                   ;
        mov     cx,1                    ;
        call    bin2hex                 ;                            
        
        mov     bx,offset F1B           ;Do ASCII character
        call    asciify                 ;
        mov     al,[asciioffset]        ;
        xor     ah,ah                   ;
        mov     di,F1Astart             ;
        add     di,ax                   ;
        mov     al,[F1B]                ;
        stosb                           ;Store ascii thingo

cont4:  cmp     [eofstate],2            ;Check if file two is still with us
        je      cont5                   ;
        mov     si,offset F2B           ;Write hex value for file two
        mov     di,F2Hstart             ;
        mov     al,[asciioffset]        ;
        mov     ah,3                    ;
        mul     ah                      ;
        add     di,ax                   ;
        mov     cx,1                    ;
        call    bin2hex                 ;                            
        
        mov     bx,offset F2B           ;Do ASCII character
        call    asciify                 ;
        mov     al,[asciioffset]        ;
        xor     ah,ah                   ;
        mov     di,F2Astart             ;
        add     di,ax                   ;
        mov     al,[F2B]                ;
        stosb                           ;Store ascii thingo

cont5:  inc     [asciioffset]           ;inc asciioffset
        cmp     [asciioffset],8         ;
        jne     AA1                     ;if asciioffset=8 [asciioffset = 0
        mov     [asciioffset],0         ;                  writeclear]
        call    writeclear              ;
        jmp     AA1                     ;

AD1:    cmp     [asciioffset],0         ;If same..
        je      AA1                     ;
        call    writeclear              ;If entry in line write and clear it
        mov     [asciioffset],0         ;

AA1:    mov     ax,[WORD LOW cbyte]     ;If cbyte=nbytes [jmp out]
        cmp     ax,[WORD LOW nbytes]    ;
        jne     cont6                   ;
        mov     ax,[WORD HIGH cbyte]    ;
        cmp     ax,[WORD HIGH nbytes]   ;
        je      OUT1                    ;

cont6:  inc     [WORD LOW cbyte]        ;Increment current byte value
        cmp     [WORD LOW cbyte],0      ;
        jne     i322                    ;
        inc     [WORD HIGH cbyte]       ;
        i322:                           ;

        jmp     READ                    ;Repeat

OUT1:   cmp     [asciioffset],0         ;If asciioffset <> 0 then writeclear
        je       END1                   ;
        call     writeclear             ;
       
END1:   mov     ah,03Eh                 ;Close files
        mov     bx,[F1Handle]           ;
        int     21h                     ;
        mov     bx,[F2Handle]           ;
        int     21h                     ;
        
EOC:    mov     ax,04C00h               ;Terminate Execution
        int     21h                     ;

ERROR:  mov     ah,09h                  ;Write error msgs and close
        int     21h                     ;
        jmp     EOC                     ;

INCLUDE "PROC.INC"
INCLUDE "DATA.INC"

END START
;==[ EOF ]===================================================================
