#include "../../plugin.hpp"
#include "bcplugin.h"

static long WINAPI ColorDialogProc(HANDLE hDlg,int Msg,int Param1,long Param2)
{
  int color=0; FarDialogItem DialogItem;
  switch(Msg)
  {
    case DN_INITDIALOG:
    case DN_BTNCLICK:
      for(int i=1;i<17;i++)
      {
        Info.SendDlgMessage(hDlg,DM_GETDLGITEM,i,(long)&DialogItem);
        if(DialogItem.Selected)
        {
          color|=(DialogItem.Flags&0xF0)>>4;
          break;
        }
      }
      for(int i=18;i<34;i++)
      {
        Info.SendDlgMessage(hDlg,DM_GETDLGITEM,i,(long)&DialogItem);
        if(DialogItem.Selected)
        {
          color|=(DialogItem.Flags&0xF0);
          break;
        }
      }
      for(int i=36;i<39;i++)
      {
        Info.SendDlgMessage(hDlg,DM_GETDLGITEM,i,(long)&DialogItem);
        DialogItem.Flags=(DialogItem.Flags&0xffffff00)|color;
        Info.SendDlgMessage(hDlg,DM_SETDLGITEM,i,(long)&DialogItem);
      }
      break;
  }
  return Info.DefDlgProc(hDlg,Msg,Param1,Param2);
}

bool SelectColor(int *fg,int *bg)
{
  //Show dialog
  /*
    000000000011111111112222222222333333333
    012345678901234567890123456789012345678
  00                                       00
  01    Color ͻ   01
  02     Foreground   Background     02
  03                           *     03
  04                                 04
  05                                 05
  06              *                  06
  07         07
  08    Text Text Text Text Text Text    08
  09    Text Text Text Text Text Text    09
  10    Text Text Text Text Text Text    10
  11   Ķ   11
  12         [ Set ]  [ Cancel ]         12
  13   ͼ   13
  14                                       14
    000000000011111111112222222222333333333
    012345678901234567890123456789012345678
  */
  static struct InitDialogItem InitItems[]={
  /* 0*/  {DI_SINGLEBOX,5,2,18,7,0,0,0,0,(char *)mColorForeground},
  /* 1*/  {DI_RADIOBUTTON, 6,3,0,0,0,0,DIF_GROUP|DIF_MOVESELECT|DIF_SETCOLOR|0x07,0,""},
  /* 2*/  {DI_RADIOBUTTON, 6,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x40,0,""},
  /* 3*/  {DI_RADIOBUTTON, 6,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x87,0,""},
  /* 4*/  {DI_RADIOBUTTON, 6,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xc0,0,""},
  /* 5*/  {DI_RADIOBUTTON, 9,3,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x17,0,""},
  /* 6*/  {DI_RADIOBUTTON, 9,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x50,0,""},
  /* 7*/  {DI_RADIOBUTTON, 9,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x90,0,""},
  /* 8*/  {DI_RADIOBUTTON, 9,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xd0,0,""},
  /* 9*/  {DI_RADIOBUTTON,12,3,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x20,0,""},
  /*10*/  {DI_RADIOBUTTON,12,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x60,0,""},
  /*11*/  {DI_RADIOBUTTON,12,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xa0,0,""},
  /*12*/  {DI_RADIOBUTTON,12,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xe0,0,""},
  /*13*/  {DI_RADIOBUTTON,15,3,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x30,0,""},
  /*14*/  {DI_RADIOBUTTON,15,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x70,0,""},
  /*15*/  {DI_RADIOBUTTON,15,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xb0,0,""},
  /*16*/  {DI_RADIOBUTTON,15,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xf0,0,""},
  /*17*/  {DI_SINGLEBOX,20,2,33,7,0,0,0,0,(char *)mColorBackground},
  /*18*/  {DI_RADIOBUTTON,21,3,0,0,0,0,DIF_GROUP|DIF_MOVESELECT|DIF_SETCOLOR|0x07,0,""},
  /*19*/  {DI_RADIOBUTTON,21,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x40,0,""},
  /*20*/  {DI_RADIOBUTTON,21,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x87,0,""},
  /*21*/  {DI_RADIOBUTTON,21,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xc0,0,""},
  /*22*/  {DI_RADIOBUTTON,24,3,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x17,0,""},
  /*23*/  {DI_RADIOBUTTON,24,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x50,0,""},
  /*24*/  {DI_RADIOBUTTON,24,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x90,0,""},
  /*25*/  {DI_RADIOBUTTON,24,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xd0,0,""},
  /*26*/  {DI_RADIOBUTTON,27,3,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x20,0,""},
  /*27*/  {DI_RADIOBUTTON,27,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x60,0,""},
  /*28*/  {DI_RADIOBUTTON,27,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xa0,0,""},
  /*29*/  {DI_RADIOBUTTON,27,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xe0,0,""},
  /*30*/  {DI_RADIOBUTTON,30,3,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x30,0,""},
  /*31*/  {DI_RADIOBUTTON,30,4,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0x70,0,""},
  /*32*/  {DI_RADIOBUTTON,30,5,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xb0,0,""},
  /*33*/  {DI_RADIOBUTTON,30,6,0,0,0,0,         DIF_MOVESELECT|DIF_SETCOLOR|0xf0,0,""},
  /*34*/  {DI_BUTTON,0,12,0,0,0,0,DIF_CENTERGROUP,1,(char *)mColorSet},
  /*35*/  {DI_BUTTON,0,12,0,0,0,0,DIF_CENTERGROUP,0,(char *)mColorCancel},
  /*36*/  {DI_TEXT,5,8,0,0,0,0,DIF_SETCOLOR,0,(char *)mColorTest1},
  /*37*/  {DI_TEXT,5,9,0,0,0,0,DIF_SETCOLOR,0,(char *)mColorTest2},
  /*38*/  {DI_TEXT,5,10,0,0,0,0,DIF_SETCOLOR,0,(char *)mColorTest3},
  /*39*/  {DI_DOUBLEBOX,3,1,35,13,0,0,0,0,(char *)mColorMain},
  /*40*/  {DI_TEXT,-1,11,0,0,0,0,DIF_SEPARATOR,0,""},
  };
  const unsigned char color_translate[]={0,4,8,0xc,1,5,9,0xd,2,6,0xa,0xe,3,7,0xb,0xf};
  struct FarDialogItem DialogItems[sizeofa(InitItems)];
  InitDialogItems(InitItems,DialogItems,sizeofa(InitItems));
  DialogItems[color_translate[*fg]+1].Focus=DialogItems[color_translate[*fg]+1].Selected=true;
  DialogItems[color_translate[*bg]+18].Selected=true;
  int DlgCode=Info.DialogEx(Info.ModuleNumber,-1,-1,39,15,"Errors",DialogItems,sizeofa(DialogItems),0,0,ColorDialogProc,0);
  if(DlgCode==34)
  {
    for(int i=1;i<17;i++)
      if(DialogItems[i].Selected)
      {
        *fg=(DialogItems[i].Flags&0xF0)>>4;
        break;
      }
    for(int i=18;i<34;i++)
      if(DialogItems[i].Selected)
      {
        *bg=(DialogItems[i].Flags&0xF0)>>4;
        break;
      }
    return true;
  }
  return false;
}
