// UNMOUNT - Unmounts a drive, so that it can be removed
// Version 1.00
// Copyright (c) 1995, Christoph H. Hochsttter

#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <winioctl.h>
#include <stdarg.h>
#include <io.h>
#include <conio.h>
#include "mnt.h"

HANDLE filenum;
UINT DriveType;
char quiet = FALSE;
char rootname[MaxRootName];
char keyin[MaxKeyIn];
char filename[MaxDeviceName];
char RealDeviceName[MaxDeviceItem];
char ValidDevice = FALSE;


import char __fastcall ValidDrive(char *);
import void __fastcall index(char *, char *[], register unsigned short *);
import int __fastcall sort(char *[],const unsigned short);

__inline void __fastcall chmalloc(void **chpointer, int bytes)
{
	if (!(*chpointer=malloc(bytes))) {
		fputs("Not enough memory.\n",stderr);
		ExitProcess(94);
	}
}

void __fastcall MyQueryDosDevice(const LPCTSTR s1,const LPTSTR s2,const DWORD i)
{
	if (!QueryDosDevice(s1,s2,i)) {
		fputs("QueryDosDevice failed.\n",stderr);
		ExitProcess(95);
	}
}

void __fastcall qputs(const char *string)
{
	if (!quiet) puts(string);
}

__inline void __fastcall qfputs(const char *string, FILE *file)
{
	if (!quiet) fputs(string,file);
}

void __fastcall qprintf(const char *string, ...)
{
va_list marker;
	va_start(marker,string);
	if (!quiet) vprintf(string,marker);
}

void __fastcall Exception(void)
{
unsigned int rc;

        rc=GetLastError();
        if (!rc) return;
        fprintf(stderr,"\n\n");
        switch (rc) {
                case 2:
                        fprintf(stderr,"The device %s does not exist.\n",keyin);
                        break;
                case 5:
                        fprintf(stderr,"Another process has opened %s exclusively or %s is no root.\n",keyin,keyin);
                        break;
                default:
                        fprintf(stderr,"An error has occured. Errornumber %d\n",rc);
        }
        ExitProcess(rc);
}


void __fastcall Usage(void)
{
        fputs("Usage: unmount [-abdelq] <drive:> to unmount a volume.\n\n",stderr);
		fputs("-a: Always delete drive letter. (Default: For non-removable disks only)\n",stderr);
		fputs("-b: Delete drive letter before locking.\n",stderr);
		fputs("-d: Never delete drive letter.\n",stderr);
		fputs("-e: Don't eject media after unmounting.\n",stderr);
		fputs("-l: Try locking the disk continously.\n",stderr);
		fputs("-q: Quiet operation.\n",stderr);
        ExitProcess(87);
}

void __fastcall DeleteDefinition(void)
{
	qprintf("Deleting \\DosDevices\\%s (Ensures no new files can be opened)\n",keyin);
	if (!DefineDosDevice(DDD_REMOVE_DEFINITION,keyin,NULL))
		Exception();
}

__inline void __fastcall PhysicalCheck(const char drive[])
{
char *DeviceBuffer;
unsigned short MaxDevicelist;
char *Devicelist[MaxDosDevices];
char CurrentDevice[MaxDeviceItem];
char *part1;
char *part2;
unsigned short i;

	if (QueryDosDevice(drive,RealDeviceName,MaxDeviceItem)) {
		if ((part1=strrchr(RealDeviceName,'\\')) == NULL) return;
		ValidDevice=TRUE;
		chmalloc(&DeviceBuffer,MaxDeviceBuffer);
		MyQueryDosDevice(NULL,DeviceBuffer,MaxDeviceBuffer);
		index(DeviceBuffer,Devicelist,&MaxDevicelist);
		MaxDevicelist=sort(Devicelist,MaxDevicelist);
		for (i=0;i<=MaxDevicelist;i++) {
			MyQueryDosDevice(Devicelist[i],CurrentDevice,MaxDeviceItem);
			part2=strrchr(CurrentDevice,'\\');
			if (stricmp(Devicelist[i],drive)\
			&&(!stricmp(CurrentDevice,RealDeviceName)\
			||((part2 != NULL )\
			&&!memicmp("\\partition",part2,10)\
			&&!memicmp(CurrentDevice,RealDeviceName,max(part2-CurrentDevice,part1-RealDeviceName))))) {
				printf("%s same physical disk as %s.\n",Devicelist[i],drive);
			}
		}
		free(DeviceBuffer);
	}
}

int main(int argc, char *argv[], char *envp[])
{
DWORD dummy = 0;
DISK_GEOMETRY Info;
BOOL DontRetryLock = TRUE;
BOOL DontEject = FALSE;
BOOL DontDeleteDefinition = FALSE;
BOOL DeleteAlways = FALSE;
BOOL DeleteBeforeLock = FALSE;
int i,j;

        if ((argc < 2) || (!ValidDrive(argv[--argc]))) Usage();

		for (i=1;i<argc;i++) {
			for (j=0;argv[i][j]!=0;j++) {
			switch (argv[i][j] | 0x20) {
				case '-':
				case '/':
					break;
				case 'l':
					DontRetryLock = FALSE;
					break;
				case 'e':
					DontEject = TRUE;
					break;
				case 'b':
					DeleteBeforeLock = TRUE;
					break;
				case 'd':
					DontDeleteDefinition = TRUE;
					break;
				case 'q':
					quiet = TRUE;
					break;
				case 'a':
					DeleteAlways = TRUE;
					break;
				default:
					Usage();
					break;
				}
			}
		}

        lstrcpy(filename,"\\\\.\\");
        lstrcat(filename,argv[argc]);
        lstrcpy(rootname,argv[argc]);
        lstrcat(rootname,"\\");
        lstrcpy(keyin,argv[argc]);

		PhysicalCheck(keyin);

        qprintf("Testing %s -- ",keyin);
        DriveType=GetDriveType(rootname);
        switch (DriveType) {
				case 0:
                	fputs("This drive does not exist\n",stderr);
                    ExitProcess(99);
                case 1:
                    fputs("non-exisiting drive, empty drive or unformatted.\n",stderr);
                    ExitProcess(98);
                case DRIVE_REMOVABLE:
                    qputs("This is a removable drive.");
                    break;
                case DRIVE_FIXED:
                    qputs("This is a fixed disk drive.");
                    break;
                case DRIVE_REMOTE:
                    fprintf(stderr,"This is a network drive. Try NET USE %s /DEL\n",keyin);
                    ExitProcess(97);
                case DRIVE_CDROM:
                    qputs("This is a CDROM-Drive. (Actually unmounting not required)");
                    break;
                case DRIVE_RAMDISK:
                    fputs("This is a RAMDISK.\n",stderr);
                    ExitProcess(96);
                default:
 					qputs("Unknown Drive Type. Assuming removable.");
        }

		if (!ValidDrive) {
			qfputs("Unable to determine Windows NT Device.\n",stderr);
			}
		else {
			qprintf("Windows NT Device Name is %s.\n",RealDeviceName);
			}
		qprintf("Opening %s\n",keyin);
        filenum=CreateFile(filename,GENERIC_READ,FILE_SHARE_READ | FILE_SHARE_WRITE,NULL,OPEN_EXISTING,0,0);
        Exception();

        if (DeviceIoControl(filenum,IOCTL_DISK_GET_DRIVE_GEOMETRY,NULL,0,&Info,sizeof(Info),&dummy,NULL))
			qprintf("Drive has %ld Cyls, %lu surfaces, %lu sectors/track and %lu bytes/sector\n",Info.Cylinders.LowPart,Info.TracksPerCylinder,Info.SectorsPerTrack,Info.BytesPerSector);

        if (DeleteBeforeLock && (DeleteAlways || ((DriveType == DRIVE_FIXED) && (!DontDeleteDefinition))))
        	DeleteDefinition();

        qprintf("Locking %s (Ensures that all files are closed)\n",keyin);
        for (i=0;!DeviceIoControl(filenum,FSCTL_LOCK_VOLUME,NULL,0,NULL,0,&dummy,NULL);) {
			if (DontRetryLock) {
				fputs("Locking failed. There still open files.\n",stderr);
				ExitProcess(95);
			}
			putchar('.');
			i=1;
			Sleep(500);
		}
        if (i==1) putchar(10);

        if (!DeleteBeforeLock && (DeleteAlways || ((DriveType == DRIVE_FIXED) && (!DontDeleteDefinition))))
        	DeleteDefinition();

		qprintf("Dismounting %s\n",keyin);
		if	(!DeviceIoControl(filenum,FSCTL_DISMOUNT_VOLUME,NULL,0,NULL,0,&dummy,NULL))
			Exception();

        if (!DontEject) {
        	qprintf("Ejecting %s -- ",keyin);
        	if (!DeviceIoControl(filenum,IOCTL_DISK_EJECT_MEDIA,NULL,0,NULL,0,&dummy,NULL)) {
               	if (GetLastError() == 1) {
               		printf("%s does not support ejecting\n",keyin) ;
                    printf("Please remove the media manually. Then press any key\n");
                    getch();
                }
               	else
                   	Exception();
            }
        	else
               	qprintf("successful\n");
		}

        qprintf("Unlocking %s\n",keyin);
        if (!DeviceIoControl(filenum,FSCTL_UNLOCK_VOLUME,NULL,0,NULL,0,&dummy,NULL))
        	Exception();

        CloseHandle(filenum);
        return 0;
}
