#include "unddi.h"
#include "nlsdata.h"

#define UNI_SIZE 10000    /* a tweak for 16-bit compilers */

__u16 *local2uni;
__u16 *fat2uni;
unsigned char uni2local[UNI_SIZE];
unsigned char *local2lower;


void nlsinit(int cplocal, int cpfat)
{
    int i;

    if (cplocal == 852) {
        local2uni = CP852_UNI;
	local2lower = CP852_LOWER;
    }
    if (cplocal == 912) {
        local2uni = CP912_UNI;
	local2lower = CP912_LOWER;
    }

    if (cpfat == 852) fat2uni = CP852_UNI;
    if (cpfat == 912) fat2uni = CP912_UNI;

    memset(uni2local, '_', sizeof(uni2local));
    for (i=0; i<256; i++) uni2local[local2uni[i]] = i;
    uni2local[0] = 0;

    for (i=1; i<256; i++) {
        if (local2uni[i] == 0) local2uni[i] = (__u16) '_';
	if (fat2uni[i] == 0) fat2uni[i] = (__u16) '_';
	if (local2lower[i] == 0) local2lower[i] = (unsigned char) i;
    }
}

unsigned char conv_uni2local(__u16 uc)
{
    if (uc >= UNI_SIZE) return '_';
    return uni2local[uc];
}

void conv_fat2local(unsigned char *s, int len)
{
    int i;
    __u16 uc;

    for (i=0; i<len; i++) {
        uc = fat2uni[s[i]];
	if (uc >= UNI_SIZE) {
	    s[i] = '_';
	} else {
	    s[i] = uni2local[uc];
	}
    }
}

unsigned char *strlwrl(char *szArg)
{
    unsigned char *szPtr;

    for ( szPtr = (unsigned char *) szArg; *szPtr; szPtr++ )
        *szPtr = local2lower[*szPtr];
    return szArg;
}
