Program DiskSpace;
{***************************************************************************}
{*                                                                         *}
{*   Zeigt graphisch den belegten Speicherplatz eines Laufwerkes an.       *}
{*   Aufruf mit Laufwerksparameter optional.                               *}
{*                                                                         *}
{*   Compiler: TP (DOS) 5.0, 5.5, 6.0 ...                                  *}
{*             FPC 1.00/Win32                                              *}
{*                                                                         *}
{*   Quelle:   1024 Bytes (Kilowettbewerb) DOS 7/93                        *}
{*                                                                         *}
{*   Autor:    Ralph Roth (Ueberarbeitungen)                               *}
{*                                                                         *}
{*   Datum:    07.07.93                                                    *}
{*   Updates:  21.02.94 - SysError Unit, Copyright angepasst               *}
{*             19.03.94 - Format (fuer Thomas)                             *}
{*             28.08.99 - lfn + layout                                     *}
{*             15.08.00 - win32 port (fpc 1.00)                            *}
{*             09.12.00 - options added                                    *}
{*                                                                         *}
{***************************************************************************}

{$IFNDEF FPC}
{$A+,B-,D+,E-,F-,L+,N-,O-,G+}
{$M 16384,0,655360}
{$ENDIF}

{$I-,S-,R-,V-}

{ DEFINE lfn}

   uses dos
   {$IFDEF ROSE}
   ,syserr, dosv2, utils
   {$ELSE}
   ,r_utils
   {$ENDIF}
   {$IFDEF LFN}
   ,lfn
   {$ENDIF}
   ;

{$IFDEF FPC}

   Type LongInt = Int64;
{$ENDIF}

   Var max : longint;
       sr  : SearchRec;
       base: String;
       par : String;
       szTmp : String;
       lTotal, lTmp, lCDROM : LongInt;

   Const   graphlen  : Byte = 40;           { Breite des Balkens }
           bMegaByte : Boolean = FALSE;
           bCDROM    : Boolean = FALSE;
           w1024     : Word = 1024;

Function c( v: String) : LongInt;

   Var sr    : SearchRec;
       x     : LongInt;
       base  : String;

Begin { c - Rekursiv! }

   c := 0;
   GetDir(0, base);
   ChDir(v);
   If ioresult <> 0 Then
     Begin
        Writeln('WARNING: Access to '+v+' denied!');
        exit;
     End; {endif}

   x := 0;
   FindFirst('*.*', AnyFile, sr);

   while doserror = 0 Do
   Begin
     If ((sr.attr And $10) = $10) And (sr.name[1]<>'.') Then
       inc(x, c(sr.name));
     inc(x, sr.size);
     FindNext(sr);
   End; {endwhile}

   ChDir(base);
   If ioresult <> 0 Then
     Begin
        writeln('Cannot chdir to: ',base,'! Program halted!');
        halt(1);
     End;
   c := x;

End; { c }

Procedure display( d: String; s : LongInt);

   Var s1, s2 : String;
       i      : Byte;

Begin { display }

    If s < 0 Then
      Begin
        s := 0;
        d := '?>'+d;
      End;
    FillChar(s1, 80, '' {'#'});
    FillChar(s2, 80, '' {'.'});
    I := Round(s / max * Graphlen);
    s1[0] := chr(i);
    s2[0] := chr(GraphLen-i);
    { komplette Zeile ausgeben }

    write(copy(d + '                     ',1, 20), s1, s2, ' ',
          Round( s / max * 100): 3, '%');

    If bMegaByte Then
        writeln((s+1)/w1024/w1024: 10: 2)
                                       Else
                                         writeln(format(s): 14);

    inc(lTotal, s);

End; { display }

Procedure Usage;

Begin { usage, 09.12.2000 }

   writeln;
   writeln('Verwendung:   space [Laufwerk:[\Verzeichnis]] [-/Optionen] [>datei.txt]');
   writeln;
   writeln('Usage:        space [Drive:[\Directory]] [-/options] [>file.txt]');
   writeln;
   writeln(GuruHeadLine('Options'));
   writeln('-? /h         Print this help screen');
   writeln('-c /7         Print used space for a CD-ROM image with 650 MB (1024^2) - 74 min');
   writeln('-C /8         Print used space for a CD-ROM image with 700 MB (1024^2) - 80 min');
   writeln('-m /m         Print used space in megabyte (1024^2), default=bytes');
   writeln('-M /M         Print used space in megabyte (1000^2), default=bytes');
   writeln;
   writeln(GuruHeadLine('Visit:  http://come.to/rose_swe'));
   writeln;
   close(OutPut);	{ fpc 1.00 bug! }
   halt;

End; { usage, 09.12.2000 }


Var t : Byte;

Begin { DiskSpace }

    Crt2Con;

    writeln;
    Writeln(GuruHeadLine('SPACE 2.50' +
           {$IFDEF LFN} '/LFN'+ {$ENDIF}
           {$IFDEF WIN32} '/Win32'+ {$ENDIF}
            ' - (c) 1993-2001 by ROSE SWE, RalphRoth@gmx.de'));
    GetDir(0, base);
    For t := 1 To ParamCount Do
      Begin
         szTmp := ParamStr(t);
         If szTmp[1] In ['-','/'] Then
            Case (szTmp[2]) Of
              'h','H','?' : usage;
              'c','7' :
                    Begin
                       bCDROM := TRUE;
                       lCDROM := 650*w1024*w1024;
                    End;
              'C','8' :
                    Begin
                       bCDROM := TRUE;
                       lCDROM := 700*w1024*w1024;
                    End;
              'm' :
                    Begin
                       bMegaByte := TRUE;
                       inc(Graphlen, 4);
                    End;
              'M' :
                    Begin
                       bMegaByte := TRUE;
                       inc(Graphlen, 4);
                       w1024 := 1000;
                    End;
            End
         Else
             par := szTmp;
      End;
    If par = '' Then par := base;
    ChDir(par);

    If IoResult<>0 Then
      Begin
        writeln;
        writeln('Can not access ',par,'!');
        usage;
      End; {endif}

    GetDir(0, par);
    max := DiskSize(0);
    writeln('Disk usage of ',par);
    lTotal := 0;

    FindFirst('*.*', AnyFile, sr);

    while DosError = 0 Do
                     Begin
                       If ((sr.attr And $10) = $10) And (sr.name[1]<>'.') Then
                         display(sr.name, c(sr.name));
                       inc(lTotal, sr.size);
                       FindNext(sr);
                     End; {endwhile}
    writeln;
    lTmp := lTotal;
    display('Used', lTmp);

    display('Free on '+copy(par,1,2), diskfree(ord(par[1])-64));
    If length(Par)< 4 Then
       display('Lost by Cluster Size', max-diskfree(ord(par[1])-64)-lTmp);
    display('Total', max);

    If bCDROM Then
      Begin
         max := lCDROM;
         If lTmp > lCDROM Then
            lTmp := lCDROM;
         display('CD-ROM image', lTmp);
      End;

    ChDir(base);
    Close(Output);

End. { DiskSpace }
