        PAGE    60,132
NAME    SCRUB
        TITLE   SCRUB Version 1.6
COMMENT |

SCRUB.COM Copyright Roedy Green Canadian Mind Products (1990)

May be freely distributed for non-military use only.

Program to clean floppy diskette drive heads.  Used in
conjunction with any liquid floppy cleaning kit.  Waves the disk
heads over the entire diskette cleaning surface for 40 seconds.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.6 1998 November 8
- embed Barker address

Version 1.5 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.4 1993 June 11
- change address

Version 1.3 March 21
- rechange CMP addresss

Version 1.2
- change CMP address
- source lost.

Version 1.1 1990 March 18
- released onto BIX
- better centering

Version 1.0 1990 March 18
- released onto BIX for testing

How it works
------------

SCRUB finds out how many diskette drives you have and how many
tracks each diskette drive has.  Then it seeks the heads back
and forth in a zig zag path over the drive to wipe the diskette
head over the entire cleaning surface.  After 40 seconds it
stops.

Futures
-------

Possibly I could allow the user to control which drives should
be cleaned.  I could also allow the user to control the length
of time the disks are cleaned.  However Peter Fletcher has
written such a program already for sophisticated users.  This
program has been kept as simple as possible since it is
targetted at first time users.


All subroutine calls are presumed to trash all registers.

|       ; end of comment

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM
;======
CSEG    segment
        assume CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
                                        ; Since this is a .COM program
        org 100h                        ; Likewise
;======================================
;       E Q U A T E S
;======================================

CleanTime       EQU     40              ; Clean for 40 seconds.
ZigZag          EQU     5               ; size of zigzag step
ZigInc          EQU     3               ; size of next major step
                                        ; pattern is 10+5 10-5 13+5 13-5
                                        ;             15   10   18    8
;======================================
;   M A I N L I N E   R O U T I N E
;======================================
start:
        Call    EraseScreen
        lea     dx, copyright           ; Announce ourselves
        Call    SayCent
        Call    HowManyFloppies         ; count how many floppies we have in CX
        JCXZ    NoFloppies
        MOV     FloppyNumber,0          ; start with A:

ForEachFloppy:
        PUSH    CX                      ; save loop counter
        Call    GetMaxTracks            ; find out how big this drive is
        Call    PromptInsert            ; ask user to insert disk
        Call    PromptScrub             ; Tell the user we are cleaning
        Call    CalcQuitTime            ; calculate when to stop scrubbing

;       Zig-Zag back and forth over the entire diskette surface.
        MOV     Iteration,0
KeepScrubbingLoop:
        Call    DoOneHop                ; Move the diskette heads
                                        ; one step of the Zig-Zag pattern
        Call    GetTicks                ; See if we have reached
        CMP     CX,word ptr QuitTime+2  ; quitting time yet
        JA      ScrubDone
        CMP     DX,word ptr QuitTime+0
        JA      ScrubDone
        ADD     Iteration,ZigInc        ; Increment KeepScrubbingLoop
        JMP     KeepScrubbingLoop       ; keep scrubbing

ScrubDone:

        Call    PromptRemove            ; tell user to take diskette out
        INC     FloppyNumber            ; increment ForEachFloppyLoop
        POP     CX
        Loop    ForEachFloppy

NoFloppies:
        mov  ax, 4c00h                  ; quit with errorlevel=0
        int 21h                         ; normal bye

;============================================
;============================================

PromptInsert    PROC
;       Prompt user to insert the cleaning disk
        Call    PatchPrompts            ; patch all prompts to say A: or B:
        lea     dx,InsertMsg            ; Prompt to Insert diskette
        Call    SayCent
        Call    ConfirmIt
        Call    EraseScreen
        RET
PromptInsert    ENDP

;============================================

PromptScrub     PROC
;       Tell user we are scrubbing
        lea     dx,Legend40Msg          ; use either 40 or 80 track legend
        CMP     Maxtracks,40
        JLE     LegendReady
        lea     dx,Legend80Msg
LegendReady:
        Call    Say

        lea     dx,ScrubbingMsg         ; Prompt that scrubbing in process
        Call    SayCent
        RET
PromptScrub     ENDP

;============================================

DoOneHop PROC
;       Actually Scrub one diskette drive
        Call    Conscience              ; allow Ctrl-Break to work
        Call    CalcWhereSeek           ; decide where to seek to next
                                        ; Use Zig-Zag pattern based on Iteration
        Call    ShowBar                 ; Display the Seek activity
        Call    FloppySeek              ; seek to WhereSeek
        RET
DoOneHop ENDP

;============================================

PromptRemove    PROC
;       Prompt user to remove the cleaning disk
        Call    EraseScreen
        lea     dx,RemoveMsg            ; Prompt to Remove diskette
        Call    SayCent
        Call    ConfirmIt
        Call    EraseScreen
        RET
PromptRemove    ENDP

;============================================

HowManyFloppies PROC
        ; ( 0 .. 4 )
        ; returns answer in CX
        ; number of floppy drives installed
        ; uses ROM Bios INT 11 to find out
        INT     011h
                        ; Bits 6 and 7 00=1 01=2 11=3
                        ; if bit 0 is off, there are no drives
        TEST    AL,1
        MOV     CX,0
        JZ      NoDrives
        MOV     AH,0
;                       shift into low bits of AH
        SHL     AX,1
        SHL     AX,1
        INC     AH
        MOV     CL,AH
NoDrives:
        RET
HowManyFloppies ENDP

;============================================

PatchPrompts    PROC
;       Patch all prompts to refer to the A: or B: drive
;       FloppyNumber 0 refers to A:
        MOV     AL,FloppyNumber
        ADD     AL,'A'
        MOV     Patch1,AL
        MOV     Patch2,AL
        MOV     Patch3,AL
        MOV     Patch4,AL
        RET
PatchPrompts    ENDP

;============================================

GetMaxTracks PROC
        ; how many tracks on this floppy? (FloppyNumber)
        ; Answer left in MaxTracks
        ; f# is A:=0 B:=1 .. 3 floppy number - NOT DOS #
        ; track # is 0..39 for 360K floppies, 0..79 for 1.2 MB
        MOV     AH,0
        INT     013h            ; reset the floppy system
        MOV     DH,0
        MOV     DL,FloppyNumber
        MOV     AH,8h           ; code for current drive parms
        INT     013h            ; ( abs diskette i/o)
        CMP     CH,40d          ; if outside range 40..80
        JL      NoGood          ; INT 13/08 does not always work
        CMP     CH,80d
        JBE     SmallEnough
NoGood:
        MOV     CH,40d          ; treat too small/big as 40 tracks
SmallEnough:
        MOV     CL,CH
        MOV     CH,0
        MOV     MaxTracks,CX
        RET
GetMaxTracks ENDP

;============================================
CalcWhereSeek   Proc
;       Calculates where we should seek next.
;       We have to stay in the bounds 0..MaxTracks-1.
;       We want to cover the whole surface eventually, using a
;       zig-zag path.
        MOV     AX,Iteration
        TEST    AX,1
        JNZ     Odd
        SUB     AX,ZigZag
        JMP     SHORT IsCalced
Odd:    ADD     AX,ZigZag
IsCalced:
        MOV     DX,0            ; so divide will not overflow
        ADD     AX,MaxTracks    ; to ensure will not be negative
        DIV     MaxTracks       ; modulus to hold us in range
        MOV     WhereSeek,DX    ; save remainder DX, AX is quot
        RET
CalcWhereSeek   EndP

;============================================

ShowBar         Proc
;       Displays a bar that graphically show the track we are seeking to.

        MOV     AX,0600h        ; erase top line
        MOV     CX,0            ; row col upper left
        MOV     DH,0d           ; row col lower right
        MOV     DL,79d
        MOV     BH,07h          ; attribute
        INT     10H             ; video scroll up
        MOV     DX,0            ; row col 0,0
        MOV     BH,0            ; page
        MOV     AH,2
        INT     10H             ; video position cursor
        MOV     BH,0            ; display page
        MOV     CX,WhereSeek    ; count of chars to write
        INC     CX              ; so track 0 shows as short bar
        MOV     AL,''          ; char to write
        MOV     BL,7h           ; attrib
        MOV     AH,9h           ; write repeated char function
        INT     10H
        RET
ShowBar ENDP

;============================================

FloppySeek PROC
        ; CH:track#    seeks floppy to WhereSeek
        ; f# is A:=0 B:=1 .. 3 floppy number - NOT DOS #
        ; track # is 0..39 for 360K floppies, 0..79 for 1.2 MB
        MOV     CH,Byte PTR WhereSeek
        MOV     AH,0
        INT     013h            ; reset the floppy system
        MOV     DH,0
        MOV     DL,FloppyNumber
        MOV     CL,1
        MOV     AL,CL
        MOV     AH,4            ; code for verify
        INT     013h            ; ( abs diskette i/o)
        RET
FloppySeek ENDP

;============================================

Conscience      Proc
;       Ask DOS if there is a keystroke pending.
;       This will allow a Ctrl-Break abort.
        MOV     AX,0B00h        ; AH=0B sigifies check status
        INT     21H             ; check input status
                                ; AL=FF means is char, 0 means no char
;       We don't care one way or the other if there was a keystroke
        RET
Conscience      EndP

;============================================

CalcQuitTime    PROC    Near
;       Get time of day in 1/18.2 second clock ticks since midnight.
;       that we will quit.
;       ??? later add midnight avoidance code.
        Call    GetTicks                ; results in CX:DX
        MOV     word ptr StartTime+2,CX ; for debugging
        MOV     word ptr StartTime+0,DX
        ADD     DX,(CleanTime*182d)/10d ; 40 seconds = 18.2*40 = 728 ticks
        ADC     CX,0
        MOV     word ptr QuitTime+2,CX
        MOV     word ptr QuitTime+0,DX
        RET
CalcQuitTime ENDP

;==============================================================

GetTicks        PROC    Near
;       Get time of day in 1/18.2 second clock ticks since midnight.
;       leaves tick count in CX:DX

        MOV     AH,0
        INT     1Ah             ; BIOS ticks since midnight
                                ; CX:DX is count
        RET
GetTicks        EndP

;==============================================================

ConfirmIt       Proc
;       Confirm that ok to proceed with update of boot block
        Lea     DX,HitSpaceMsg
        Call    SayCent
        mov     AH,07                   ; read one char, no echo
        int     21h
        CMP     AL,32                   ; is it a blank?
        JE      Confirmed
        CMP     AL,0dh                  ; is it Cr?
        JE      Confirmed
        JMP     SHORT Abort             ; No, Bail out
Confirmed:                              ; Yes, carry on
        RET
ConfirmIT  EndP
;============================================
abort:
                                ; error exit
        mov  ax, 4c04h          ; ERRORLEVEL = 4
        int  21h                ; DIE
;============================================
SayCent Proc
;       on entry DX points to a string to display
;       it may contain CrLfs in it.  It is terminated by $.
;       We Print each line centred.
LineLoop:
        MOV     SI,DX   ; SI points to first char
        MOV     DI,DX   ; DI save secord copy
        SUB     BX,BX   ; count chars in line, 0 to start
                        ; SI points to first char of line
CharLoop:
        LODSB           ; get first char
        CMP     AL,'$'
        JE      FoundEnd
        CMP     AL,13d
        JE      FoundEol
        INC     BX      ; found an ordinary char, count it.
        JMP     CharLoop
FoundEol:
                        ; found Cr, print centred line.
        MOV     CX,80d  ; calc # spaces needed for centering
        SUB     CX,BX   ; BX is count of real chars in line
        SHR     CX,1    ; divide by 2
        AND     CX,3Fh  ; just in case line too long.
        JCXZ    SpacesDone
                        ; CX now contains number of spaces we want to emit.
SpaceLoop:
        MOV     DL,' '
        MOV     AH,02
        INT     21H     ; emit enough spaces to centre the line.
        LOOP    SpaceLoop
SpacesDone:
        MOV     CX,BX   ; BX contains length of string
        ADD     CX,2    ; account for CrLf at the end
        MOV     DX,DI   ; CX=count DX=addr
        MOV     BX,1    ; handle 1 - standard output
        MOV     AX,4000H ; AH=40 signifies write by handle
        INT     21H     ; Write the string itself
        INC     SI      ; point just past the LF
        MOV     DX,SI   ; point to start of next string.
        JMP     LineLoop; process the next line of text
FoundEnd:
                        ; We are done.  All lines have CrLf before $
        RET             ; so we need not process any tail end.
SayCent EndP
;============================================
Say     Proc

;       on entry DX points to a string to display
        MOV     AH,9
        Int     21h
        ret
Say     EndP
;============================================
EraseScreen     Proc
;       erase the the display screen
        MOV     AX,0600h        ; erase entire screen
        MOV     CX,0            ; row col upper left
        MOV     DH,24d          ; row col lower right
        MOV     DL,79d
        MOV     BH,07h          ; attribute
        INT     10H             ; video scroll up
        MOV     DX,0            ; row col 0,0
        MOV     BH,0            ; page
        MOV     AH,2
        INT     10H             ; video position cursor
        RET
EraseScreen     EndP
;======================
;   V A R I A B L E S
;======================
StartTime       DD      0       ; time in ticks to start scrub
QuitTime        DD      0       ; time in ticks to stop scrub
MaxTracks       DW      0       ; highest track # on this floppy
Iteration       DW      0       ; iteration count -- how many seeks done
                                ; so for
WhereSeek       DW      0       ; Whick track to seek to next
FloppyNumber    DB      0       ; 0=A: floppy we are working on now.

;
;   Display Strings

copyright       label byte
 CR
 db    'ͻ'
 CR
 db    ' SCRUB 1.6 Floppy Diskette Drive Cleaner '
 CR
 db    'ͼ'
 CR
 CR
        db      '(c) Copyright Roedy Green 1990,1998'
        CR
        CR
        db      ' Canadian Mind Products ۲'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        db      'May be freely distributed and used for any purpose except military.'
        CR
        EOS

HitSpaceMsg     label byte
 db     'Hit the space bar when you have done so, or Esc to abort.'
 CR
 EOS

InsertMsg       label byte
 db     'Please put 9 drops of cleaning fluid on the cleaning diskette cutout(s)'
 CR
 db     '(the large oval holes) and insert the diskette into drive A:'
Patch1  = BYTE PTR $-2d
 CR
 CR
 db     'Ŀ'
 CR
 db     'A:    '
Patch2  = BYTE PTR $-16d
 CR
 db     ''
 CR
 EOS

Legend40Msg     Label byte
 CR     ; leave room for the bar display above
 db     ''
 EOS

Legend80Msg     Label byte
 CR     ; leave room for the bar display above
 db     ''
 EOS

ScrubbingMsg    label byte
 CR
 CR
 CR
 db     'Cleaning the head in drive A:'
Patch3  = BYTE PTR $-2d
 db     '... This will take 40 seconds.'
 CR
 EOS

RemoveMsg       label byte
 CR
 db     'Please remove the cleaning diskette from A:'
Patch4  = BYTE PTR $-2d
 CR
 db     'and record the usage on the diskette with a felt pen.'
 db     07h
 CR
 EOS

CSEG ends
end     Start
