Program NextDirectory;

{$I-}
var
   CurPath: string;
   NewSubdir: integer;
   FirstRun: boolean;

Procedure FirstRunCheck(var FirstRun: boolean; var NewSubdir: integer);
var
   InFile: text;
   IOerror: integer;
begin
   FirstRun := FALSE;
   assign(InFile, 'nextdir.dat');
   reset(InFile);
   IOerror:=IOResult;

   {*** IOerror = 2: File Not Found ***}
   if IOerror = 2 then begin
      NewSubdir := 1;
      FirstRun := TRUE;
   end else begin
   {*** File was found ***}
      readln(InFile, NewSubdir);
      close(InFile);
   {*** Increment subdirectory counter ***}
      NewSubdir := NewSubdir + 1;
   end;

   assign(InFile, 'nextdir.dat');
   rewrite(InFile);
   writeln(InFile, NewSubdir);
   close(InFile);
end;

Procedure GetStartPath(var CurPath: string);
var
  InFile: text;
begin
   assign(InFile, 'dldir.bat');
   reset(InFile);
   readln(InFile, CurPath);
   close(InFile);
end;

Procedure RemoveIncrement(var CurPath: string);
var
   x: integer;
   Cutoff: integer;
begin
   for x := length(CurPath) downto 1 do begin
      if CurPath[x] = '\' then begin
         Cutoff := x - 1;
         break;
      end;
   end;
   CurPath := copy(Curpath,1,Cutoff);
end;

Procedure InitEnvironment(NewSubdir: integer);
var
   InFile: text;
   CurPath: string;
begin
   GetStartPath(CurPath);
   assign(InFile, 'dldir.bat');
   rewrite(InFile);
   write(InFile, CurPath + '\');
   writeln(InFile,NewSubdir);
   close(InFile);
end;

Procedure SetEnvironment(CurPath: string; NewSubdir: integer);
var
   InFile: text;
begin
   GetStartPath(CurPath);
   RemoveIncrement(CurPath);
   assign(InFile, 'dldir.bat');
   rewrite(InFile);
   write(InFile, CurPath + '\');
   writeln(InFile,NewSubdir);
   close(InFile);
end;

Begin
   FirstRunCheck(FirstRun,NewSubdir);
   if FirstRun then begin
      InitEnvironment(NewSubdir);
   end else begin
      SetEnvironment(CurPath,NewSubdir);
   end;
End.

