#include <dos.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TRACKSIZE	512
#define MAXPART	4
#define MAXDRIVE	2
#define MB	1048576L
typedef enum { FALSE, TRUE } BOOLEAN;
typedef struct {
	unsigned nosec;
	unsigned nohead;
	unsigned nocyl;
	unsigned long totalsectors;
} FIXEDDISK;

typedef struct {
	char boot;
	char startinghead;
	unsigned char startingsec;
	unsigned char startingcyl;
	char sysid;
	char endinghead;
	unsigned char endingsec;
	unsigned char endingcyl;
	unsigned long firstsector;
	unsigned long nosec;
} PARTITION;

typedef struct PL_STRUCT {
	PARTITION part;
	struct PL_STRUCT *subpart;
} PARTLIST;

#define ssec(P) P->part.startingsec & 0x3F
#define esec(P) P->part.startingsec & 0x3F
#define scyl(P) P->part.startingcyl | ((P->part.startingsec & 0xC0) << 2)
#define ecyl(P) P->part.endingcyl | ((P->part.endingsec & 0xC0) << 2)
	
char *trackbuffer;
FIXEDDISK Disk[MAXDRIVE];
PARTLIST partition[MAXDRIVE][MAXPART];		/* Primary partition information	*/

void Initialize(void);
int ReadCMOS(void);
void GetPartitions(PARTLIST *, int);
int ReadTrack(unsigned, unsigned, unsigned, unsigned, char far *);
void DisplayPartitions(int);
void DisplayAPartition(char *, PARTLIST *);
void DisplaySizes(int);
unsigned long DisplaySize2(int, unsigned long, PARTLIST *);

main() {
	Initialize();
	ReadCMOS();
	GetPartitions(NULL, 0);
	GetPartitions(NULL, 1);
	DisplayPartitions(0);
	DisplaySizes(0);
	DisplayPartitions(1);
	DisplaySizes(1);
	return 0;
}

void Initialize(void) {
	int drive, x;
	
	if((trackbuffer = malloc(TRACKSIZE)) == NULL) {
		puts("Insufficient memory");
		exit(4);
	};
	for(drive = 0; drive < MAXDRIVE; drive++)
		for(x = 0; x < MAXPART; x++)
			partition[drive][x].subpart = NULL;
}

int ReadCMOS(void) {
	Disk[0].nosec  = 63;
	Disk[0].nohead = 16;
	Disk[0].nocyl  = 1654;
//
	Disk[1].nosec  = 63;
	Disk[1].nohead = 16;
	Disk[1].nocyl  = 1060;
	Disk[0].totalsectors = (unsigned long)Disk[0].nosec * 
													(unsigned long)Disk[0].nohead * 
													(unsigned long)Disk[0].nocyl;
	Disk[1].totalsectors = (unsigned long)Disk[1].nosec * 
													(unsigned long)Disk[1].nohead * 
													(unsigned long)Disk[1].nocyl;
	return TRUE;
}

void GetPartitions(PARTLIST *p, int drive) {
	int x;
	PARTITION tp[MAXPART];
	
	if(p == NULL) {
		if(ReadTrack(drive, 1, 0, 0, trackbuffer) != 1)
			exit(4);
	} else {
		if((p->subpart = malloc(sizeof(PARTLIST) * MAXPART)) == NULL)
			exit(4);
		for(x = 0; x < MAXPART; x++)
			p->subpart[x].subpart = NULL;
		if(ReadTrack(drive, ssec(p), p->part.startinghead, scyl(p), trackbuffer) != 1)
			exit(4);
	};
	memcpy(tp, 
				 (char *)trackbuffer + TRACKSIZE - ((sizeof(PARTITION) * MAXPART) + 2),
				 sizeof(PARTITION) * MAXPART);
	if(p == NULL) {
		for(x = 0; x < MAXPART; x++)
			memcpy(&partition[drive][x].part, &tp[x], sizeof(PARTITION));
		for(x = 0; x < MAXPART; x++)
			if(partition[drive][x].part.sysid == 0x05)
				GetPartitions(&partition[drive][x], drive);
	} else {
		for(x = 0; x < MAXPART; x++) {
			memcpy(&p->subpart[x].part, &tp[x], sizeof(PARTITION));
			p->subpart[x].part.firstsector += p->part.firstsector;
		};
		for(x = 0; x < MAXPART; x++)
			if(p->subpart[x].part.sysid == 0x05)
				GetPartitions(&p->subpart[x], drive);
	};
}

int ReadTrack(unsigned drive, unsigned sec, unsigned head, unsigned cyl,
			char far *where) {
	union REGS regs;
	struct SREGS sregs;

	if(sec > 0x3F) {
		puts("Sector number too high");
		return -1;
	} else if(head > 0x7F) {
		puts("Head number too high");
		return -1;
	} else if(cyl > 0x3FF) {
		puts("Cylinder number too high");
		return -1;
	};
	regs.x.ax = 0x0201;
	regs.x.bx = FP_OFF(where);
	regs.h.ch = cyl & 0xFF;
	regs.h.cl = ((cyl >> 2) & 0xC0) | sec;
	regs.h.dh = head;
	regs.h.dl = drive | 0x80;
	sregs.es  = FP_SEG(where);
	int86x(0x13, &regs, &regs, &sregs);
	return regs.x.ax;
}

void DisplayPartitions(int drive) {
	char partname[10];
	int x;
	
	printf("******************************************************************************\n");
	printf("*                                                                            *\n");
	printf("*                             Drive %1.1d                                        *\n", drive);
	printf("*                                                                            *\n");
	printf("******************************************************************************\n");
	printf("  PART     BOOT  HEAD SECT CYL    ID  HEAD SECT CYL    1ST SECTOR  NO. SECTORS\n");
	printf("---------  ----  ---  ---  -----  --  ---  ---  -----  ----------  ----------\n");
//        9.9.9.9.9
	for(x = 0; x < MAXPART; x++)
		if(partition[drive][x].part.sysid) {
			itoa(x, partname, 10);
			DisplayAPartition(partname, &partition[drive][x]);
		};
}

void DisplayAPartition(char *partname1, PARTLIST *p) {
	int x;
	char partname[10];
	char partnum[2];
	printf("%9s  %3s   %3u  %3u  %5u  %.2X  %3u  %3u  %5u  %10lu  %10lu\n",
		partname1,
		p->part.sysid & 0x80 ? "YES" : "NO",
		p->part.startinghead,
		ssec(p),
		scyl(p),
		p->part.sysid,
		p->part.endinghead,
		esec(p),
		ecyl(p),
		p->part.firstsector,
		p->part.nosec
	);
	if(p->subpart) {
		for(x = 0; x < MAXPART; x++) {
			if(p->subpart[x].part.sysid) {
				itoa(x, partnum, 10);
				strcpy(partname, partname1);
				strcat(partname, ".");
				strcat(partname, partnum);
				DisplayAPartition(partname, &p->subpart[x]);
			};
		};
	}
}

void DisplaySizes(int drive) {
	printf("PART  1ST SECTOR  LAST SECTOR NO. SECTORS DISK SIZE   (MB)\n");
	printf("----  ----------  ----------  ----------  ----------  ----\n");
	DisplaySize2(drive, 0L, partition[drive]);
}

unsigned long DisplaySize2(int drive, unsigned long cursec, PARTLIST *p) {
	unsigned long disksize;
	unsigned disksizemb;
	int x = 0;
	do {
		if(p[x].part.sysid == 0x05) {
			cursec = DisplaySize2(drive, cursec, p[x].subpart);
			x++;
		} else if(p[x].part.sysid) {
			if(p[x].part.firstsector == cursec) {
				disksize = p[x].part.nosec * TRACKSIZE;
				disksizemb = disksize / MB;
				printf(" %2u   %10lu  %10lu  %10lu  %10lu  %4u\n",
					p[x].part.sysid,
					p[x].part.firstsector,
					p[x].part.firstsector + p[x].part.nosec - 1,
					p[x].part.nosec,
					disksize,
					disksizemb
					);
				cursec = p[x].part.firstsector + p[x].part.nosec;
				x++;
			} else {
				disksize = (p[x].part.firstsector - cursec) * TRACKSIZE;
				disksizemb = disksize / MB;
				printf("FREE  %10lu  %10lu  %10lu  %10lu  %4u\n",
					cursec,
					p[x].part.firstsector - 1,
					p[x].part.firstsector - cursec,
					disksize,
					disksizemb
				);
				cursec = p[x].part.firstsector;
			};
		} else {
			disksize = (Disk[drive].totalsectors - cursec) * TRACKSIZE;
			disksizemb = disksize / MB;
			printf("FREE  %10lu  %10lu  %10lu  %10lu  %4u\n",
				cursec,
				Disk[drive].totalsectors,
				Disk[drive].totalsectors - cursec,
				disksize,
				disksizemb
			);
			cursec = Disk[drive].totalsectors + 1;
		};
	} while(cursec != Disk[drive].totalsectors + 1);
	return cursec;
}
