;       park.COM 1.3
comment 
        Last updated by Roedy Green
        originally by Paul Unruh  1986 December 4
        This program is copyrighted but may be copied freely
        for non-military use only.
        parks all hard disk drives
        coached by Roedy Green
        1.  It parks all the hard disks, not just C:
        2.  It doesn't waste time with a recalibrate unless it is
            necessary.
        3.  It doesn't mess up your screen with messages.
        4.  It parks to the last cylinder + 1 -- the landing zone,
            not to the last cylinder of your precious data.
        5.  If your CMOS has a valid landing zone, it uses that in
            preference to park your disk further up on "the beach".
        6.  It doesn't freeze the machine when it is done.
        7.  It comes with source code so you can change it.
        8.  Works on XT or AT.


Please report bugs and problems to:

Roedy Green
Canadian Mind Products
#208 - 525 Ninth Street
New Westminster BC Canada
V5H 2N6
tel:(604) 777-1804
mailto:roedy@mindprod.com
http://mindprod.com


Version 1.3 1998 November 8
- embed Barker address

Version 1.2 1996 October 25
- embed POB 707 Quathiaski Cove address

Version 1.1 1993 June 7
- landing zone support, using int 41 for C: and 46 for D:
- embed our name and address

Version 1 1986 December 4
- original
; 

; M A C R O S

CR      MACRO   ; Carriage return line feed
        DB 0dh,0ah
        ENDM

;======

EOS     MACRO   ; marks end of display string
        DB 0dh,0ah,'$'
        ENDM

;======

DriveTab Struc                  ; Drive Table accessible Via
                                ; BIOS int 41H for C: or 46H for D:
                                ; Int 41H vector points to the table.
                                ; You don't INVOKE int 41H, or 46H!!

        Max_Cyl         dw ?    ; Max number of cylinders
        Max_Heads       db ?    ; Max number of heads
        Red_Write_Cyl   dw ?    ; starting reduced write cylinder
        Precomp_Cyl     dw ?    ; starting write precompensation
        Ecc_Burst       db ?    ; max ECC burst length (bits)
        Step_Control    db ?
        Std_TimeOut     db ?
        Fmt_TimeOut     db ?
        Chk_TimeOut     db ?
        Land_Zone       dw ?
        Sects_Per_Track db ?
        reserved        db ?    ; 1 byte reserved
DriveTab Ends

code    segment para

        assume  cs:code,ds:code
        org     100h

park    proc    far

start:
        mov     di,0080h        ; drive no. for c:
        mov     dx,di           ; get drv parms for disk c:
        mov     ax,0800h        ; ah 08 = get disk parameters
        int     13h             ; into CX/DX

        mov     cl,dl           ; put drv count in cx
        xor     ch,ch           ; zero high order byte of drive count
        jcxz    quit            ; zero drives--exit procedure
sloop:                          ; loop once for each drive c: d:...
        push    cx              ; save cx loop counter
                                ; get parameters for drive i
        mov     dx,di           ; disk c: d: ...
        mov     ax,0800h        ; ah 08 = get disk parameters
        push    es              ; bug, some Phoenix BIOS trash ES:DI
        push    di
        int     13h             ; into CX/DX
        pop     di
        pop     ES
                                ; ch=max cyl and cl=has high two bits
        xor     ax,ax
        mov     al,cl
        shl     ax,1
        shl     ax,1
        mov     al,ch           ; this is the max cyl #.
        inc     ax              ; landing zone is max cyl + 1
        mov     cx,ax           ; CX=our Computed landing Zone
        Call    BetterLZ        ; try for a better landing zone in CX
                                ; is possible for C: or D:
                                ; CX has best shot at Landing Zone
        mov     dx,di           ; disk c: d: ...
        mov     ax,0c00h        ; ah 0c = seek
        int     13h             ; do first seek
        jnc     ok              ; jmp if seek works ok
        mov     dx,di           ; disk c: d: ...
        mov     ax,1100h        ; didn't work -- recalibrate
        int     13h
        mov     dx,di           ; disk c: d: ...
                                ; CX still has the seek cyl

        mov     ax,0c00h        ; ah 0c = seek
        int     13h             ; redo the seek
                                ; don't bother to retry if it didn't work
ok:
        pop     cx              ; restore cx
        inc     di              ; inc to next drive  D: is 81
        loop    sloop

quit:   mov     ax,4c00h        ; exit park
        int     21h

;==========================

BetterLZ        Proc    Near            ; try for a better landing zone

;       on entry di has disk# 80=C: 81=D:
;       cx has best guess at lz
;       on exit cx has a better lz.
;       use landingzone taken from drive table, but ensure it is in range
;       maxcyl+1 to Maxcyl+11
;
        cmp     di,0081h        ; C:?  D:?  else?
        jle     BetterC
        je      BetterD
        ret                     ; greater, cannot do anything
BetterC:
        mov     al,41h          ; C: drive table at int 41
        jmp     GetDriveTab
BetterD:
        mov     al,46h          ; D: drive table at int 46
GetDriveTab:
        mov     ah,35h          ; get int 41 pointer to drive table
        push    ES
        int     21h             ; ES:BX points to drive table
        mov     ax,ES:[BX].Land_Zone
                                ; get official landing zone
                                ; often it contains ridiculous values.
                                ; corral to range <MaxCyl+1 .. MaxCyl+11>
                                ; CX contains our computed Landing Zone
                                ; AX contains the official Landing Zone
        pop     ES
        cmp     ax,cx
        jge     bigEnough
        mov     ax,cx           ; official was too small, use calculated
bigenough:
        add     cx,10
        cmp     ax,cx
        jle     SmallEnough
        sub     cx,10
        mov     ax,cx           ; official was too big, use calculated
                                ; NOT calculated + 10
SmallEnough:
        mov     cx,ax           ; leave best guess in CX
        ret

BetterLZ        endp

;==========================

CopyrightMsg    label byte      ; does not display
        CR
        DB      ' Park 1.3 ۲'
        CR
        DB      'Freeware to park all hard disks.'
        CR
        DB      'usage:  PARK'
        CR
        DB      'Copyright (c) 1986-1999 Roedy Green Canadian Mind Products'
        CR
        DB      '#208 - 525 Ninth Street, New Westminster, BC Canada V3M 5T9',13,10
        DB      'tel:(604) 777-1804   mailto:roedy@mindprod.com   http://mindprod.com',13,10
        DB      'May be freely distributed and used for any purpose except military.'
        EOS


;==========================

park    endp
code    ends
        end     start
