/*
 * File: os2hdd.c
 *
 * OS/2 Distributive Disks Extractor
 *
 * Copyright (C) by AVN, 1997
 * All rigths reserved.
 */
# include <dos.h>
# include <string.h>
# include <stdlib.h>
# include <io.h>
# include <fcntl.h>
# include <sys/stat.h>
# include <time.h> 
# include <sys/utime.h>
# include "sysp.h"

# define OFFSET    0x26
# define LASTCLUST 0x0FFF
# define MARKER1   0x00F058AA
# define MARKER2   0x00F059AA /* ???                      */
# define MARKER3   0x00D058A6 /* Shifted root directory ? */
# define MARKER4   0x00F05AAA /* Compressed dump          */

unsigned short offset;
BOOT     boot;
char     basepath[ 256 ];
char    *fat;
int      fdin;

/* Creates a directory structure if it does not already exist */

int create_dirs( char *path )
{
unsigned char dir[ 256 ];
unsigned long path_idx = 0;

  while( path[ path_idx ] ) {
    if( path[ path_idx ] == '\\' || path[ path_idx ] == '/' ) {
      if( path_idx == 0 || path[ path_idx - 1 ] == ':' ) {
        memcpy( dir, path, path_idx + 1 );
        dir[ path_idx + 1 ] = '\0';
      }
      else {
        memcpy( dir, path, path_idx );
        dir[ path_idx ] = '\0';
      }
      if( access( dir, F_OK ) != 0 ) {
        if( mkdir( dir ) == -1 )
          return 1;
      }
    }
    path_idx++;
  }
  return 0;
}

mkdirname( char *file, FITEM *d )
{
int  i, j, flag;

  memcpy( file, d->name, 8 );
  for( i = 7, flag = 0; i >= 0; i-- ) {
    if( file[ i ] == 0 ) continue;
    else if( file[ i ] == ' ' ) if( !flag ) file[ i ] = 0;
                                else        file[ i ] = '_';
    else if( !flag ) {
      j = i+1;
      flag = 1;
    }
  }
  sprintf( file+j, ".%.3s", d->ext );
  for( i = j+4; i > j; i-- ) {
    if( file[ i ] == 0 ) continue;
    else if( file[ i ] == ' ' ) file[ i ] = '_';
  }
}

mkfilename( char *file, FITEM *d )
{
int  i, j;

  memcpy( file, d->name, 8 );
  for( i = 7; i >= 0; i-- ) {
    if( file[ i ] == 0 ) continue;
    else if( file[ i ] == ' ' ) file[ i ] = 0;
    else {
      j = i+1;
      break;
    }
  }
  sprintf( file+j, ".%.3s", d->ext );
  for( i = j+4; i > j; i-- ) {
    if( file[ i ] == 0 ) continue;
    else if( file[ i ] == ' ' ) file[ i ] = 0;
    else break;
  }
  if( file[ i ] == '.' ) file[ i ] = 0;
}

int nextclust( int clust )
{
int next;

  next = *(short *)(fat+clust*3/2);
  if( clust & 1 )
    next >>= 4;
  return next & LASTCLUST;  
}

readfile( char *buf, FITEM *d )
{
int clust, csize, baseoff;

  baseoff = offset +
            (boot.bpb.ressecs+boot.bpb.fatsize*boot.bpb.fatcnt)*boot.bpb.sectsize +
            boot.bpb.rootsize*sizeof( FITEM );
  csize = boot.bpb.sectsize*boot.bpb.clustsize;
  for( clust = d->cluster_nu; clust != LASTCLUST; clust = nextclust( clust ) ) {
    lseek( fdin, baseoff+(clust-2)*csize, 0 );
    read( fdin, buf, csize );
    buf += csize;
  }
}

copyfile( FITEM *d, char *path )
{
char  filename[ 256 ];
char *content = NULL;
int   fdout, i, clust;
union {
  unsigned short shda;
  FDATE          stda;
} da;
union {
  unsigned short shti;
  FTIME          stti;
} ti;
struct tm      tm;
struct utimbuf timbuf;
time_t t;

  if( !strncmp( d->name, ".          ", 11 ) ||
      !strncmp( d->name, "..         ", 11 ) )
    return;
  sprintf( filename, "%s/", path );
  mkfilename( filename+strlen(filename), d );
  printf( "Found %s, ", filename );
  fflush( stdout );
  if( d->attr & F_DIR ) { /* Directory */
    if( access( filename, F_OK ) ) {
      printf( "making directory... " );
      fflush( stdout );
      if( mkdir( filename ) != -1 )
        printf( "Ok!\n" );
      else {
        printf( "Error" );
        fflush( stdout );
        goto label1;
      }
      fflush( stdout );
    }
    else
      printf( "already exists\n" );
    for( i = 0, clust = d->cluster_nu; clust != LASTCLUST; clust = nextclust( clust ) ) i++;
    d->size = i*boot.bpb.sectsize*boot.bpb.clustsize;
    content = malloc( (i+1)*boot.bpb.sectsize*boot.bpb.clustsize );
    if( content == NULL ) {
      printf( "Can't allocate memory\n" );
      return;
    }
    readfile( content, d );
    for( i = 0; i < d->size/sizeof( FITEM ); i++ )
      if( ((FITEM *)content)[ i ].name[ 0 ] != 0 &&
          ((FITEM *)content)[ i ].name[ 0 ] != 0xE5 ) {
        copyfile( ((FITEM *)content)+i, filename );
      }
  }
  else { /* File */
    if( d->size > 0 ) {
      printf( "reading (%d bytes)... ", d->size );
      fflush( stdout );
      content = malloc( d->size+boot.bpb.sectsize*boot.bpb.clustsize );
      if( content == NULL ) {
        printf( "Can't allocate memory\n" );
        return;
      }
      readfile( content, d );
    }
    printf( "creating... " );
    fflush( stdout );
    if( ( fdout = open( filename, O_BINARY|O_WRONLY|O_CREAT,
                        S_IWRITE|S_IREAD ) ) >= 0 ) {
      if( d->size > 0 ) {
        printf( "writing... " );
        fflush( stdout );
        write( fdout, content, d->size );
        close( fdout );
      }
      printf( "Ok!\n" );
      fflush( stdout );
    }
    else
      perror( "open" );
  }
/* 
        da.stda.day   = d->date.day;
        da.stda.month = d->date.month;
        da.stda.year  = d->date.year;
        ti.stti.hour  = d->time.hour;
        ti.stti.min   = d->time.min;
        ti.stti.sec   = d->time.sec;
        _dos_setftime( fdout, da.shda, ti.shti );
*/
  tm.tm_sec  = d->time.sec * 2;
  tm.tm_min  = d->time.min;
  tm.tm_hour = d->time.hour;
  tm.tm_mday = d->date.day;
  tm.tm_mon  = d->date.month - 1;
  tm.tm_year = d->date.year + 80;
  t = mktime( &tm ); 
  timbuf.actime  = t;
  timbuf.modtime = t;
  utime( filename, &timbuf );

  _dos_setfileattr( filename, d->attr );
label1:
  if( content ) free( content );
}

main( int argc, char *argv[] )
{
FITEM *root;
char   filename[ 256 ];
int    i;
long   marker = 0;

  if( argc != 3 ) {
    printf( "OS/2 Image Files Extractor 1.01\n"
            "Copyright (C) by AVN, 1997. All rights reserved.\n"
            "\n"
            "Usage: os2hdd file path\n" );
    exit( 1 );
  }
  if( argc > 2 ) {
    strcpy( basepath, argv[ 2 ] );
    create_dirs( basepath );
  }
  else basepath[ 0 ] = 0;
  if( ( fdin = open( argv[ 1 ], O_BINARY|O_RDONLY ) ) >= 0 ) {
    read( fdin, &marker, sizeof marker );
    if( marker == MARKER1 ) {
      lseek( fdin, OFFSET, 0 ); /* 뢠 ᬥ饭  ᬥ饭 */
      read( fdin, &offset, sizeof offset );
      printf( "Offset to disk dump is %ld\n", offset );
    }
    else if( marker == MARKER3 || marker == MARKER2 ) {
      lseek( fdin, OFFSET, 0 ); /* 뢠 ᬥ饭  ᬥ饭 */
      read( fdin, &offset, sizeof offset );
      printf( "Offset to disk dump is %ld\n", offset );
/*
      printf( "This is dump with shifted root directory. Can't expand.\n" );
      exit( 1 );
*/
    }
    else if( marker == MARKER4 ) {
      printf( "This is compressed dump. Can't expand.\n" );
      exit( 1 );
    }
    else {
      printf( "Try to think that it is ordinary disk dump. (marker=%08X)\n", marker );
      offset = 0;
    }
    lseek( fdin, offset, 0 );
    read( fdin, &boot, sizeof boot );
    printf( "Sector size: %d bytes\n", boot.bpb.sectsize );
    printf( "FAT size:    %d sectors\n", boot.bpb.fatsize );
    printf( "Root size:   %d entries\n", boot.bpb.rootsize );
    lseek( fdin, (boot.bpb.ressecs*boot.bpb.sectsize)+offset, 0 );
    fat = malloc( boot.bpb.fatsize*boot.bpb.sectsize );
    read( fdin, fat, boot.bpb.fatsize*boot.bpb.sectsize );
    root = malloc( boot.bpb.rootsize*sizeof( FITEM ) );
    lseek( fdin, offset+
                 (boot.bpb.ressecs+
                  boot.bpb.fatsize*boot.bpb.fatcnt)*boot.bpb.sectsize, 0 );
    read( fdin, root, boot.bpb.rootsize*sizeof( FITEM ) );
    for( i = 0; i < boot.bpb.rootsize; i++ )
      if( root[ i ].name[ 0 ] != 0 && root[ i ].name[ 0 ] != 0xE5 ) {
        if( root[ i ].attr & F_LABEL ) {
          printf( "Disk label: %.8s%.3s\n", root[ i ].name, root[ i ].ext );
          mkdirname( filename, root+i );
          strcat( basepath, "/" );
          strcat( basepath, filename );
          mkdir( basepath );
        }
        else {
          if( strncmp( root[ i ].name, "EA DATA  SF", 11 ) &&
              strncmp( root[ i ].name, "WP ROOT  SF", 11 ) )
            copyfile( root+i, basepath );
        }
      }
    close( fdin );
  }
  else
    printf( "Can't open file %s\n", argv[ 1 ] );
}
