# ifndef _SYSP_H_
# define _SYSP_H_

/*
 * File: SYSP.H   Date: 07.09.92
 *
 * ᠭ ⥬ ⠡   MS DOS
 *   䠩 sysp.h  "⥪ ⥬ ணࠬ"
 * 쥢 ஫
 *
 *          Copyright (C) by AVN  1992
 *             All rights reserved.
 */

# include <stdio.h>

/*  ࠩ */

typedef struct _header {
  struct _header far *next;          /* ⥫   ᫥饣 ࠩ            */
  unsigned short      attrib;        /* ਡ ࠩ                                     */
  unsigned short      strateg;       /* 饭 ணࠬ ⥣                          */
  unsigned short      inter;         /* 饭 ணࠬ ࠡ⪨ 뢠               */
  char                dev_name[ 8 ]; /*  ன⢠  ⢮ 㦨 ன */
} HEADER;

# define READCMD  4
# define WRITECMD 8

typedef struct {
  unsigned char      reqlen;
  unsigned char      requnit;
  unsigned char      reqcmd;
  short              reqstat;
  unsigned char      reqres[ 8 ];
} IOHEADER;

typedef struct {
  IOHEADER           header;
  unsigned char      media;
  unsigned char far *area;
  short              count;
  unsigned short     start;
  char far          *label;
  unsigned long      lstart;
} RWREQ;

/*  ୮ ⠡ 裡 DOS 3.x, 4.x */

typedef struct _CVT_ {    /* Offset Size  Description                                 */
                          /* -12    WORD  (DOS 3.1-3.3) sharing retry count           */
                          /* -10    WORD  (DOS 3.1-3.3) sharing retry delay           */
                          /* -8     DWORD (DOS 3.x) pointer to current disk buffer    */
                          /* -4     WORD  (DOS 3.x) pointer in DOS code segment
                                          of unread CON input                         */
  unsigned short mcb_seg;       /* -2     WORD  segment of first memory control block       */
                          /*  ࢮ ࠢ饣   (MCB)          */
  void far *dev_cb;       /* 00h    DWORD pointer to first DOS DPB                    */
                          /* ⥫    ࠢ ன⢠         */
  void far *file_tab;     /* 04h    DWORD pointer to list of DOS file tables          */
                          /* ⥫  ⠡ 䠩 DOS                          */
  void far *clock_dr;     /* 08h    DWORD pointer to CLOCK$ device driver,
                                          resident or installable                     */
                          /* ⥫  ࠩ CLOCK$, ⠭
                              १                                          */
  void far *con_dr;       /* 0Ch    DWORD pointer actual CON device driver,
                                          resident or installable                     */
                          /* ⥫  㠫 ࠩ CON,
                             ⠭  १                            */
  unsigned short max_btbl;      /* 10h    WORD  maximum bytes/block of any block device     */
                          /* ᨬ쭮 ᫮    筮 ன⢠      */
  void far *disk_buf;     /* 12h    DWORD pointer to first disk buffer                */
                          /* ⥫   ᪮                        */
  void far *drv_info;     /* 16h    DWORD pointer to array of current directory
                                          structures                                  */
                          /* ⥫  ᨢ ଠ樨  ன⢠            */
  void far *fcb_tabl;     /* 1Ah    DWORD pointer to FCB table                        */
                          /* ⥫  ⠡ FCB                                 */
  unsigned short fcb_size;      /* 1Eh    WORD  number of protected FCBs (the y in FCB=x,y) */
                          /*  ⠡ FCB                                       */
  unsigned char num_bdev; /* 20h    BYTE  number of block devices                     */
                          /* ᫮  ன                                  */
  unsigned char lastdriv; /* 21h    BYTE  value of LASTDRIVE command in CONFIG.SYS    */
                          /* 祭 LASTDRIVE  䠩 CONFIG.SYS ( 㬮砭 5)   */
  HEADER    nul_head;     /* 22h 18 BYTEs actual NUL device driver header             */
  unsigned char njoin;    /* 34h    BYTE  number of JOIN'ed drives                    */
  /*                                            DOS 4.x                               */
  unsigned short specprog;      /* 35h    WORD  pointer within IBMDOS code segment to list
                                          of special program names                    */
  void (far *ifs)();      /* 37h    DWORD pointer to far routine for resident IFS
                                          utility functions                           */
  void far *ifschain;     /* 3Bh    DWORD pointer to chain of IFS drivers             */
  unsigned  short xbuffers;     /* 3Fh    WORD  the x in BUFFERS x,y                        */
  unsigned  short ybuffers;     /* 41h    WORD  the x in BUFFERS x,y                        */
  char      bootdrive;    /* 43h    BYTE  boot drive (1=A:)                           */
  char      flag386;      /* 44h    BYTE  01 if 80386+, 00h otherwise???              */
  unsigned  short extmem;       /* 45h    WORD  extended memory size in K                   */
} CVT;

/*  ࠢ  MCB */

typedef struct _MCB_ {
  unsigned char type; /*   MCB (M  Z)                      */
  unsigned short owner;     /* ࠣ   (᫨ 0,  
                         뢠 ᠬ ᥡ                           */
  unsigned short size;      /* ᫮ ࠣ䮢  ⮬  ( ࠣ
                          ࠧ 16                          */
  char     reserve[3];/* १ࢨ஢                              */
  char     program[8];/*  ணࠬ (⮫쪮  DOS 4.00+)         */
} MCB;

/* 䨪 ணࠬ ᥣ PSP */

typedef struct _PSP_ {       /* Offset  Size    Description                          */
  unsigned char int20h[2];   /*  00h  2 BYTEs   program exit point                   */
  unsigned short mem_top;          /*  02h    WORD    memory size in paragraphs            */
  unsigned char reserv1;     /*  04h    BYTE    unused                               */
  unsigned char call_dsp[5]; /*  05h  5 BYTEs   CP/M entry point                     */
  void far *term_adr;        /*  0Ah    DWORD   terminate address (old INT 22h)      */
  void far *cbrk_adr;        /*  0Eh    DWORD   break address (old INT 23h)          */
  void far *crit_err;        /*  12h    DWORD   critical error handler (old INT 24h) */
  unsigned short parn_psp;         /*  16h    WORD    parent PSP segment                   */
  unsigned char file_tab[20];/*  18h 20 BYTEs   DOS 2+ open file table, FFh = unused */
  unsigned short env_seg;          /*  2Ch    WORD    DOS 2+ enviroment segment            */
  void far *ss_sp;           /*  2Eh    DWORD   DOS 2+ process's SS:SP on entry to last INT 21h call */
  unsigned short max_open;         /*  32h    WORD    DOS 3+ max open files                */
  void far *file_tba;        /*  34h    DWORD   DOS 3+ open file table address       */
  void far *prev_psp;        /*  38h    DWORD   DOS 3+ pointer to previous PSP       */
  unsigned char reserv2[20]; /*  3Ch 20 BYTEs   unused                               */
  unsigned char disp[3];     /*  50h  3 BYTEs   DOS function dispatcher (FAR routine)*/
  unsigned char reserv3[9];  /*  53h  9 BYTEs   unused                               */
  unsigned char fcb1[16];    /*  5Ch 16 BYTEs   FCB #1                               */
  unsigned char fcb2[20];    /*  6Ch 20 BYTEs   FCB #2                               */
  unsigned char p_size;      /*  80h    BYTE    length of command tail               */
  unsigned char parm[127];   /*  81h 127 BYTEs  command tail                         */
} PSP;

/*  ࠢ ன⢮ DOS 4.x */

typedef struct _DDCB4_ {
  unsigned char drv_num;   /*  ன⢠ (0 ᮮ⢥ ன A, 1 - B  .. */
  unsigned char drv_numd;  /* ⥫  ன⢠  ࠩ         */
  unsigned short sec_size;       /*  ᥪ                                   */
  unsigned char clu_size;  /* ⢮ ᥪ஢   - 1                      */
  unsigned char clu_base;  /* ⥯ 2 ᫠ ᥪ஢                       */
  unsigned short boot_siz;       /* ⢮ १ࢨ஢ ᥪ஢                   */
  unsigned char fat_num;   /* ⢮  FAT                                    */
  unsigned short max_dir;        /* ᨬ쭮 ᫮ ਯ஢ 䠩  ୥ ⠫ */
  unsigned short data_sec;       /*  ࢮ ᥪ   ᪥
                               ᥪ, ᮮ⢥騩  2               */
  unsigned short hi_clust;       /* ᨬ쭮 ⢮ ஢ (ࠢ
                              㢥祭  1  ஢            */
  unsigned short fat_size;       /* ⢮ ᥪ஢   FAT                       */
  unsigned short root_sec;       /*  ࢮ ᥪ ୥ ⠫                */
  void far *drv_addr;      /*  ࠩ, 㦨饣  ன⢮        */
  unsigned char media;     /*  ᠭ । ⥫                      */
  unsigned char acc_flag;  /*  㯠, 0 砥,   ன     */
  struct _DDCB4_ far *next;/*  ᫥饣  DDCB,  ᫥   
                                ᬥ饭 室 FFFF                          */
  unsigned short begsearch;      /*  1Dh    WORD    cluster at which to start search for free
                                              space when writing                      */
  unsigned short nfree;          /*  1Fh    WORD    number of free clusters on drive, FFFFh = unknown */
} DDCB4;

/*  ࠢ ன⢮ DOS 3.x */

typedef struct _DDCB3_ {
  unsigned char drv_num;   /*  ன⢠ (0 ᮮ⢥ ன A, 1 - B  .. */
  unsigned char drv_numd;  /* ⥫  ன⢠  ࠩ         */
  unsigned short sec_size;       /*  ᥪ                                   */
  unsigned char clu_size;  /* ⢮ ᥪ஢   - 1                      */
  unsigned char clu_base;  /* ⥯ 2 ᫠ ᥪ஢                       */
  unsigned short boot_siz;       /* ⢮ १ࢨ஢ ᥪ஢                   */
  unsigned char fat_num;   /* ⢮  FAT                                    */
  unsigned short max_dir;        /* ᨬ쭮 ᫮ ਯ஢ 䠩  ୥ ⠫ */
  unsigned short data_sec;       /*  ࢮ ᥪ   ᪥
                               ᥪ, ᮮ⢥騩  2               */
  unsigned short hi_clust;       /* ᨬ쭮 ⢮ ஢ (ࠢ 㢥祭
                               1  ஢                         */
  unsigned char fat_size;  /* ⢮ ᥪ஢   FAT                       */
  unsigned short root_sec;       /*  ࢮ ᥪ ୥ ⠫                */
  void far *drv_addr;      /*  ࠩ, 㦨饣  ன⢮        */
  unsigned char media;     /*  ᠭ । ⥫                      */
  unsigned char acc_flag;  /*  㯠, 0 砥,   ன     */
  struct _DDCB3_ far *next;/*  ᫥饣  DDCB,  ᫥   
                                ᬥ饭 室 FFFF                          */
  unsigned short begsearch;      /*  1Ch    WORD    cluster at which to start search for free
                                              space when writing                      */
  unsigned short nfree;          /*  1Eh    WORD    number of free clusters on drive, FFFFh = unknown */
} DDCB3;

/* ࠢ騩  DOS  䠩 */

typedef struct _DFCB_ {
  unsigned short handl_num;
  unsigned char access_mode;
  unsigned short reserv1;
  unsigned short dev_info;
  void far *driver;
  unsigned short first_clu;
  unsigned short time;
  unsigned short date;
  unsigned long fl_size;
  unsigned long offset;
  unsigned short reserv2;
  unsigned short reserv7;
  unsigned short reserv3;
  char reserv4;
  char filename[11];
  char reserv5[6];
  unsigned short ownr_psp;
  unsigned short reserv6;
  unsigned short last_clu;
  char reserv8[4];
} DFCB;

/*  䠩 DOS */

typedef struct _DFT_ {
  struct _DFT_ far *next;
  unsigned short file_count;
  DFCB dfcb;
} DFT;

/* ࠢ騩  ᪮  BCB  DOS 4.x */

typedef struct _BCB_ {
	struct _BCB_ far *next;
	unsigned char drive;
	unsigned char flag;
	unsigned short sect_num;
	unsigned short reserv1;
	DDCB4 far *ddcb;
	unsigned short reserv2;
} BCB;

/* ଠ  ᪥ DOS 3.x */

typedef struct {
  char path[64];           /* 騩  㯠  ᪠ */
  unsigned short reserv1;        /* १ࢨ஢                */
  unsigned short reserv2;        /* १ࢨ஢                */
  unsigned char reserv3;   /* १ࢨ஢                */
  DDCB3 far *ddcb;         /*  ᮮ⢥饣 DDCB    */
  unsigned short cdir_clu;       /*
                                  *   ⥪饣 ⠫  ᪠
                                  * 0 ᮮ⢥ ୥ ⠫,
                                  * -1,᫨     頫
                                  */
  unsigned short reserv4;        /* १ࢨ஢                */
  unsigned short reserv5;        /* १ࢨ஢                */
  unsigned short reserv6;        /* १ࢨ஢                */
} DINFO3;

/* ଠ  ᪥ DOS 4.x */

typedef struct {
  char path[64];           /* 騩  㯠  ᪠ */
  unsigned short reserv1;        /* १ࢨ஢                */
  unsigned short reserv2;        /* १ࢨ஢                */
  unsigned char reserv3;   /* १ࢨ஢                */
  DDCB3 far *ddcb;         /*  ᮮ⢥饣 DDCB    */
  unsigned short cdir_clu;       /*
                                  *   ⥪饣 ⠫  ᪠
                                  * 0 ᮮ⢥ ୥ ⠫,
                                  * -1,᫨     頫
                                  */
  unsigned short reserv4;        /* १ࢨ஢                */
  unsigned short reserv5;        /* १ࢨ஢                */
  unsigned short reserv6;        /* १ࢨ஢                */
  unsigned char reserv7[7];/* १ࢨ஢                */
} DINFO4;

/*  EXE-ணࠬ */

typedef struct _EXE_HDR_ {
  unsigned short signature;
  unsigned short part_pag;
  unsigned short file_size;
  unsigned short rel_item;
  unsigned short hdr_size;
  unsigned short min_mem;
  unsigned short max_mem;
  unsigned short ss_reg;
  unsigned short sp_reg;
  unsigned short chk_summ;
  unsigned short ip_reg;
  unsigned short cs_reg;
  unsigned short relt_off;
  unsigned short overlay;
} EXE_HDR;

/*  ᯮ ᥣ⮢ EXE-ணࠬ */

typedef struct _RELOC_TAB_ {
  unsigned short offset;
  unsigned short segment;
} RELOC_TAB;

/* 䨣 ᪮ ⥬ */

typedef struct _DISK_CONFIG_ {
  short n_floppy;
  short n_hard;
  short t_floppy1;
  short t_floppy2;
  short t_hard1;
  short t_hard2;
} DISK_CONFIG;

/*  ࠬ஢ ᪥ */

typedef struct _DPT_ {
  unsigned char srt_hut;
  unsigned char dma_hlt;
  unsigned char motor_w;
  unsigned char sec_size;
  unsigned char eot;
  unsigned char gap_rw;
  unsigned char dtl;
  unsigned char gap_f;
  unsigned char fill_char;
  unsigned char hst;
  unsigned char mot_start;
} DPT;

/*  ࠬ஢ ᪠ */

typedef struct _HDPT_ {
  unsigned short max_cyl;
  unsigned char max_head;
  unsigned short srwcc;
  unsigned short swpc;
  unsigned char max_ecc;
  unsigned char dstopt;
  unsigned char st_del;
  unsigned char fm_del;
  unsigned char chk_del;
  unsigned char reserve[4];
} HDPT;

/*  ⠡ ࠧ */

typedef struct _PART_ENTRY_ {
  unsigned char flag;     /* Boot flag: 0=not activ, 80H=activ        */
  unsigned char beg_head; /* Begins: head number                      */
  unsigned short beg_sec_cyl;   /* Begins: sector & cylinder of boot sector */
  unsigned char sys;      /* System code:
                           * 0=unknown,
                           * 1=DOS 12-bit FAT,
                           * 4=16-bit,
                           * 5=Extended DOS partition
                           */
  unsigned char end_head;  /* Ends: head number                       */
  unsigned short end_sec_cyl;    /* Ends: sector & cylinder of last sector  */
  unsigned long rel_sec;   /* Beginning relative sector number        */
  unsigned long size;      /* Size (total sectors)                    */
} PART_ENTRY;

/*  㧮筠  */

typedef struct _MBOOT_ {
  char boot_prg[0x1be];       /* Code to load and execute boot sector
                                 of active partition                  */
  PART_ENTRY part_table[4];   /* 4 Partition entries                  */
  unsigned char signature[2]; /* Partition table signature (0aa55H)   */
} MBOOT;

/* ७  ࠬ஢ BIOS */

typedef struct _EBPB_ {
  unsigned short sectsize;      /* Bytes per sector                                       */
  char clustsize;         /* Sectors per allocation unit (cluster)                  */
  unsigned short ressecs;       /* Boot and reserved sectors                              */
  char fatcnt;            /* Number of File Allocation Tables                       */
  unsigned short rootsize;      /* Maximum number of 32-byte directory entries in root    */
  unsigned short totsecs;       /* Total number of sectors in media (DOS partition < 32M);
                             (0 means use DWORD at offset 15h - drvsecs)            */
  char media;             /* Media descriptor                                       */
  unsigned short fatsize;       /* Number of sectors in 1 FAT                             */
/********************************* Extended BPB additions *********************************/
  unsigned short seccnt;        /* Sectors per track                                      */
  unsigned short headcnt;       /* Number of read/write heads                             */
  unsigned short hiddensec_low; /* Hidden sectors low word (partition < 32M)              */
  unsigned short hiddensec_hi;  /* Hidden sectors high word (partition > 32M)             */
  unsigned long drvsecs;  /* 32-bit Total sectors in volume (partition > 32M)       */
} EBPB;

/* 㧮筠   MS-DOS 4.01 */

typedef struct {
  char jmp[3];         /* Near jump to boot code                         */
  char oem[8];         /* OEM company name and version                   */
  EBPB bpb;            /* Extended BPB (25 bytes)                        */
  char drive;          /* Physical drive number (0=floppy,80h=hard disk) */
  char reserved;       /* Reserved                                       */
  char signature;      /* Extended Boot record signature  (always 29H)   */
  unsigned short volser_lo;  /*       Volume Serial Number                     */
  unsigned short volser_hi;  /*   (  based on when formatted )                 */
  char label[11];      /*           Volume Label                         */
  char fat_format[8];  /* (Contains   'FAT12   ' or 'FAT16   ')          */
                       /* 62 (3eH) bytes long                            */
  char boot_prg[384];  /* Code to load and execute boot sector
                          of active partition                            */
  PART_ENTRY part_table[4];     /* 4 Partition entry                     */
  unsigned char ptsignature[2]; /* Partition table signature (0aa55H)    */
} BOOT;

/* ६ ᫥  䠩 */

typedef struct _FTIME_ {
  unsigned short sec : 5, min : 6, hour : 5;
} FTIME;

/*  ᫥  䠩 */

typedef struct _FDATE_ {
  unsigned short day : 5, month : 4, year : 7;
} FDATE;

/* ਯ 䠩  ⠫ */

typedef struct _FITEM_ {
  char name[8];
  char ext[3];
  char attr;
  char reserved[10];
  FTIME time;
  FDATE date;
  unsigned short cluster_nu;
  unsigned long size;
} FITEM;

# define F_NORMAL   0x00
# define F_READONLY 0x01
# define F_HIDDEN   0x02
# define F_SYSTEM   0x04
# define F_LABEL    0x08
# define F_DIR      0x10
# define F_ARC      0x20
# define F_RESERVED 0xC0

/* ଠ ४  GENERIC IOCTL */

typedef struct _TRK_LY_ {
  unsigned short no;
  unsigned short size;
} TRK_LY;

/* ࠬ ன⢠  GENERIC IOCTL */

typedef struct _DPB_ {
  char spec;
  char devtype;
  unsigned short devattr;
  unsigned short numofcyl;
  char media_type;
  EBPB bpb;
  char reserved[6];
  unsigned short trkcnt;
  TRK_LY trk[100];
} DPB;

/* ࠬ  ଠ஢ 㭪樥 GENERIC IOCTL */

typedef struct _DPB_FORMAT_ {
  char spec;
  unsigned short head;
  unsigned short track;
} DPB_FORMAT;

/* ࠬ  ⥭/ 㭪樥 GENERIC IOCTL */

typedef struct _DPB_WR_ {
  char spec;
  unsigned short head;
  unsigned short track;
  unsigned short sector;
  unsigned short sectcnt;
  void far *buffer;
} DPB_WR;

/* 䨪 BIOS */

typedef struct _BIOS_ID_ {
  char date[8];
  unsigned short reserve;
  char pc_type;
} BIOS_ID;

unsigned char far *getcsf( void ); /* Get Critical section flag (InDOS) */
unsigned char far *getcef( void ); /* Get Critical error flag           */
CVT far *getcvt( void );           /* Get list of lists                 */

# endif
