#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ndfs.h>


static int nd_wait( ULONG ulPeriod, ULONG ulRetries )
{
    int rc;
    int i;
    int infinity = (ulRetries == 0ul);
    
    for ( i = 0; infinity || i < ulRetries; i++ )
    {
        IFSINFO ifsInfo;
        ULONG ulDataLength = sizeof( IFSINFO );
        rc = NdQueryInfo( ND_INFO_IFS, &ifsInfo, &ulDataLength );
        if ( rc == NO_ERROR && ifsInfo.usCpgmConnected ) 
        {
            return 0;
        }
        DosSleep( ulPeriod*1000ul );
    }
            
    return 1;
}


int main( int argc, char *argv[] )
{
    int rc = 0;
    ULONG wait_time = 10; // 10 seconds
    ULONG retries = 3; // 3 times
    printf( "NetDrive NDCTL Wait Utility\n" );
    
    switch( argc )
    {
        default:
        {
            printf( "ndwait [wait_time retries]\n" );
            printf( "    default wait_time=10 (in seconds), retries=3\n" );
        } break;
        case 3:
        {
             wait_time = atoi( argv[1] );
             if ( wait_time == 0 ) 
             {
                 wait_time = 10;
             }
             retries = atoi( argv[2] );
        }
        case 1:
        {
            rc = nd_wait( wait_time, retries );
            if (rc != 0)
            {
                printf("NDCTL is not ready yet.\n");
            }
            else
            {
                printf("NDCTL is ready.\n");
            }
        } break;
    }
    return rc;
}
