#include <stdio.h>
#include <string.h>
#include <ndfs.h>



void printRIDINFO( RIDINFO *pRidInfo )
{
    printf("Requests information:\n"
           "    completed: %lu\n"
           "    maximum allowed: %u\n"
           "    in process: %u\n"
           "    maximum in process: %u\n"
           "    in return wait: %u\n"
           "    in captive wait: %u\n"
           "    free hits: %lu\n"
           "    captive hits: %lu\n"
           "    free faults: %lu\n"
           "    captive faults: %lu\n"
           "    free scanned: %lu\n"
           "    captive scanned: %lu\n",
    pRidInfo->ulReqCompleted,
    (int)pRidInfo->usReqMax,
    (int)pRidInfo->usReqInProcess,
    (int)pRidInfo->usReqMaxInProcess,
    (int)pRidInfo->usReqRetCnt,
    (int)pRidInfo->usReqCptCnt,
    (int)pRidInfo->ulFreeHits,
    (int)pRidInfo->ulCptHits,
    (int)pRidInfo->ulFreeFaults,
    (int)pRidInfo->ulCptFaults,
    (int)pRidInfo->ulFreeScanned,
    (int)pRidInfo->ulCptScanned
    );
}

int nd_query( void )
{
    int rc;
    IFSINFO ifsInfo;
    ULONG ulDataLength = sizeof( IFSINFO );
    rc = NdQueryInfo( ND_INFO_IFS, &ifsInfo, &ulDataLength );
 
    if (rc != 0)
    {
        printf("Query failed: return code = %ld.\n", rc);
    }
    else
    {
        printf("Query successful.\n");
        printf("%s FSD ver. %d.%3.3d\n", ifsInfo.achName, ifsInfo.usVerMajor, ifsInfo.usVerMinor );
        printf("NDCTL is%s connected\n", ifsInfo.usCpgmConnected?"":" not" );
        printf("NDCTL pid = %d\n", ifsInfo.usCpgmPID );
        printRIDINFO( &ifsInfo.ridInfo );
    }
            
    return (int)rc;
}


int main( int argc, char *argv[] )
{
 
    int rc = 0;
    printf( "NetDrive Query Information Utility\n" );
    rc = nd_query();
    return rc;
}
