#include <stdio.h>
#include <string.h>
#include <ndfs.h>


int main( int argc, char *argv[] )
{
 
    int rc = 0;
    printf( "NetDrive Mount Utility\n" );
    if ( argc != 5 )
    {
        printf( "ndmount type dest src ro|rw\n" );
        rc = -1;
    }
    else
    {
        char *type = argv[1];
        char *dest = argv[2];
        char *src  = argv[3];
        char *flag = argv[4];
        
        ULONG ulFlags = 0ul;
        
        if ( stricmp( flag, "ro" ) == 0 ||
             stricmp( flag, "r" ) == 0 )
        {
           ulFlags |= DO_FLAG_WRITEPROTECT;
        }
        rc = NdMount( type, ulFlags, dest, src );
        if (rc != 0)
        {
            printf("Mount failed: return code = %ld.\n", rc);
        }
        else
        {
            printf("Mount successful.\n");
        }
    }
    return rc;
}
